/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.v5;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.v5.V5InvalidAttributeException;
import com.cognos.xqe.ast.v5.V5InvalidElementException;
import com.cognos.xqe.ast.v5.V5QueryNode;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5.query.V5Selection;
import com.cognos.xqe.ast.v5.result.V5QueryResultDefinition;
import com.cognos.xqe.ast.v5Exp.V5Parameter;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.rsapi.RSAPIDataset;
import com.cognos.xqe.source.ISource;
import com.cognos.xqe.trace.XQEDebugLog;
import com.cognos.xqe.transformation.relational.binding.SQLQueryItemList;
import com.cognos.xqe.util.Governors;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Attribute;
import org.dom4j.Element;

public class V5QuerySet
extends V5QueryNode {
    public static final String NODE_TYPE_NAME = "V5QuerySet";
    public static final String V5_NODE_NAME = "querySet";
    public static final String PROP_STRING_EXPRESSION_LOCALE = "expressionLocale";
    public static final String PROP_STRING_MODEL_PATH = "modelPath";
    public static final String PROP_STRING_ORG_MODEL_PATH = "orgModelPath";
    public static final String PROP_STRING_REPORT_NAME = "reportName";
    public static final String PROP_BOOLEAN_UNREFERENCED_QRDS_REMOVED = "unreferencedQRDsRemoved";
    public static final String PROP_BOOLEAN_UNREFERENCED_QUERIES_REMOVED = "unreferencedQueriesRemoved";
    public static final String PROP_OBJECT_UNREFERENCED_QUERY_ITEMS_TREE_WALKER = "unreferencedQueryItemsTreeWalker";
    public static final String PROP_OBJECT_V5PARAMETERS_MAP = "v5ParametersMap";
    public static final String PROP_OBJECT_QUERY_ITEMS = "queryItems";
    private static final String PROP_OBJECT_ARRAY_RETRIEVE_DATASETS = "retrieveDatasetArray";
    private static final String QUERY_RESULT_DEFINITIONS = "queryResultDefinitions";
    private static final String PROPERTY = "property";
    public static final String REQUEST_HINTS = "requestHints";
    private static final String ENABLED = "enabled";
    private static final String NAME = "name";
    private static final String VALUE = "value";
    private static final String PROP_NON_REUSABLE = "nonReusable";
    public static final String V5_VERSION = "v5Version";
    private static final String PROP_CONTAINS_REQUEST_HINT = "containsRequestHint";
    public static final String MULTIDIM_SUBQUERY = "MultiDimensionalSubquery";
    public static final String PROP_MAP_QUERYNAME_TO_QUERYNODE = "queryNameToQueryNode";
    public static final String PROP_RESOLVED_QUERIES = "resolvedQueries";
    public static final String PROP_QUERY_DEPENDENCY_MAP = "queryDependencyMap";
    public static final String PROP_DATASOURCES = "dataSources";
    public static final String PROP_MAXCOLUMNNAMELENGTH = "maxColumnNameLengthProp";
    public static final String PROP_MAXTABLENAMELENGTH = "maxTableNameLengthProp";
    public static final String PROP_INITIALQUERYSET = "initialQuerySet";
    public static final String PROP_STRING_MODEL_TYPE = "modelType";
    public static final String PROP_EXECUTING_SQL_QUERY = "executing_sql_query";
    public static final String PROP_SQL_QUERY_FM = "sqlQueryFM";
    public static final String PROP_USED_SOURCES = "usedSources";
    public static final String PROP_DOUBLE_SAMPLEPERCENT = "samplePercent";
    public static final String PROP_INTEGER_SAMPLEROWCOUNT = "sampleRowCount";
    public static final String PROP_INTEGER_SAMPLESEED = "sampleSeed";
    private static final String PROP_QUERY_REFERS_TO_FM_PACKAGE = "queryRefersToFMPackage";
    private static final String PROP_FOR_REST = "forREST";
    public static final String PROP_PROMPT_HANDLING = "promptHandling";

    @Override
    public int getType() {
        return 101002;
    }

    @Override
    public String getNodeTypeName() {
        return NODE_TYPE_NAME;
    }

    @Override
    public void capture(PlanningEnvironment env, Element inputNode) throws V5InvalidAttributeException, V5InvalidElementException {
        Object migrateBaseVersionInConfig;
        Element queryFeedback;
        XQENodeFactory factory = env.getNodeFactory();
        boolean readV5SpecFormat = env.isReadV5SpecFormat();
        int size = inputNode.attributeCount();
        for (int i = 0; i < size; ++i) {
            Attribute att = inputNode.attribute(i);
            String attname = att.getName();
            if (attname.equals(PROP_STRING_EXPRESSION_LOCALE)) {
                this.setStringPropertyValue(attname, att.getValue());
                continue;
            }
            if (attname.equals(V5_VERSION) || attname.equals(PROP_INTEGER_SAMPLEROWCOUNT) || attname.equals(PROP_INTEGER_SAMPLESEED)) {
                this.setIntegerPropertyValue(attname, att.getValue());
                continue;
            }
            if (attname.equals(PROP_DOUBLE_SAMPLEPERCENT)) {
                this.setPropertyValue(attname, Double.valueOf(att.getValue()));
                continue;
            }
            if (attname.equals(PROP_FOR_REST)) {
                this.setPropertyValue(attname, Boolean.valueOf(att.getValue()));
                continue;
            }
            if (readV5SpecFormat && attname.equals("id")) {
                this.setStringPropertyValue(attname, att.getValue());
                continue;
            }
            if (!readV5SpecFormat) {
                if (attname.equals(PROP_STRING_MODEL_PATH)) {
                    this.setStringPropertyValue(PROP_STRING_MODEL_PATH, att.getValue());
                    continue;
                }
                if (attname.equals(PROP_BOOLEAN_UNREFERENCED_QUERIES_REMOVED) || attname.equals(PROP_BOOLEAN_UNREFERENCED_QRDS_REMOVED)) {
                    this.setPropertyValue(attname, Boolean.parseBoolean(att.getValue()));
                    continue;
                }
                if (!attname.equals(PROP_STRING_MODEL_TYPE)) continue;
                this.setStringPropertyValue(PROP_STRING_MODEL_TYPE, att.getValue());
                ((RequestEnvironment)env.getRequestEnvironment()).setModelType(att.getValue());
                continue;
            }
            if (attname.equals(PROP_PROMPT_HANDLING)) {
                this.setPropertyValue(attname, att.getValue());
                continue;
            }
            throw new V5InvalidAttributeException(XQEMessageKeys.V5_InvalidAttribute, attname, inputNode.getName());
        }
        if (!readV5SpecFormat) {
            env.setRoot(this);
        }
        List children = inputNode.elements();
        size = children.size();
        HashMap<String, V5DataItem> v5IdToV5QueryNodeMap = new HashMap<String, V5DataItem>();
        for (int i = 0; i < size; ++i) {
            String grandchildname;
            Element grandchild;
            List grandchildren;
            IXQEQueryNode[] child = (IXQEQueryNode[])children.get(i);
            String childname = child.getName();
            if (!readV5SpecFormat) {
                IXQEQueryNode[] dataItems;
                V5QueryNode node;
                if (!childname.equals("V5Query") && !childname.equals("V5QueryResultDefinition") || (node = factory.createV5Node(childname)) == null) continue;
                this.addChild(node);
                node.capture(env, (Element)child);
                if (101006 != node.getNodeType()) continue;
                V5Query query = (V5Query)node;
                V5Selection v5Selection = query.getV5Selection();
                for (IXQEQueryNode iDataItem : dataItems = v5Selection.getDescendantsOfType(101003, false)) {
                    V5DataItem dataItem = (V5DataItem)iDataItem;
                    v5IdToV5QueryNodeMap.put((String)dataItem.getPropertyValue("orgId"), dataItem);
                }
                continue;
            }
            if (childname.equals("queries") || childname.equals(QUERY_RESULT_DEFINITIONS)) {
                grandchildren = child.elements();
                int gsize = grandchildren.size();
                for (int j = 0; j < gsize; ++j) {
                    grandchild = (Element)grandchildren.get(j);
                    grandchildname = grandchild.getName();
                    V5QueryNode node = factory.createV5Node(grandchildname);
                    if (node == null) continue;
                    this.addChild(node);
                    node.capture(env, grandchild);
                }
                continue;
            }
            if (childname.equals(REQUEST_HINTS)) {
                grandchildren = child.elements();
                int gsize = grandchildren.size();
                for (int j = 0; j < gsize; ++j) {
                    grandchild = (Element)grandchildren.get(j);
                    grandchildname = grandchild.getName();
                    if (grandchildname.equals(RequestHint.NO_DATA_MODE.getPropertyName()) || grandchildname.equals(RequestHint.DESIGN_MODE.getPropertyName()) || grandchildname.equals(RequestHint.DATASET_MODE.getPropertyName())) {
                        this.setBooleanPropertyValue(grandchildname, grandchild.attributeValue(ENABLED));
                        this.setBooleanPropertyValue(PROP_CONTAINS_REQUEST_HINT, Boolean.TRUE.toString());
                        continue;
                    }
                    if (grandchildname.equals(RequestHint.EXECUTION_OPTIMIZATION.getPropertyName())) {
                        this.setStringPropertyValue(grandchildname, grandchild.attributeValue(VALUE));
                        this.setBooleanPropertyValue(PROP_CONTAINS_REQUEST_HINT, Boolean.TRUE.toString());
                        continue;
                    }
                    if (grandchildname.equals(RequestHint.LOCAL_CACHE.getPropertyName())) continue;
                    if (grandchildname.equals(RequestHint.MAX_TABLE_NAME_LENGTH.getPropertyName())) {
                        this.setIntegerPropertyValue(grandchildname, grandchild.attributeValue(VALUE));
                        this.setBooleanPropertyValue(PROP_CONTAINS_REQUEST_HINT, Boolean.TRUE.toString());
                        continue;
                    }
                    if (grandchildname.equals(RequestHint.SUPPRESS_DUPLICATE_MEASURE_VALUES.getPropertyName())) {
                        this.setBooleanPropertyValue(grandchildname, grandchild.attributeValue(VALUE));
                        this.setBooleanPropertyValue(PROP_CONTAINS_REQUEST_HINT, Boolean.TRUE.toString());
                        continue;
                    }
                    if (grandchildname.equals(RequestHint.INCLUDE_EMPTY_CELLS.getPropertyName())) {
                        XQEDebugLog.err.println("Invalid V5 element: " + grandchildname);
                        continue;
                    }
                    if (grandchildname.equals(RequestHint.OPTIMIZE_MASTER_DETAIL_FOR_ALL_ROWS.getPropertyName())) {
                        this.setStringPropertyValue(grandchildname, grandchild.attributeValue(VALUE));
                        this.setBooleanPropertyValue(PROP_CONTAINS_REQUEST_HINT, Boolean.TRUE.toString());
                        continue;
                    }
                    if (grandchildname.equals(RequestHint.CACHE_POLICY_CONNECTION_COMMAND_BLOCKS.getPropertyName())) {
                        this.setStringPropertyValue(grandchildname, grandchild.attributeValue(VALUE));
                        this.setBooleanPropertyValue(PROP_CONTAINS_REQUEST_HINT, Boolean.TRUE.toString());
                        continue;
                    }
                    if (grandchildname.equals(RequestHint.CACHE_POLICY_DB_ACCESS.getPropertyName())) {
                        this.setStringPropertyValue(grandchildname, grandchild.attributeValue(VALUE));
                        this.setBooleanPropertyValue(PROP_CONTAINS_REQUEST_HINT, Boolean.TRUE.toString());
                        continue;
                    }
                    if (grandchildname.equals(RequestHint.PARAMETER_MAP.getPropertyName())) {
                        this.setBooleanPropertyValue(PROP_CONTAINS_REQUEST_HINT, Boolean.TRUE.toString());
                        if (grandchild.attributeValue(NAME).equals("_env")) continue;
                        throw new V5InvalidAttributeException(XQEMessageKeys.V5_InvalidParameterMapName, grandchild.attributeValue(NAME));
                    }
                    if (grandchildname.equals(RequestHint.SQLJOINSYNTAX.getPropertyName())) {
                        this.setStringPropertyValue(grandchildname, grandchild.attributeValue(VALUE));
                        this.setBooleanPropertyValue(PROP_CONTAINS_REQUEST_HINT, Boolean.TRUE.toString());
                        continue;
                    }
                    if (grandchildname.equals(RequestHint.LOCAL_CACHE_POLICY.getPropertyName())) {
                        this.setStringPropertyValue(grandchildname, grandchild.attributeValue(VALUE));
                        this.setBooleanPropertyValue(PROP_CONTAINS_REQUEST_HINT, Boolean.TRUE.toString());
                        continue;
                    }
                    if (grandchildname.equals(RequestHint.MASTER_DETAIL_OPTIMIZATION.getPropertyName())) {
                        this.setStringPropertyValue(grandchildname, grandchild.attributeValue(VALUE));
                        this.setBooleanPropertyValue(PROP_CONTAINS_REQUEST_HINT, Boolean.TRUE.toString());
                        continue;
                    }
                    if (grandchildname.equals(RequestHint.BURST_KEY_LIST.getPropertyName())) {
                        this.setStringPropertyValue(grandchildname, grandchild.attributeValue(VALUE));
                        this.setBooleanPropertyValue(PROP_CONTAINS_REQUEST_HINT, Boolean.TRUE.toString());
                        continue;
                    }
                    if (grandchildname.equals(RequestHint.BURST_MASTER_QUERY_NAME.getPropertyName())) {
                        this.setStringPropertyValue(grandchildname, grandchild.attributeValue(VALUE));
                        this.setBooleanPropertyValue(PROP_CONTAINS_REQUEST_HINT, Boolean.TRUE.toString());
                        continue;
                    }
                    if (grandchildname.equals(RequestHint.REMOVE_AGGOP_WHEN_FLT_PAA_IS_FALSE.getPropertyName())) {
                        this.setStringPropertyValue(grandchildname, grandchild.attributeValue(VALUE));
                        this.setBooleanPropertyValue(PROP_CONTAINS_REQUEST_HINT, Boolean.TRUE.toString());
                        continue;
                    }
                    if (grandchildname.equals(RequestHint.REMOVE_AGGOP_WHEN_DI_AGG_IS_NONE.getPropertyName())) {
                        this.setStringPropertyValue(grandchildname, grandchild.attributeValue(VALUE));
                        this.setBooleanPropertyValue(PROP_CONTAINS_REQUEST_HINT, Boolean.TRUE.toString());
                        continue;
                    }
                    if (grandchildname.equals(RequestHint.ROW_STITCH_FOR_FACT_LESS_QUERY.getPropertyName())) {
                        this.setStringPropertyValue(grandchildname, grandchild.attributeValue(VALUE));
                        this.setBooleanPropertyValue(PROP_CONTAINS_REQUEST_HINT, Boolean.TRUE.toString());
                        continue;
                    }
                    if (grandchildname.equals(RequestHint.STITCH_WITH_NULLS.getPropertyName())) {
                        this.setStringPropertyValue(grandchildname, grandchild.attributeValue(VALUE));
                        this.setBooleanPropertyValue(PROP_CONTAINS_REQUEST_HINT, Boolean.TRUE.toString());
                        continue;
                    }
                    if (grandchildname.equals(RequestHint.SQLGENERATIONDETATTR.getPropertyName())) {
                        this.setStringPropertyValue(grandchildname, grandchild.attributeValue(VALUE));
                        this.setBooleanPropertyValue(PROP_CONTAINS_REQUEST_HINT, Boolean.TRUE.toString());
                        continue;
                    }
                    if (grandchildname.equals(RequestHint.SQLGENERATIONLEVATTR.getPropertyName())) {
                        this.setStringPropertyValue(grandchildname, grandchild.attributeValue(VALUE));
                        this.setBooleanPropertyValue(PROP_CONTAINS_REQUEST_HINT, Boolean.TRUE.toString());
                        continue;
                    }
                    if (grandchildname.equals(RequestHint.NATIVE_SQL_IN_CTE.getPropertyName())) {
                        this.setStringPropertyValue(grandchildname, grandchild.attributeValue(VALUE));
                        this.setBooleanPropertyValue(PROP_CONTAINS_REQUEST_HINT, Boolean.TRUE.toString());
                        continue;
                    }
                    if (grandchildname.equals(RequestHint.SUPPRESS_MESSAGES.getPropertyName())) {
                        this.setStringPropertyValue(grandchildname, grandchild.attributeValue(VALUE));
                        this.setBooleanPropertyValue(PROP_CONTAINS_REQUEST_HINT, Boolean.TRUE.toString());
                        continue;
                    }
                    if (grandchildname.equals(RequestHint.DMR_PRELOAD_CELLS_EXECUTION_MODE.getPropertyName())) {
                        this.setStringPropertyValue(grandchildname, grandchild.attributeValue(VALUE));
                        this.setBooleanPropertyValue(PROP_CONTAINS_REQUEST_HINT, Boolean.TRUE.toString());
                        continue;
                    }
                    V5InvalidElementException e = new V5InvalidElementException(XQEMessageKeys.V5_InvalidElement, grandchildname, childname);
                    if (grandchildname.equals("conservativeATClauseGeneration") || grandchildname.equals("useSQLParameters")) {
                        ExecutionEnvironment ee = (ExecutionEnvironment)env.getExecutionEnvironment();
                        ee.addNag(e.getLocalizedMessage());
                        continue;
                    }
                    throw e;
                }
                continue;
            }
            if (childname.equals(PROP_STRING_MODEL_PATH)) {
                String modelPath = child.getText();
                this.setStringPropertyValue(childname, modelPath);
                ((RequestEnvironment)env.getRequestEnvironment()).setModelPath(modelPath);
                String modelType = child.attributeValue("type");
                if (modelType == null) continue;
                this.setStringPropertyValue(PROP_STRING_MODEL_TYPE, modelType);
                ((RequestEnvironment)env.getRequestEnvironment()).setModelType(modelType);
                continue;
            }
            if (childname.equals(PROP_STRING_REPORT_NAME)) continue;
            throw new V5InvalidElementException(XQEMessageKeys.V5_InvalidElement, childname, inputNode.getName());
        }
        if (!readV5SpecFormat) {
            IXQEQueryNode[] boundDataItems;
            for (IXQEQueryNode iDataItem : boundDataItems = this.getDescendantsOfType(201060, false)) {
                V5DataItem dataItem;
                IXQEQueryNode[] boundDIRef = (IXQEQueryNode[])iDataItem;
                String refDIId = (String)boundDIRef.getPropertyValue("refDataItemId");
                if (refDIId == null || (dataItem = (V5DataItem)v5IdToV5QueryNodeMap.get(refDIId)) == null) continue;
                boundDIRef.setRefDataItem(dataItem);
            }
        }
        if ((queryFeedback = inputNode.getParent().element("queryFeedback")) != null) {
            Iterator it = queryFeedback.elementIterator(PROPERTY);
            while (it.hasNext()) {
                Element propertyElement = (Element)it.next();
                String nameValue = propertyElement.attributeValue(NAME);
                if (nameValue == null || nameValue.equals("")) continue;
                String queryNameValue = propertyElement.attributeValue("queryName");
                if (queryNameValue == null || queryNameValue.equals("")) {
                    for (IXQEQueryNode child : this.getChildrenOfType(101055)) {
                        V5QueryResultDefinition v5QRD = (V5QueryResultDefinition)child;
                        v5QRD.addQueryFeedback(nameValue);
                    }
                    continue;
                }
                V5QueryResultDefinition qrd = this.getQRD(queryNameValue);
                if (qrd == null) continue;
                qrd.addQueryFeedback(nameValue);
            }
            it = queryFeedback.elementIterator("migrationBaseVersion");
            if (it.hasNext()) {
                ((RequestEnvironment)env.getRequestEnvironment()).setMigrationBaseVersion(RequestEnvironment.convertMigrationBaseVersion(((Element)it.next()).getText()));
            }
        }
        if (((RequestEnvironment)env.getRequestEnvironment()).getMigrationBaseVersion() == RequestEnvironment.MigrationBaseVersionEnum.NOT_DEFINED && (migrateBaseVersionInConfig = env.getMultiRequestContext().fetchXQEConfigurationProperty("queryPlanning.migrationBaseVersion.[@value]", RequestEnvironment.MigrationBaseVersionEnum.NOT_DEFINED.name())) != null && !((String)migrateBaseVersionInConfig).equals(RequestEnvironment.MigrationBaseVersionEnum.NOT_DEFINED.name())) {
            ((RequestEnvironment)env.getRequestEnvironment()).setMigrationBaseVersion(RequestEnvironment.convertMigrationBaseVersion((String)migrateBaseVersionInConfig));
        }
        this.setPropertyValue(PROP_BOOLEAN_UNREFERENCED_QRDS_REMOVED, Boolean.FALSE);
    }

    public V5Query getV5Query(String refquery) {
        V5Query v5Query = null;
        HashMap queries = (HashMap)this.getPropertyValue(PROP_MAP_QUERYNAME_TO_QUERYNODE);
        if (queries != null && (v5Query = (V5Query)queries.get(refquery)) != null) {
            return v5Query;
        }
        String v5QueryName = null;
        for (int i = 0; i < this.getNumberChildren(); ++i) {
            IXQEQueryNode v5QueryNode = this.getChild(i);
            if (v5QueryNode.getNodeType() != 101006 || !refquery.equals(v5QueryName = (String)v5QueryNode.getPropertyValue(NAME))) continue;
            return (V5Query)v5QueryNode;
        }
        return null;
    }

    public V5Query getV5QueryExternal(String queryName) {
        V5QuerySet querySetParent;
        V5Query query = this.getV5Query(queryName);
        if (query == null && (querySetParent = (V5QuerySet)this.getAncestorOfType(101002)) != null) {
            query = querySetParent.getV5QueryExternal(queryName);
        }
        return query;
    }

    public String getModelPath() {
        return (String)this.getPropertyValue(PROP_STRING_MODEL_PATH);
    }

    public String getModelType() {
        return (String)this.getPropertyValue(PROP_STRING_MODEL_TYPE);
    }

    @Override
    public int isValidPlannedQuery() {
        IXQEQueryNode[] children = this.getChildren();
        if (0 == children.length) {
            return -1;
        }
        return super.isValidPlannedQuery();
    }

    public void setNonReusable(boolean value) {
        this.setPropertyValue(PROP_NON_REUSABLE, value);
    }

    public boolean isNonReusable() {
        Boolean result = (Boolean)this.getPropertyValue(PROP_NON_REUSABLE);
        if (result == null) {
            return false;
        }
        return result;
    }

    public V5QueryResultDefinition getQRD(String qrdName) {
        V5QueryResultDefinition v5QueryResultDefinition = null;
        Iterator<IXQEQueryNode> childIterator = this.getChildrenIterator();
        while (childIterator.hasNext()) {
            IXQEQueryNode child = childIterator.next();
            if (child.getType() != 101055 || !((V5QueryResultDefinition)child).getName().equals(qrdName)) continue;
            v5QueryResultDefinition = (V5QueryResultDefinition)child;
            break;
        }
        return v5QueryResultDefinition;
    }

    public boolean hasNoQRDs() {
        boolean hasNoQRDs = true;
        Iterator<IXQEQueryNode> childIterator = this.getChildrenIterator();
        while (childIterator.hasNext()) {
            IXQEQueryNode child = childIterator.next();
            if (child.getType() != 101055) continue;
            hasNoQRDs = false;
            break;
        }
        return hasNoQRDs;
    }

    public void setUnreferencedQueriesRemoved() {
        this.setPropertyValue(PROP_BOOLEAN_UNREFERENCED_QUERIES_REMOVED, Boolean.TRUE);
    }

    public boolean getUnreferencedQueriesRemoved() {
        Boolean unreferencedQueriesRemoved = (Boolean)this.getPropertyValue(PROP_BOOLEAN_UNREFERENCED_QUERIES_REMOVED);
        if (unreferencedQueriesRemoved == null) {
            return false;
        }
        return unreferencedQueriesRemoved;
    }

    public boolean getUnreferencedQRDsRemoved() {
        Boolean unreferencedQRDsRemoved = (Boolean)this.getPropertyValue(PROP_BOOLEAN_UNREFERENCED_QRDS_REMOVED);
        if (unreferencedQRDsRemoved == null) {
            return false;
        }
        return unreferencedQRDsRemoved;
    }

    public void setUnreferencedQRDsRemoved() {
        this.setPropertyValue(PROP_BOOLEAN_UNREFERENCED_QRDS_REMOVED, Boolean.TRUE);
    }

    public void setUnreferencedQueryItemsTreeWalker(Object walker) {
        this.setPropertyValue(PROP_OBJECT_UNREFERENCED_QUERY_ITEMS_TREE_WALKER, walker);
    }

    public Object getUnreferencedQueryItemsTreeWalker() {
        return this.getPropertyValue(PROP_OBJECT_UNREFERENCED_QUERY_ITEMS_TREE_WALKER);
    }

    public Set<V5QueryResultDefinition> getUnreferencedQRDs() {
        Set<V5QueryResultDefinition> referencedQRDs = new HashSet<V5QueryResultDefinition>();
        HashSet<V5QueryResultDefinition> unreferencedQRDs = new HashSet<V5QueryResultDefinition>();
        this.getQRDsDirectlyReferencedFromRetrieveDataset(referencedQRDs, unreferencedQRDs);
        while (unreferencedQRDs.removeAll(referencedQRDs = V5QuerySet.getQRDsDirectlyReferencedAsDetail(referencedQRDs, unreferencedQRDs))) {
        }
        return unreferencedQRDs;
    }

    public List<V5QueryResultDefinition> getReferencedQRDs(V5Query v5Query) {
        ArrayList<V5QueryResultDefinition> v5QueryResultDefinitions = new ArrayList<V5QueryResultDefinition>();
        Iterator<IXQEQueryNode> childIterator = this.getChildrenIterator();
        String queryName = v5Query.getV5QueryName();
        while (childIterator.hasNext()) {
            V5QueryResultDefinition qrd;
            IXQEQueryNode child = childIterator.next();
            if (child.getType() != 101055 || !(qrd = (V5QueryResultDefinition)child).getV5Query().getV5QueryName().equals(queryName)) continue;
            v5QueryResultDefinitions.add(qrd);
        }
        return v5QueryResultDefinitions;
    }

    private void getQRDsDirectlyReferencedFromRetrieveDataset(Set<V5QueryResultDefinition> referencedQRDs, Set<V5QueryResultDefinition> unreferencedQRDs) {
        Iterator<IXQEQueryNode> childIterator = this.getChildrenIterator();
        while (childIterator.hasNext()) {
            IXQEQueryNode child = childIterator.next();
            if (child.getType() != 101055) continue;
            V5QueryResultDefinition v5QueryResultDefinition = (V5QueryResultDefinition)child;
            if (this.isQRDDirectlyReferencedFromRetrieveDataset(v5QueryResultDefinition)) {
                referencedQRDs.add(v5QueryResultDefinition);
                continue;
            }
            unreferencedQRDs.add(v5QueryResultDefinition);
        }
    }

    public String getQueryNameReferencedFromRetrieveDataset() {
        IXQEQueryNode child;
        Iterator<IXQEQueryNode> childIterator = this.getChildrenIterator();
        while (childIterator.hasNext()) {
            V5QueryResultDefinition v5QueryResultDefinition;
            child = childIterator.next();
            if (child.getType() != 101055 || !this.isQRDDirectlyReferencedFromRetrieveDataset(v5QueryResultDefinition = (V5QueryResultDefinition)child)) continue;
            return v5QueryResultDefinition.getV5Query().getV5QueryName();
        }
        childIterator = this.getChildrenIterator();
        while (childIterator.hasNext()) {
            child = childIterator.next();
            if (child.getType() != 401005) continue;
            RSAPIDataset dataset = (RSAPIDataset)child;
            return dataset.getRefQueryName();
        }
        return null;
    }

    private static Set<V5QueryResultDefinition> getQRDsDirectlyReferencedAsDetail(Set<V5QueryResultDefinition> referencedQRDs, Set<V5QueryResultDefinition> unreferencedQRDs) {
        HashSet<V5QueryResultDefinition> result = new HashSet<V5QueryResultDefinition>();
        block0: for (V5QueryResultDefinition unreferencedQRD : unreferencedQRDs) {
            for (V5QueryResultDefinition referencedQRD : referencedQRDs) {
                if (!referencedQRD.referencesDetailQRD(unreferencedQRD)) continue;
                result.add(unreferencedQRD);
                continue block0;
            }
        }
        return result;
    }

    public void recordPropertyElements(Element rootElement) {
        List properties = rootElement.elements(PROPERTY);
        for (Element property : properties) {
            String name = property.attribute(NAME).getStringValue();
            String value = property.attribute(VALUE).getStringValue();
            if (name == null || value == null) {
                this.throwInternalError("Property does not have name or value pair");
            }
            this.setPropertyValue(name, value);
        }
    }

    public void setRetrieveDatasetArray(String[] retrieveDatasetArray) {
        Arrays.sort(retrieveDatasetArray);
        this.setPropertyValue(PROP_OBJECT_ARRAY_RETRIEVE_DATASETS, retrieveDatasetArray);
    }

    public String[] getRetrieveDatasetArray() {
        Object property = this.getPropertyValue(PROP_OBJECT_ARRAY_RETRIEVE_DATASETS);
        if (property == null) {
            return new String[0];
        }
        return (String[])property;
    }

    private boolean isQRDDirectlyReferencedFromRetrieveDataset(V5QueryResultDefinition v5QueryResultDefinition) {
        Object[] retrieveDatasetArray = this.getRetrieveDatasetArray();
        boolean result = retrieveDatasetArray.length == 0 ? true : Arrays.binarySearch(retrieveDatasetArray, v5QueryResultDefinition.getName()) >= 0;
        return result;
    }

    public boolean containsRequestHints() {
        Object obj = this.getPropertyValue(PROP_CONTAINS_REQUEST_HINT);
        if (obj == null) {
            return false;
        }
        return (Boolean)obj;
    }

    public boolean isNoDataMode() {
        Boolean isNoDataMode = this.getBooleanPropertyValue(RequestHint.NO_DATA_MODE.getPropertyName());
        return isNoDataMode != null && isNoDataMode.equals(Boolean.TRUE);
    }

    public boolean isMultidimensionalSubquery() {
        Object b = this.getPropertyValue(MULTIDIM_SUBQUERY);
        if (b == null) {
            return false;
        }
        return b == Boolean.TRUE;
    }

    public Map<String, List<V5Parameter>> getV5ParametersMap() {
        return (Map)this.getPropertyValue(PROP_OBJECT_V5PARAMETERS_MAP);
    }

    public void setV5ParametersMap(Map<String, List<V5Parameter>> map) {
        this.setPropertyValue(PROP_OBJECT_V5PARAMETERS_MAP, map);
    }

    public static V5QuerySet getRootQuerySet(PlanningEnvironment environment, IXQEQueryNode node) {
        IXQEQueryNode root;
        if (environment != null && (root = environment.getRoot()).getType() == 101002) {
            return (V5QuerySet)root;
        }
        return (V5QuerySet)node.getAncestorOfType(101002);
    }

    public static V5QuerySet getRootQuerySet(IXQEQueryNode node) {
        return (V5QuerySet)node.getAncestorOfType(101002);
    }

    public void addResolvedQuery(String queryName) {
        ArrayList<String> resolvedQueries = (ArrayList<String>)this.getPropertyValue(PROP_RESOLVED_QUERIES);
        if (resolvedQueries == null) {
            resolvedQueries = new ArrayList<String>();
            this.setPropertyValue(PROP_RESOLVED_QUERIES, resolvedQueries);
        }
        resolvedQueries.add(queryName);
    }

    public void addQueryInQueryMap(String queryName, V5Query v5Query) {
        HashMap<String, V5Query> queryMap = (HashMap<String, V5Query>)this.getPropertyValue(PROP_MAP_QUERYNAME_TO_QUERYNODE);
        if (queryMap == null) {
            queryMap = new HashMap<String, V5Query>();
            this.setPropertyValue(PROP_MAP_QUERYNAME_TO_QUERYNODE, queryMap);
        }
        queryMap.put(queryName, v5Query);
    }

    public TreeSet<String> getDependentQueriesOf(String v5QueryName) {
        TreeMap queryDependencyMap = (TreeMap)this.getPropertyValue(PROP_QUERY_DEPENDENCY_MAP);
        if (queryDependencyMap != null) {
            return (TreeSet)queryDependencyMap.get(v5QueryName);
        }
        return null;
    }

    public void setMaxColumnNameLength(int maxColumnNameLength) {
        Integer maxLength = this.getIntegerPropertyValue(PROP_MAXCOLUMNNAMELENGTH);
        if (maxLength == null || maxColumnNameLength < maxLength) {
            Integer value = maxColumnNameLength;
            this.setIntegerPropertyValue(PROP_MAXCOLUMNNAMELENGTH, value.toString());
        }
    }

    public int getMaxColumnNameLength() {
        Integer maxLength = this.getIntegerPropertyValue(PROP_MAXCOLUMNNAMELENGTH);
        if (maxLength == null) {
            return 18;
        }
        return maxLength;
    }

    public void setMaxTableNameLength(int maxTableNameLength) {
        Integer maxLength = this.getIntegerPropertyValue(PROP_MAXTABLENAMELENGTH);
        if (maxLength == null || maxTableNameLength < maxLength) {
            Integer value = maxTableNameLength;
            this.setIntegerPropertyValue(PROP_MAXTABLENAMELENGTH, value.toString());
        }
    }

    public int getMaxTableNameLength() {
        Integer maxLength = this.getIntegerPropertyValue(PROP_MAXTABLENAMELENGTH);
        if (maxLength == null) {
            return 18;
        }
        return maxLength;
    }

    public boolean addDataSource(IDataSource dataSource) {
        HashSet<IDataSource> dataSourceProperty = (HashSet<IDataSource>)this.getPropertyValue(PROP_DATASOURCES);
        if (dataSourceProperty == null) {
            dataSourceProperty = new HashSet<IDataSource>();
            dataSourceProperty.add(dataSource);
            this.setPropertyValue(PROP_DATASOURCES, dataSourceProperty);
            return true;
        }
        if (!dataSourceProperty.contains(dataSource)) {
            dataSourceProperty.add(dataSource);
            return true;
        }
        return false;
    }

    public Set<IDataSource> getDataSources() {
        return (Set)this.getPropertyValue(PROP_DATASOURCES);
    }

    public void setQueryItemList(SQLQueryItemList qItems) {
        this.setPropertyValue(PROP_OBJECT_QUERY_ITEMS, qItems);
    }

    public SQLQueryItemList getQueryItemList() {
        return (SQLQueryItemList)this.getPropertyValue(PROP_OBJECT_QUERY_ITEMS);
    }

    public List<V5Query> getReferencingQueries(String subQueryName, PlanningEnvironment environment) {
        IXQEQueryNode[] queries;
        ArrayList<V5Query> ret = new ArrayList<V5Query>();
        for (IXQEQueryNode current : queries = this.getChildrenOfType(101006)) {
            V5Query query = (V5Query)current;
            Set<String> subQueries = query.getSubQueryNames(environment);
            if (!subQueries.contains(subQueryName)) continue;
            ret.add(query);
        }
        return ret;
    }

    public boolean isExecutingSqlQuery() {
        return this.getPropertyValue(PROP_EXECUTING_SQL_QUERY) != null;
    }

    public void setExecutingSqlQuery() {
        this.setPropertyValue(PROP_EXECUTING_SQL_QUERY, true);
    }

    public void addSource(ISource src) {
        TreeSet<ISource> usedSrcs = (TreeSet<ISource>)this.getPropertyValue(PROP_USED_SOURCES);
        if (usedSrcs == null) {
            usedSrcs = new TreeSet<ISource>();
            this.setPropertyValue(PROP_USED_SOURCES, usedSrcs);
        }
        usedSrcs.add(src);
    }

    public List<ISource> getSources() {
        TreeSet usedSrcs = (TreeSet)this.getPropertyValue(PROP_USED_SOURCES);
        if (usedSrcs == null) {
            return null;
        }
        return new ArrayList<ISource>(usedSrcs);
    }

    public void setQueryRefersToFMPackage(boolean queryRefersToFMPackage) {
        this.setPropertyValue(PROP_QUERY_REFERS_TO_FM_PACKAGE, queryRefersToFMPackage);
    }

    public boolean getQueryRefersToFMPackage() {
        Boolean queryRefersToFMPackage = (Boolean)this.getPropertyValue(PROP_QUERY_REFERS_TO_FM_PACKAGE);
        if (queryRefersToFMPackage == null) {
            return false;
        }
        return queryRefersToFMPackage;
    }

    public void setForREST(boolean value) {
        if (!value) {
            this.removeProperty(PROP_FOR_REST);
            return;
        }
        this.setPropertyValue(PROP_FOR_REST, Boolean.TRUE);
    }

    public boolean isForREST() {
        return this.getPropertyValue(PROP_FOR_REST) != null && this.getPropertyValue(PROP_FOR_REST) == Boolean.TRUE;
    }

    public void setPromptHandling(String value) {
        this.setPropertyValue(PROP_PROMPT_HANDLING, value);
    }

    public String getPromptHandling() {
        return (String)this.getPropertyValue(PROP_PROMPT_HANDLING);
    }

    public boolean getIsPromptHandlingNoFault() {
        return "nofault".equals(this.getPromptHandling());
    }

    public Governors getGovernorOfRetrieveDatasetV5Query() {
        String queryName = this.getQueryNameReferencedFromRetrieveDataset();
        if (StringUtils.isEmpty((CharSequence)queryName)) {
            return null;
        }
        V5Query query = this.getV5Query(queryName);
        if (query == null) {
            return null;
        }
        Governors gov = query.getGovernors();
        return gov;
    }

    public static enum RequestHint {
        NO_DATA_MODE("noDataMode"),
        DESIGN_MODE("designMode"),
        EXECUTION_OPTIMIZATION("executionOptimization"),
        LOCAL_CACHE("localCache"),
        PARAMETER_MAP("parameterMap"),
        INCLUDE_EMPTY_CELLS("includeEmptyCells"),
        SUPPRESS_DUPLICATE_MEASURE_VALUES("suppressDuplicateMeasureValues"),
        MAX_TABLE_NAME_LENGTH("maxTableNameLength"),
        OPTIMIZE_MASTER_DETAIL_FOR_ALL_ROWS("optimizeMasterDetailForAllRows"),
        CACHE_POLICY_CONNECTION_COMMAND_BLOCKS("cachePolicyConnectionCommandBlocks"),
        CACHE_POLICY_DB_ACCESS("cachePolicyDBAccess"),
        SQLJOINSYNTAX("useSQLJoinSyntax"),
        LOCAL_CACHE_POLICY("localCachePolicy"),
        MASTER_DETAIL_OPTIMIZATION("masterDetailOptimization"),
        BURST_KEY_LIST("burstKeyList"),
        BURST_MASTER_QUERY_NAME("burstMasterQuery"),
        REMOVE_AGGOP_WHEN_FLT_PAA_IS_FALSE(Governors.AllGovernors.REMOVE_AGGOP_WHEN_FLT_PAA_IS_FALSE.getKey()),
        REMOVE_AGGOP_WHEN_DI_AGG_IS_NONE(Governors.AllGovernors.REMOVE_AGGOP_WHEN_DI_AGG_IS_NONE.getKey()),
        ROW_STITCH_FOR_FACT_LESS_QUERY(Governors.AllGovernors.ROW_STITCH_FOR_FACT_LESS_QUERY.getKey()),
        STITCH_WITH_NULLS(Governors.AllGovernors.STITCH_WITH_NULLS.getKey()),
        SQLGENERATIONDETATTR(Governors.AllGovernors.SQLGENERATIONDETATTR.getKey()),
        SQLGENERATIONLEVATTR(Governors.AllGovernors.SQLGENERATIONLEVATTR.getKey()),
        NATIVE_SQL_IN_CTE(Governors.AllGovernors.NATIVE_SQL_IN_CTE.getKey()),
        SUPPRESS_MESSAGES(Governors.AllGovernors.SUPPRESS_MESSAGES.getKey()),
        DMR_PRELOAD_CELLS_EXECUTION_MODE(Governors.AllGovernors.DMR_PRELOAD_CELLS_EXECUTION_MODE.getKey()),
        DATASET_MODE("datasetMode");

        private final String name;

        private RequestHint(String propName) {
            this.name = propName;
        }

        public String getPropertyName() {
            return this.name;
        }
    }
}

