/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.v5.modquery;

import com.cognos.xqe.ast.v5.V5InvalidAttributeException;
import com.cognos.xqe.ast.v5.V5InvalidElementException;
import com.cognos.xqe.ast.v5.V5QueryNode;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import java.util.List;
import org.dom4j.Attribute;
import org.dom4j.Element;

public class ModFilterStringCompare
extends V5QueryNode {
    public static final String NODE_TYPE_NAME = "ModFilterStringCompare";
    public static final String V5_NODE_NAME = "modFilterStringCompare";
    public static final String FILTER_VALUE_PROP = "filterValue";

    @Override
    public int getType() {
        return 101095;
    }

    @Override
    public String getNodeTypeName() {
        return NODE_TYPE_NAME;
    }

    @Override
    public void capture(PlanningEnvironment env, Element inputNode) throws V5InvalidAttributeException, V5InvalidElementException {
        int size = inputNode.attributeCount();
        for (int i = 0; i < size; ++i) {
            Attribute att = inputNode.attribute(i);
            String attname = att.getName();
            if (attname.equals("refDataItem") || attname.equals("operator") || attname.equals("caseInsensitive") || attname.equals("escapeCharacter") || attname.equals("parameterName")) {
                this.setStringPropertyValue(attname, att.getValue());
                continue;
            }
            if (attname.equals("includeNulls") || attname.equals("parameterized")) {
                this.setBooleanPropertyValue(attname, att.getValue());
                continue;
            }
            throw new V5InvalidAttributeException(XQEMessageKeys.V5_InvalidAttribute, attname, inputNode.getName());
        }
        List children = inputNode.elements();
        size = children.size();
        for (int i = 0; i < size; ++i) {
            Element child = (Element)children.get(i);
            String childname = child.getName();
            if (!childname.equals("modFilterValue")) {
                throw new V5InvalidElementException(XQEMessageKeys.V5_InvalidElement, childname, inputNode.getName());
            }
            this.setStringPropertyValue(FILTER_VALUE_PROP, child.getText());
        }
    }
}

