/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.v5.modquery;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.v5.V5InvalidAttributeException;
import com.cognos.xqe.ast.v5.V5InvalidElementException;
import com.cognos.xqe.ast.v5.V5QueryNode;
import com.cognos.xqe.ast.v5.modquery.ModDataItem;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import java.util.List;
import org.dom4j.Attribute;
import org.dom4j.Element;

public class ModQuery
extends V5QueryNode {
    public static final String NODE_TYPE_NAME = "ModQuery";
    public static final String V5_NODE_NAME = "modQuery";

    @Override
    public int getType() {
        return 101079;
    }

    @Override
    public String getNodeTypeName() {
        return NODE_TYPE_NAME;
    }

    @Override
    public void capture(PlanningEnvironment env, Element inputNode) throws V5InvalidAttributeException, V5InvalidElementException {
        XQENodeFactory factory = env.getNodeFactory();
        int size = inputNode.attributeCount();
        for (int i = 0; i < size; ++i) {
            Attribute att = inputNode.attribute(i);
            String attname = att.getName();
            if (attname.equals("name")) {
                this.setStringPropertyValue(attname, att.getValue());
                continue;
            }
            if (attname.equals("autoSummary")) {
                this.setBooleanPropertyValue(attname, att.getValue());
                continue;
            }
            throw new V5InvalidAttributeException(XQEMessageKeys.V5_InvalidAttribute, attname, inputNode.getName());
        }
        List children = inputNode.elements();
        size = children.size();
        for (int i = 0; i < size; ++i) {
            V5QueryNode node;
            Element child = (Element)children.get(i);
            String childname = child.getName();
            if (childname.equals("modDataItems") || childname.equals("modDetailSortList")) {
                node = factory.createV5Node(childname);
                if (node == null) continue;
                this.addChild(node);
                node.capture(env, child);
                continue;
            }
            if (childname.equals("modFilters")) {
                node = factory.createV5Node(childname);
                if (node == null) continue;
                this.addChild(node);
                node.capture(env, child);
                continue;
            }
            if (childname.equals("metadataPath")) {
                String path = child.attributeValue("path");
                if (path == null || path.isEmpty()) continue;
                this.setPropertyValue("metadataPath", path);
                continue;
            }
            throw new V5InvalidElementException(XQEMessageKeys.V5_InvalidElement, childname, inputNode.getName());
        }
    }

    public String getName() {
        return (String)this.getPropertyValue("name");
    }

    public ModDataItem getModDataItemByName(String name) {
        IXQEQueryNode[] items;
        for (IXQEQueryNode item : items = this.getDescendantsOfType(101081, false)) {
            String nm = (String)item.getPropertyValue("name");
            if (!name.equals(nm)) continue;
            return (ModDataItem)item;
        }
        return null;
    }

    public boolean getAutoSummary() {
        Boolean b = this.getBooleanPropertyValue("autoSummary");
        if (b == null) {
            return true;
        }
        return b;
    }
}

