/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.v5.modquery;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.v5.V5InvalidAttributeException;
import com.cognos.xqe.ast.v5.V5InvalidElementException;
import com.cognos.xqe.ast.v5.V5QueryNode;
import com.cognos.xqe.ast.v5.modquery.ModSet;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import java.util.List;
import org.dom4j.Attribute;
import org.dom4j.Element;

public class ModSort
extends ModSet {
    public static final String NODE_TYPE_NAME = "ModSort";
    public static final String V5_NODE_NAME = "modSort";
    public static final String STR_NULL_POSITION = "nullPosition";
    public static final String STR_NULL_FIRST = "first";
    public static final String STR_NULL_LAST = "last";
    public static final String BOOL_SORT_ASCENDING = "sortAscending";

    @Override
    public int getType() {
        return 101087;
    }

    @Override
    public String getNodeTypeName() {
        return NODE_TYPE_NAME;
    }

    public boolean isSortAscending() {
        return this.getBooleanPropertyValue(BOOL_SORT_ASCENDING);
    }

    public void setSortAscending(boolean sortAscendingValue) {
        this.setPropertyValue(BOOL_SORT_ASCENDING, sortAscendingValue);
    }

    public void setNullPosition(String nullPositionValue) {
        this.setPropertyValue(STR_NULL_POSITION, nullPositionValue);
    }

    public String getNullPosition() {
        return (String)this.getPropertyValue(STR_NULL_POSITION);
    }

    @Override
    public void capture(PlanningEnvironment env, Element inputNode) throws V5InvalidAttributeException, V5InvalidElementException {
        int i;
        XQENodeFactory factory = env.getNodeFactory();
        List children = inputNode.elements();
        int size = children.size();
        V5QueryNode modBaseSet = null;
        for (i = 0; i < size; ++i) {
            Element child = (Element)children.get(i);
            String childname = child.getName();
            if (childname.equals("modBaseSet") || childname.equals("modSortBy")) {
                V5QueryNode node = factory.createV5Node(childname);
                if (childname.equals("modBaseSet")) {
                    modBaseSet = node;
                }
                if (node == null) continue;
                this.addChild(node);
                node.capture(env, child);
                continue;
            }
            throw new V5InvalidElementException(XQEMessageKeys.V5_InvalidElement, childname, inputNode.getName());
        }
        if (modBaseSet == null) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "invalid modSort as it has no child of type modBaseSet");
        }
        size = inputNode.attributeCount();
        this.setSortAscending(true);
        for (i = 0; i < size; ++i) {
            Attribute att = inputNode.attribute(i);
            String attname = att.getName();
            if (attname.equals(STR_NULL_POSITION)) {
                this.setNullPosition(att.getValue());
                continue;
            }
            if (attname.equals("ascending")) {
                this.setSortAscending(att.getValue().equals(Boolean.TRUE.toString()));
                continue;
            }
            throw new V5InvalidAttributeException(XQEMessageKeys.V5_InvalidAttribute, attname, inputNode.getName());
        }
        if (this.getNullPosition() == null) {
            if (this.isSortAscending()) {
                this.setNullPosition(STR_NULL_FIRST);
            } else {
                this.setNullPosition(STR_NULL_LAST);
            }
        }
    }

    @Override
    public boolean isContextDependent() {
        Boolean b = (Boolean)this.getPropertyValue("contextDepedent");
        if (b == null) {
            IXQEQueryNode[] tuple;
            b = Boolean.FALSE;
            IXQEQueryNode[] sortBy = this.getChildrenOfType(101097);
            if (sortBy != null && sortBy.length == 1 && (tuple = sortBy[0].getChildrenOfType(101098)) != null && tuple.length > 0) {
                b = Boolean.TRUE;
            }
            this.setPropertyValue("contextDepedent", b);
        }
        return b;
    }
}

