/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.v5.result;

import com.cognos.xqe.ast.v5.V5InvalidAttributeException;
import com.cognos.xqe.ast.v5.V5InvalidElementException;
import com.cognos.xqe.ast.v5.V5QueryNode;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import java.util.List;
import org.dom4j.Attribute;
import org.dom4j.Element;

public class V5PropertyExpression
extends V5QueryNode {
    public static final String NODE_TYPE_NAME = "V5PropertyExpression";
    public static final String V5_NODE_NAME = "propertyExpression";
    public static final String PROP_STRING_EXPRESSION = "expression";

    @Override
    public int getType() {
        return 101054;
    }

    @Override
    public String getNodeTypeName() {
        return NODE_TYPE_NAME;
    }

    @Override
    public void capture(PlanningEnvironment env, Element inputNode) throws V5InvalidAttributeException, V5InvalidElementException {
        if (inputNode.attributeCount() > 0) {
            Attribute att = inputNode.attribute(0);
            String attname = att.getName();
            throw new V5InvalidAttributeException(XQEMessageKeys.V5_InvalidAttribute, attname, inputNode.getName());
        }
        List children = inputNode.elements();
        if (children.size() > 0) {
            Element child = (Element)children.get(0);
            String childname = child.getName();
            throw new V5InvalidElementException(XQEMessageKeys.V5_InvalidElement, childname, inputNode.getName());
        }
        this.setStringPropertyValue(PROP_STRING_EXPRESSION, inputNode.getText());
    }
}

