/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.v5.result;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.localprocessing.OLAPEmptyRowDecoration;
import com.cognos.xqe.ast.localprocessing.OLAPHierarchyDecoration;
import com.cognos.xqe.ast.localprocessing.RelationalOlapDecorationNode;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.ast.v5.V5InvalidAttributeException;
import com.cognos.xqe.ast.v5.V5InvalidElementException;
import com.cognos.xqe.ast.v5.V5QueryNode;
import com.cognos.xqe.ast.v5.result.V5EdgeGroup;
import com.cognos.xqe.ast.v5Exp.V5BoundDataItemReference;
import com.cognos.xqe.ast.v5Exp.V5SimpleNode;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.rsapi.RSAPIDataItem;
import com.cognos.xqe.rsapi.RSAPIEdgeRowset;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.util.pool.XQEIntegerPool;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import org.dom4j.Attribute;
import org.dom4j.Element;

public class V5ValueSet
extends V5QueryNode {
    public static final String NODE_TYPE_NAME = "V5ValueSet";
    public static final String V5_NODE_NAME = "valueSet";
    public static final String PROP_STRING_NAME = "name";
    public static final String PROP_STRING_REF_DATAITEM = "refDataItem";
    public static final String PROP_INTEGER_SOLVE_ORDER = "solveOrder";
    public static final String PROP_STRING_MD_DATAITEM_NAME = "MDDataItemName";
    public static final String PROP_SPACER = "spacer";
    public static final String PROP_NO_CELL_VALUE = "noCellValue";
    public static final String PROP_CELL_VALUE = "withCellValue";
    public static final String PROP_SPACER_NO_CELL_VALUE = "spacerNoCellValue";
    public static final String PROP_SPACER_CELL_VALUE = "spacerCellValue";
    public static final String PROP_SPACER_REPALCEMENT = "spacerReplacement";
    private static final String PROP_STRING_IS_REPORT_SUMMARY = "isReportSummary";
    public static final String PROP_STRING_IS_REPORT_DETAIL = "isReportDetail";
    public static final String PROP_STRING_DETAIL_AUTOMATIC = "detailIsAutomatic";
    private static final String PROP_EMPTY_ROW_DECORATIONS = "emptyRowDecos";
    public static final String PROP_EMPTY_VALUESET_DECORATION = "emptyValueSetDeco";
    public static final String PROP_NORMALIZATION_HIERARCHY = "normalizationHierarchy";
    private static final String GROUP_HEADER = "groupHeader";
    private static final String GROUP_BODY = "groupBody";
    private static final String GROUP_FOOTER = "groupFooter";
    private static final String GROUP_SORT = "groupSort";
    private static final String PROPERTY_EXPRESSION = "propertyExpressions";
    private static final String PROP_CLONED_EDGEGROUP = "clonedEdgeGroup";
    public static final Integer NOT_CLONED = XQEIntegerPool.getInteger(-1);
    public static final String PROP_AS_REPORTSUMMARY = "treatedAsReportSummary";
    public static final String PROP_VALUESETEXPRESSION_RETRIEVED = "retrieveV5ValueSetExpressionApplied";
    public static final String HAS_DIFF_HIER_ORDER_ON_SIBLING_PATH = "hasDiffHierOrderOnSiblingPath";

    @Override
    public int getType() {
        return 101057;
    }

    @Override
    public String getNodeTypeName() {
        return NODE_TYPE_NAME;
    }

    public final String getV5ElementName() {
        return V5_NODE_NAME;
    }

    @Override
    public void capture(PlanningEnvironment env, Element inputNode) throws V5InvalidAttributeException, V5InvalidElementException {
        boolean readV5SpecFormat = env.isReadV5SpecFormat();
        XQENodeFactory factory = env.getNodeFactory();
        int size = inputNode.attributeCount();
        for (int i = 0; i < size; ++i) {
            Attribute att = inputNode.attribute(i);
            String attname = att.getName();
            if (attname.equals(PROP_STRING_NAME) || attname.equals(PROP_STRING_REF_DATAITEM) || attname.equals(PROP_STRING_MD_DATAITEM_NAME)) {
                this.setStringPropertyValue(attname, att.getValue());
                continue;
            }
            if (attname.equals(PROP_INTEGER_SOLVE_ORDER)) {
                this.setIntegerPropertyValue(attname, att.getValue());
                continue;
            }
            if (attname.equals(PROP_SPACER)) {
                String value = att.getValue();
                if (value.equals(PROP_NO_CELL_VALUE)) {
                    this.setSpacerNoCellValue(true);
                    this.setIsReportDetail(false);
                    continue;
                }
                if (!value.equals(PROP_CELL_VALUE)) continue;
                this.setSpacerCellValue(true);
                this.setIsReportDetail(true);
                continue;
            }
            if (!readV5SpecFormat) continue;
            V5InvalidAttributeException e = new V5InvalidAttributeException(XQEMessageKeys.V5_InvalidAttribute, attname, inputNode.getName());
            ExecutionEnvironment ee = (ExecutionEnvironment)env.getExecutionEnvironment();
            ee.addNag(e.getLocalizedMessage());
        }
        List children = inputNode.elements();
        size = children.size();
        for (int i = 0; i < size; ++i) {
            Element child = (Element)children.get(i);
            String childname = child.getName();
            if (childname.equals(PROPERTY_EXPRESSION) || childname.equals(GROUP_SORT)) {
                List grandchildren = child.elements();
                int gsize = grandchildren.size();
                for (int j = 0; j < gsize; ++j) {
                    Element grandchild = (Element)grandchildren.get(j);
                    String grandchildname = grandchild.getName();
                    V5QueryNode node = factory.createV5Node(grandchildname);
                    if (node == null) continue;
                    this.addChild(node);
                    node.capture(env, grandchild);
                }
                continue;
            }
            if (childname.equals(GROUP_HEADER) || childname.equals("V5GroupHeader") || childname.equals(GROUP_BODY) || childname.equals("V5GroupBody") || childname.equals(GROUP_FOOTER) || childname.equals("V5GroupFooter") || childname.equals("V5SortItem")) {
                V5QueryNode node = factory.createV5Node(childname);
                if (node == null) continue;
                this.addChild(node);
                node.capture(env, child);
                continue;
            }
            throw new V5InvalidElementException(XQEMessageKeys.V5_InvalidElement, childname, inputNode.getName());
        }
    }

    public void setRefDataItemProperty(String refDataItemName) {
        this.setPropertyValue(PROP_STRING_REF_DATAITEM, refDataItemName);
    }

    public String getRefDataItemProperty() {
        return (String)this.getPropertyValue(PROP_STRING_REF_DATAITEM);
    }

    public void setNameProperty(String name) {
        this.setPropertyValue(PROP_STRING_NAME, name);
    }

    public String getNameProperty() {
        return (String)this.getPropertyValue(PROP_STRING_NAME);
    }

    public int getDepth() {
        IXQEQueryNode[] v5EdgeGroups = this.getAncestorsOfType(101050);
        if (v5EdgeGroups == null) {
            this.throwInternalError("");
        }
        return v5EdgeGroups.length;
    }

    public Integer getHierarchyDepth(boolean calculate) {
        Integer hierarchyDepth = null;
        IXQEQueryNode v5EdgeGroup = this.getParent();
        if (v5EdgeGroup.getType() == 101050) {
            IXQEQueryNode[] v5EdgeGroups;
            if (!calculate) {
                hierarchyDepth = ((V5EdgeGroup)v5EdgeGroup).getPropertyHierarchyDepth();
            }
            if (hierarchyDepth == null && (v5EdgeGroups = this.getAncestorsOfType(101050)) != null) {
                HashSet<IHierarchy> hierarchySet = new HashSet<IHierarchy>();
                for (int i = 0; i < v5EdgeGroups.length; ++i) {
                    IHierarchy edgeGroupHierarchy = ((V5EdgeGroup)v5EdgeGroups[i]).getPropertyHierarchy();
                    if (edgeGroupHierarchy == null) continue;
                    hierarchySet.add(edgeGroupHierarchy);
                }
                int hierDepth = hierarchySet.size();
                hierarchyDepth = XQEIntegerPool.getInteger(hierDepth);
            }
        }
        return hierarchyDepth;
    }

    public V5SimpleNode[] getProjectedExpressions() {
        ArrayList<IXQEQueryNode> projectedExprs = new ArrayList<IXQEQueryNode>();
        int[] categories = new int[]{201122, 201121, 201125, 201116, 201117, 201110, 201127};
        MDXQuery mdxQuery = (MDXQuery)this.getAncestorOfType(1002);
        int numberChildren = this.getNumberChildren();
        for (int idx = 0; idx < numberChildren; ++idx) {
            IXQEQueryNode projNode = this.getChild(idx);
            if (projNode.getType() == 601024) {
                IXQEQueryNode expr = null;
                if (((RelationalOlapDecorationNode)projNode).getExpression() == null && ((RelationalOlapDecorationNode)projNode).getWrapRefObjectName() != null && !((RelationalOlapDecorationNode)projNode).getWrapRefObjectName().isEmpty()) {
                    IXQEQueryNode[] relOLAPDecos;
                    for (IXQEQueryNode relOLAPDeco : relOLAPDecos = mdxQuery.getDescendantsOfType(601024, false)) {
                        RelationalOlapDecorationNode curRrelOLAPDeco = (RelationalOlapDecorationNode)relOLAPDeco;
                        if (!((RelationalOlapDecorationNode)projNode).getWrapRefObjectName().equals(curRrelOLAPDeco.getWrapName()) || curRrelOLAPDeco.getExpression() == null) continue;
                        expr = curRrelOLAPDeco.getExpression();
                        break;
                    }
                    if (expr == null) {
                        projNode.throwInternalError("getExpression() == null");
                    }
                } else {
                    expr = ((RelationalOlapDecorationNode)projNode).getExpression();
                }
                if (expr != null) {
                    projNode = expr;
                }
            }
            if (projNode.getType() == 201060) {
                projNode = ((V5BoundDataItemReference)projNode).getReferencedExpression();
            }
            while (projNode.getType() == 101003) {
                projNode = projNode.getChild(0);
            }
            if (!projNode.isOfCategories(categories)) continue;
            projectedExprs.add(projNode);
            break;
        }
        V5SimpleNode[] finalNodeArray = new V5SimpleNode[projectedExprs.size()];
        finalNodeArray = projectedExprs.toArray(finalNodeArray);
        return finalNodeArray;
    }

    @Override
    public MDXHierInfo getHierarchyInfo() {
        V5SimpleNode[] projectedExprs = this.getProjectedExpressions();
        MDXHierInfo op1HierInfo = null;
        if (projectedExprs.length == 1) {
            op1HierInfo = V5SimpleNode.getHierarchyInfo(projectedExprs[0]);
            for (int i = 1; i < projectedExprs.length; ++i) {
                MDXHierInfo op2HierInfo = V5SimpleNode.getHierarchyInfo(projectedExprs[i]);
                op1HierInfo.unionHierInfo(op2HierInfo);
            }
        }
        return op1HierInfo;
    }

    public boolean checkHierarchies() {
        boolean result = true;
        int[] categories = new int[]{201122, 201121, 201125, 201116, 201117, 201110};
        int numberChildren = this.getNumberChildren();
        for (int idx = 0; idx < numberChildren; ++idx) {
            boolean singleDimension;
            IXQEQueryNode child = this.getChild(idx);
            if (!child.isOfCategories(categories)) continue;
            MDXHierInfo thisHierInfo = ((V5SimpleNode)child).getHierarchyInfo();
            boolean bl = singleDimension = thisHierInfo.getNumProjectedHierarchies() == 1;
            if (!singleDimension && child.isOfCategory(201122)) {
                singleDimension = true;
                IDimension dim = thisHierInfo.getProjectedHierarchy(0).getDimension();
                for (int i = 1; i < thisHierInfo.getNumProjectedHierarchies(); ++i) {
                    if (dim.equals(thisHierInfo.getProjectedHierarchy(i).getDimension())) continue;
                    singleDimension = false;
                    break;
                }
            }
            result = singleDimension;
            break;
        }
        return result;
    }

    public void setIsReportSummary(String refDataItemName) {
        this.setPropertyValue(PROP_STRING_IS_REPORT_SUMMARY, refDataItemName);
    }

    public String isReportSummary() {
        return (String)this.getPropertyValue(PROP_STRING_IS_REPORT_SUMMARY);
    }

    public void clearIsReportSummary() {
        this.removeProperty(PROP_STRING_IS_REPORT_SUMMARY);
    }

    public void setIsReportDetail(Boolean isDetail) {
        this.setPropertyValue(PROP_STRING_IS_REPORT_DETAIL, isDetail);
    }

    public void setDetailAutomatic(Boolean isDetailAutomatic) {
        this.setPropertyValue(PROP_STRING_DETAIL_AUTOMATIC, isDetailAutomatic);
    }

    public boolean getIsDetailAutomatic() {
        boolean isAutomatic = true;
        if (this.getPropertyValue(PROP_STRING_DETAIL_AUTOMATIC) != null) {
            isAutomatic = (Boolean)this.getPropertyValue(PROP_STRING_DETAIL_AUTOMATIC);
        }
        return isAutomatic;
    }

    public boolean isReportDetail() {
        boolean isDetail = true;
        if (this.getPropertyValue(PROP_STRING_IS_REPORT_DETAIL) != null) {
            isDetail = (Boolean)this.getPropertyValue(PROP_STRING_IS_REPORT_DETAIL);
        }
        return isDetail;
    }

    public void setClonedEdgeGroup(Integer orgNodeId) {
        this.setPropertyValue(PROP_CLONED_EDGEGROUP, orgNodeId);
    }

    public boolean isClonedEdgeGroup() {
        boolean isCloned = false;
        if (!this.isCloneOf().equals(NOT_CLONED)) {
            isCloned = true;
        }
        return isCloned;
    }

    public Integer isCloneOf() {
        Integer orgNodeId = this.getPropertyValue(PROP_CLONED_EDGEGROUP) != null ? (Integer)this.getPropertyValue(PROP_CLONED_EDGEGROUP) : NOT_CLONED;
        return orgNodeId;
    }

    public boolean isEmpty(boolean bodyOnly) {
        boolean empty = false;
        if (this.getRefDataItemProperty() == null) {
            int i;
            IXQEQueryNode[] children;
            if (bodyOnly) {
                children = this.getChildrenOfType(101051);
            } else {
                int[] types = new int[]{101053, 101052, 101051};
                children = this.getChildrenOfTypes(types);
            }
            for (i = 0; i < children.length && children[i].getChildrenOfType(101015).length <= 0; ++i) {
            }
            empty = i == children.length;
        }
        return empty;
    }

    public OLAPHierarchyDecoration getOLAPHierarchyDecorationProperty() {
        return (OLAPHierarchyDecoration)this.getPropertyValue("olapDecorationRef");
    }

    public void setOLAPHierarchyDecorationProperty(OLAPHierarchyDecoration deco) {
        this.setPropertyValue("olapDecorationRef", deco);
    }

    private List<OLAPEmptyRowDecoration> getEmptyRowDecorationsProperty() {
        return (List)this.getPropertyValue(PROP_EMPTY_ROW_DECORATIONS);
    }

    public void addEmptyRowDecorationProperty(OLAPEmptyRowDecoration emptyRowDecoration) {
        List<OLAPEmptyRowDecoration> emptyRowDecos = this.getEmptyRowDecorationsProperty();
        if (emptyRowDecos == null) {
            emptyRowDecos = new ArrayList<OLAPEmptyRowDecoration>();
            this.setPropertyValue(PROP_EMPTY_ROW_DECORATIONS, emptyRowDecos);
        }
        emptyRowDecos.add(emptyRowDecoration);
    }

    public List<OLAPEmptyRowDecoration> transferEmptyRowDecorationsProperty() {
        List<OLAPEmptyRowDecoration> emptyRowDecos = this.getEmptyRowDecorationsProperty();
        this.removeProperty(PROP_EMPTY_ROW_DECORATIONS);
        return emptyRowDecos;
    }

    @Override
    public V5QueryNode getEffectiveNodeForMessage() {
        String refDataItemName = this.getRefDataItemProperty();
        if (refDataItemName != null) {
            return this.getDataItemByName(refDataItemName);
        }
        return null;
    }

    public SortedMap<Integer, List<Integer>> getDataItemIndexesProjectingSameSet() {
        return (SortedMap)this.getPropertyValue("dataItemIndexesProjectingSameSet");
    }

    public void setDataItemIndexesProjectingSameSet(SortedMap<Integer, List<Integer>> value) {
        if (value != null && !value.isEmpty()) {
            this.setPropertyValue("dataItemIndexesProjectingSameSet", value);
            return;
        }
        this.removeProperty("dataItemIndexesProjectingSameSet");
    }

    public void appendDataItemIndexProjectingSameSet(int rowsetId, int aDataItemIndex) {
        ArrayList<Integer> values;
        SortedMap<Integer, List<Integer>> dataitemIndixesProjectingSameSet = this.getDataItemIndexesProjectingSameSet();
        if (dataitemIndixesProjectingSameSet == null) {
            dataitemIndixesProjectingSameSet = new TreeMap<Integer, List<Integer>>();
        }
        if ((values = (ArrayList<Integer>)dataitemIndixesProjectingSameSet.get(rowsetId)) == null) {
            values = new ArrayList<Integer>();
            dataitemIndixesProjectingSameSet.put(rowsetId, values);
        }
        if (values.contains(aDataItemIndex)) {
            return;
        }
        values.add(aDataItemIndex);
        this.setDataItemIndexesProjectingSameSet(dataitemIndixesProjectingSameSet);
    }

    public boolean isSpacerNoCellValue() {
        return this.getBooleanPropertyValue(PROP_SPACER_NO_CELL_VALUE) == Boolean.TRUE;
    }

    public void setSpacerNoCellValue(boolean value) {
        if (value) {
            this.setPropertyValue(PROP_SPACER_NO_CELL_VALUE, Boolean.TRUE);
            return;
        }
        this.removeProperty(PROP_SPACER_NO_CELL_VALUE);
    }

    public boolean isSpacerCellValue() {
        return this.getBooleanPropertyValue(PROP_SPACER_CELL_VALUE) == Boolean.TRUE;
    }

    public void setSpacerCellValue(boolean value) {
        if (value) {
            this.setPropertyValue(PROP_SPACER_CELL_VALUE, Boolean.TRUE);
            return;
        }
        this.removeProperty(PROP_SPACER_CELL_VALUE);
    }

    public boolean isSpacerReplacement() {
        return this.getBooleanPropertyValue(PROP_SPACER_REPALCEMENT) == Boolean.TRUE;
    }

    public void setSpacerReplacement(boolean value) {
        if (value) {
            this.setPropertyValue(PROP_SPACER_REPALCEMENT, Boolean.TRUE);
            return;
        }
        this.removeProperty(PROP_SPACER_REPALCEMENT);
    }

    public RSAPIEdgeRowset getRSAPIEdgeRowset() {
        return (RSAPIEdgeRowset)this.getPropertyValue("RSAPIEdgeRowset");
    }

    public void setRSAPIEdgeRowset(RSAPIEdgeRowset rsapiRowset) {
        if (rsapiRowset != null) {
            this.setPropertyValue("RSAPIEdgeRowset", rsapiRowset);
        } else {
            this.removeProperty("RSAPIEdgeRowset");
        }
    }

    public RSAPIDataItem getRSAPIDataItem() {
        return (RSAPIDataItem)this.getPropertyValue("RSAPIRefDataItem");
    }

    public void setRSAPIDataItem(RSAPIDataItem rsapiRefDataItem) {
        if (rsapiRefDataItem != null) {
            this.setPropertyValue("RSAPIRefDataItem", rsapiRefDataItem);
        } else {
            this.removeProperty("RSAPIRefDataItem");
        }
    }

    public boolean isNonDetailGroupBodyValue() {
        return this.getPropertyValue("nonDetailGroupBodyValue") == Boolean.TRUE;
    }

    public void setNonDetailGroupBodyValue(boolean value) {
        if (value) {
            this.setPropertyValue("nonDetailGroupBodyValue", Boolean.TRUE);
        } else {
            this.removeProperty("nonDetailGroupBodyValue");
        }
    }

    @Override
    public void dumpProperties(XQETrace trace) {
        super.dumpProperties(trace);
        RSAPIEdgeRowset rowset = this.getRSAPIEdgeRowset();
        if (rowset != null) {
            trace.attribute("rowsetId", rowset.getRowsetId());
        }
    }

    public boolean hasDiffHierOrderOnSiblingPath() {
        return this.getPropertyValue(HAS_DIFF_HIER_ORDER_ON_SIBLING_PATH) == Boolean.TRUE;
    }

    public void setHasDiffHierOrderOnSiblingPath(boolean value) {
        if (!value) {
            this.removeProperty(HAS_DIFF_HIER_ORDER_ON_SIBLING_PATH);
            return;
        }
        this.setPropertyValue(HAS_DIFF_HIER_ORDER_ON_SIBLING_PATH, Boolean.TRUE);
    }

    public void setContextProperty(String[] context) {
        if (context != null && context.length > 0) {
            this.setPropertyValue("context", context);
            return;
        }
        this.removeProperty("context");
    }

    public String[] getContextProperty() {
        return (String[])this.getPropertyValue("context");
    }

    public String getMixedDMRRelational() {
        return (String)this.getPropertyValue("mixedDMRRelational");
    }

    public void setMixedDMRRelational(String mixedDMRRelational) {
        if (mixedDMRRelational == null) {
            this.removeProperty("mixedDMRRelational");
            return;
        }
        this.setPropertyValue("mixedDMRRelational", mixedDMRRelational);
    }
}

