/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.v5.utils;

import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.trace.XQEDebugLog;
import com.cognos.xqe.util.pool.XQESAXReaderPool;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.ElementHandler;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;

public final class SimpleSaxParser {
    private Document document;
    private static final String DOUBLE_SLASH = "//";
    public static final String UTF_8 = "UTF-8";

    public Document getDocument() {
        return this.document;
    }

    public void parseStream(InputStream parseMe) {
        this.saxParse(parseMe);
    }

    public void parseStream(InputStream parseMe, ElementHandler handler) {
        this.saxParse(parseMe, handler);
    }

    public void parseFile(String parseMe) throws FileNotFoundException {
        BufferedInputStream istream = new BufferedInputStream(new FileInputStream(parseMe));
        this.saxParse(istream);
    }

    public void parseString(String parseMe) {
        RuntimeException exception;
        block6: {
            SAXReader xmlReader = null;
            exception = null;
            try {
                xmlReader = XQESAXReaderPool.getInstance().borrowReader();
                this.document = xmlReader.read(parseMe);
            }
            catch (Exception e) {
                exception = XQERuntimeException.wrap(e);
            }
            if (xmlReader != null) {
                try {
                    XQESAXReaderPool.getInstance().returnReader(xmlReader);
                }
                catch (Exception ex) {
                    if (exception != null) break block6;
                    exception = XQERuntimeException.wrap(ex);
                }
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    public void saxParse(InputStream parseMe) {
        RuntimeException exception;
        block6: {
            SAXReader xmlReader = null;
            exception = null;
            try {
                xmlReader = XQESAXReaderPool.getInstance().borrowReader();
                this.document = xmlReader.read(parseMe);
            }
            catch (Exception e) {
                exception = XQERuntimeException.wrap(e);
            }
            if (xmlReader != null) {
                try {
                    XQESAXReaderPool.getInstance().returnReader(xmlReader);
                }
                catch (Exception ex) {
                    if (exception != null) break block6;
                    exception = XQERuntimeException.wrap(ex);
                }
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    private void saxParse(InputStream parseMe, ElementHandler handler) {
        RuntimeException exception;
        block6: {
            SAXReader xmlReader = null;
            exception = null;
            try {
                xmlReader = XQESAXReaderPool.getInstance().borrowReader();
                xmlReader.setDefaultHandler(handler);
                this.document = xmlReader.read(parseMe);
            }
            catch (Exception e) {
                exception = XQERuntimeException.wrap(e);
            }
            if (xmlReader != null) {
                try {
                    XQESAXReaderPool.getInstance().returnReader(xmlReader);
                }
                catch (Exception ex) {
                    if (exception != null) break block6;
                    exception = XQERuntimeException.wrap(ex);
                }
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    public String getAttributeValue(Node node, String name) {
        String result = null;
        if (node instanceof Element) {
            Element elt = (Element)node;
            result = elt.attributeValue(name);
        }
        return result;
    }

    public Node getFirstChildByName(Node node, String name) {
        Element result = null;
        if (node instanceof Element) {
            Element elt = (Element)node;
            result = elt.element(name);
        }
        return result;
    }

    public Node getNextSiblingByName(Node node, String name) {
        Element after;
        Element parent;
        Element result = null;
        if (node instanceof Element && (parent = (after = (Element)node).getParent()) != null) {
            List children = parent.elements();
            int index = children.indexOf(after);
            int size = children.size();
            if (index >= 0) {
                for (int i = index + 1; i < size && result == null; ++i) {
                    Element elt = (Element)children.get(i);
                    if (!elt.getName().equals(name)) continue;
                    result = elt;
                }
            }
        }
        return result;
    }

    public String getChildValueByName(Node item, String name) {
        String value = null;
        if (item instanceof Element) {
            value = ((Element)item).elementText(name);
        }
        return value;
    }

    public String getChildData(String parentTag, String childTag) {
        int len;
        String result = null;
        List nodes = this.document.selectNodes(DOUBLE_SLASH + parentTag);
        if (nodes != null && (len = nodes.size()) > 0) {
            Node item = (Node)nodes.get(0);
            result = this.getChildValueByName(item, childTag);
        }
        return result;
    }

    public Node getFirstNode(String parentTag, String childTag) {
        int len;
        Node result = null;
        List nodes = this.document.selectNodes(DOUBLE_SLASH + parentTag);
        if (nodes != null && (len = nodes.size()) > 0) {
            Node item;
            result = item = (Node)nodes.get(0);
        }
        return result;
    }

    public static Element accessElementsByPath(Element elt, String[] path) {
        Element result = elt;
        for (int i = 0; i < path.length && result != null; ++i) {
            String pathPart = path[i];
            Element item = result.element(pathPart);
            if (item instanceof Element) {
                result = item;
                continue;
            }
            result = null;
            XQEDebugLog.out.println("Failed to find.1 " + pathPart + " index " + i);
            XQEDebugLog.out.println(elt.toString());
        }
        return result;
    }
}

