/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.v5Exp;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.v5.V5InvalidAttributeException;
import com.cognos.xqe.ast.v5.V5InvalidElementException;
import com.cognos.xqe.ast.v5.V5QueryNode;
import com.cognos.xqe.ast.v5Exp.V5SimpleNode;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import java.util.List;
import org.dom4j.Attribute;
import org.dom4j.Element;

public class V5AggregateBreakClause
extends V5SimpleNode {
    public static final String NODE_TYPE_NAME = "V5AggregateBreakClause";
    public static final int SUBTYPE_BREAK_FOR_REPORT = 0;
    public static final int SUBTYPE_BREAK_FOR_ALL = 1;
    public static final int SUBTYPE_BREAK_FOR_ANY = 2;

    public V5AggregateBreakClause() {
        this.setSubType(2);
        this.setNativeName("FOR");
    }

    @Override
    public boolean isOfCategory(int category) {
        if (category == 201037) {
            return true;
        }
        return super.isOfCategory(category);
    }

    @Override
    public int getType() {
        return 201037;
    }

    @Override
    public String getNodeTypeName() {
        return NODE_TYPE_NAME;
    }

    @Override
    public void writeFormattedText(StringBuilder buffer) {
        buffer.append(" ");
        buffer.append(this.getNativeName());
        buffer.append(" ");
        IXQEQueryNode[] children = this.getChildren();
        int len = children.length;
        switch (this.getSubType()) {
            case 1: {
                buffer.append("ALL ");
                break;
            }
            case 0: 
            case 2: {
                if (len != 0) break;
                buffer.append("REPORT");
                return;
            }
            default: {
                return;
            }
        }
        for (int i = 0; i < children.length; ++i) {
            children[i].writeFormattedText(buffer);
            if (i >= len - 1) continue;
            buffer.append("; ");
        }
    }

    public void removeForClauseItem(IXQEQueryNode item) {
        this.detachChild(item);
        if (this.getNumberChildren() == 0) {
            this.setSubType(0);
        }
    }

    @Override
    public void capture(PlanningEnvironment env, Element inputNode) throws V5InvalidAttributeException, V5InvalidElementException {
        boolean readV5SpecFormat = env.isReadV5SpecFormat();
        XQENodeFactory factory = env.getNodeFactory();
        int size = inputNode.attributeCount();
        for (int i = 0; i < size; ++i) {
            Attribute att = inputNode.attribute(i);
            String attname = att.getName();
            if (attname.equals("subtype")) {
                this.setSubType(Integer.parseInt(att.getValue()));
                continue;
            }
            if (!readV5SpecFormat) continue;
            throw new V5InvalidAttributeException(XQEMessageKeys.V5_InvalidAttribute, attname, inputNode.getName());
        }
        List children = inputNode.elements();
        size = children.size();
        for (int i = 0; i < size; ++i) {
            Element child = (Element)children.get(i);
            String childname = child.getName();
            if (childname.equals("V5MultiPartIdentifier")) {
                V5QueryNode node = factory.createV5ExpNode(childname);
                if (node == null) continue;
                this.addChild(node);
                node.capture(env, child);
                continue;
            }
            throw new V5InvalidElementException(XQEMessageKeys.V5_InvalidElement, childname, inputNode.getName());
        }
    }
}

