/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.v5Exp;

public final class V5AggregateEnum {
    public static final String AGGREGATE = "aggregate";
    public static final int NONE = 0;
    public static final String NONE_NAME = "none";
    public static final int SUMMARIZE = 1;
    public static final String SUMMARIZE_NAME = "summarize";
    public static final int CALCULATED = 2;
    public static final String CALCULATED_NAME = "calculated";
    public static final int AUTOMATIC = 3;
    public static final String AUTOMATIC_NAME = "automatic";
    public static final int TOTAL = 4;
    public static final String TOTAL_NAME = "total";
    public static final int COUNT = 5;
    public static final String COUNT_NAME = "count";
    public static final int COUNT_DISTINCT = 6;
    public static final String COUNT_DISTINCT_NAME = "countDistinct";
    public static final int AVERAGE = 7;
    public static final String AVERAGE_NAME = "average";
    public static final int MINIMUM = 8;
    public static final String MINIMUM_NAME = "minimum";
    public static final int MAXIMUM = 9;
    public static final String MAXIMUM_NAME = "maximum";
    public static final int MEDIAN = 10;
    public static final String MEDIAN_NAME = "median";
    public static final int VARIANCE = 11;
    public static final String VARIANCE_NAME = "variance";
    public static final int STANDARD_DEVIATION = 12;
    public static final String STANDARD_DEVIATION_NAME = "standardDeviation";
    public static final int NOT_APPLICABLE = 13;
    public static final String NOT_APPLICABLE_NAME = "notApplicable";
    public static final int TRUE = 14;
    public static final String TRUE_NAME = "true";
    public static final int FALSE = 15;
    public static final String FALSE_NAME = "false";
    public static final int UNSUPPORTED = 16;
    public static final String UNSUPPORTED_NAME = "unsupported";
    public static final int UNKNOWN = -1;
    public static final String UNKNOWN_NAME = "unknown";

    private V5AggregateEnum() {
    }

    public static int getAggregate(String name) {
        if (name.equals(NONE_NAME)) {
            return 0;
        }
        if (name.equals(CALCULATED_NAME)) {
            return 2;
        }
        if (name.equals(SUMMARIZE_NAME)) {
            return 1;
        }
        if (name.equals(AUTOMATIC_NAME)) {
            return 3;
        }
        if (name.equals(TOTAL_NAME)) {
            return 4;
        }
        if (name.equals(COUNT_NAME)) {
            return 5;
        }
        if (name.equals(COUNT_DISTINCT_NAME)) {
            return 6;
        }
        if (name.equals(AVERAGE_NAME)) {
            return 7;
        }
        if (name.equals(MINIMUM_NAME)) {
            return 8;
        }
        if (name.equals(MAXIMUM_NAME)) {
            return 9;
        }
        if (name.equals(MEDIAN_NAME)) {
            return 10;
        }
        if (name.equals(VARIANCE_NAME)) {
            return 11;
        }
        if (name.equals(STANDARD_DEVIATION_NAME)) {
            return 12;
        }
        if (name.equals(NOT_APPLICABLE_NAME)) {
            return 13;
        }
        if (name.equals(TRUE_NAME)) {
            return 14;
        }
        if (name.equals(FALSE_NAME)) {
            return 15;
        }
        if (name.equals(UNSUPPORTED_NAME)) {
            return 16;
        }
        return -1;
    }

    public static boolean isStandardAggregate(String aggregateName) {
        if (aggregateName.equals("sum")) {
            return true;
        }
        int aggregateType = V5AggregateEnum.getAggregate(aggregateName);
        switch (aggregateType) {
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                return true;
            }
        }
        return false;
    }

    public static boolean isDefinedRegularAggregate(String aggregateName) {
        return aggregateName != null && !aggregateName.equals(NONE_NAME) && !aggregateName.equals(UNKNOWN_NAME) && !aggregateName.equals(UNSUPPORTED_NAME) && !aggregateName.equals(AUTOMATIC_NAME) && !aggregateName.equals(CALCULATED_NAME) && !aggregateName.equals(NOT_APPLICABLE_NAME);
    }

    public static boolean isDefinedAggregateFunction(String aggregateName) {
        return aggregateName != null && !aggregateName.equals(UNKNOWN_NAME) && !aggregateName.equals(UNSUPPORTED_NAME) && !aggregateName.equals(AUTOMATIC_NAME) && !aggregateName.equals(CALCULATED_NAME) && !aggregateName.equals(NOT_APPLICABLE_NAME);
    }

    public static boolean isAutomaticAggregate(String aggregateName) {
        return aggregateName.equals(AUTOMATIC_NAME);
    }

    public static int convertToV5AggregateFunctionSubtype(int v5AggregateEnum) {
        switch (v5AggregateEnum) {
            case 4: {
                return 9;
            }
            case 8: {
                return 6;
            }
            case 9: {
                return 4;
            }
            case 7: {
                return 1;
            }
            case 5: 
            case 6: {
                return 2;
            }
            case 10: {
                return 5;
            }
            case 12: {
                return 7;
            }
            case 11: {
                return 10;
            }
        }
        return -1;
    }
}

