/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.v5Exp;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.rqp.RQPDataItem;
import com.cognos.xqe.ast.rqp.RQPDataItemRef;
import com.cognos.xqe.ast.v5Exp.AbstractV5ValueExpression;
import com.cognos.xqe.ast.v5Exp.V5SimpleNode;
import com.cognos.xqe.data.DataTypeComparator;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.util.pool.XQEIntegerPool;

public class V5CaseExpression
extends AbstractV5ValueExpression {
    public static final String NODE_TYPE_NAME = "V5CaseExpression";
    public static final String PROP_CASE_SUBTYPE = "subType";
    public static final int SUBTYPE_SIMPLE_CASE = 0;
    public static final int SUBTYPE_SEARCH_CASE = 1;
    public static final String NAME_SUBTYPE_SIMPLE_CASE = "simple case";
    public static final String NAME_SUBTYPE_SEARCH_CASE = "search case";
    public static final String NATIVE_NAME = "case";
    public static final String SPACE = " ";
    public static final String END = " end";
    public static final String ELSE = " else";

    @Override
    public boolean isOfCategory(int category) {
        if (category == 201018) {
            return true;
        }
        return super.isOfCategory(category);
    }

    @Override
    public int getType() {
        return 201018;
    }

    @Override
    public int getSubType() {
        return (Integer)this.getPropertyValue(PROP_CASE_SUBTYPE);
    }

    @Override
    public void setSubType(int caseExprSubType) {
        this.setPropertyValue(PROP_CASE_SUBTYPE, XQEIntegerPool.getInteger(caseExprSubType));
    }

    @Override
    public String getNodeTypeName() {
        return NODE_TYPE_NAME;
    }

    public IDataType[] getDataTypesFromThenElseClauses() {
        IDataType[] pTypes = super.getChildDataTypes();
        int start = 0;
        if (this.getSubType() == 0) {
            start = 1;
        }
        IDataType[] rTypes = new IDataType[pTypes.length - start];
        for (int i = 0; i < rTypes.length; ++i) {
            rTypes[i] = pTypes[i + start];
        }
        return rTypes;
    }

    @Override
    public IDataType getDataType() {
        IDataType[] pTypes = this.getDataTypesFromThenElseClauses();
        IDataType result = pTypes[0];
        for (int i = 1; i < pTypes.length; ++i) {
            result = DataTypeComparator.getCompatibleType(result, pTypes[i]);
        }
        return result;
    }

    @Override
    public IDataType getDataTypeOfV5ParameterChildAtIndex(int index) {
        IDataType expectedDataType = null;
        IXQEQueryNode lhs = this.getV5ParameterChildAtIndex(index);
        if (lhs.getType() == 801009) {
            RQPDataItem proj = ((RQPDataItemRef)lhs).getReferencedItem();
            lhs = proj.getExpression();
        }
        if (lhs.getType() == 201024 && lhs.getPropertyValue("datatype") == null) {
            return null;
        }
        expectedDataType = ((V5SimpleNode)lhs).getDataType();
        return expectedDataType;
    }

    @Override
    public IXQEQueryNode getV5ParameterChildAtIndex(int index) {
        IXQEQueryNode otherNode = null;
        if (this.getSubType() == 0) {
            IXQEQueryNode firstV5CaseWhenClause = V5CaseExpression.skipUnrelatedNodes(this.getChild(1));
            otherNode = index == 0 ? V5CaseExpression.skipUnrelatedNodes(firstV5CaseWhenClause.getChild(0)) : V5CaseExpression.skipUnrelatedNodes(firstV5CaseWhenClause.getChild(1));
        } else {
            otherNode = V5CaseExpression.skipUnrelatedNodes(this.getChild(0));
        }
        return otherNode;
    }

    @Override
    public String getNativeName() {
        return NATIVE_NAME;
    }

    @Override
    public void writeFormattedText(StringBuilder buffer) {
        buffer.append(this.getNativeName());
        IXQEQueryNode[] children = this.getChildren();
        if (children.length > 0) {
            buffer.append(SPACE);
            children[0].writeFormattedText(buffer);
            for (int i = 1; i < children.length; ++i) {
                if (children[i].getType() != 201019) {
                    buffer.append(ELSE);
                }
                buffer.append(SPACE);
                children[i].writeFormattedText(buffer);
            }
            buffer.append(END);
        }
    }
}

