/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.v5Exp;

import com.cognos.i18n.NumericFormat;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.macro.MacroExpander;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.ast.v5.V5SyntaxException;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5Exp.V5BoundModelIdentifier;
import com.cognos.xqe.ast.v5Exp.util.V5ExpressionCheck;
import com.cognos.xqe.ast.v5Exp.util.V5ExpressionTypeEnum;
import com.cognos.xqe.ast.v5Exp_new2.binding.V5NameBinding;
import com.cognos.xqe.ast.v5Exp_new2.parser.ASTMultiPartIdentifier;
import com.cognos.xqe.ast.v5Exp_new2.parser.Node;
import com.cognos.xqe.ast.v5Exp_new2.parser.ParseException;
import com.cognos.xqe.ast.v5Exp_new2.parser.SimpleNode;
import com.cognos.xqe.ast.v5Exp_new2.parser.TokenMgrError;
import com.cognos.xqe.ast.v5Exp_new2.parser.V5ExpressionParserUtil;
import com.cognos.xqe.ast.v5Exp_new2.visitor.InvalidFunctionArgumentCountException;
import com.cognos.xqe.ast.v5Exp_new2.visitor.InvalidFunctionParameterTypeException;
import com.cognos.xqe.ast.v5Exp_new2.visitor.V5ExpressionParserVisitor;
import com.cognos.xqe.ast.v5Exp_new2.visitor.V5ExpressionValidationVisitor;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.exception.IMessageKey;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.IModelDataSource;
import com.cognos.xqe.metadata.IQueryItem;
import com.cognos.xqe.metadata.MetadataType;
import com.cognos.xqe.metadata.provider.MetadataConnection;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.ResponseMessage;
import com.cognos.xqe.transformation.olap.XQEOlapUnsupportedQueryException;
import com.cognos.xqe.transformation.v5tocogsql.util.metadataContext.IMetadataContextManager;
import com.cognos.xqe.transformation.v5tocogsql.util.metadataContext.MetadataContext;
import com.cognos.xqe.util.LoopDetectionChain;
import com.cognos.xqe.util.UniqueNameGenerator;
import com.cognos.xqe.util.UniqueNameParser;
import com.cognos.xqe.util.fds.FDSDataTypeEnum;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public final class V5ExpressionProcessor {
    private static final String SPLIT_DOT = "\\.";
    private boolean mDoBinding;
    private Locale mExpressionLocale;
    private Locale mProductLocale;
    private PlanningEnvironment mEnvironment;
    private ExecutionEnvironment mExecEnv;
    private LoopDetectionChain loopDetectionChain = new LoopDetectionChain();
    private V5QuerySet mRootQuerySet = null;

    private V5ExpressionProcessor(PlanningEnvironment environment, ExecutionEnvironment execEnv, Locale expressionLocale, boolean doBinding) {
        IXQEQueryNode rootNode;
        this.mEnvironment = environment;
        this.mExecEnv = execEnv;
        this.mExpressionLocale = expressionLocale;
        this.mProductLocale = ((RequestEnvironment)this.mEnvironment.getRequestEnvironment()).getProductLocale();
        this.mDoBinding = doBinding;
        if (doBinding && (rootNode = environment.getRoot()) != null) {
            if (rootNode.getType() != 101002) {
                rootNode = rootNode.getChild(0);
            }
            if (rootNode.getType() == 101002) {
                this.mRootQuerySet = (V5QuerySet)rootNode;
            }
        }
    }

    private V5ExpressionProcessor(Locale expressionLocale, Locale productLocale) {
        this.mExpressionLocale = expressionLocale;
        this.mProductLocale = productLocale;
    }

    public static IXQEQueryNode parse(String expression, Locale expressionLocale, Locale productLocale) throws XQERuntimeException {
        return V5ExpressionProcessor.process(expression, expressionLocale, productLocale);
    }

    public static IXQEQueryNode parse(String expression, PlanningEnvironment environment, Locale locale) throws XQERuntimeException {
        return V5ExpressionProcessor.process(expression, environment, locale, null, false);
    }

    public static IXQEQueryNode process(String expression, PlanningEnvironment environment, Locale locale) throws XQERuntimeException {
        return V5ExpressionProcessor.process(expression, environment, locale, null, true);
    }

    public static IXQEQueryNode process(String expression, PlanningEnvironment environment, Locale locale, IXQEQueryNode expressionContext) throws XQERuntimeException {
        return V5ExpressionProcessor.process(expression, environment, locale, expressionContext, true);
    }

    public static IXQEQueryNode process(String expression, PlanningEnvironment environment, Locale locale, IXQEQueryNode expressionContext, boolean doBinding) throws XQERuntimeException {
        ExecutionEnvironment execEnv = (ExecutionEnvironment)environment.getExecutionEnvironment();
        IXQEQueryNode xqeQueryNode = null;
        V5ExpressionProcessor processor = new V5ExpressionProcessor(environment, execEnv, locale, doBinding);
        V5Query currentQuery = null;
        if (expressionContext != null && processor.mRootQuerySet != null) {
            currentQuery = (V5Query)expressionContext.getAncestorOfType(101006);
            if (expressionContext.getType() == 101003) {
                String identifier = UniqueNameGenerator.createUniqueName(currentQuery.getV5QueryName(), ((V5DataItem)expressionContext).getNameProperty());
                processor.loopDetectionChain.push(identifier);
            }
        }
        xqeQueryNode = processor.processExpression(expression, expressionContext, currentQuery);
        return xqeQueryNode;
    }

    private static IXQEQueryNode process(String expression, Locale expressionLocale, Locale productLocale) throws XQERuntimeException {
        V5ExpressionProcessor processor = new V5ExpressionProcessor(expressionLocale, productLocale);
        return processor.processExpression(expression, null, null);
    }

    private IXQEQueryNode processExpression(String expression, IXQEQueryNode expressionContext, V5Query currentQuery) {
        SimpleNode parserNode = null;
        if (this.mExecEnv != null) {
            parserNode = this.mExecEnv.getMultiRequestContext().getSessionContext().getNewV5(expression);
        }
        if (parserNode == null) {
            parserNode = this.parseUsingUniqueNameParserReturningAST(expression);
            if (parserNode == null) {
                parserNode = this.parseUsingNewParser(expression, currentQuery, expressionContext);
            }
            if (this.mExecEnv != null) {
                this.mExecEnv.getMultiRequestContext().getSessionContext().cacheNewV5(expression, parserNode);
            }
        }
        if (parserNode != null) {
            if (this.mExecEnv != null) {
                parserNode = parserNode.deepCopy();
            }
            return this.completeExpression(parserNode, currentQuery, expressionContext, expression);
        }
        return null;
    }

    private ASTMultiPartIdentifier parseUsingUniqueNameParserReturningAST(String expression) {
        String trimmedExp = expression.trim();
        String[] parts = UniqueNameParser.parseNoThrow(trimmedExp);
        if (parts != null) {
            return new ASTMultiPartIdentifier(parts, trimmedExp);
        }
        return null;
    }

    private SimpleNode parseUsingNewParser(String expression, V5Query currentQuery, IXQEQueryNode expressionContext) {
        SimpleNode parserNode = null;
        try {
            parserNode = V5ExpressionParserUtil.parseExpression(expression, this.mExpressionLocale);
        }
        catch (ParseException e) {
            String[] strings = V5ExpressionParserUtil.getInvalidTokenImageAndValidSyntax(expression, e);
            String invalidTokenImage = null;
            String validSyntax = null;
            if (strings.length == 2) {
                invalidTokenImage = strings[0];
                validSyntax = strings[1];
            }
            throw this.buildSyntaxException(expression, currentQuery, expressionContext, invalidTokenImage, validSyntax);
        }
        catch (TokenMgrError e) {
            if (e.getErrorCode() == 0) {
                String[] strings = V5ExpressionParserUtil.getInvalidTokenImageAndValidSyntax(expression, e);
                String invalidTokenImage = strings[0];
                String validSyntax = strings[1];
                throw this.buildSyntaxException(expression, currentQuery, expressionContext, invalidTokenImage, validSyntax);
            }
            throw XQERuntimeException.wrap(XQEMessageKeys.GEN_UnexpectedException, e);
        }
        catch (Exception e) {
            throw XQERuntimeException.wrap(XQEMessageKeys.GEN_UnexpectedException, e);
        }
        return parserNode;
    }

    private V5SyntaxException buildSyntaxException(String expression, V5Query currentQuery, IXQEQueryNode expressionContext, String invalidTokenImage, String validSyntax) {
        if (invalidTokenImage == null) {
            if (expressionContext != null && expressionContext.getType() == 101003) {
                String dataItemName = ((V5DataItem)expressionContext).getNameProperty();
                throw new V5SyntaxException(XQEMessageKeys.V5_SyntaxErrorUnexpectedEOF1, dataItemName, currentQuery.getV5QueryName(), expression);
            }
            throw new V5SyntaxException(XQEMessageKeys.V5_SyntaxErrorUnexpectedEOF2, expression);
        }
        if (expressionContext != null && expressionContext.getType() == 101003) {
            String dataItemName = ((V5DataItem)expressionContext).getNameProperty();
            return new V5SyntaxException(XQEMessageKeys.V5_SyntaxError4, dataItemName, currentQuery.getV5QueryName(), invalidTokenImage, validSyntax);
        }
        return new V5SyntaxException(XQEMessageKeys.V5_SyntaxError3, expression, invalidTokenImage, validSyntax);
    }

    private IXQEQueryNode completeExpression(SimpleNode node, V5Query currentQuery, IXQEQueryNode expressionContext, String expression) {
        XQENodeFactory nodeFactory = null;
        if (this.mEnvironment != null) {
            nodeFactory = this.mEnvironment.getNodeFactory();
        }
        IXQEQueryNode xqeQueryNode = null;
        if (this.mDoBinding) {
            List<V5DataItem> referencedDataItems;
            V5NameBinding bindingImpl = new V5NameBinding(this.mEnvironment, this.mRootQuerySet, currentQuery, expressionContext);
            V5ExpressionParserUtil.bindExpression(node, bindingImpl);
            List<ASTMultiPartIdentifier> boundToDataItems = bindingImpl.getBoundToDataItems();
            if (boundToDataItems != null) {
                for (ASTMultiPartIdentifier boundToDataItem : boundToDataItems) {
                    if (boundToDataItem.getStatus() == ASTMultiPartIdentifier.IdentifierStatusEnum.BOUND_DATA_ITEM || boundToDataItem.getStatus() == ASTMultiPartIdentifier.IdentifierStatusEnum.BOUND_QUERY_ITEM) {
                        V5DataItem dataItem = (V5DataItem)boundToDataItem.getPropertyValue("refDataItem");
                        this.processDataItem(dataItem, boundToDataItem);
                        continue;
                    }
                    if (boundToDataItem.getStatus() != ASTMultiPartIdentifier.IdentifierStatusEnum.BOUND_MEMBER_SET) continue;
                    ArrayList refDataItems = (ArrayList)boundToDataItem.getPropertyValue("refDataItemsToValueSets");
                    for (V5DataItem dataItem : refDataItems) {
                        this.processDataItem(dataItem, boundToDataItem);
                    }
                }
            }
            if ((referencedDataItems = bindingImpl.getReferencedDataItems()) != null) {
                for (V5DataItem dataItem : referencedDataItems) {
                    this.processDataItem(dataItem, null);
                }
            }
        }
        if (this.mEnvironment.validateExpressions()) {
            this.validateExpression(node, currentQuery, expressionContext, expression);
        }
        V5ExpressionParserVisitor visitor = new V5ExpressionParserVisitor(nodeFactory, this.mDoBinding);
        xqeQueryNode = (IXQEQueryNode)node.jjtAccept(visitor, null);
        return xqeQueryNode;
    }

    private void validateExpression(SimpleNode node, V5Query currentQuery, IXQEQueryNode expressionContext, String expression) {
        this.checkSelfReference(node, expressionContext, expression);
        boolean shouldValidateOLAPParameters = currentQuery != null;
        String interfaceID = null;
        if (shouldValidateOLAPParameters) {
            IModelDataSource dataSource;
            if (currentQuery.getV5Source().needQueryOverTabularStream()) {
                shouldValidateOLAPParameters = false;
            }
            if ((dataSource = currentQuery.getModelDataSource()) != null) {
                interfaceID = dataSource.getInterface();
                if (!dataSource.isMultidimensional()) {
                    shouldValidateOLAPParameters = false;
                }
            } else {
                shouldValidateOLAPParameters = false;
            }
        }
        boolean inDetailFilterContext = expressionContext != null && (expressionContext.getType() == 101013 || expressionContext.getType() == 101008);
        try {
            MetadataConnection metadataConnection = null;
            if (this.mEnvironment != null) {
                metadataConnection = this.mEnvironment.getMetadataConnection();
            }
            V5ExpressionProcessor.validateExpression(node, interfaceID, shouldValidateOLAPParameters, inDetailFilterContext, metadataConnection);
        }
        catch (InvalidFunctionParameterTypeException invalidFunction) {
            String dataTypeNames = this.fdsDataTypesToString(invalidFunction.getExpectedDataTypes());
            XQEOlapUnsupportedQueryException exception = null;
            if (expressionContext == null || currentQuery == null) {
                exception = new XQEOlapUnsupportedQueryException(XQEMessageKeys.PLN_InvalidFunctionParameterNoQuery, invalidFunction.getParameterPosition(), (Object)invalidFunction.getFunctionName(), (Object)expression, (Object)dataTypeNames);
            } else {
                String queryName = currentQuery.getV5QueryName();
                V5DataItem dataItem = null;
                if (expressionContext.getType() == 101003) {
                    dataItem = (V5DataItem)expressionContext;
                    exception = new XQEOlapUnsupportedQueryException(XQEMessageKeys.PLN_InvalidFunctionParameter, invalidFunction.getParameterPosition(), (Object)invalidFunction.getFunctionName(), (Object)dataItem.getNameProperty(), (Object)queryName, (Object)dataTypeNames);
                } else {
                    exception = new XQEOlapUnsupportedQueryException(XQEMessageKeys.PLN_InvalidFunctionParameterInFilter, invalidFunction.getParameterPosition(), (Object)invalidFunction.getFunctionName(), (Object)expression, (Object)queryName, (Object)dataTypeNames);
                }
            }
            if (!invalidFunction.isLoggingAllowed()) {
                throw exception;
            }
            boolean expectedNonValue = false;
            for (FDSDataTypeEnum dataType : invalidFunction.getExpectedDataTypes()) {
                if (dataType.isValueType()) continue;
                expectedNonValue = true;
                break;
            }
            if (shouldValidateOLAPParameters || expectedNonValue) {
                throw exception;
            }
            ((RequestEnvironment)this.mEnvironment.getRequestEnvironment()).getResponseMessageFolder().appendPlanningResponseMessage(new ResponseMessage(1, ResponseMessage.ResponseMessageType.TYPE_PLAN_STAT_INT, exception), expressionContext, this.mEnvironment.getRoot());
        }
        catch (InvalidFunctionArgumentCountException invalidFunction) {
            if (expressionContext == null || currentQuery == null) {
                throw new XQEOlapUnsupportedQueryException(XQEMessageKeys.PLN_InvalidArgumentCountNoQuery, invalidFunction.getFunctionName(), String.valueOf(invalidFunction.getParameterCount()), expression);
            }
            String queryName = currentQuery.getV5QueryName();
            if (expressionContext.getType() == 101003) {
                String dataItemName = ((V5DataItem)expressionContext).getNameProperty();
                throw new XQEOlapUnsupportedQueryException(XQEMessageKeys.PLN_InvalidArgumentCount2, invalidFunction.getFunctionName(), (Object)String.valueOf(invalidFunction.getParameterCount()), (Object)dataItemName, (Object)queryName);
            }
            throw new XQEOlapUnsupportedQueryException(XQEMessageKeys.PLN_InvalidArgumentCountInFilter, invalidFunction.getFunctionName(), (Object)String.valueOf(invalidFunction.getParameterCount()), (Object)expression, (Object)queryName);
        }
    }

    private void checkSelfReference(Node node, IXQEQueryNode expressionContext, String expression) {
        if (expressionContext != null && node.jjtGetNumChildren() > 0) {
            for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
                Node n = node.jjtGetChild(i);
                if (n instanceof ASTMultiPartIdentifier) {
                    String[] parts;
                    ASTMultiPartIdentifier multiPart = (ASTMultiPartIdentifier)n;
                    String nativeName = multiPart.getNativeName();
                    if ("validate".equals(((RequestEnvironment)this.mEnvironment.getRequestEnvironment()).getOperationName())) {
                        String[] parts2;
                        String contextIdentifier = (String)expressionContext.getPropertyValue("contextIdentifier");
                        if (contextIdentifier == null || (parts2 = contextIdentifier.split(SPLIT_DOT)).length != 2 || !parts2[1].equals(nativeName)) continue;
                        this.addMessageForValidate(expressionContext, nativeName, expression);
                        continue;
                    }
                    if (!"validateAll".equals(((RequestEnvironment)this.mEnvironment.getRequestEnvironment()).getOperationName())) continue;
                    Object o1 = expressionContext.getPropertyValue("contextMetadata");
                    Object o2 = multiPart.getPropertyValue("metadata");
                    if (o1 != null && o2 != null) {
                        if (!o1.equals(o2)) continue;
                        this.addMessageForValidate(expressionContext, nativeName, expression);
                        continue;
                    }
                    String contextName = (String)expressionContext.getPropertyValue("name");
                    if (contextName == null || ((parts = contextName.split(SPLIT_DOT)).length != 1 || !contextName.equals(nativeName)) && (parts.length != 2 || !parts[1].equals(nativeName))) continue;
                    this.addMessageForValidate(expressionContext, nativeName, expression);
                    continue;
                }
                this.checkSelfReference(n, expressionContext, expression);
            }
        }
    }

    private void addMessageForValidate(IXQEQueryNode dataItem, String identifier, String expression) {
        IMessageKey.Param2 msgParam = XQEMessageKeys.PLN_ExpressionHasSelfReference;
        ResponseMessage msg = new ResponseMessage(1, ResponseMessage.ResponseMessageType.TYPE_PLAN_STAT_INT, msgParam, identifier, expression);
        ((RequestEnvironment)this.mEnvironment.getRequestEnvironment()).getResponseMessageFolder().appendPlanningResponseMessage(msg, dataItem, this.mEnvironment.getRoot());
    }

    private void processDataItem(V5DataItem dataItem, ASTMultiPartIdentifier multiPartIdentifier) {
        IXQEQueryNode enode = null;
        IXQEQueryNode child = dataItem.getChild(0);
        if (child.getType() == 101004) {
            Object prop = child.getPropertyValue("expression");
            child.removeProperty("expression");
            V5Query currentQuery = (V5Query)dataItem.getAncestorOfType(101006);
            String identifier = UniqueNameGenerator.createUniqueName(currentQuery.getV5QueryName(), dataItem.getNameProperty());
            if (!this.loopDetectionChain.push(identifier)) {
                throw new XQERuntimeException(XQEMessageKeys.PLN_LoopInExpression, currentQuery.getV5QueryName(), this.loopDetectionChain.serialize());
            }
            if (prop instanceof String) {
                IMetadataContextManager mcMgr;
                MetadataConnection conn;
                String mcName;
                String expression = (String)prop;
                MetadataContext metadataContext = (MetadataContext)child.getPropertyValue("metadataContext");
                if (metadataContext == null && (mcName = (String)child.getPropertyValue("metadataContextName")) != null && (conn = this.mEnvironment.getMetadataConnection()) != null && (mcMgr = conn.getMetadataContextManager()) != null) {
                    metadataContext = mcMgr.getExistingMetadataContext(mcName);
                }
                if (expression.contains("#")) {
                    MacroExpander expander = new MacroExpander();
                    expression = expander.expand(child, this.mEnvironment, expression);
                }
                try {
                    Boolean bOrg = null;
                    if (this.mDoBinding && metadataContext != null) {
                        bOrg = Boolean.TRUE;
                        this.mDoBinding = false;
                    }
                    enode = this.processExpression(expression, dataItem, currentQuery);
                    if (bOrg != null) {
                        this.mDoBinding = true;
                    }
                    if (enode != null) {
                        child.addChild(enode);
                    }
                    if (metadataContext != null) {
                        metadataContext.setMetadataContextOnV5MultiPartIdentifier(child.getChild(0));
                    }
                }
                catch (XQERuntimeException xre) {
                    if (((RequestEnvironment)this.mEnvironment.getRequestEnvironment()).isValidateRequest()) {
                        ((RequestEnvironment)this.mEnvironment.getRequestEnvironment()).getResponseMessageFolder().appendPlanningResponseMessage(new ResponseMessage(0, ResponseMessage.ResponseMessageType.TYPE_PLAN_STAT_INT, xre), dataItem, this.mEnvironment.getRoot());
                        child.setPropertyValue("isInvalidExpression", true);
                    }
                    throw xre;
                }
            }
            this.loopDetectionChain.pop();
        }
        if (multiPartIdentifier != null && multiPartIdentifier.getFDSDataType() == null) {
            if (enode == null && (enode = child).getType() == 101004) {
                if (enode.getNumberChildren() == 0) {
                    return;
                }
                enode = enode.getChild(0);
            }
            multiPartIdentifier.setFDSDataType(V5ExpressionCheck.getFDSDataTypeForV5Expression(enode));
            if (enode.getType() == 201116) {
                V5BoundModelIdentifier identifier = (V5BoundModelIdentifier)enode;
                if (identifier.isMeasure()) {
                    multiPartIdentifier.setIsMeasure();
                } else {
                    IMetadata metadata = identifier.getMetadata();
                    if (MetadataType.isQueryItem(metadata) && ((IQueryItem)metadata).isProperty()) {
                        multiPartIdentifier.setIsExplicitProperty();
                    }
                }
            }
        }
    }

    private String fdsDataTypesToString(List<FDSDataTypeEnum> dataTypes) {
        StringBuilder dataTypeNames = new StringBuilder();
        NumericFormat format = new NumericFormat(this.mProductLocale);
        char grouping = format.getGroupingSeparator();
        for (int i = 0; i < dataTypes.size(); ++i) {
            FDSDataTypeEnum dataType;
            if (i > 0) {
                dataTypeNames.append(grouping);
                dataTypeNames.append(" ");
            }
            if ((dataType = dataTypes.get(i)) == FDSDataTypeEnum.ANY_VALUE) {
                dataTypeNames.append(V5ExpressionTypeEnum.VALUE.getExpressionTypeName());
                continue;
            }
            dataTypeNames.append(dataType.toFDSKeyword());
        }
        return dataTypeNames.toString();
    }

    private static void validateExpression(SimpleNode node, String interfaceID, boolean shouldValidateOLAPParameters, boolean inDetailFilterContext, MetadataConnection mdc) {
        V5ExpressionValidationVisitor visitor = new V5ExpressionValidationVisitor(interfaceID, shouldValidateOLAPParameters, inDetailFilterContext, mdc);
        node.jjtAccept(visitor, null);
    }
}

