/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.v5Exp;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.rqp.RQPDataItem;
import com.cognos.xqe.ast.rqp.RQPDataItemRef;
import com.cognos.xqe.ast.rqp.RQPQuery;
import com.cognos.xqe.ast.sql.SQLNativeSql;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5.query.V5Expression;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5.query.V5SqlQuery;
import com.cognos.xqe.ast.v5Exp.AbstractV5ValueExpression;
import com.cognos.xqe.ast.v5Exp.V5BoundDataItemReference;
import com.cognos.xqe.ast.v5Exp.V5BoundMultiPartIdentifier;
import com.cognos.xqe.ast.v5Exp.V5Parameter;
import com.cognos.xqe.ast.v5Exp.V5SimpleNode;
import com.cognos.xqe.bibushandler.content.ContentManager;
import com.cognos.xqe.bibushandler.content.ICMConnection;
import com.cognos.xqe.data.DataTypeComparator;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.types.ClobType;
import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.types.DateType;
import com.cognos.xqe.data.types.FloatType;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.types.IntegerType;
import com.cognos.xqe.data.types.TimeType;
import com.cognos.xqe.data.types.TimestampType;
import com.cognos.xqe.data.types.VarcharType;
import com.cognos.xqe.data.types.VariantType;
import com.cognos.xqe.function.date.AddDays;
import com.cognos.xqe.function.date.AddHours;
import com.cognos.xqe.function.date.AddMinutes;
import com.cognos.xqe.function.date.AddMonths;
import com.cognos.xqe.function.date.AddSeconds;
import com.cognos.xqe.function.date.AddYears;
import com.cognos.xqe.function.date.Age;
import com.cognos.xqe.function.date.DayOfWeek;
import com.cognos.xqe.function.date.DayOfYear;
import com.cognos.xqe.function.date.DaysBetween;
import com.cognos.xqe.function.date.DaysToEndOfMonth;
import com.cognos.xqe.function.date.FirstOfMonth;
import com.cognos.xqe.function.date.HoursBetween;
import com.cognos.xqe.function.date.LastOfMonth;
import com.cognos.xqe.function.date.MakeTimestamp;
import com.cognos.xqe.function.date.MinutesBetween;
import com.cognos.xqe.function.date.MonthsBetween;
import com.cognos.xqe.function.date.SecondsBetween;
import com.cognos.xqe.function.date.ShiftTimeZone;
import com.cognos.xqe.function.date.WeekOfYear;
import com.cognos.xqe.function.date.YMDIntBetween;
import com.cognos.xqe.function.date.YearsBetween;
import com.cognos.xqe.function.numeric.Ascii;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.IModelDataSource;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.util.context.ExecutionEnvironmentContext;
import com.cognos.xqe.util.fds.FDSDataTypeEnum;
import com.cognos.xqe.util.fds.FDSException;
import com.cognos.xqe.util.fds.IFunctionDefinition;
import com.cognos.xqe.util.fds.IFunctionNode;
import com.cognos.xqe.util.fds.IFunctionParameter;
import com.cognos.xqe.util.pool.XQEIntegerPool;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class V5GenericFunction
extends AbstractV5ValueExpression {
    public static final String NODE_TYPE_NAME = "V5GenericFunction";
    public static final int SUBTYPE_UNKNOWN = 0;
    public static final int SUBTYPE_ADD_SECONDS = 1;
    public static final int SUBTYPE_ADD_MINUTES = 2;
    public static final int SUBTYPE_ADD_HOURS = 3;
    public static final int SUBTYPE_ADD_DAYS = 4;
    public static final int SUBTYPE_ADD_MONTHS = 5;
    public static final int SUBTYPE_ADD_YEARS = 6;
    public static final int SUBTYPE_SECONDS_BETWEEN = 7;
    public static final int SUBTYPE_MINUTES_BETWEEN = 8;
    public static final int SUBTYPE_HOURS_BETWEEN = 9;
    public static final int SUBTYPE_AGE = 10;
    public static final int SUBTYPE_DAY_OF_WEEK = 11;
    public static final int SUBTYPE_DAY_OF_YEAR = 12;
    public static final int SUBTYPE_DAYS_BETWEEN = 13;
    public static final int SUBTYPE_DAYS_TO_END_OF_MONTH = 14;
    public static final int SUBTYPE_FIRST_OF_MONTH = 15;
    public static final int SUBTYPE_LAST_OF_MONTH = 16;
    public static final int SUBTYPE_MAKE_TIMESTAMP = 17;
    public static final int SUBTYPE_MONTHS_BETWEEN = 18;
    public static final int SUBTYPE_WEEK_OF_YEAR = 19;
    public static final int SUBTYPE_YEARS_BETWEEN = 20;
    public static final int SUBTYPE_YMDINT_BETWEEN = 21;
    public static final int SUBTYPE_ASCII = 22;
    public static final int SUBTYPE_SHIFT_TIMEZONE = 23;
    public static final String PROP_STRING_NAME = "name";
    public static final String PROP_OBJECT_DATATYPE = "dataType";
    public static final String VENDOR_INFORMIX = "V_Informix";
    public static final String VENDOR_SYBASE_ASE = "V_Sybase";
    public static final String IS_COLUMN = "isColumn";
    public static final String PROP_FDS_FORMAT_STRING = "fdsFormatString";

    public void setName(String name) {
        this.setPropertyValue(PROP_STRING_NAME, name);
    }

    @Override
    public String getName() {
        return (String)this.getPropertyValue(PROP_STRING_NAME);
    }

    @Override
    public int getType() {
        return 201042;
    }

    @Override
    public String getNodeTypeName() {
        return NODE_TYPE_NAME;
    }

    @Override
    public IDataType getDataType() {
        IDataType[] oDataTypes;
        IDataType result = (IDataType)this.getPropertyValue(PROP_OBJECT_DATATYPE);
        if (result != null) {
            return result;
        }
        for (IDataType dt : oDataTypes = this.getChildDataTypes()) {
            if (dt != null) continue;
            return null;
        }
        switch (this.mSubtype) {
            case 1: {
                result = AddSeconds.getOutputType(oDataTypes);
                break;
            }
            case 2: {
                result = AddMinutes.getOutputType(oDataTypes);
                break;
            }
            case 3: {
                result = AddHours.getOutputType(oDataTypes);
                break;
            }
            case 4: {
                result = AddDays.getOutputType(oDataTypes);
                break;
            }
            case 5: {
                result = AddMonths.getOutputType(oDataTypes);
                break;
            }
            case 6: {
                result = AddYears.getOutputType(oDataTypes);
                break;
            }
            case 7: {
                result = SecondsBetween.getOutputType(oDataTypes);
                break;
            }
            case 8: {
                result = MinutesBetween.getOutputType(oDataTypes);
                break;
            }
            case 9: {
                result = HoursBetween.getOutputType(oDataTypes);
                break;
            }
            case 10: {
                result = Age.getOutputType(oDataTypes);
                break;
            }
            case 11: {
                result = DayOfWeek.getOutputType(oDataTypes);
                break;
            }
            case 12: {
                result = DayOfYear.getOutputType(oDataTypes);
                break;
            }
            case 13: {
                result = DaysBetween.getOutputType(oDataTypes);
                break;
            }
            case 14: {
                result = DaysToEndOfMonth.getOutputType(oDataTypes);
                break;
            }
            case 15: {
                result = FirstOfMonth.getOutputType(oDataTypes);
                break;
            }
            case 16: {
                result = LastOfMonth.getOutputType(oDataTypes);
                break;
            }
            case 17: {
                result = MakeTimestamp.getOutputType(oDataTypes);
                break;
            }
            case 18: {
                result = MonthsBetween.getOutputType(oDataTypes);
                break;
            }
            case 19: {
                result = WeekOfYear.getOutputType(oDataTypes);
                break;
            }
            case 20: {
                result = YearsBetween.getOutputType(oDataTypes);
                break;
            }
            case 21: {
                result = YMDIntBetween.getOutputType(oDataTypes);
                break;
            }
            case 23: {
                result = ShiftTimeZone.getOutputType(oDataTypes);
                break;
            }
            case 22: {
                result = Ascii.getOutputType(oDataTypes);
                if (result != null) break;
                this.setSubType(0);
                this.setName(this.getName().toLowerCase());
                result = VariantType.VARIANT;
                break;
            }
            default: {
                result = VariantType.VARIANT;
            }
        }
        this.setDataType(result);
        return result;
    }

    public void setDataType(IDataType dataType) {
        this.setPropertyValue(PROP_OBJECT_DATATYPE, dataType);
    }

    public static IDataType getDataType(FDSDataTypeEnum dataType) {
        switch (dataType) {
            case STRING: {
                return VarcharType.DEFAULTVARCHARTYPE;
            }
            case NUMERIC: 
            case INTEGER: {
                return IntegerType.INTEGERTYPE;
            }
            case FLOAT: {
                return FloatType.FLOATTYPE;
            }
            case DATE: {
                return DateType.DATETYPE;
            }
            case TIME: {
                return TimeType.TIMETYPE;
            }
            case DATETIME: {
                return TimestampType.TIMESTAMPTYPE;
            }
            case TEXTBLOB: {
                return ClobType.CLOBTYPE;
            }
            case ANY_VALUE: {
                return VariantType.VARIANT;
            }
        }
        return null;
    }

    public static String getVendorID(String interfaceID, String cmDatasourceName) {
        String vendorID = "";
        if ("OR".equalsIgnoreCase(interfaceID) || "JD-OR".equalsIgnoreCase(interfaceID)) {
            vendorID = "V_Oracle";
        } else if ("D2".equalsIgnoreCase(interfaceID) || "JD-D2".equalsIgnoreCase(interfaceID)) {
            vendorID = "V_DB2";
        } else if ("OL".equalsIgnoreCase(interfaceID) || "SS".equalsIgnoreCase(interfaceID) || "JD-SS".equalsIgnoreCase(interfaceID)) {
            vendorID = "V_SQLServer";
        } else if ("TD".equalsIgnoreCase(interfaceID) || "JD-TD".equalsIgnoreCase(interfaceID)) {
            vendorID = "V_Teradata";
        } else if ("NZ".equalsIgnoreCase(interfaceID) || "JD-NZ".equalsIgnoreCase(interfaceID)) {
            vendorID = "V_Netezza";
        } else if ("IF".equalsIgnoreCase(interfaceID)) {
            vendorID = VENDOR_INFORMIX;
        } else if ("CT".equalsIgnoreCase(interfaceID)) {
            vendorID = VENDOR_SYBASE_ASE;
        } else if ("JDBC".equalsIgnoreCase(interfaceID)) {
            ExecutionEnvironment env = (ExecutionEnvironment)ExecutionEnvironmentContext.getExecutionEnvironment();
            Collection<ICMConnection> conns = ContentManager.getConnections(env.getRequestEnvironment(), cmDatasourceName);
            String cs = conns.iterator().next().getConnectionString();
            String[] tokens = cs.split("URL=jdbc:");
            if (tokens.length < 2) {
                return vendorID;
            }
            String[] protocol = tokens[1].split(":");
            if (tokens.length < 1) {
                return vendorID;
            }
            if ("exa".equalsIgnoreCase(protocol[0])) {
                vendorID = "V_Exasol";
            } else if ("portal".equalsIgnoreCase(protocol[0])) {
                vendorID = "V_Greenplum";
            } else if ("informix-sqli".equalsIgnoreCase(protocol[0])) {
                vendorID = VENDOR_INFORMIX;
            } else if ("mysql".equalsIgnoreCase(protocol[0])) {
                vendorID = "V_MySQL";
            } else if ("paraccel".equalsIgnoreCase(protocol[0])) {
                vendorID = "V_Paraccel";
            } else if ("postgresql".equalsIgnoreCase(protocol[0])) {
                vendorID = "V_Postgres";
            } else if ("sybase".equalsIgnoreCase(protocol[0])) {
                vendorID = VENDOR_SYBASE_ASE;
            } else if ("vectorwise".equalsIgnoreCase(protocol[0])) {
                vendorID = "V_Vectorwise";
            } else if ("vertica".equalsIgnoreCase(protocol[0])) {
                vendorID = "V_Vertica";
            }
        }
        return vendorID;
    }

    @Override
    public void setSubType(int type) {
        this.mSubtype = type;
        this.setPropertyValue("subtype", XQEIntegerPool.getInteger(this.mSubtype));
    }

    @Override
    public IDataType getDataTypeOfV5ParameterChildAtIndex(int index) {
        IDataType dataType = null;
        switch (this.mSubtype) {
            case 1: {
                dataType = AddSeconds.getParameterType(index);
                break;
            }
            case 2: {
                dataType = AddMinutes.getParameterType(index);
                break;
            }
            case 3: {
                dataType = AddHours.getParameterType(index);
                break;
            }
            case 4: {
                dataType = AddDays.getParameterType(index);
                break;
            }
            case 5: {
                dataType = AddMonths.getParameterType(index);
                break;
            }
            case 6: {
                dataType = AddYears.getParameterType(index);
                break;
            }
            case 7: {
                dataType = SecondsBetween.getParameterType(index);
                break;
            }
            case 8: {
                dataType = MinutesBetween.getParameterType(index);
                break;
            }
            case 9: {
                dataType = HoursBetween.getParameterType(index);
                break;
            }
            case 10: {
                dataType = Age.getParameterType(index);
                break;
            }
            case 11: {
                dataType = DayOfWeek.getParameterType(index);
                break;
            }
            case 12: {
                dataType = DayOfYear.getParameterType(index);
                break;
            }
            case 13: {
                dataType = DaysBetween.getParameterType(index);
                break;
            }
            case 14: {
                dataType = DaysToEndOfMonth.getParameterType(index);
                break;
            }
            case 15: {
                dataType = FirstOfMonth.getParameterType(index);
                break;
            }
            case 16: {
                dataType = LastOfMonth.getParameterType(index);
                break;
            }
            case 17: {
                dataType = MakeTimestamp.getParameterType(index);
                break;
            }
            case 18: {
                dataType = MonthsBetween.getParameterType(index);
                break;
            }
            case 19: {
                dataType = WeekOfYear.getParameterType(index);
                break;
            }
            case 20: {
                dataType = YearsBetween.getParameterType(index);
                break;
            }
            case 21: {
                dataType = YMDIntBetween.getParameterType(index);
                break;
            }
            case 23: {
                dataType = ShiftTimeZone.getParameterType(index);
                break;
            }
            default: {
                List<IDataType> possibleDataTypes = V5GenericFunction.getPossibleDataTypesForArgument(this, this.getChild(index));
                dataType = !possibleDataTypes.isEmpty() ? possibleDataTypes.get(0) : DataTypeFactory.getStringType();
            }
        }
        return dataType;
    }

    public static List<IDataType> getPossibleDataTypesForArgument(V5GenericFunction v5GenericFunc, IXQEQueryNode funcArgNode) {
        int pos = v5GenericFunc.getPositionOfChild(funcArgNode);
        ArrayList<IDataType> dataDTs = new ArrayList<IDataType>();
        byte[] dataTypes = null;
        switch (v5GenericFunc.getSubType()) {
            case 1: {
                dataTypes = AddSeconds.ACCEPTED_TYPES[pos];
                break;
            }
            case 2: {
                dataTypes = AddMinutes.ACCEPTED_TYPES[pos];
                break;
            }
            case 3: {
                dataTypes = AddHours.ACCEPTED_TYPES[pos];
                break;
            }
            case 4: {
                dataTypes = AddDays.ACCEPTED_TYPES[pos];
                break;
            }
            case 5: {
                dataTypes = AddMonths.ACCEPTED_TYPES[pos];
                break;
            }
            case 6: {
                dataTypes = AddYears.ACCEPTED_TYPES[pos];
                break;
            }
            case 7: {
                dataTypes = SecondsBetween.ACCEPTED_TYPES[pos];
                break;
            }
            case 8: {
                dataTypes = MinutesBetween.ACCEPTED_TYPES[pos];
                break;
            }
            case 9: {
                dataTypes = HoursBetween.ACCEPTED_TYPES[pos];
                break;
            }
            case 10: {
                dataTypes = Age.ACCEPTED_TYPES[pos];
                break;
            }
            case 11: {
                dataTypes = DayOfWeek.ACCEPTED_TYPES[pos];
                break;
            }
            case 12: {
                dataTypes = DayOfYear.ACCEPTED_TYPES[pos];
                break;
            }
            case 13: {
                dataTypes = DaysBetween.ACCEPTED_TYPES[pos];
                break;
            }
            case 14: {
                dataTypes = DaysToEndOfMonth.ACCEPTED_TYPES[pos];
                break;
            }
            case 15: {
                dataTypes = FirstOfMonth.ACCEPTED_TYPES[pos];
                break;
            }
            case 16: {
                dataTypes = LastOfMonth.ACCEPTED_TYPES[pos];
                break;
            }
            case 17: {
                dataTypes = MakeTimestamp.ACCEPTED_TYPES[pos];
                break;
            }
            case 18: {
                dataTypes = MonthsBetween.ACCEPTED_TYPES[pos];
                break;
            }
            case 19: {
                dataTypes = WeekOfYear.ACCEPTED_TYPES[pos];
                break;
            }
            case 20: {
                dataTypes = YearsBetween.ACCEPTED_TYPES[pos];
                break;
            }
            case 21: {
                dataTypes = YMDIntBetween.ACCEPTED_TYPES[pos];
                break;
            }
            case 23: {
                dataTypes = ShiftTimeZone.ACCEPTED_TYPES[pos];
                break;
            }
            default: {
                try {
                    IFunctionDefinition funcDef = IFunctionDefinition.Factory.createFDAllLocales();
                    funcDef.addContextFiltersForCQE();
                    funcDef.showHidden();
                    String vendorID = V5GenericFunction.getVendorIdFromClosestModelItem(funcArgNode);
                    if (vendorID == null) {
                        vendorID = V5GenericFunction.getVendorIdFromSQLQuery(funcArgNode);
                    }
                    if (vendorID != null) {
                        funcDef.addVendorFunctionSetFilter(vendorID);
                    }
                    ArrayList<IFunctionNode> functionList = funcDef.findFuncListByName(v5GenericFunc.getNativeName());
                    int numOfArgsForGenericFunc = v5GenericFunc.getNumberChildren();
                    for (int i = 0; i < functionList.size(); ++i) {
                        int funcPos;
                        IDataType returnDataTypeOfFunc;
                        IXQEQueryNode parent;
                        int j;
                        IFunctionNode fdsFunc = functionList.get(i);
                        int numOfArgsForFdsFunc = fdsFunc.getParameters().size();
                        boolean isMatching = true;
                        if (numOfArgsForGenericFunc > numOfArgsForFdsFunc) {
                            isMatching = false;
                        } else if (numOfArgsForGenericFunc < numOfArgsForFdsFunc) {
                            for (j = v5GenericFunc.getNumberChildren(); j < numOfArgsForFdsFunc; ++j) {
                                IFunctionParameter fdsFuncParam = fdsFunc.getParameters().get(j);
                                if (fdsFuncParam.getMinOccurs() == 0) continue;
                                isMatching = false;
                                break;
                            }
                        }
                        if (!isMatching) continue;
                        for (j = 0; j < numOfArgsForGenericFunc; ++j) {
                            if (j == pos) continue;
                            String fdsFuncParamTypeString = fdsFunc.getParameterTypes().get(j);
                            FDSDataTypeEnum fdsFuncParamType = FDSDataTypeEnum.fromFDS(fdsFuncParamTypeString);
                            IXQEQueryNode paramNode = v5GenericFunc.getChild(j);
                            IDataType genericFuncParamType = null;
                            if (paramNode instanceof V5Parameter && paramNode.getPropertyValue("datatype") == null) continue;
                            if (paramNode instanceof V5SimpleNode) {
                                genericFuncParamType = ((V5SimpleNode)paramNode).getDataType();
                            } else if (paramNode instanceof V5DataItem) {
                                genericFuncParamType = ((V5DataItem)paramNode).getDataType();
                            }
                            if (genericFuncParamType == null) continue;
                            if (fdsFuncParamType == FDSDataTypeEnum.STRING && !genericFuncParamType.isTextType()) {
                                isMatching = false;
                                break;
                            }
                            if (fdsFuncParamType == FDSDataTypeEnum.NUMERIC && !genericFuncParamType.isNumeric()) {
                                isMatching = false;
                                break;
                            }
                            if (fdsFuncParamType == FDSDataTypeEnum.DATE && !genericFuncParamType.isDate()) {
                                isMatching = false;
                                break;
                            }
                            if (fdsFuncParamType == FDSDataTypeEnum.TIME && !genericFuncParamType.isTime()) {
                                isMatching = false;
                                break;
                            }
                            if (fdsFuncParamType == FDSDataTypeEnum.DATETIME && !genericFuncParamType.isTimestamp()) {
                                isMatching = false;
                                break;
                            }
                            if (fdsFuncParamType != FDSDataTypeEnum.INTEGER || genericFuncParamType.isInteger()) continue;
                            isMatching = false;
                            break;
                        }
                        if (!isMatching) continue;
                        IFunctionParameter param = fdsFunc.getParameters().get(pos);
                        for (FDSDataTypeEnum dType : param.getTypes()) {
                            IDataType dataType = V5GenericFunction.getDataType(dType);
                            if (dataType == null) {
                                dataType = VariantType.VARIANT;
                            }
                            dataDTs.add(dataType);
                        }
                        if (dataDTs.size() <= 1 && !((IDataType)dataDTs.get(0)).isVariant() || fdsFunc.getReturnType().getParameterDataTypePosition() != pos + 1 || !((parent = v5GenericFunc.getParent()) instanceof V5SimpleNode) || (returnDataTypeOfFunc = ((V5SimpleNode)parent).getDataTypeOfV5ParameterChildAtIndex(funcPos = parent.getPositionOfChild(v5GenericFunc))) == null) continue;
                        for (IDataType dType : dataDTs) {
                            if (!DataTypeComparator.areCompatibleDataTypes(returnDataTypeOfFunc, dType)) continue;
                            dataDTs.clear();
                            dataDTs.add(returnDataTypeOfFunc);
                            return dataDTs;
                        }
                    }
                }
                catch (FDSException e) {
                    dataDTs.add(VariantType.VARIANT);
                }
                return dataDTs;
            }
        }
        for (int i = 0; i < dataTypes.length; ++i) {
            dataDTs.add(DataTypeFactory.getDataType(dataTypes[i]));
        }
        return dataDTs;
    }

    public static String getVendorIdFromClosestModelItem(IXQEQueryNode prompt) {
        IModelDataSource ds = null;
        IXQEQueryNode parent = prompt.getParent();
        while (ds == null && !(parent instanceof V5Query) && !(parent instanceof RQPQuery)) {
            ds = V5GenericFunction.getClosestDataSource(parent);
            parent = parent.getParent();
        }
        if (ds == null) {
            return null;
        }
        String dsType = ds.getInterface();
        String functionSetId = V5GenericFunction.getVendorID(dsType, ds.getCMDataSourceName());
        return functionSetId;
    }

    public static String getVendorIdFromSQLQuery(IXQEQueryNode prompt) {
        IDataSource ds;
        SQLNativeSql sqlNativeQuery;
        V5Query v5Query = (V5Query)prompt.getAncestorOfType(101006);
        V5SqlQuery v5SqlQuery = (V5SqlQuery)v5Query.getV5Source().getFirstChildByType(101016);
        if (v5SqlQuery != null && (sqlNativeQuery = (SQLNativeSql)v5Query.getV5Source().getFirstDescendantOfTypeOrdered(301012, false)) != null && (ds = sqlNativeQuery.getDataSource()) != null) {
            String dsType = ds.getType();
            String cmDSName = ds.getCMDataSourceName();
            String functionSetId = V5GenericFunction.getVendorID(dsType, cmDSName);
            return functionSetId;
        }
        return null;
    }

    public static IModelDataSource getClosestDataSource(IXQEQueryNode parent) {
        for (IXQEQueryNode child : parent.getChildren()) {
            IMetadata metaData;
            if (!(child instanceof V5BoundMultiPartIdentifier) || (metaData = ((V5BoundMultiPartIdentifier)child).getMetadata()) == null) continue;
            return metaData.getConnection().getModelDataSources().get(0);
        }
        for (IXQEQueryNode child : parent.getChildren()) {
            V5DataItem diRef;
            if (!(child instanceof V5BoundDataItemReference) || !(diRef = ((V5BoundDataItemReference)child).getRefDataItem()).hasDescendantOfType(201116, false)) continue;
            return V5GenericFunction.getClosestDataSource(diRef);
        }
        for (IXQEQueryNode child : parent.getChildren()) {
            if (!(child instanceof V5Expression) && !(child instanceof AbstractV5ValueExpression) || !child.hasDescendantOfType(201116, false)) continue;
            return V5GenericFunction.getClosestDataSource(child);
        }
        for (IXQEQueryNode child : parent.getChildren()) {
            if (!(child instanceof V5DataItem) || !((V5DataItem)child).getIsProjected() || !child.hasDescendantOfType(201116, false)) continue;
            return V5GenericFunction.getClosestDataSource(child);
        }
        for (IXQEQueryNode child : parent.getChildren()) {
            RQPDataItem rqpDI;
            if (!(child instanceof RQPDataItemRef) || !(rqpDI = ((RQPDataItemRef)child).getReferencedItem()).hasDescendantOfType(201116, false)) continue;
            return V5GenericFunction.getClosestDataSource(rqpDI);
        }
        return null;
    }

    @Override
    public boolean isSameExpression(IXQEQueryNode node, boolean compareCalcDefiniton) {
        if (!super.isSameExpression(node, compareCalcDefiniton)) {
            return false;
        }
        return this.getName().equals(((V5GenericFunction)node).getName());
    }
}

