/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.v5Exp;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.v5.V5InvalidAttributeException;
import com.cognos.xqe.ast.v5.V5InvalidElementException;
import com.cognos.xqe.ast.v5Exp.AbstractV5ValueExpression;
import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import org.dom4j.Attribute;
import org.dom4j.Element;

public class V5LiteralValue
extends AbstractV5ValueExpression {
    public static final String NODE_TYPE_NAME = "V5LiteralValue";
    public static final String PROP_OBJECT_VALUE = "value";
    public static final String PROP_OBJECT_DATATYPE = "dataType";
    public static final String PROP_OBJECT_INCLUSIVE = "inclusive";
    private static final String QUOTE = "'";
    public static final String NULL_KEYWORD = "null";
    private static final String ESCAPED_SINGLE_QUOTE = "''";

    public V5LiteralValue() {
        this.setInclusive(true);
    }

    public void setDataType(IDataType dataType) {
        this.setPropertyValue(PROP_OBJECT_DATATYPE, dataType);
    }

    @Override
    public IDataType getDataType() {
        return (IDataType)this.getPropertyValue(PROP_OBJECT_DATATYPE);
    }

    public void setInclusive(Boolean inclusive) {
        this.setPropertyValue(PROP_OBJECT_INCLUSIVE, new Boolean(inclusive));
    }

    public boolean getInclusive() {
        Boolean inclusive = (Boolean)this.getPropertyValue(PROP_OBJECT_INCLUSIVE);
        return inclusive;
    }

    public void setValue(String sValue) {
        IDataType dataType = this.getDataType();
        if (dataType == null) {
            return;
        }
        Value value = (Value)dataType.createValue();
        value.set(sValue);
        this.setPropertyValue(PROP_OBJECT_VALUE, value);
    }

    public void setValue(Value value) {
        this.setPropertyValue(PROP_OBJECT_VALUE, value);
    }

    public Value getValue() {
        return (Value)this.getPropertyValue(PROP_OBJECT_VALUE);
    }

    @Override
    public boolean isOfCategory(int category) {
        if (category == 201026) {
            return true;
        }
        return super.isOfCategory(category);
    }

    @Override
    public int getType() {
        return 201026;
    }

    @Override
    public String getNodeTypeName() {
        return NODE_TYPE_NAME;
    }

    @Override
    public void writeFormattedText(StringBuilder buffer) {
        Value v = this.getValue();
        if (v == null || v.isNull()) {
            buffer.append(NULL_KEYWORD);
        } else if (this.getDataType().isTextType()) {
            String escapedString = this.getValue().getString().replace(QUOTE, ESCAPED_SINGLE_QUOTE);
            buffer.append(QUOTE).append(escapedString).append(QUOTE);
        } else {
            buffer.append(v.toString());
        }
    }

    @Override
    public String getNativeName() {
        String name = super.getNativeName();
        if (name == null) {
            Value v = this.getValue();
            if (v == null || v.isNull()) {
                name = NULL_KEYWORD;
            } else if (this.getDataType().isTextType()) {
                String escapedString = this.getValue().getString().replace(QUOTE, ESCAPED_SINGLE_QUOTE);
                name = QUOTE + escapedString + QUOTE;
            } else {
                name = v.toString();
            }
        }
        return name;
    }

    @Override
    public boolean isSameExpression(IXQEQueryNode node, boolean compareCalcDefiniton) {
        boolean rc;
        if (this == node) {
            return true;
        }
        if (node.getType() != 201026) {
            return false;
        }
        Value value = ((V5LiteralValue)node).getValue();
        boolean bl = rc = value.getDataType().getCCLTypeCode() == this.getValue().getDataType().getCCLTypeCode();
        if (rc) {
            rc = value.compareTo(this.getValue()) == 0;
        }
        return rc;
    }

    @Override
    public boolean isLiteral() {
        return true;
    }

    @Override
    public boolean isNullable() {
        Value v = this.getValue();
        return v == null || !v.isOK();
    }

    @Override
    public void capture(PlanningEnvironment env, Element inputNode) throws V5InvalidAttributeException, V5InvalidElementException {
        boolean readV5SpecFormat = env.isReadV5SpecFormat();
        XQENodeFactory factory = env.getNodeFactory();
        int size = inputNode.attributeCount();
        for (int i = 0; i < size; ++i) {
            Attribute att = inputNode.attribute(i);
            String attname = att.getName();
            if (attname.equals(PROP_OBJECT_DATATYPE)) {
                IDataType dType = DataTypeFactory.getType(att.getValue());
                this.setDataType(dType);
                continue;
            }
            if (attname.equals(PROP_OBJECT_INCLUSIVE)) {
                this.setInclusive(new Boolean(att.getValue()));
                continue;
            }
            if (attname.equals(PROP_OBJECT_VALUE)) {
                this.setValue(att.getValue());
                continue;
            }
            if (!readV5SpecFormat) continue;
            throw new V5InvalidAttributeException(XQEMessageKeys.V5_InvalidAttribute, attname, inputNode.getName());
        }
    }
}

