/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.v5Exp;

import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.ast.olap.util.MDXLevelInfo;
import com.cognos.xqe.ast.v5.V5InvalidAttributeException;
import com.cognos.xqe.ast.v5.V5InvalidElementException;
import com.cognos.xqe.ast.v5Exp.V5SimpleNode;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.types.MemberType;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.MetadataUtil;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import java.util.List;
import org.dom4j.Attribute;
import org.dom4j.Element;

public class V5MemberUniqueName
extends V5SimpleNode {
    public static final String NODE_TYPE_NAME = "V5MemberUniqueName";
    public static final String PROP_STRING_MODEL = "model";
    public static final String PROP_STRING_LOGICAL = "logical";
    public static final String PROP_STRING_PHYSICAL = "physical";
    public static final String PROP_STRING_PROVIDER_UNIQUE_NAME = "providerUniqueName";
    public static final String PROP_OBJECT_METADATA = "metadata";

    public void setModel(String model) {
        this.setPropertyValue(PROP_STRING_MODEL, model);
    }

    public String getModel() {
        return (String)this.getPropertyValue(PROP_STRING_MODEL);
    }

    public void setLogical(String logical) {
        this.setPropertyValue(PROP_STRING_LOGICAL, logical);
    }

    public String getLogical() {
        return (String)this.getPropertyValue(PROP_STRING_LOGICAL);
    }

    public void setPhysical(String physical) {
        this.setPropertyValue(PROP_STRING_PHYSICAL, physical);
    }

    public String getPhysical() {
        String physical = (String)this.getPropertyValue(PROP_STRING_PHYSICAL);
        return physical;
    }

    public void setProviderUniqueName(String providerUniqueName) {
        if (providerUniqueName == null) {
            this.removeProperty(PROP_STRING_PROVIDER_UNIQUE_NAME);
            return;
        }
        this.setPropertyValue(PROP_STRING_PROVIDER_UNIQUE_NAME, providerUniqueName);
    }

    public String getProviderUniqueName() {
        String providerUniqueName = (String)this.getPropertyValue(PROP_STRING_PROVIDER_UNIQUE_NAME);
        return providerUniqueName;
    }

    @Override
    public int getType() {
        return 201028;
    }

    @Override
    public String getNodeTypeName() {
        return NODE_TYPE_NAME;
    }

    @Override
    public String getNativeName() {
        String physical = this.getPhysical();
        if (physical == null) {
            return this.getModel() + super.getNativeName() + this.getLogical();
        }
        return this.getModel() + super.getNativeName() + ":" + physical;
    }

    @Override
    public IDataType getDataType() {
        return MemberType.MEMBERTYPE;
    }

    public void setMetadata(IMetadata metadata) {
        this.setPropertyValue(PROP_OBJECT_METADATA, metadata);
    }

    @Override
    public IMetadata getMetadata() {
        return (IMetadata)this.getPropertyValue(PROP_OBJECT_METADATA);
    }

    public IHierarchy getHierarchy() {
        IHierarchy hierarchy = null;
        IMetadata metadata = this.getMetadata();
        if (metadata != null) {
            hierarchy = MetadataUtil.getHierarchy(metadata);
        }
        return hierarchy;
    }

    public ILevel getLevel() {
        ILevel level = null;
        IMetadata metadata = this.getMetadata();
        if (metadata != null) {
            level = MetadataUtil.getLevel(metadata);
        }
        return level;
    }

    @Override
    public MDXHierInfo getHierarchyInfo() {
        MDXHierInfo hierInfo = new MDXHierInfo();
        IHierarchy hierarchy = this.getHierarchy();
        if (hierarchy != null) {
            hierInfo.appendProjectedHierarchy(hierarchy);
        }
        return hierInfo;
    }

    @Override
    public MDXLevelInfo getHierarchyLevelInfo(MDXLevelInfo hierarchy, List<V5SimpleNode> fncs) {
        MDXLevelInfo levelInfo = new MDXLevelInfo();
        if (this.getHierarchy().equals(hierarchy.getHierarchyInfo().getProjectedHierarchy(0))) {
            if (this.getLevel() == null) {
                levelInfo.addProjectedHierarchy(this.getHierarchy());
            } else {
                levelInfo.addProjectedHierarchy(this.getLevel());
            }
        }
        return levelInfo;
    }

    @Override
    public void capture(PlanningEnvironment env, Element inputNode) throws V5InvalidAttributeException, V5InvalidElementException {
        boolean readV5SpecFormat = env.isReadV5SpecFormat();
        int size = inputNode.attributeCount();
        for (int i = 0; i < size; ++i) {
            Attribute att = inputNode.attribute(i);
            String attname = att.getName();
            if (attname.equals(PROP_STRING_LOGICAL)) {
                this.setLogical(att.getValue());
                continue;
            }
            if (attname.equals(PROP_STRING_MODEL)) {
                this.setModel(att.getValue());
                continue;
            }
            if (attname.equals("nativeName")) {
                this.setNativeName(att.getValue());
                continue;
            }
            if (!readV5SpecFormat) continue;
            throw new V5InvalidAttributeException(XQEMessageKeys.V5_InvalidAttribute, attname, inputNode.getName());
        }
        int i = 0;
        List children = inputNode.elements();
        size = children.size();
        if (i < size) {
            Element child = (Element)children.get(i);
            String childname = child.getName();
            throw new V5InvalidElementException(XQEMessageKeys.V5_InvalidElement, childname, inputNode.getName());
        }
    }
}

