/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.v5Exp;

import com.cognos.xqe.ast.IXQENodeFactory;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.ast.rqp.RQPDataItem;
import com.cognos.xqe.ast.rqp.RQPDataItemRef;
import com.cognos.xqe.ast.v5.V5QueryNode;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5.utils.V5NodeFormatResolver;
import com.cognos.xqe.ast.v5Exp.V5BoundDataItemReference;
import com.cognos.xqe.ast.v5Exp.V5MemberSummaryFunction;
import com.cognos.xqe.ast.v5Exp.V5OrderFunction;
import com.cognos.xqe.ast.v5Exp.V5RollupAggregateEnum;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.transformation.decomposition.ValidateV5Expression;
import com.cognos.xqe.util.pool.XQEIntegerPool;
import java.util.ArrayList;

public abstract class V5SimpleNode
extends V5QueryNode {
    public static final String PROP_INTEGER_SUBTYPE = "subtype";
    public static final String PROP_STRING_NATIVE_NAME = "nativeName";
    public static final String PROP_BOOLEAN_IS_COERCION = "isCoercion";
    protected int mSubtype;
    public static final String OPEN_BRACKET = "[";
    public static final String CLOSE_BRACKET = "]";
    public static final String OPEN_PARENTHESIS = "(";
    public static final String CLOSE_PARENTHESIS = ")";
    public static final String OPEN_BRACE = "{";
    public static final String CLOSE_BRACE = "}";
    public static final String LIST_SEPARATOR = "; ";
    public static final String SPACE = " ";
    public static final String EMPTY_STRING = "";
    public static final String AND = "and";

    protected V5SimpleNode() {
    }

    public int getSubType() {
        return this.mSubtype;
    }

    public void setSubType(int type) {
        this.mSubtype = type;
        this.setPropertyValue(PROP_INTEGER_SUBTYPE, XQEIntegerPool.getInteger(this.mSubtype));
    }

    @Override
    public void copyContentTo(IXQENodeFactory nodeFactory, IXQEQueryNode node) {
        super.copyContentTo(nodeFactory, node);
        V5SimpleNode target = (V5SimpleNode)node;
        target.mSubtype = this.mSubtype;
    }

    public IDataType getDataType() {
        return null;
    }

    @Override
    public String getFormat() {
        int subType;
        int nodeType;
        V5NodeFormatResolver formatResolver = V5NodeFormatResolver.getV5NodeFormatResolver();
        String formatString = formatResolver.resolveFormat(nodeType = this.getType(), subType = this.getSubType());
        if (formatString != null && formatString.startsWith("@")) {
            int argu = Integer.valueOf(formatString.substring(1)) - 1;
            if (this.getNumberChildren() <= argu) {
                return null;
            }
            IXQEQueryNode child = this.getChild(argu);
            if (!(child instanceof V5SimpleNode)) {
                return null;
            }
            V5SimpleNode childNode = (V5SimpleNode)child;
            formatString = childNode.getFormat();
        }
        return formatString;
    }

    public IDataType[] getChildDataTypes() {
        int numberChildren = this.getNumberChildren();
        IDataType[] oDataTypes = new IDataType[numberChildren];
        for (int i = 0; i < numberChildren; ++i) {
            oDataTypes[i] = V5SimpleNode.getNodeDataType(this.getChild(i));
        }
        return oDataTypes;
    }

    public static IDataType getNodeDataType(IXQEQueryNode node) {
        RQPDataItem referencedItem;
        IDataType dataType = null;
        if (node instanceof V5SimpleNode) {
            dataType = ((V5SimpleNode)node).getDataType();
        } else if (node instanceof V5DataItem) {
            dataType = ((V5DataItem)node).getDataType();
        } else if (node instanceof RQPDataItemRef && (referencedItem = ((RQPDataItemRef)node).getReferencedItem()) != null) {
            dataType = V5SimpleNode.getNodeDataType(referencedItem.getChild(0));
        }
        return dataType;
    }

    IXQEQueryNode getV5ParameterChildAtIndex(int index) {
        return null;
    }

    IXQEQueryNode getFirstSiblingAtIndex(int index) {
        IXQEQueryNode[] siblings = this.getChildren();
        IXQEQueryNode lhs = null;
        for (int i = 0; i < siblings.length; ++i) {
            if (i == index) continue;
            lhs = siblings[i];
            break;
        }
        return V5SimpleNode.skipUnrelatedNodes(lhs);
    }

    public IDataType getDataTypeOfV5ParameterChildAtIndex(int index) {
        return null;
    }

    public boolean isMeasure() {
        return false;
    }

    public IMetadata getMetadata() {
        return null;
    }

    @Override
    public String[] getSyntaxProperties() {
        return new String[]{PROP_INTEGER_SUBTYPE};
    }

    @Override
    public int getType() {
        return 201120;
    }

    @Override
    public boolean isOfCategory(int category) {
        if (category == 201120) {
            return true;
        }
        return super.isOfCategory(category);
    }

    @Override
    public MDXHierInfo getHierarchyInfo() {
        MDXHierInfo hierInfo = new MDXHierInfo();
        return hierInfo;
    }

    protected MDXHierInfo getFirstChildHierarchyInfo() {
        MDXHierInfo hierInfo = new MDXHierInfo();
        if (this.getNumberChildren() >= 1) {
            IXQEQueryNode childNode;
            for (childNode = this.getChild(0); !(childNode instanceof V5SimpleNode) && childNode != null && childNode.getNumberChildren() >= 1; childNode = childNode.getChild(0)) {
            }
            if (childNode != null && childNode instanceof V5SimpleNode) {
                hierInfo = ((V5SimpleNode)childNode).getHierarchyInfo();
            }
        }
        return hierInfo;
    }

    protected MDXHierInfo getSecondChildHierarchyInfo() {
        MDXHierInfo hierInfo = new MDXHierInfo();
        if (this.getNumberChildren() >= 2) {
            IXQEQueryNode childNode = this.getChild(1);
            while (childNode.getType() == 101003) {
                childNode = childNode.getChild(0);
            }
            hierInfo = ((V5SimpleNode)childNode).getHierarchyInfo();
        }
        return hierInfo;
    }

    public void setRollupAggregate(V5RollupAggregateEnum rollupAggregate) {
        this.setPropertyValue("rollupAggregate", rollupAggregate);
    }

    public V5RollupAggregateEnum getRollupAggregate() {
        V5RollupAggregateEnum rollupAggregate = (V5RollupAggregateEnum)this.getPropertyValue("rollupAggregate");
        if (rollupAggregate == null) {
            rollupAggregate = V5RollupAggregateEnum.UNDEFINED;
        }
        return rollupAggregate;
    }

    public void setNativeName(String name) {
        this.setPropertyValue(PROP_STRING_NATIVE_NAME, name);
    }

    public String getNativeName() {
        return (String)this.getPropertyValue(PROP_STRING_NATIVE_NAME);
    }

    public void setIsCoercion(boolean value) {
        if (value) {
            this.setPropertyValue(PROP_BOOLEAN_IS_COERCION, Boolean.TRUE);
        }
    }

    public boolean isCoercion() {
        return this.getPropertyValue(PROP_BOOLEAN_IS_COERCION) == Boolean.TRUE;
    }

    @Override
    public void writeFormattedText(StringBuilder buffer) {
        buffer.append(this.getNativeName());
        IXQEQueryNode[] children = this.getChildren();
        if (children.length > 0) {
            buffer.append(OPEN_PARENTHESIS);
            children[0].writeFormattedText(buffer);
            for (int i = 1; i < children.length; ++i) {
                buffer.append(LIST_SEPARATOR);
                children[i].writeFormattedText(buffer);
            }
            if (this instanceof V5OrderFunction) {
                buffer.append(LIST_SEPARATOR);
                V5OrderFunction v5Order = (V5OrderFunction)this;
                buffer.append(v5Order.getSortOrderString());
            }
            buffer.append(CLOSE_PARENTHESIS);
        }
    }

    public ValidateV5Expression.ErrorCode validateExpression(ArrayList<String> params) {
        return ValidateV5Expression.ErrorCode.OK;
    }

    public static IXQEQueryNode skipUnrelatedNodes(IXQEQueryNode originalNode) {
        int[] skipCategories = new int[]{201086, 201073};
        IXQEQueryNode newNode = originalNode;
        while (newNode.getType() == 101003 || newNode.getType() == 101004 || newNode.getType() == 201060 || newNode.getNumberChildren() == 1 && newNode.isOfCategories(skipCategories)) {
            if (newNode.getType() == 201060) {
                newNode = ((V5BoundDataItemReference)newNode).getReferencedExpression();
                continue;
            }
            newNode = newNode.getChild(0);
        }
        return newNode;
    }

    public boolean isLiteral() {
        return true;
    }

    public boolean isNullable() {
        IXQEQueryNode[] children = this.getChildren();
        if (children.length == 0) {
            return true;
        }
        for (IXQEQueryNode child : children) {
            if (child.isOfCategory(201120) && !((V5SimpleNode)child).isNullable()) continue;
            return true;
        }
        return false;
    }

    public static MDXHierInfo getHierarchyInfo(V5SimpleNode projectedExpr) {
        MDXHierInfo hierInfo = null;
        hierInfo = projectedExpr.getType() == 201032 ? ((V5MemberSummaryFunction)projectedExpr).getSetHierarchyInfo(false) : projectedExpr.getHierarchyInfo();
        return hierInfo;
    }
}

