/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.v5Exp;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.rqp.RQPDataItem;
import com.cognos.xqe.ast.rqp.RQPDataItemRef;
import com.cognos.xqe.ast.v5.V5QueryNode;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5.utils.V5NodeFormatResolver;
import com.cognos.xqe.ast.v5Exp.AbstractV5ValueExpression;
import com.cognos.xqe.ast.v5Exp.V5SimpleNode;
import com.cognos.xqe.ast.v5Exp.util.V5ExpressionCheck;
import com.cognos.xqe.ast.v5Exp.util.V5ExpressionTypeEnum;
import com.cognos.xqe.data.DataSubType;
import com.cognos.xqe.data.types.DateType;
import com.cognos.xqe.data.types.DoubleType;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.types.IntegerType;
import com.cognos.xqe.data.types.IntervalDayTimeType;
import com.cognos.xqe.data.types.IntervalYearMonthType;
import com.cognos.xqe.data.types.TimeType;
import com.cognos.xqe.data.types.TimeWithTZType;
import com.cognos.xqe.data.types.TimestampType;
import com.cognos.xqe.data.types.TimestampWithTZType;
import com.cognos.xqe.function.character.Concat;
import com.cognos.xqe.function.operator.Add;
import com.cognos.xqe.function.operator.Divide;
import com.cognos.xqe.function.operator.Multiply;
import com.cognos.xqe.function.operator.Negate;
import com.cognos.xqe.function.operator.Subtract;
import com.cognos.xqe.transformation.decomposition.ValidateV5Expression;
import java.util.ArrayList;

public class V5ValueExpression
extends AbstractV5ValueExpression {
    public static final String NODE_TYPE_NAME = "V5ValueExpression";
    public static final int SUBTYPE_CONCATENATE = 0;
    public static final int SUBTYPE_MINUS = 1;
    public static final int SUBTYPE_PLUS = 2;
    public static final int SUBTYPE_DIVIDE = 3;
    public static final int SUBTYPE_MULTIPLY = 4;
    public static final int SUBTYPE_UNARYPLUS = 5;
    public static final int SUBTYPE_UNARYMINUS = 6;
    public static final String NODE_SUBTYPE_NAME_CONCATENATE = "||";
    public static final String NODE_SUBTYPE_NAME_MINUS = "-";
    public static final String NODE_SUBTYPE_NAME_PLUS = "+";
    public static final String NODE_SUBTYPE_NAME_DIVIDE = "/";
    public static final String NODE_SUBTYPE_NAME_MULTIPLY = "*";
    private static final String STRING = "string";

    @Override
    public boolean isOfCategory(int category) {
        if (category == 201014) {
            return true;
        }
        return super.isOfCategory(category);
    }

    @Override
    public int getType() {
        return 201014;
    }

    @Override
    public String getNodeTypeName() {
        return NODE_TYPE_NAME;
    }

    @Override
    public IDataType getDataType() {
        IDataType[] oDataTypes = this.getChildDataTypes();
        if (V5ValueExpression.hasMetadataResultType(oDataTypes)) {
            return DoubleType.DOUBLETYPE;
        }
        IDataType result = null;
        switch (this.mSubtype) {
            case 0: {
                result = Concat.getOutputType(oDataTypes);
                break;
            }
            case 1: {
                result = Subtract.getOutputType(oDataTypes);
                break;
            }
            case 2: {
                result = Add.getOutputType(oDataTypes);
                break;
            }
            case 3: {
                result = Divide.getOutputType(oDataTypes);
                break;
            }
            case 4: {
                result = Multiply.getOutputType(oDataTypes);
                break;
            }
            case 5: 
            case 6: {
                result = Negate.getOutputType(oDataTypes);
                break;
            }
            default: {
                result = null;
            }
        }
        return result;
    }

    private static boolean hasMetadataResultType(IDataType[] fArgumentTypes) {
        for (int i = 0; i < fArgumentTypes.length; ++i) {
            if (fArgumentTypes[i] == null || fArgumentTypes[i].getSubType() != DataSubType.METADATATYPE) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isMeasure() {
        int numberChildren = this.getNumberChildren();
        for (int i = 0; i < numberChildren; ++i) {
            if (!((V5SimpleNode)this.getChild(i)).isMeasure()) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getFormat() {
        String formatString = null;
        switch (this.getSubType()) {
            case 3: 
            case 4: {
                if (this.getNumberChildren() != 2) {
                    this.throwInternalError("invalid number of children");
                }
                String formatStringLeft = null;
                IXQEQueryNode childLeft = this.getChild(0);
                if (childLeft instanceof V5SimpleNode) {
                    formatStringLeft = ((V5SimpleNode)childLeft).getFormat();
                }
                String formatStringRight = null;
                IXQEQueryNode childRight = this.getChild(1);
                if (childRight instanceof V5SimpleNode) {
                    formatStringRight = ((V5SimpleNode)childRight).getFormat();
                }
                if (this.getSubType() == 3 && V5NodeFormatResolver.isCurrencyFormat(formatStringLeft) && V5NodeFormatResolver.isCurrencyFormat(formatStringRight)) {
                    return "<formatGroup><numberFormat/></formatGroup>";
                }
                if (V5NodeFormatResolver.isPercentFormat(formatStringLeft)) {
                    return formatStringRight;
                }
                if (V5NodeFormatResolver.isPercentFormat(formatStringRight)) {
                    return formatStringLeft;
                }
                if (V5NodeFormatResolver.isIntegerFormat(formatStringLeft)) {
                    return formatStringRight;
                }
                if (V5NodeFormatResolver.isIntegerFormat(formatStringRight)) {
                    return formatStringLeft;
                }
                if (V5NodeFormatResolver.isNumberFormat(formatStringLeft)) {
                    return formatStringRight;
                }
                if (V5NodeFormatResolver.isNumberFormat(formatStringRight)) {
                    return formatStringLeft;
                }
                formatString = formatStringLeft;
                break;
            }
            default: {
                formatString = super.getFormat();
            }
        }
        return formatString;
    }

    @Override
    public IDataType getDataTypeOfV5ParameterChildAtIndex(int index) {
        IDataType expectedDataType = null;
        if (this.getSubType() == 5 || this.getSubType() == 6) {
            IXQEQueryNode parent = this.getParent();
            expectedDataType = parent.isOfCategory(201120) ? ((V5SimpleNode)parent).getDataTypeOfV5ParameterChildAtIndex(parent.getPositionOfChild(this)) : super.getDataTypeOfV5ParameterChildAtIndex(parent.getPositionOfChild(this));
        } else {
            IXQEQueryNode lhs = this.getFirstSiblingAtIndex(index);
            if (lhs.getType() == 201024 && lhs.getPropertyValue("datatype") == null) {
                IXQEQueryNode parent = this.getParent();
                while (parent.getType() == 101003) {
                    parent = parent.getChild(0);
                }
                if (parent != this) {
                    expectedDataType = parent.isOfCategory(201120) ? ((V5SimpleNode)parent).getDataTypeOfV5ParameterChildAtIndex(parent.getPositionOfChild(this)) : super.getDataTypeOfV5ParameterChildAtIndex(parent.getPositionOfChild(this));
                }
            } else {
                IXQEQueryNode leftExprNode = lhs;
                if (lhs.getType() == 801009) {
                    RQPDataItem proj = ((RQPDataItemRef)lhs).getReferencedItem();
                    leftExprNode = proj.getExpression();
                }
                expectedDataType = leftExprNode instanceof V5SimpleNode ? ((V5SimpleNode)leftExprNode).getDataType() : this.findDataTypeBasedOnKnownType(this.getSubType(), expectedDataType, 2 - index);
            }
        }
        return expectedDataType;
    }

    private IDataType findDataTypeBasedOnKnownType(int opType, IDataType knownType, int siblingPos) {
        IDataType[][] addDTTable = new IDataType[][]{{TimestampType.TIMESTAMPTYPE, DateType.DATETYPE, TimeType.TIMETYPE}, {TimestampWithTZType.TIMESTAMPWITHTZTYPE, DateType.DATETYPE, TimeWithTZType.TIMEWITHTZTYPE}, {DateType.DATETYPE, DateType.DATETYPE, IntervalDayTimeType.DEFAULT_INTERVALDAYTIMETYPE}, {DateType.DATETYPE, DateType.DATETYPE, IntervalYearMonthType.DEFAULT_INTERVALYEARMONTHTYPE}, {TimestampType.TIMESTAMPTYPE, TimeType.TIMETYPE, DateType.DATETYPE}, {TimeType.TIMETYPE, TimeType.TIMETYPE, IntervalDayTimeType.DEFAULT_INTERVALDAYTIMETYPE}, {TimestampWithTZType.TIMESTAMPWITHTZTYPE, TimeWithTZType.TIMEWITHTZTYPE, DateType.DATETYPE}, {TimeWithTZType.TIMEWITHTZTYPE, TimeWithTZType.TIMEWITHTZTYPE, IntervalDayTimeType.DEFAULT_INTERVALDAYTIMETYPE}, {TimestampType.TIMESTAMPTYPE, TimestampType.TIMESTAMPTYPE, IntervalDayTimeType.DEFAULT_INTERVALDAYTIMETYPE}, {TimestampType.TIMESTAMPTYPE, TimestampType.TIMESTAMPTYPE, IntervalYearMonthType.DEFAULT_INTERVALYEARMONTHTYPE}, {TimestampWithTZType.TIMESTAMPWITHTZTYPE, TimestampWithTZType.TIMESTAMPWITHTZTYPE, IntervalDayTimeType.DEFAULT_INTERVALDAYTIMETYPE}, {TimestampWithTZType.TIMESTAMPWITHTZTYPE, TimestampWithTZType.TIMESTAMPWITHTZTYPE, IntervalYearMonthType.DEFAULT_INTERVALYEARMONTHTYPE}, {TimeType.TIMETYPE, IntervalDayTimeType.DEFAULT_INTERVALDAYTIMETYPE, TimeType.TIMETYPE}, {TimeWithTZType.TIMEWITHTZTYPE, IntervalDayTimeType.DEFAULT_INTERVALDAYTIMETYPE, TimeWithTZType.TIMEWITHTZTYPE}, {DateType.DATETYPE, IntervalDayTimeType.DEFAULT_INTERVALDAYTIMETYPE, DateType.DATETYPE}, {TimestampType.TIMESTAMPTYPE, IntervalDayTimeType.DEFAULT_INTERVALDAYTIMETYPE, TimestampType.TIMESTAMPTYPE}, {TimestampWithTZType.TIMESTAMPWITHTZTYPE, IntervalDayTimeType.DEFAULT_INTERVALDAYTIMETYPE, TimestampWithTZType.TIMESTAMPWITHTZTYPE}, {IntervalDayTimeType.DEFAULT_INTERVALDAYTIMETYPE, IntervalDayTimeType.DEFAULT_INTERVALDAYTIMETYPE, IntervalDayTimeType.DEFAULT_INTERVALDAYTIMETYPE}, {DateType.DATETYPE, IntervalYearMonthType.DEFAULT_INTERVALYEARMONTHTYPE, DateType.DATETYPE}, {TimestampType.TIMESTAMPTYPE, IntervalYearMonthType.DEFAULT_INTERVALYEARMONTHTYPE, TimestampType.TIMESTAMPTYPE}, {TimestampWithTZType.TIMESTAMPWITHTZTYPE, IntervalYearMonthType.DEFAULT_INTERVALYEARMONTHTYPE, TimestampWithTZType.TIMESTAMPWITHTZTYPE}, {IntervalDayTimeType.DEFAULT_INTERVALDAYTIMETYPE, IntervalYearMonthType.DEFAULT_INTERVALYEARMONTHTYPE, IntervalDayTimeType.DEFAULT_INTERVALDAYTIMETYPE}};
        IDataType[][] subtractDTTable = new IDataType[][]{{IntervalDayTimeType.DEFAULT_INTERVALDAYTIMETYPE, DateType.DATETYPE, DateType.DATETYPE}, {IntervalDayTimeType.DEFAULT_INTERVALDAYTIMETYPE, DateType.DATETYPE, TimestampType.TIMESTAMPTYPE}, {IntervalDayTimeType.DEFAULT_INTERVALDAYTIMETYPE, DateType.DATETYPE, TimestampWithTZType.TIMESTAMPWITHTZTYPE}, {DateType.DATETYPE, DateType.DATETYPE, IntervalDayTimeType.DEFAULT_INTERVALDAYTIMETYPE}, {DateType.DATETYPE, DateType.DATETYPE, IntervalYearMonthType.DEFAULT_INTERVALYEARMONTHTYPE}, {IntervalDayTimeType.DEFAULT_INTERVALDAYTIMETYPE, TimeType.TIMETYPE, TimeType.TIMETYPE}, {IntervalDayTimeType.DEFAULT_INTERVALDAYTIMETYPE, TimeType.TIMETYPE, TimeWithTZType.TIMEWITHTZTYPE}, {TimeType.TIMETYPE, TimeType.TIMETYPE, IntervalDayTimeType.DEFAULT_INTERVALDAYTIMETYPE}, {IntervalDayTimeType.DEFAULT_INTERVALDAYTIMETYPE, TimeWithTZType.TIMEWITHTZTYPE, TimeWithTZType.TIMEWITHTZTYPE}, {IntervalDayTimeType.DEFAULT_INTERVALDAYTIMETYPE, TimeWithTZType.TIMEWITHTZTYPE, TimeType.TIMETYPE}, {TimeWithTZType.TIMEWITHTZTYPE, TimeWithTZType.TIMEWITHTZTYPE, IntervalDayTimeType.DEFAULT_INTERVALDAYTIMETYPE}, {IntervalDayTimeType.DEFAULT_INTERVALDAYTIMETYPE, TimestampType.TIMESTAMPTYPE, TimestampType.TIMESTAMPTYPE}, {IntervalDayTimeType.DEFAULT_INTERVALDAYTIMETYPE, TimestampType.TIMESTAMPTYPE, DateType.DATETYPE}, {IntervalDayTimeType.DEFAULT_INTERVALDAYTIMETYPE, TimestampType.TIMESTAMPTYPE, TimeWithTZType.TIMEWITHTZTYPE}, {TimestampType.TIMESTAMPTYPE, TimestampType.TIMESTAMPTYPE, IntervalDayTimeType.DEFAULT_INTERVALDAYTIMETYPE}, {TimestampType.TIMESTAMPTYPE, TimestampType.TIMESTAMPTYPE, IntervalYearMonthType.DEFAULT_INTERVALYEARMONTHTYPE}, {IntervalDayTimeType.DEFAULT_INTERVALDAYTIMETYPE, TimestampWithTZType.TIMESTAMPWITHTZTYPE, TimestampWithTZType.TIMESTAMPWITHTZTYPE}, {IntervalDayTimeType.DEFAULT_INTERVALDAYTIMETYPE, TimestampWithTZType.TIMESTAMPWITHTZTYPE, DateType.DATETYPE}, {IntervalDayTimeType.DEFAULT_INTERVALDAYTIMETYPE, TimestampWithTZType.TIMESTAMPWITHTZTYPE, TimestampType.TIMESTAMPTYPE}, {TimestampWithTZType.TIMESTAMPWITHTZTYPE, TimestampWithTZType.TIMESTAMPWITHTZTYPE, IntervalDayTimeType.DEFAULT_INTERVALDAYTIMETYPE}, {TimestampWithTZType.TIMESTAMPWITHTZTYPE, TimestampWithTZType.TIMESTAMPWITHTZTYPE, IntervalYearMonthType.DEFAULT_INTERVALYEARMONTHTYPE}, {IntervalDayTimeType.DEFAULT_INTERVALDAYTIMETYPE, IntervalDayTimeType.DEFAULT_INTERVALDAYTIMETYPE, IntervalDayTimeType.DEFAULT_INTERVALDAYTIMETYPE}, {IntervalYearMonthType.DEFAULT_INTERVALYEARMONTHTYPE, IntervalYearMonthType.DEFAULT_INTERVALYEARMONTHTYPE, IntervalYearMonthType.DEFAULT_INTERVALYEARMONTHTYPE}};
        IDataType[][] multiplyDTTable = new IDataType[][]{{IntervalDayTimeType.DEFAULT_INTERVALDAYTIMETYPE, IntegerType.INTEGERTYPE, IntervalDayTimeType.DEFAULT_INTERVALDAYTIMETYPE}, {IntervalYearMonthType.DEFAULT_INTERVALYEARMONTHTYPE, IntegerType.INTEGERTYPE, IntervalYearMonthType.DEFAULT_INTERVALYEARMONTHTYPE}, {IntervalDayTimeType.DEFAULT_INTERVALDAYTIMETYPE, IntervalDayTimeType.DEFAULT_INTERVALDAYTIMETYPE, IntegerType.INTEGERTYPE}, {IntervalYearMonthType.DEFAULT_INTERVALYEARMONTHTYPE, IntervalYearMonthType.DEFAULT_INTERVALYEARMONTHTYPE, IntegerType.INTEGERTYPE}};
        IDataType[][] divideDTTable = new IDataType[][]{{IntervalDayTimeType.DEFAULT_INTERVALDAYTIMETYPE, IntervalDayTimeType.DEFAULT_INTERVALDAYTIMETYPE, IntegerType.INTEGERTYPE}, {IntervalYearMonthType.DEFAULT_INTERVALYEARMONTHTYPE, IntervalYearMonthType.DEFAULT_INTERVALYEARMONTHTYPE, IntegerType.INTEGERTYPE}};
        IDataType[][] tableToUse = null;
        switch (opType) {
            case 2: {
                tableToUse = addDTTable;
                break;
            }
            case 1: {
                tableToUse = subtractDTTable;
                break;
            }
            case 4: {
                tableToUse = multiplyDTTable;
                break;
            }
            case 3: {
                tableToUse = divideDTTable;
                break;
            }
        }
        if (tableToUse != null) {
            for (int i = 0; i < tableToUse.length; ++i) {
                if (!tableToUse[i][siblingPos].equals(knownType)) continue;
                int pos = tableToUse[i].length;
                return tableToUse[i][pos - siblingPos];
            }
        }
        return null;
    }

    public String getNodeSubTypeName() {
        String subTypeName = null;
        switch (this.mSubtype) {
            case 0: {
                subTypeName = NODE_SUBTYPE_NAME_CONCATENATE;
                break;
            }
            case 1: {
                subTypeName = NODE_SUBTYPE_NAME_MINUS;
                break;
            }
            case 2: {
                subTypeName = NODE_SUBTYPE_NAME_PLUS;
                break;
            }
            case 3: {
                subTypeName = NODE_SUBTYPE_NAME_DIVIDE;
                break;
            }
            case 4: {
                subTypeName = NODE_SUBTYPE_NAME_MULTIPLY;
                break;
            }
            case 5: {
                subTypeName = NODE_SUBTYPE_NAME_PLUS;
                break;
            }
            case 6: {
                subTypeName = NODE_SUBTYPE_NAME_MINUS;
                break;
            }
            default: {
                subTypeName = null;
            }
        }
        return subTypeName;
    }

    @Override
    public void setSubType(int type) {
        super.setSubType(type);
        this.setNativeName(this.getNodeSubTypeName());
    }

    @Override
    public void writeFormattedText(StringBuilder buffer) {
        if (this.getSubType() == 5 || this.getSubType() == 6) {
            super.writeFormattedText(buffer);
        } else {
            IXQEQueryNode[] children = this.getChildren();
            if (children.length > 0) {
                buffer.append("(");
                ((V5QueryNode)children[0]).writeFormattedText(buffer);
                for (int i = 1; i < children.length; ++i) {
                    buffer.append(this.getNativeName());
                    ((V5QueryNode)children[i]).writeFormattedText(buffer);
                }
                buffer.append(")");
            }
        }
    }

    @Override
    public ValidateV5Expression.ErrorCode validateExpression(ArrayList<String> parts) {
        DataSubType dataSubType = null;
        V5ExpressionTypeEnum expressionType = null;
        int subType = this.getSubType();
        if (subType == 0) {
            IXQEQueryNode[] operands;
            for (IXQEQueryNode operand : operands = this.getChildren()) {
                if (operand instanceof V5SimpleNode) {
                    IDataType dataType = ((V5SimpleNode)operand).getDataType();
                    expressionType = V5ExpressionCheck.getExpressionType(operand);
                    if (dataType != null) {
                        dataSubType = dataType.getSubType();
                    }
                }
                if (dataSubType != DataSubType.METADATATYPE) continue;
                int nodePosition = operand.getParent().getPositionOfChild(operand) + 1;
                V5DataItem v5DataItem = (V5DataItem)this.getAncestorOfType(101003);
                parts.add(String.valueOf(nodePosition));
                parts.add(this.getNativeName());
                parts.add(v5DataItem.getNameProperty());
                parts.add(STRING);
                if (expressionType != V5ExpressionTypeEnum.UNKNOWN) {
                    parts.add(expressionType.getExpressionTypeName());
                }
                return ValidateV5Expression.ErrorCode.InvalidFunctionParameter;
            }
        }
        return ValidateV5Expression.ErrorCode.OK;
    }
}

