/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.v5Exp.util;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQEQueryNode;
import com.cognos.xqe.ast.olap.AbstractMDXNode;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.ast.olap.util.MDXLevelInfo;
import com.cognos.xqe.ast.rqp.RQPDataItem;
import com.cognos.xqe.ast.rqp.RQPDataItemRef;
import com.cognos.xqe.ast.v5.V5QueryNode;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5.query.V5Selection;
import com.cognos.xqe.ast.v5Exp.V5BoundParameter;
import com.cognos.xqe.ast.v5Exp.V5BoundToMetadata;
import com.cognos.xqe.ast.v5Exp.V5Parameter;
import com.cognos.xqe.ast.v5Exp.V5SimpleNode;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.metadata.ICalculation;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.INamedSet;
import com.cognos.xqe.metadata.IQueryItem;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.masterdetail.MasterDetailLink;
import com.cognos.xqe.query.masterdetail.MasterDetailProvider;
import com.cognos.xqeqte.QTEQueryNode;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public abstract class V5ParameterUtil {
    public static final String PROP_STRING_DATATYPE = "datatype";
    public static final String PROP_STRING_MODEL_IDENTIFIER = "modelIdentifier";
    public static final String PROP_STRING_VALUE_EXPRESSION = "valueExpression";
    public static final String PROP_STRING_IS_MEMBER_PARAMETER = "isMemberParameter";
    public static final String PROP_BOOLEAN_ISLITERAL = "isLiteral";
    public static final String MASTER_DETAIL_LINK_NAMES = "masterDetailLinkNames";
    public static final int[] PARENT_EXPRESSION_TYPES = new int[]{201013, 201011, 201005, 201006, 201007};

    private V5ParameterUtil() {
    }

    public static IHierarchy getHierarchy(V5BoundToMetadata parameter) {
        IHierarchy hierarchy;
        block23: {
            block22: {
                hierarchy = null;
                IMetadata metadataObj = parameter.getMetadata();
                if (metadataObj == null) break block22;
                switch (metadataObj.getObjectType()) {
                    case HIERARCHY: {
                        hierarchy = (IHierarchy)metadataObj;
                        break;
                    }
                    case LEVEL: {
                        hierarchy = ((ILevel)metadataObj).getHierarchy();
                        break;
                    }
                    case MEMBER: {
                        hierarchy = ((IMember)metadataObj).getLevel().getHierarchy();
                        break;
                    }
                    case DIMENSION: {
                        if (((IDimension)metadataObj).isMeasuresDimension()) {
                            hierarchy = ((IDimension)metadataObj).getDefaultHierarchy();
                            break;
                        }
                        break block23;
                    }
                    case CALCULATION: {
                        if (((ICalculation)metadataObj).getCalcType().equals("namedSet")) {
                            hierarchy = ((INamedSet)metadataObj).getHierarchy();
                            break;
                        }
                        break block23;
                    }
                    case QUERY_ITEM: {
                        hierarchy = ((IQueryItem)metadataObj).getHierarchy();
                        break;
                    }
                }
                break block23;
            }
            IXQEQueryNode parent = parameter.getParent();
            if (parent.getType() == 201101) {
                parent = parent.getParent();
            }
            if (parent.isOfTypes(PARENT_EXPRESSION_TYPES)) {
                IXQEQueryNode[] siblings = parent.getChildren();
                QTEQueryNode lhs = null;
                for (int i = 0; i < siblings.length; ++i) {
                    if (siblings[i] == parameter) continue;
                    lhs = siblings[i];
                    break;
                }
                if (lhs == null) {
                    return null;
                }
                while (lhs.getType() == 101003) {
                    lhs = lhs.getChild(0);
                }
                if (lhs.getType() == 801009) {
                    RQPDataItem proj = ((RQPDataItemRef)lhs).getReferencedItem();
                    lhs = proj.getExpression();
                }
                if ((lhs.getType() == 201024 || lhs.getType() == 201127) && ((V5BoundToMetadata)lhs).getMetadata() == null) {
                    return null;
                }
                MDXHierInfo hierarchyInfo = null;
                if (lhs.isOfCategory(1001)) {
                    hierarchyInfo = ((AbstractMDXNode)lhs).getHierarchyInfo();
                } else if (lhs.isOfCategory(201120)) {
                    hierarchyInfo = ((V5SimpleNode)lhs).getHierarchyInfo();
                } else {
                    return null;
                }
                if (!hierarchyInfo.getProjectedHierarchies().isEmpty()) {
                    hierarchy = hierarchyInfo.getProjectedHierarchy(0);
                }
            }
        }
        return hierarchy;
    }

    public static MDXLevelInfo getHierarchyLevelInfo(V5BoundToMetadata parameter, MDXLevelInfo forHierarchy, List<V5SimpleNode> fncs) {
        MDXLevelInfo levelInfo = new MDXLevelInfo();
        if (V5ParameterUtil.getHierarchy(parameter).equals(forHierarchy.getHierarchyInfo().getProjectedHierarchy(0))) {
            List<ILevel> levels = V5ParameterUtil.getLevels(parameter);
            if (levels.size() > 0) {
                levelInfo.addProjectedLevels(V5ParameterUtil.getLevels(parameter));
            } else {
                levelInfo.addProjectedHierarchyNoLevels(V5ParameterUtil.getHierarchy(parameter));
            }
        }
        return levelInfo;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static List<ILevel> getLevels(V5BoundToMetadata parameter) {
        List<ILevel> levels = new ArrayList<ILevel>();
        IMetadata metaData = parameter.getMetadata();
        PlanningEnvironment planEnv = (PlanningEnvironment)parameter.getPlanningEnvironment();
        if (metaData != null) {
            switch (metaData.getObjectType()) {
                case LEVEL: {
                    levels.add((ILevel)metaData);
                    return levels;
                }
                case QUERY_ITEM: {
                    levels.add(((IQueryItem)metaData).getLevel());
                    return levels;
                }
                case MEMBER: {
                    levels.add(((IMember)metaData).getLevel());
                    return levels;
                }
                case HIERARCHY: {
                    IHierarchy hierarchy = (IHierarchy)metaData;
                    List<String> mdLinkNames = (List<String>)parameter.getPropertyValue(MASTER_DETAIL_LINK_NAMES);
                    Object queryName = parameter.getPropertyValue("queryName");
                    if (mdLinkNames == null && queryName != null) {
                        RequestEnvironment requestEnv = (RequestEnvironment)planEnv.getRequestEnvironment();
                        MasterDetailProvider mdProvider = requestEnv.getMasterDetailProvider();
                        String parameterName = null;
                        switch (parameter.getType()) {
                            case 201024: {
                                parameterName = ((V5Parameter)parameter).getParameterName();
                                break;
                            }
                            case 201127: {
                                parameterName = ((V5BoundParameter)parameter).getParameterName();
                                break;
                            }
                            default: {
                                parameter.throwInternalError("Unexpected object type: " + parameter.getNodeTypeName() + ", id: " + parameter.getId());
                            }
                        }
                        mdLinkNames = mdProvider.getMasterDetailLinkNamesForParameter(parameterName, (String)queryName);
                    }
                    if (mdLinkNames != null && !mdLinkNames.isEmpty()) {
                        for (String mdLinkName : mdLinkNames) {
                            MDXLevelInfo masterQueryLevelInfo = V5ParameterUtil.getPromptLevelInfoFromMasterDetailLink(parameter, mdLinkName);
                            if (masterQueryLevelInfo == null || masterQueryLevelInfo.isEmpty()) {
                                levels.addAll(hierarchy.getLevels());
                                continue;
                            }
                            if (!masterQueryLevelInfo.getHierarchyInfo().projectsHierarchy(hierarchy)) continue;
                            List<ILevel> masterQueryLevels = masterQueryLevelInfo.getProjectedLevels(hierarchy);
                            for (ILevel aLevel : masterQueryLevels) {
                                ILevel detailQueryLevel = hierarchy.getLevel(aLevel.getUniqueName());
                                if (detailQueryLevel == null) continue;
                                levels.add(detailQueryLevel);
                            }
                        }
                    }
                    if (levels.size() != 0) return levels;
                    levels.addAll(hierarchy.getLevels());
                    return levels;
                }
                case CALCULATION: {
                    if (!((ICalculation)metaData).getCalcType().equals("namedSet")) return levels;
                    INamedSet namedSet = (INamedSet)metaData;
                    List linkNames = (List)parameter.getPropertyValue(MASTER_DETAIL_LINK_NAMES);
                    if (linkNames != null && !linkNames.isEmpty()) {
                        Iterator queryName = linkNames.iterator();
                        while (queryName.hasNext()) {
                            String linkName = (String)queryName.next();
                            MDXLevelInfo masterQueryLevelInfo = V5ParameterUtil.getPromptLevelInfoFromMasterDetailLink(parameter, linkName);
                            if (masterQueryLevelInfo == null || masterQueryLevelInfo.isEmpty()) {
                                levels.addAll(namedSet.getLevels());
                                continue;
                            }
                            if (!masterQueryLevelInfo.getHierarchyInfo().projectsHierarchy(namedSet.getHierarchy())) continue;
                            levels.addAll(masterQueryLevelInfo.getProjectedLevels(namedSet.getHierarchy()));
                        }
                        return levels;
                    }
                    levels.addAll(namedSet.getLevels());
                    return levels;
                }
                case NAMED_SET: {
                    levels.addAll(((INamedSet)metaData).getLevels());
                    return levels;
                }
                default: {
                    parameter.throwInternalError("The prompt node has invalid metadata.");
                    return levels;
                }
            }
        } else {
            IXQEQueryNode parent = parameter.getParent();
            if (parent.getType() == 201101) {
                parent = parent.getParent();
            }
            if (parent.isOfTypes(PARENT_EXPRESSION_TYPES)) {
                IXQEQueryNode[] siblings = parent.getChildren();
                IXQEQueryNode lhs = null;
                for (int i = 0; i < siblings.length; ++i) {
                    if (siblings[i] == parameter) continue;
                    lhs = siblings[i];
                    break;
                }
                MDXLevelInfo levelInfo = V5ParameterUtil.getPromptLevelInfoFromSibling(parameter, (XQEQueryNode)lhs, planEnv);
                return levelInfo.getProjectedLevels(levelInfo.getHierarchyInfo().getProjectedHierarchy(0));
            }
            parent.throwInternalError("Can not resolve metadata for prompt child of this node.");
        }
        return levels;
    }

    public static V5SimpleNode getAncestorInfoNode(V5BoundToMetadata node) {
        IXQEQueryNode ancestor = node.getParent();
        if (ancestor.getType() == 101004) {
            ancestor = ancestor.getParent();
        }
        if (ancestor.getType() == 101003) {
            ancestor = ancestor.getParent();
        }
        if (ancestor.getType() == 201101) {
            ancestor = ancestor.getParent();
        }
        if (ancestor.isOfCategory(201120)) {
            return (V5SimpleNode)ancestor;
        }
        return null;
    }

    public static MDXLevelInfo getPromptLevelInfoFromSibling(V5BoundToMetadata parameter, XQEQueryNode sibling, PlanningEnvironment environment) {
        IXQEQueryNode parent = parameter.getParent();
        int childIndex = parent.getPositionOfChild(sibling);
        sibling.detach();
        MDXLevelInfo level = null;
        if (sibling.isOfCategory(1001)) {
            level = ((AbstractMDXNode)sibling).getLevelInfo();
        } else if (sibling.isOfCategories(new int[]{201120, 101003})) {
            MDXLevelInfo contextLevel = new MDXLevelInfo();
            IHierarchy hierarchy = ((V5QueryNode)sibling).getHierarchyInfo().getProjectedHierarchy(0);
            contextLevel.addProjectedHierarchy(hierarchy.getDefaultMember().getLevel());
            ArrayList<V5SimpleNode> fncs = new ArrayList<V5SimpleNode>();
            level = ((V5QueryNode)sibling).getHierarchyLevelInfo(contextLevel, fncs);
        } else {
            sibling.throwInternalError("Unknown node type.");
        }
        parent.addChild(sibling, childIndex);
        return level;
    }

    public static MDXLevelInfo getPromptLevelInfoFromMasterDetailLink(V5BoundToMetadata parameter, String mdLinkName) {
        PlanningEnvironment environment = (PlanningEnvironment)parameter.getPlanningEnvironment();
        V5QuerySet querySet = (V5QuerySet)parameter.getAncestorOfType(101002);
        MasterDetailProvider mdProvider = ((RequestEnvironment)environment.getRequestEnvironment()).getMasterDetailProvider();
        MasterDetailLink link = mdProvider.getLink(mdLinkName);
        V5Query masterQuery = null;
        if (link != null) {
            masterQuery = querySet.getV5Query(link.getMasterQueryName());
            V5Query detailQuery = querySet.getV5Query(link.getDetailQueryName());
            if (masterQuery == null && detailQuery != null && detailQuery.isSingleQueryMasterDetail()) {
                masterQuery = querySet.getV5Query(link.getDetailQueryName());
            }
        }
        if (masterQuery == null) {
            return new MDXLevelInfo();
        }
        V5Selection masterSelection = masterQuery.getV5Selection();
        String masterRefDataItem = link.getMasterRefDataItem();
        V5DataItem linkItem = masterSelection.getDataItemByRefName(masterRefDataItem);
        MDXLevelInfo level = null;
        if (linkItem != null) {
            XQEQueryNode masterDataItem = (XQEQueryNode)linkItem.getChild(0);
            if (masterDataItem.isOfCategory(1001)) {
                level = ((AbstractMDXNode)masterDataItem).getLevelInfo();
            } else if (masterDataItem.isOfCategories(new int[]{201120, 101003})) {
                MDXLevelInfo contextLevel = new MDXLevelInfo();
                IXQEQueryNode[] parametersInMasterDataItem = masterDataItem.getDescendantsOfTypes(new int[]{201127, 201024}, true);
                boolean isSameParameter = false;
                for (IXQEQueryNode masterParameter : parametersInMasterDataItem) {
                    if (masterParameter != parameter) continue;
                    isSameParameter = true;
                    break;
                }
                if (isSameParameter || ((V5QueryNode)masterDataItem).getHierarchyInfo().getProjectedHierarchies().size() == 0) {
                    return contextLevel;
                }
                IHierarchy hierarchy = ((V5QueryNode)masterDataItem).getHierarchyInfo().getProjectedHierarchy(0);
                contextLevel.addProjectedHierarchy(hierarchy.getDefaultMember().getLevel());
                ArrayList<V5SimpleNode> fncs = new ArrayList<V5SimpleNode>();
                level = ((V5QueryNode)masterDataItem).getHierarchyLevelInfo(contextLevel, fncs);
            } else {
                masterDataItem.throwInternalError("Unknown node type in master data item.");
            }
        }
        if (level == null) {
            return new MDXLevelInfo();
        }
        return level;
    }

    public static void setV5ParameterProperties(V5Parameter v5Parameter) {
        PlanningEnvironment environment = (PlanningEnvironment)v5Parameter.getPlanningEnvironment();
        V5Query v5Query = v5Parameter.getV5Query();
        String queryName = v5Query.getRootQueryName();
        v5Parameter.setQueryName(queryName);
        v5Parameter.resolveModelIdentifier();
        v5Parameter.resolveValueExpression();
        MasterDetailProvider mdProvider = ((RequestEnvironment)environment.getRequestEnvironment()).getMasterDetailProvider();
        boolean isMasterDetailLinkParameter = mdProvider.isMasterDetailLinkParameter(v5Parameter.getParameterName().trim(), queryName);
        if (!isMasterDetailLinkParameter && mdProvider.isDetailQuery(queryName)) {
            isMasterDetailLinkParameter = mdProvider.isSameParameterInMasterQuery(v5Parameter.getParameterName().trim(), queryName);
        }
        v5Parameter.setIsMasterDetail(isMasterDetailLinkParameter);
    }

    public static List<IXQEQueryNode> getSiblings(V5BoundToMetadata node) {
        V5SimpleNode ancestor = V5ParameterUtil.getAncestorInfoNode(node);
        ArrayList<IXQEQueryNode> siblings = new ArrayList<IXQEQueryNode>();
        if (ancestor != null && ancestor.isOfTypes(V5Parameter.MODEL_IDENTIFIER_TYPES)) {
            int index = -1;
            if (ancestor.getType() == 201134) {
                if ((ancestor = (V5SimpleNode)ancestor.getParent()).getType() != 201011) {
                    return siblings;
                }
                index = 1;
            } else {
                index = ancestor.getSubtreeIndexForDescendant(node);
            }
            if (!ancestor.isOfCategory(201126)) {
                return siblings;
            }
            for (int ancestorIndex = 0; ancestorIndex < ancestor.getNumberChildren(); ++ancestorIndex) {
                IXQEQueryNode child;
                if (ancestorIndex == index || (child = ancestor.getChild(ancestorIndex)) == node) continue;
                siblings.add(V5Parameter.skipUnrelatedNodes(child));
            }
        }
        return siblings;
    }

    public static V5Parameter getSiblingV5ParameterOfModelIdentifier(V5BoundToMetadata mpi) {
        V5Parameter parameter = null;
        List<IXQEQueryNode> siblings = V5ParameterUtil.getSiblings(mpi);
        for (int i = 0; i < siblings.size() && parameter == null; ++i) {
            IXQEQueryNode sibling = siblings.get(i);
            if (sibling.getType() != 201024) continue;
            parameter = (V5Parameter)sibling;
        }
        return parameter;
    }
}

