/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.ast.v5Exp_new2.visitor;

import com.cognos.xqe.ast.IXQENodeFactory;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5.query.V5QueryItem;
import com.cognos.xqe.ast.v5Exp.V5BoundDataItemReference;
import com.cognos.xqe.ast.v5Exp.V5BoundMemberSetReference;
import com.cognos.xqe.ast.v5Exp.V5BoundModelIdentifier;
import com.cognos.xqe.ast.v5Exp.V5BoundQueryItemReference;
import com.cognos.xqe.ast.v5Exp.V5BoundSQLQueryItemReference;
import com.cognos.xqe.ast.v5Exp.V5CastTarget;
import com.cognos.xqe.ast.v5Exp.V5GenericFunction;
import com.cognos.xqe.ast.v5Exp.V5LiteralValue;
import com.cognos.xqe.ast.v5Exp.V5MemberUniqueName;
import com.cognos.xqe.ast.v5Exp.V5MultiPartIdentifier;
import com.cognos.xqe.ast.v5Exp.V5SimpleNode;
import com.cognos.xqe.ast.v5Exp.util.V5MunUtil;
import com.cognos.xqe.ast.v5Exp_new2.parser.ASTAddMemberToSetFunction;
import com.cognos.xqe.ast.v5Exp_new2.parser.ASTAggregateAtClause;
import com.cognos.xqe.ast.v5Exp_new2.parser.ASTAggregateBreakClause;
import com.cognos.xqe.ast.v5Exp_new2.parser.ASTAggregateTupleClause;
import com.cognos.xqe.ast.v5Exp_new2.parser.ASTAggregateWithinClause;
import com.cognos.xqe.ast.v5Exp_new2.parser.ASTAlias;
import com.cognos.xqe.ast.v5Exp_new2.parser.ASTBetweenExpression;
import com.cognos.xqe.ast.v5Exp_new2.parser.ASTBinarySetSummaryFunction;
import com.cognos.xqe.ast.v5Exp_new2.parser.ASTCaseExpression;
import com.cognos.xqe.ast.v5Exp_new2.parser.ASTCaseWhenClause;
import com.cognos.xqe.ast.v5Exp_new2.parser.ASTCastTarget;
import com.cognos.xqe.ast.v5Exp_new2.parser.ASTComparisonExpression;
import com.cognos.xqe.ast.v5Exp_new2.parser.ASTContainsExpression;
import com.cognos.xqe.ast.v5Exp_new2.parser.ASTCurrentMeasureFunction;
import com.cognos.xqe.ast.v5Exp_new2.parser.ASTDateLiteral;
import com.cognos.xqe.ast.v5Exp_new2.parser.ASTDescendantsFunction;
import com.cognos.xqe.ast.v5Exp_new2.parser.ASTDrilldownMemberFunction;
import com.cognos.xqe.ast.v5Exp_new2.parser.ASTEndsWithExpression;
import com.cognos.xqe.ast.v5Exp_new2.parser.ASTExtractFunction;
import com.cognos.xqe.ast.v5Exp_new2.parser.ASTFloatLiteral;
import com.cognos.xqe.ast.v5Exp_new2.parser.ASTFormatFunction;
import com.cognos.xqe.ast.v5Exp_new2.parser.ASTFunction;
import com.cognos.xqe.ast.v5Exp_new2.parser.ASTHierarchizeFunction;
import com.cognos.xqe.ast.v5Exp_new2.parser.ASTIfExpression;
import com.cognos.xqe.ast.v5Exp_new2.parser.ASTInExpression;
import com.cognos.xqe.ast.v5Exp_new2.parser.ASTInRangeExpression;
import com.cognos.xqe.ast.v5Exp_new2.parser.ASTIntegerLiteral;
import com.cognos.xqe.ast.v5Exp_new2.parser.ASTInternalHolder;
import com.cognos.xqe.ast.v5Exp_new2.parser.ASTIntervalLiteral;
import com.cognos.xqe.ast.v5Exp_new2.parser.ASTIsMissingExpression;
import com.cognos.xqe.ast.v5Exp_new2.parser.ASTIsNullExpression;
import com.cognos.xqe.ast.v5Exp_new2.parser.ASTJsonFunction;
import com.cognos.xqe.ast.v5Exp_new2.parser.ASTLikeExpression;
import com.cognos.xqe.ast.v5Exp_new2.parser.ASTLiteralNull;
import com.cognos.xqe.ast.v5Exp_new2.parser.ASTLiteralPrompt;
import com.cognos.xqe.ast.v5Exp_new2.parser.ASTLiteralRange;
import com.cognos.xqe.ast.v5Exp_new2.parser.ASTLiteralSpecial;
import com.cognos.xqe.ast.v5Exp_new2.parser.ASTLogicalExpression;
import com.cognos.xqe.ast.v5Exp_new2.parser.ASTLookupExpression;
import com.cognos.xqe.ast.v5Exp_new2.parser.ASTLookupMapElement;
import com.cognos.xqe.ast.v5Exp_new2.parser.ASTMemberAnalyticFunction;
import com.cognos.xqe.ast.v5Exp_new2.parser.ASTMemberParameter;
import com.cognos.xqe.ast.v5Exp_new2.parser.ASTMemberSummaryFunction;
import com.cognos.xqe.ast.v5Exp_new2.parser.ASTMemberUniqueName;
import com.cognos.xqe.ast.v5Exp_new2.parser.ASTMovingAndRunningSummaryFunction;
import com.cognos.xqe.ast.v5Exp_new2.parser.ASTMultiPartIdentifier;
import com.cognos.xqe.ast.v5Exp_new2.parser.ASTOLAPSetFunction;
import com.cognos.xqe.ast.v5Exp_new2.parser.ASTOption;
import com.cognos.xqe.ast.v5Exp_new2.parser.ASTOrderFunction;
import com.cognos.xqe.ast.v5Exp_new2.parser.ASTOrderedValueExpression;
import com.cognos.xqe.ast.v5Exp_new2.parser.ASTPassThrough;
import com.cognos.xqe.ast.v5Exp_new2.parser.ASTPeriodPredicate;
import com.cognos.xqe.ast.v5Exp_new2.parser.ASTPeriodValueConstructor;
import com.cognos.xqe.ast.v5Exp_new2.parser.ASTRowValueConstructor;
import com.cognos.xqe.ast.v5Exp_new2.parser.ASTStartsWithExpression;
import com.cognos.xqe.ast.v5Exp_new2.parser.ASTStringFunction;
import com.cognos.xqe.ast.v5Exp_new2.parser.ASTStringLiteral;
import com.cognos.xqe.ast.v5Exp_new2.parser.ASTTimeLiteral;
import com.cognos.xqe.ast.v5Exp_new2.parser.ASTTimeWithTZLiteral;
import com.cognos.xqe.ast.v5Exp_new2.parser.ASTTimestampLiteral;
import com.cognos.xqe.ast.v5Exp_new2.parser.ASTTimestampWithTZLiteral;
import com.cognos.xqe.ast.v5Exp_new2.parser.ASTTrimFunction;
import com.cognos.xqe.ast.v5Exp_new2.parser.ASTValueAnalyticFunction;
import com.cognos.xqe.ast.v5Exp_new2.parser.ASTValueExpression;
import com.cognos.xqe.ast.v5Exp_new2.parser.ASTValueSummaryFunction;
import com.cognos.xqe.ast.v5Exp_new2.parser.ASTVariableArgumentList;
import com.cognos.xqe.ast.v5Exp_new2.parser.ASTXmlFunction;
import com.cognos.xqe.ast.v5Exp_new2.parser.SimpleNode;
import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.types.DecimalType;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.types.IntervalType;
import com.cognos.xqe.data.types.NumericType;
import com.cognos.xqe.data.types.VarcharType;
import com.cognos.xqe.data.values.BigDecimalValue;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.transformation.v5.BindV5RoleValue;
import com.cognos.xqe.util.fds.FDSDataTypeEnum;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class V5ExpressionParserVisitor
implements com.cognos.xqe.ast.v5Exp_new2.parser.V5ExpressionParserVisitor {
    private static final int THREE = 3;
    private static final int FOUR = 4;
    private static final String DAY = "day";
    private static final String SECOND = "second";
    private static final String VISIT_METHOD = "V5ExpressionParserVisitor.visit()";
    private IXQENodeFactory nodeFactory;
    private boolean doBinding;
    private static HashMap<String, V5FunctionInfo> functionMap = new HashMap(100001);

    public V5ExpressionParserVisitor(IXQENodeFactory factory, boolean bindingDone) {
        this.nodeFactory = factory;
        this.doBinding = bindingDone;
    }

    @Override
    public Object visit(ASTLiteralNull node, Object data) {
        return this.createNode(201023, node, data);
    }

    @Override
    public Object visit(ASTLiteralPrompt node, Object data) {
        return this.createNode(201024, node, data);
    }

    @Override
    public Object visit(ASTLiteralRange node, Object data) {
        return this.createNode(201022, node, data);
    }

    @Override
    public Object visit(ASTLiteralSpecial node, Object data) {
        return this.createNode(201025, node, data);
    }

    @Override
    public Object visit(ASTMultiPartIdentifier node, Object data) {
        V5SimpleNode newNode = null;
        switch (node.getStatus()) {
            case BIND_FAILED: {
                newNode = this.createV5MultiPartIdentifier(node, data);
                ((V5MultiPartIdentifier)newNode).setBindToModelFailed();
                break;
            }
            case UNBOUND: {
                newNode = this.createV5MultiPartIdentifier(node, data);
                break;
            }
            case BOUND_DATA_ITEM: {
                newNode = this.createV5BoundDataItemReference(node, data);
                break;
            }
            case BOUND_MEMBER_SET: {
                newNode = this.createV5BoundMemberSetReference(node, data);
                break;
            }
            case BOUND_MODEL_OBJECT: {
                newNode = this.createV5BoundModelIdentifier(node, data);
                break;
            }
            case BOUND_QUERY_ITEM: {
                newNode = this.createV5BoundQueryItemReference(node, data);
                break;
            }
            case BOUND_SQL_QUERY_ITEM: {
                newNode = this.createV5BoundSQLQueryItemReference(node, data);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        this.cloneNameParts(newNode, node);
        return newNode;
    }

    private void cloneNameParts(IXQEQueryNode xqeNode, ASTMultiPartIdentifier parserNode) {
        String[] nameParts = parserNode.getNameParts();
        if (nameParts != null && nameParts.length > 0) {
            String[] clonedNameParts = new String[nameParts.length];
            System.arraycopy(nameParts, 0, clonedNameParts, 0, nameParts.length);
            xqeNode.setPropertyValue("nameParts", clonedNameParts);
        }
    }

    V5MultiPartIdentifier createV5MultiPartIdentifier(ASTMultiPartIdentifier node, Object data) {
        V5MultiPartIdentifier newNode = (V5MultiPartIdentifier)this.createNode(201030, node, data);
        newNode.setNameParts(node.getNameParts());
        newNode.setIdentifier(node.getNativeName());
        newNode.removeProperty("status");
        return newNode;
    }

    V5BoundDataItemReference createV5BoundDataItemReference(ASTMultiPartIdentifier node, Object data) {
        V5BoundDataItemReference newNode = (V5BoundDataItemReference)this.createNode(201060, node, data);
        newNode.setIdentifier(node.getNativeName());
        newNode.setRefDataItem((V5DataItem)node.getPropertyValue("refDataItem"));
        Boolean isQueryRefItem = (Boolean)node.getPropertyValue("isQueryRefItem");
        if (isQueryRefItem != null) {
            newNode.setIsQueryRefItem();
        }
        return newNode;
    }

    V5BoundMemberSetReference createV5BoundMemberSetReference(ASTMultiPartIdentifier node, Object data) {
        V5BoundMemberSetReference newNode = (V5BoundMemberSetReference)this.createNode(201138, node, data);
        newNode.setIdentifier(node.getNativeName());
        newNode.setRefDataItems((ArrayList)node.getPropertyValue("refDataItemsToValueSets"));
        return newNode;
    }

    V5BoundModelIdentifier createV5BoundModelIdentifier(ASTMultiPartIdentifier node, Object data) {
        IMetadata metadata = (IMetadata)node.getPropertyValue("metadata");
        V5BoundModelIdentifier newNode = (V5BoundModelIdentifier)this.createNode(201116, node, data);
        newNode.setIdentifier(node.getNativeName());
        newNode.setMetadata(metadata);
        if (node.getPropertyValue("v5QueryIdentifier") != null) {
            newNode.setPropertyValue("v5QueryIdentifier", Boolean.TRUE);
        }
        return newNode;
    }

    V5BoundQueryItemReference createV5BoundQueryItemReference(ASTMultiPartIdentifier node, Object data) {
        V5BoundQueryItemReference newNode = (V5BoundQueryItemReference)this.createNode(201097, node, data);
        newNode.setIdentifier(node.getNativeName());
        newNode.setRefQueryItem((V5QueryItem)node.getPropertyValue("refQueryItem"));
        newNode.setRefDataItem((V5DataItem)node.getPropertyValue("refDataItem"));
        return newNode;
    }

    V5BoundSQLQueryItemReference createV5BoundSQLQueryItemReference(ASTMultiPartIdentifier node, Object data) {
        V5BoundSQLQueryItemReference newNode = (V5BoundSQLQueryItemReference)this.createNode(201103, node, data);
        newNode.setIdentifier(node.getNativeName());
        return newNode;
    }

    @Override
    public Object visit(ASTMemberParameter node, Object data) {
        return this.createNode(201027, node, data);
    }

    @Override
    public Object visit(ASTMemberUniqueName node, Object data) {
        V5MemberUniqueName newNode = (V5MemberUniqueName)this.createNode(201028, node, data);
        if (node.getStatus() == ASTMemberUniqueName.MUNStatusEnum.MODEL_BIND_FAILED) {
            V5MunUtil.setPropertyMUNBinding(newNode, false);
        } else if (node.getStatus() == ASTMemberUniqueName.MUNStatusEnum.MODEL_BOUND) {
            newNode.setMetadata((IMetadata)node.getPropertyValue("metadata"));
        }
        newNode.removeProperty("status");
        return newNode;
    }

    @Override
    public Object visit(ASTLogicalExpression node, Object data) {
        return this.createNode(201003, node, data);
    }

    @Override
    public Object visit(ASTLikeExpression node, Object data) {
        return this.createNode(201004, node, data);
    }

    @Override
    public Object visit(ASTContainsExpression node, Object data) {
        return this.createNode(201005, node, data);
    }

    @Override
    public Object visit(ASTStartsWithExpression node, Object data) {
        return this.createNode(201006, node, data);
    }

    @Override
    public Object visit(ASTEndsWithExpression node, Object data) {
        return this.createNode(201007, node, data);
    }

    @Override
    public Object visit(ASTBetweenExpression node, Object data) {
        return this.createNode(201008, node, data);
    }

    @Override
    public Object visit(ASTIsMissingExpression node, Object data) {
        return this.createNode(201009, node, data);
    }

    @Override
    public Object visit(ASTIsNullExpression node, Object data) {
        return this.createNode(201010, node, data);
    }

    @Override
    public Object visit(ASTInExpression node, Object data) {
        return this.createNode(201011, node, data);
    }

    @Override
    public Object visit(ASTInRangeExpression node, Object data) {
        return this.createNode(201012, node, data);
    }

    @Override
    public Object visit(ASTComparisonExpression node, Object data) {
        return this.createNode(201013, node, data);
    }

    @Override
    public Object visit(ASTValueExpression node, Object data) {
        return this.createNode(201014, node, data);
    }

    @Override
    public Object visit(ASTPassThrough node, Object data) {
        return this.createNode(201015, node, data);
    }

    @Override
    public Object visit(ASTCaseExpression node, Object data) {
        return this.createNode(201018, node, data);
    }

    @Override
    public Object visit(ASTCaseWhenClause node, Object data) {
        return this.createNode(201019, node, data);
    }

    @Override
    public Object visit(ASTIfExpression node, Object data) {
        return this.createNode(201017, node, data);
    }

    @Override
    public Object visit(ASTLookupExpression node, Object data) {
        return this.createNode(201020, node, data);
    }

    @Override
    public Object visit(ASTLookupMapElement node, Object data) {
        return this.createNode(201021, node, data);
    }

    @Override
    public Object visit(ASTMemberSummaryFunction node, Object data) {
        return this.createNode(201032, node, data);
    }

    @Override
    public Object visit(ASTBinarySetSummaryFunction node, Object data) {
        return this.createNode(201031, node, data);
    }

    @Override
    public Object visit(ASTValueSummaryFunction node, Object data) {
        return this.createNode(201031, node, data);
    }

    @Override
    public Object visit(ASTMovingAndRunningSummaryFunction node, Object data) {
        return this.createNode(201035, node, data);
    }

    @Override
    public Object visit(ASTMemberAnalyticFunction node, Object data) {
        return this.createNode(201034, node, data);
    }

    @Override
    public Object visit(ASTValueAnalyticFunction node, Object data) {
        return this.createNode(201033, node, data);
    }

    @Override
    public Object visit(ASTOrderedValueExpression node, Object data) {
        return this.createNode(201114, node, data);
    }

    @Override
    public Object visit(ASTAggregateTupleClause node, Object data) {
        return this.createNode(201038, node, data);
    }

    @Override
    public Object visit(ASTAggregateWithinClause node, Object data) {
        return this.createNode(201039, node, data);
    }

    @Override
    public Object visit(ASTAggregateAtClause node, Object data) {
        return this.createNode(201036, node, data);
    }

    @Override
    public Object visit(ASTAggregateBreakClause node, Object data) {
        return this.createNode(201037, node, data);
    }

    @Override
    public Object visit(ASTFunction node, Object data) {
        V5SimpleNode newNode = this.createFunctionNode(node, data);
        if (this.doBinding && newNode.getType() == 201098) {
            BindV5RoleValue.bind(newNode);
            return newNode;
        }
        if (newNode.getSubType() != -1 && newNode.getType() == 201042) {
            V5GenericFunction generic = (V5GenericFunction)newNode;
            FDSDataTypeEnum dataType = node.getFDSDataType();
            if (dataType != null) {
                generic.setDataType(V5GenericFunction.getDataType(dataType));
            }
            switch (generic.getSubType()) {
                case 1: {
                    generic.setName("AddSeconds");
                    break;
                }
                case 2: {
                    generic.setName("AddMinutes");
                    break;
                }
                case 3: {
                    generic.setName("AddHours");
                    break;
                }
                case 4: {
                    generic.setName("AddDays");
                    break;
                }
                case 5: {
                    generic.setName("AddMonths");
                    break;
                }
                case 6: {
                    generic.setName("AddYears");
                    break;
                }
                case 7: {
                    generic.setName("SecondsBetween");
                    break;
                }
                case 8: {
                    generic.setName("MinutesBetween");
                    break;
                }
                case 9: {
                    generic.setName("HoursBetween");
                    break;
                }
                case 10: {
                    generic.setName("Age");
                    break;
                }
                case 22: {
                    generic.setName("Ascii");
                    break;
                }
                case 11: {
                    generic.setName("DayOfWeek");
                    break;
                }
                case 12: {
                    generic.setName("DayOfYear");
                    break;
                }
                case 13: {
                    generic.setName("DaysBetween");
                    break;
                }
                case 14: {
                    generic.setName("DaysToEndOfMonth");
                    break;
                }
                case 15: {
                    generic.setName("FirstOfMonth");
                    break;
                }
                case 16: {
                    generic.setName("LastOfMonth");
                    break;
                }
                case 17: {
                    generic.setName("MakeTimestamp");
                    break;
                }
                case 18: {
                    generic.setName("MonthsBetween");
                    break;
                }
                case 19: {
                    generic.setName("WeekOfYear");
                    break;
                }
                case 20: {
                    generic.setName("YearsBetween");
                    break;
                }
                case 21: {
                    generic.setName("YMDIntBetween");
                    break;
                }
                case 23: {
                    generic.setName("ShiftTimeZone");
                    break;
                }
            }
        }
        return newNode;
    }

    @Override
    public Object visit(ASTXmlFunction node, Object data) {
        return this.createNode(201133, node, data);
    }

    @Override
    public Object visit(ASTJsonFunction node, Object data) {
        return this.createNode(201142, node, data);
    }

    @Override
    public Object visit(ASTStringFunction node, Object data) {
        return this.createNode(201041, node, data);
    }

    @Override
    public Object visit(ASTAddMemberToSetFunction node, Object data) {
        return this.createNode(201119, node, data);
    }

    @Override
    public Object visit(ASTCastTarget node, Object data) {
        V5CastTarget n = (V5CastTarget)this.createNode(201052, node, data);
        byte cclDType = node.getDataType();
        IDataType dType = null;
        switch (cclDType) {
            case 45: {
                int length = node.getLength();
                dType = DataTypeFactory.getCharType(length);
                break;
            }
            case 1: {
                int length = node.getLength();
                dType = DataTypeFactory.getVarcharType(length);
                break;
            }
            case 12: 
            case 54: {
                int precision = node.getPrecision();
                int scale = node.getScale();
                dType = DataTypeFactory.getDecimalType(precision, scale);
                break;
            }
            case 60: {
                int leadingPrecision = (Integer)node.getPropertyValue("leadingPrecision");
                int fSecondsPrecision = (Integer)node.getPropertyValue("fSecondsPrecision");
                String fromQualifier = ((String)node.getPropertyValue("fromQualifier")).toLowerCase();
                String toQualifier = (String)node.getPropertyValue("toQualifier");
                if (toQualifier != null) {
                    toQualifier = toQualifier.toLowerCase();
                }
                dType = DataTypeFactory.getIntervalType(fromQualifier, toQualifier, leadingPrecision, fSecondsPrecision);
                break;
            }
            case 56: {
                int length = node.getLength();
                dType = DataTypeFactory.getNVarcharType(length);
                break;
            }
            case 55: {
                int length = node.getLength();
                dType = DataTypeFactory.getNCharType(length);
                break;
            }
            default: {
                dType = DataTypeFactory.getDataType(cclDType);
            }
        }
        n.setDataType(dType);
        return n;
    }

    @Override
    public Object visit(ASTCurrentMeasureFunction node, Object data) {
        return this.createNode(201058, node, data);
    }

    @Override
    public Object visit(ASTDescendantsFunction node, Object data) {
        return this.createNode(201062, node, data);
    }

    @Override
    public Object visit(ASTExtractFunction node, Object data) {
        return this.createNode(201065, node, data);
    }

    @Override
    public Object visit(ASTFormatFunction node, Object data) {
        return this.createNode(201069, node, data);
    }

    @Override
    public Object visit(ASTOrderFunction node, Object data) {
        return this.createNode(201091, node, data);
    }

    @Override
    public Object visit(ASTTrimFunction node, Object data) {
        return this.createNode(201109, node, data);
    }

    @Override
    public Object visit(ASTIntegerLiteral node, Object data) {
        NumericType dType = null;
        String integerLiteral = node.getValue();
        try {
            long iValue = Long.parseLong(integerLiteral);
            dType = iValue <= 32767L ? DataTypeFactory.getSmallintType() : (iValue <= Integer.MAX_VALUE ? DataTypeFactory.getIntegerType() : DataTypeFactory.getLongType());
        }
        catch (NumberFormatException e) {
            dType = null != integerLiteral && integerLiteral.length() <= 256 ? DataTypeFactory.getDecimalType(integerLiteral.length(), 0) : DataTypeFactory.getDoubleType();
        }
        return this.createLiteralNode(node, data, integerLiteral, dType);
    }

    @Override
    public Object visit(ASTFloatLiteral node, Object data) {
        NumericType type = null;
        String fixedPointLiteral = node.getValue();
        if (null != fixedPointLiteral && fixedPointLiteral.lastIndexOf(69) == -1 && fixedPointLiteral.lastIndexOf(101) == -1) {
            int precision = fixedPointLiteral.length();
            int scale = fixedPointLiteral.indexOf(46);
            if (scale != -1) {
                scale = --precision - scale;
            }
            type = precision <= 256 ? DataTypeFactory.getDecimalType(precision, scale) : DataTypeFactory.getDoubleType();
        } else {
            type = DataTypeFactory.getDoubleType();
        }
        return this.createLiteralNode(node, data, fixedPointLiteral, type);
    }

    @Override
    public Object visit(ASTStringLiteral node, Object data) {
        String sValue = node.getValue();
        VarcharType dType = DataTypeFactory.getVarcharType(sValue.length());
        return this.createLiteralNode(node, data, sValue, dType);
    }

    @Override
    public Object visit(ASTDateLiteral node, Object data) {
        return this.createLiteralNode(node, data, node.getValue(), DataTypeFactory.getDateType());
    }

    @Override
    public Object visit(ASTTimeLiteral node, Object data) {
        return this.createLiteralNode(node, data, node.getValue(), DataTypeFactory.getTimeType());
    }

    @Override
    public Object visit(ASTTimestampLiteral node, Object data) {
        return this.createLiteralNode(node, data, node.getValue(), DataTypeFactory.getTimestampType());
    }

    @Override
    public Object visit(ASTTimeWithTZLiteral node, Object data) {
        return this.createLiteralNode(node, data, node.getValue(), DataTypeFactory.getTimeWithTZType());
    }

    @Override
    public Object visit(ASTTimestampWithTZLiteral node, Object data) {
        return this.createLiteralNode(node, data, node.getValue(), DataTypeFactory.getTimestampWithTZType());
    }

    @Override
    public Object visit(ASTIntervalLiteral node, Object data) {
        String value = node.getValue();
        int idx = value.lastIndexOf(32);
        String startField = value.substring(idx + 1, value.length());
        String endField = (String)node.removePropertyValue("endField");
        if (endField == null && 0 < startField.lastIndexOf(58)) {
            startField = DAY;
            endField = SECOND;
            idx = value.length();
        }
        IntervalType dType = DataTypeFactory.getIntervalType(startField, endField, -1, -1);
        return this.createLiteralNode(node, data, value.substring(0, idx), dType);
    }

    @Override
    public Object visit(ASTVariableArgumentList node, Object data) {
        return this.createNode(201135, node, data);
    }

    @Override
    public Object visit(ASTAlias node, Object data) {
        return this.createNode(201136, node, data);
    }

    @Override
    public Object visit(ASTOption node, Object data) {
        return this.createNode(201137, node, data);
    }

    @Override
    public Object visit(ASTOLAPSetFunction node, Object data) {
        return this.createFunctionNode(node, data);
    }

    @Override
    public Object visit(SimpleNode node, Object data) {
        throw new XQERuntimeException(XQEMessageKeys.GEN_MethodNotImplemented_INTERNAL, VISIT_METHOD);
    }

    @Override
    public Object visit(ASTInternalHolder node, Object data) {
        throw new XQERuntimeException(XQEMessageKeys.GEN_MethodNotImplemented_INTERNAL, VISIT_METHOD);
    }

    @Override
    public Object visit(ASTRowValueConstructor node, Object data) {
        return this.createNode(201141, node, data);
    }

    @Override
    public Object visit(ASTPeriodValueConstructor node, Object data) {
        return this.createNode(201143, node, data);
    }

    @Override
    public Object visit(ASTPeriodPredicate node, Object data) {
        return this.createNode(201144, node, data);
    }

    private Object createNode(int type, SimpleNode node, Object data) {
        V5SimpleNode n = (V5SimpleNode)this.nodeFactory.createNode(type);
        Set<Map.Entry<String, Object>> properties = node.getProperties().entrySet();
        for (Map.Entry<String, Object> entry : properties) {
            n.setPropertyValue(entry.getKey(), entry.getValue());
        }
        int subType = node.getSubType();
        if (subType >= 0) {
            n.setSubType(subType);
        }
        if (data != null) {
            ((IXQEQueryNode)data).addChild(n);
        }
        node.childrenAccept(this, n);
        return n;
    }

    private Object createLiteralNode(SimpleNode node, Object data, String sValue, IDataType dType) {
        V5LiteralValue n = (V5LiteralValue)this.createNode(201026, node, data);
        n.setDataType(dType);
        Value value = (Value)dType.createValue();
        value.set(sValue);
        if (dType.getTypeName().equals("double") && Double.isInfinite(value.getDouble())) {
            DecimalType type = new DecimalType(Integer.MAX_VALUE, 2);
            value = DataValueFactory.createDecimalValue(type);
            ((BigDecimalValue)value).set(new BigDecimal(sValue));
        }
        n.setPropertyValue("value", value);
        return n;
    }

    private V5SimpleNode createFunctionNode(ASTFunction node, Object data) {
        int type = 201042;
        int subType = 0;
        V5FunctionInfo functionInfo = functionMap.get(node.getNativeName().toLowerCase());
        if (functionInfo != null && node.jjtGetNumChildren() >= functionInfo.getMinimumParameters() && (functionInfo.getMaximumParameters() == -1 || node.jjtGetNumChildren() <= functionInfo.getMaximumParameters())) {
            type = functionInfo.getType();
            subType = functionInfo.getSubType();
        }
        V5SimpleNode n = (V5SimpleNode)this.createNode(type, node, data);
        if (subType != -1) {
            n.setSubType(subType);
        }
        return n;
    }

    @Override
    public Object visit(ASTHierarchizeFunction node, Object data) {
        return this.createFunctionNode(node, data);
    }

    @Override
    public Object visit(ASTDrilldownMemberFunction node, Object data) {
        return this.createFunctionNode(node, data);
    }

    static {
        functionMap.put("_add_seconds", new V5FunctionInfo(2, 201042, 1));
        functionMap.put("_add_minutes", new V5FunctionInfo(2, 201042, 2));
        functionMap.put("_add_hours", new V5FunctionInfo(2, 201042, 3));
        functionMap.put("_add_days", new V5FunctionInfo(2, 201042, 4));
        functionMap.put("_add_months", new V5FunctionInfo(2, 201042, 5));
        functionMap.put("_add_years", new V5FunctionInfo(2, 201042, 6));
        functionMap.put("_seconds_between", new V5FunctionInfo(2, 201042, 7));
        functionMap.put("_minutes_between", new V5FunctionInfo(2, 201042, 8));
        functionMap.put("_hours_between", new V5FunctionInfo(2, 201042, 9));
        functionMap.put("_age", new V5FunctionInfo(1, 201042, 10));
        functionMap.put("_day_of_week", new V5FunctionInfo(2, 201042, 11));
        functionMap.put("_day_of_year", new V5FunctionInfo(1, 201042, 12));
        functionMap.put("_days_between", new V5FunctionInfo(2, 201042, 13));
        functionMap.put("_days_to_end_of_month", new V5FunctionInfo(1, 201042, 14));
        functionMap.put("_first_of_month", new V5FunctionInfo(1, 201042, 15));
        functionMap.put("_last_of_month", new V5FunctionInfo(1, 201042, 16));
        functionMap.put("_make_timestamp", new V5FunctionInfo(3, 201042, 17));
        functionMap.put("_months_between", new V5FunctionInfo(2, 201042, 18));
        functionMap.put("_week_of_year", new V5FunctionInfo(1, 201042, 19));
        functionMap.put("_years_between", new V5FunctionInfo(2, 201042, 20));
        functionMap.put("_ymdint_between", new V5FunctionInfo(2, 201042, 21));
        functionMap.put("ascii", new V5FunctionInfo(1, 201042, 22));
        functionMap.put("_shift_timezone", new V5FunctionInfo(2, 3, 201042, 23));
        functionMap.put("_round", new V5FunctionInfo(1, 2, 201040, 8));
        functionMap.put("abs", new V5FunctionInfo(1, 201040, 0));
        functionMap.put("arccos", new V5FunctionInfo(1, 201040, 11));
        functionMap.put("arcsin", new V5FunctionInfo(1, 201040, 12));
        functionMap.put("arctan", new V5FunctionInfo(1, 201040, 10));
        functionMap.put("ceil", new V5FunctionInfo(1, 201040, 1));
        functionMap.put("ceiling", new V5FunctionInfo(1, 201040, 2));
        functionMap.put("cos", new V5FunctionInfo(1, 201040, 17));
        functionMap.put("coshyp", new V5FunctionInfo(1, 201040, 14));
        functionMap.put("exp", new V5FunctionInfo(1, 201040, 3));
        functionMap.put("floor", new V5FunctionInfo(1, 201040, 4));
        functionMap.put("ln", new V5FunctionInfo(1, 201040, 5));
        functionMap.put("log10", new V5FunctionInfo(1, 201040, 19));
        functionMap.put("mod", new V5FunctionInfo(2, 201040, 6));
        functionMap.put("power", new V5FunctionInfo(2, 201040, 7));
        functionMap.put("random", new V5FunctionInfo(0, 1, 201040, 21));
        functionMap.put("round", new V5FunctionInfo(1, 2, 201040, 8));
        functionMap.put("sin", new V5FunctionInfo(1, 201040, 18));
        functionMap.put("sinhyp", new V5FunctionInfo(1, 201040, 15));
        functionMap.put("sqrt", new V5FunctionInfo(1, 201040, 9));
        functionMap.put("tan", new V5FunctionInfo(1, 201040, 16));
        functionMap.put("tanhyp", new V5FunctionInfo(1, 201040, 13));
        functionMap.put("width-bucket", new V5FunctionInfo(4, 201040, 20));
        functionMap.put("char_length", new V5FunctionInfo(1, 201041, 5));
        functionMap.put("character_length", new V5FunctionInfo(1, 201041, 5));
        functionMap.put("index", new V5FunctionInfo(2, 201041, 4));
        functionMap.put("lower", new V5FunctionInfo(1, 201041, 1));
        functionMap.put("octet_length", new V5FunctionInfo(1, 201041, 6));
        functionMap.put("position", new V5FunctionInfo(2, 201041, 3));
        functionMap.put("reverse", new V5FunctionInfo(1, 201041, 7));
        functionMap.put("substring", new V5FunctionInfo(2, 3, 201041, 2));
        functionMap.put("upper", new V5FunctionInfo(1, 201041, 0));
        functionMap.put("_firstfromset", new V5FunctionInfo(3, 201043));
        functionMap.put("_nullmember", new V5FunctionInfo(1, 201146));
        functionMap.put("_rangeset", new V5FunctionInfo(2, 201134));
        functionMap.put("_remainderset", new V5FunctionInfo(3, 201044));
        functionMap.put("ancestor", new V5FunctionInfo(2, 201045));
        functionMap.put("ancestors", new V5FunctionInfo(2, 201046));
        functionMap.put("bottomcount", new V5FunctionInfo(3, 201047));
        functionMap.put("bottompercent", new V5FunctionInfo(3, 201048));
        functionMap.put("bottomsum", new V5FunctionInfo(3, 201049));
        functionMap.put("caption", new V5FunctionInfo(1, 201050));
        functionMap.put("cast", new V5FunctionInfo(2, 201051));
        functionMap.put("children", new V5FunctionInfo(1, 201053));
        functionMap.put("closingperiod", new V5FunctionInfo(1, 2, 201054, -1));
        functionMap.put("coalesce", new V5FunctionInfo(1, -1, 201055, -1));
        functionMap.put("completetuple", new V5FunctionInfo(1, -1, 201056, -1));
        functionMap.put("cousin", new V5FunctionInfo(2, 201057));
        functionMap.put("currentmember", new V5FunctionInfo(1, 201059));
        functionMap.put("defaultmember", new V5FunctionInfo(1, 201061));
        functionMap.put("drilldownmember", new V5FunctionInfo(2, 201149));
        functionMap.put("emptyset", new V5FunctionInfo(1, 201063));
        functionMap.put("except", new V5FunctionInfo(2, 201064));
        functionMap.put("filter", new V5FunctionInfo(2, 201066));
        functionMap.put("firstchild", new V5FunctionInfo(1, 201067));
        functionMap.put("firstsibling", new V5FunctionInfo(1, 201068));
        functionMap.put("generate", new V5FunctionInfo(2, 201070));
        functionMap.put("head", new V5FunctionInfo(1, 2, 201071, -1));
        functionMap.put("hierarchize", new V5FunctionInfo(1, 201072));
        functionMap.put("hierarchy", new V5FunctionInfo(1, 201073));
        functionMap.put("intersect", new V5FunctionInfo(2, 201074));
        functionMap.put("isempty", new V5FunctionInfo(1, 201075));
        functionMap.put("item", new V5FunctionInfo(2, 201076));
        functionMap.put("lag", new V5FunctionInfo(2, 201077));
        functionMap.put("lastchild", new V5FunctionInfo(1, 201078));
        functionMap.put("lastperiods", new V5FunctionInfo(2, 201079));
        functionMap.put("lastsibling", new V5FunctionInfo(1, 201080));
        functionMap.put("lead", new V5FunctionInfo(2, 201081));
        functionMap.put("level", new V5FunctionInfo(1, 201082));
        functionMap.put("levels", new V5FunctionInfo(2, 201083));
        functionMap.put("linkmember", new V5FunctionInfo(2, 201132));
        functionMap.put("member", new V5FunctionInfo(1, 4, 201085, -1));
        functionMap.put("members", new V5FunctionInfo(1, 201086));
        functionMap.put("mtd", new V5FunctionInfo(1, 201131));
        functionMap.put("nestedset", new V5FunctionInfo(2, 201087));
        functionMap.put("nextmember", new V5FunctionInfo(1, 201088));
        functionMap.put("nullif", new V5FunctionInfo(2, 201089));
        functionMap.put("openingperiod", new V5FunctionInfo(1, 2, 201090, -1));
        functionMap.put("ordinal", new V5FunctionInfo(1, 201092));
        functionMap.put("parallelperiod", new V5FunctionInfo(1, 3, 201093, -1));
        functionMap.put("parent", new V5FunctionInfo(1, 201094));
        functionMap.put("periodstodate", new V5FunctionInfo(2, 201095));
        functionMap.put("prevmember", new V5FunctionInfo(1, 201096));
        functionMap.put("qtd", new V5FunctionInfo(1, 201130));
        functionMap.put("rolevalue", new V5FunctionInfo(1, 2, 201098, -1));
        functionMap.put("rootmember", new V5FunctionInfo(1, 201099));
        functionMap.put("rootmembers", new V5FunctionInfo(1, 201100));
        functionMap.put("set", new V5FunctionInfo(1, -1, 201101, -1));
        functionMap.put("siblings", new V5FunctionInfo(1, 201102));
        functionMap.put("ascendants", new V5FunctionInfo(1, 201148));
        functionMap.put("subset", new V5FunctionInfo(2, 3, 201104, -1));
        functionMap.put("tail", new V5FunctionInfo(1, 2, 201105, -1));
        functionMap.put("topcount", new V5FunctionInfo(3, 201106));
        functionMap.put("toppercent", new V5FunctionInfo(3, 201107));
        functionMap.put("topsum", new V5FunctionInfo(3, 201108));
        functionMap.put("tuple", new V5FunctionInfo(1, -1, 201110, -1));
        functionMap.put("union", new V5FunctionInfo(2, 201111));
        functionMap.put("unique", new V5FunctionInfo(1, 201112));
        functionMap.put("value", new V5FunctionInfo(1, 201113));
        functionMap.put("wtd", new V5FunctionInfo(1, 201129));
        functionMap.put("ytd", new V5FunctionInfo(1, 201128));
    }

    static class V5FunctionInfo {
        private int minParameters;
        private int maxParameters;
        private int type = -1;
        private int subType = -1;

        V5FunctionInfo(int theNumberOfParameters, int theType) {
            this(theNumberOfParameters, theType, -1);
        }

        V5FunctionInfo(int theNumberOfParameters, int theType, int theSubType) {
            this(theNumberOfParameters, theNumberOfParameters, theType, theSubType);
        }

        V5FunctionInfo(int theMinParameters, int theMaxParameters, int theType, int theSubType) {
            this.minParameters = theMinParameters;
            this.maxParameters = theMaxParameters;
            this.type = theType;
            this.subType = theSubType;
        }

        public int getMinimumParameters() {
            return this.minParameters;
        }

        public int getMaximumParameters() {
            return this.maxParameters;
        }

        public int getType() {
            return this.type;
        }

        public int getSubType() {
            return this.subType;
        }
    }
}

