/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.bibushandler;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.bibushandler.CancelableRequestRegistry;
import com.cognos.xqe.bibushandler.IRequestEnvironment;
import com.cognos.xqe.bibushandler.XQEEnvironment;
import com.cognos.xqe.bibushandler.content.ICMSessionIdentity;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.query.engine.IEnvironmentFactory;
import com.cognos.xqe.query.engine.IExecutionEnvironment;
import com.cognos.xqe.query.engine.ResponseMessage;
import com.cognos.xqe.query.engine.ResponseMessageFolder;
import com.cognos.xqe.query.parameters.Parameters;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.trace.config.LoggingOverrides;
import com.cognos.xqe.util.IQueryReuseManager;
import com.cognos.xqe.util.LocaleConverter;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.dom4j.Element;

public abstract class BaseRequestEnvironment<E extends IExecutionEnvironment>
extends XQEEnvironment
implements IRequestEnvironment {
    public static final String UNKNOWN = "unknown";
    public static final String REPORT_ELEMENT_NAME = "report";
    public static final String REPORT_NAME_ATTRIBUTE_NAME = "reportName";
    public static final String REPORT_PATH_ELEMENT_NAME = "reportPath";
    public static final String DEFAULT_LOCALE = "en-us";
    protected final CancelableRequestRegistry mCancelableRequestRegistry;
    protected E mExecutionEnvironment = null;
    protected Locale runLocale;
    protected String runLocaleStr;
    protected Locale productLocale;
    protected Locale expressionLocale;
    protected Writer curTraceWriter;
    protected String queryContextID = null;
    protected String sessionContextID = null;
    protected String biBusSessionID = "";
    protected String requestID;
    protected String subRequestID;
    protected boolean internalQuery = true;
    protected String sqlFilePath;
    protected String datasetPath;
    protected String camPassport;
    protected Element camPassportElement;
    protected Element biBusHeaderElement;
    protected String camCapabilityPassport;
    protected String camUserPassport;
    protected String reportName;
    protected String reportPath;
    protected String operationName;
    protected int dqaLoggingPreference = 0;
    protected boolean resolveConnection = false;
    protected String modelPath;
    protected boolean includeEmptyCells;
    protected ResponseMessageFolder responseMessageFolder = null;
    protected String sapLogonTicket;
    protected String replanQuery = null;
    protected IXQEQueryNode preplanQuery = null;
    protected int randomSeed = 0;
    protected boolean randomSeedSet = false;
    protected boolean compatibilityExecuted = false;
    protected String packageName;
    protected Boolean detectSAPVariableUniqueness = null;
    protected IEnvironmentFactory environmentFactory = null;
    protected String cubeName = null;
    protected String mCMCacheContext = null;
    protected boolean isValidateRequest = false;
    protected boolean isValidateMissingMembers = false;
    protected boolean isDMRRequest = false;
    protected boolean isMixedRequest = false;
    protected IQueryReuseManager queryReuseManager;
    protected TreeMap<String, String> resolvedMacros = new TreeMap();
    protected Element mInfo = null;
    protected LoggingOverrides mLoggingOverrides = null;
    private boolean isInternal = false;
    private boolean monitorResources = false;
    private boolean resolveIsNullable = false;
    private String jdbcTraceFileName;
    private Set<String> capabilities;
    private List<ICMSessionIdentity> defaultIdentityNames;
    private List<ICMSessionIdentity> identities;
    protected String modelType;
    protected Map<String, String> cookies;
    protected String serviceID = null;
    private int xV5ExternalUpdateId = -1;
    private String moduleSearchPath;
    private boolean useDesignLocaleForExpressions;

    public boolean isInternal() {
        return this.isInternal;
    }

    public void setInternal(boolean value) {
        this.isInternal = value;
    }

    public boolean getMonitorResources() {
        return this.monitorResources;
    }

    public void setMonitorResources(boolean monResources) {
        this.monitorResources = monResources;
    }

    public void setExternalQueryId(int nodeId) {
        if (this.xV5ExternalUpdateId == -1) {
            this.xV5ExternalUpdateId = nodeId;
            return;
        }
        if (this.xV5ExternalUpdateId != nodeId) {
            String string1 = "XV5ExternalUpdate(id=";
            String string2 = ")";
            StringBuilder sb = new StringBuilder("Found two XV5ExternalUpdate associated to the same BaseRequestEnvironment: ");
            sb.append("XV5ExternalUpdate(id=");
            sb.append(this.xV5ExternalUpdateId);
            sb.append(")");
            sb.append("and ");
            sb.append("XV5ExternalUpdate(id=");
            sb.append(nodeId);
            sb.append(")");
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "");
        }
    }

    public Boolean getdetectSAPVariableUniqueness() {
        return this.detectSAPVariableUniqueness;
    }

    public void setdetectSAPVariableUniqueness(boolean configFileValue) {
        this.detectSAPVariableUniqueness = configFileValue;
    }

    public BaseRequestEnvironment() {
        this(false);
    }

    public BaseRequestEnvironment(boolean isBigSQL) {
        this.mCancelableRequestRegistry = null;
        this.responseMessageFolder = new ResponseMessageFolder();
    }

    public BaseRequestEnvironment(CancelableRequestRegistry cancelableRequestRegistry) {
        this.mCancelableRequestRegistry = cancelableRequestRegistry;
        this.responseMessageFolder = new ResponseMessageFolder();
    }

    @Override
    public Element getInfo() {
        return this.mInfo;
    }

    @Override
    public void setInfo(Element info) {
        this.mInfo = info;
    }

    @Override
    public Element getBibusHeader() {
        return null;
    }

    @Override
    public String getCAMUserSessionID() {
        return this.biBusSessionID;
    }

    @Override
    public String getReportName() {
        if (this.reportName == null) {
            Element reportElement;
            if (this.getInfo() != null && (reportElement = this.getInfo().element(REPORT_ELEMENT_NAME)) != null) {
                this.reportName = reportElement.getText();
            }
            if (this.reportName == null && this.reportPath != null) {
                String nameMarker = "[@name=";
                int lastNameIdx = this.reportPath.lastIndexOf("[@name=");
                if (lastNameIdx != -1) {
                    this.reportName = this.reportPath.substring(lastNameIdx + "[@name=".length() + 1, this.reportPath.lastIndexOf("]") - 1);
                }
            }
        }
        if (this.reportName == null) {
            this.reportName = UNKNOWN;
        }
        return this.reportName;
    }

    @Override
    public void setReportName(String name) {
        this.reportName = name;
    }

    @Override
    public String getReportPath() {
        return this.reportPath;
    }

    public void setExecutionEnvironment(IExecutionEnvironment env) {
        this.mExecutionEnvironment = env;
    }

    @Override
    public E getExecutionEnvironment() {
        return this.mExecutionEnvironment;
    }

    @Override
    public Parameters getRequestParameters() {
        return this.mExecutionEnvironment.getMultiRequestContext().getRequestParameters().getParameters();
    }

    @Override
    public void setRequestParameters(Parameters theParameters) {
        this.mExecutionEnvironment.getMultiRequestContext().getRequestParameters().setParameters(theParameters);
    }

    @Override
    public int getMaxSeverityLevel() {
        return this.responseMessageFolder.getMaxSeverityLevel();
    }

    @Override
    public void setMaxSeverityLevel(String severityLevel) {
        int iSeverityLevel = -1;
        if (severityLevel != null && !severityLevel.equals("")) {
            iSeverityLevel = ResponseMessage.severityLevelToInt(severityLevel);
        }
        this.setMaxSeverityLevel(iSeverityLevel);
    }

    @Override
    public void setMaxSeverityLevel(int iSeverityLevel) {
        if (iSeverityLevel < -1 || iSeverityLevel > 3) {
            throw new XQERuntimeException(XQEMessageKeys.PLN_XQEQueryNodeInternalError_INTERNAL, "Invalid severity level", Integer.toString(iSeverityLevel));
        }
        this.responseMessageFolder.setMaxSeverityLevel(iSeverityLevel);
    }

    @Override
    public void setMaxSeverityLevelForFeedback(Element command) {
        Element queryFeedback = command.element("queryFeedback");
        if (queryFeedback != null) {
            this.setMaxSeverityLevel(queryFeedback.attributeValue("severityLevel"));
        }
    }

    public String getQueryContextID() {
        return this.queryContextID;
    }

    public void setQueryContextID(String aQueryContextID) {
        this.queryContextID = aQueryContextID;
    }

    @Override
    public String getSessionContextID() {
        return this.sessionContextID;
    }

    @Override
    public void setSessionContextID(String aSessionContextID) {
        this.sessionContextID = aSessionContextID;
    }

    @Override
    public String getRequestID() {
        return this.requestID;
    }

    @Override
    public void setRequestID(String aRequestID) {
        this.requestID = aRequestID;
    }

    @Override
    public String getSubRequestID() {
        return this.subRequestID;
    }

    @Override
    public void setSubRequestID(String aSubRequestID) {
        this.subRequestID = aSubRequestID;
    }

    public boolean getInternalQuery() {
        return this.internalQuery;
    }

    public void setInternalQuery(boolean iq) {
        this.internalQuery = iq;
    }

    @Override
    public Locale getProductLocale() {
        if (this.productLocale == null) {
            this.setProductLocale(DEFAULT_LOCALE);
        }
        return this.productLocale;
    }

    @Override
    public void setProductLocale(String aLocale) {
        if (aLocale == null || aLocale.length() == 0) {
            aLocale = DEFAULT_LOCALE;
        }
        this.productLocale = LocaleConverter.strToLocale(aLocale);
    }

    @Override
    public void setProductLocale(Locale aLocale) {
        this.productLocale = aLocale;
    }

    @Override
    public Locale getRunLocale() {
        if (this.runLocale == null) {
            this.setRunLocale(DEFAULT_LOCALE);
        }
        return this.runLocale;
    }

    @Override
    public String getRunLocaleStr() {
        return this.runLocaleStr;
    }

    @Override
    public void setRunLocale(String aLocale) {
        if (aLocale == null || aLocale.length() == 0) {
            aLocale = DEFAULT_LOCALE;
        }
        this.runLocaleStr = aLocale;
        this.runLocale = LocaleConverter.strToLocale(aLocale);
    }

    @Override
    public void setRunLocale(Locale aLocale) {
        this.runLocale = aLocale;
    }

    @Override
    public Locale getExpressionLocale() {
        if (this.expressionLocale == null) {
            this.expressionLocale = this.getRunLocale();
        }
        return this.expressionLocale;
    }

    @Override
    public void setExpressionLocale(String aLocale) {
        this.expressionLocale = aLocale == null || aLocale.length() == 0 ? this.getRunLocale() : LocaleConverter.strToLocale(aLocale);
    }

    @Override
    public void setExpressionLocale(Locale aLocale) {
        this.expressionLocale = aLocale;
    }

    @Override
    public String getCAMPassport() {
        return this.camPassport;
    }

    @Override
    public void setCAMPassport(String aCAMPassport) {
        this.camPassport = aCAMPassport;
        this.camUserPassport = aCAMPassport;
    }

    @Override
    public Element getCAMPassportElement() {
        return this.camPassportElement;
    }

    public void setCAMPassportElement(Element aCAMPassportElement) {
        this.camPassportElement = aCAMPassportElement;
    }

    @Override
    public Element getBiBusHeaderElement() {
        return this.biBusHeaderElement;
    }

    public void setBiBusHeaderElement(Element aBiBusHeaderElement) {
        this.biBusHeaderElement = aBiBusHeaderElement;
    }

    @Override
    public String getCAMUserPassport() {
        return this.camUserPassport;
    }

    @Override
    public void setCAMUserPassport(String aCAMUserPassport) {
        this.camUserPassport = aCAMUserPassport;
    }

    @Override
    public String getCAMCapabilityPassport() {
        return this.camCapabilityPassport;
    }

    @Override
    public void setCAMCapabilityPassport(String aCAMCapabilityPassport) {
        this.camCapabilityPassport = aCAMCapabilityPassport;
    }

    public String getSAPLogonTicket() {
        return this.sapLogonTicket;
    }

    public void setOperationName(String anOperationName) {
        this.operationName = anOperationName;
        this.setValidateRequest(this.operationName != null && (this.operationName.equals("validate") || this.operationName.equals("validateAll")));
    }

    public void setDQALoggingPreference(int dqaLogging) {
        this.dqaLoggingPreference = dqaLogging;
    }

    @Override
    public String getOperationName() {
        return this.operationName;
    }

    public int getDQALoggingPreference() {
        return this.dqaLoggingPreference;
    }

    @Override
    public void setIncludeEmptyCells(boolean aIncludeEmptyCells) {
        this.includeEmptyCells = aIncludeEmptyCells;
    }

    @Override
    public boolean getIncludeEmptyCells() {
        return this.includeEmptyCells;
    }

    @Override
    public void setSqlFilePath(String path) {
        this.sqlFilePath = path;
    }

    @Override
    public String getSqlFilePath() {
        return this.sqlFilePath;
    }

    @Override
    public void setDatasetPath(String path) {
        this.datasetPath = path;
    }

    @Override
    public String getDatasetPath() {
        return this.datasetPath;
    }

    @Override
    public void setCurrentTraceWriter(Writer writer) {
        this.curTraceWriter = writer;
    }

    @Override
    public Writer getCurrentTraceWriter() {
        return this.curTraceWriter;
    }

    @Override
    public void setReplanQuery(String name) {
        this.replanQuery = name;
    }

    @Override
    public String getReplanQuery() {
        return this.replanQuery;
    }

    public void setPreplanQuery(IXQEQueryNode src) {
        this.preplanQuery = src;
    }

    public IXQEQueryNode getPreplanQuery() {
        return this.preplanQuery;
    }

    @Override
    public void setModelPath(String theModelPath) {
        this.modelPath = theModelPath;
    }

    @Override
    public void setModelPathIfNotSet(String theModelPath) {
        if (this.getModelPath() == null) {
            this.setModelPath(theModelPath);
        }
    }

    @Override
    public String getModelPath() {
        return this.modelPath;
    }

    @Override
    public ResponseMessageFolder getResponseMessageFolder() {
        return this.responseMessageFolder;
    }

    @Override
    public int getRandomSeed() {
        return this.randomSeed;
    }

    @Override
    public void setRandomSeed(int newRandomSeed) {
        this.randomSeed = newRandomSeed;
        this.randomSeedSet = true;
    }

    @Override
    public boolean isRandomSeedSet() {
        return this.randomSeedSet;
    }

    @Override
    public boolean isGetParametersRequest() {
        return this.getOperationName() != null && this.getOperationName().equals("getParameters");
    }

    @Override
    public boolean getCompatibilityCodeExecuted() {
        return this.compatibilityExecuted;
    }

    @Override
    public void setCompatibilityCodeExecuted(int deltaNumber) {
        this.compatibilityExecuted = true;
        XQELogger mLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "Delta", LogLevel.WARN);
        mLogger.log("Delta " + deltaNumber + " executed in compatibility mode for report " + this.reportName);
    }

    @Override
    public CancelableRequestRegistry getCancelableRequestRegistry() {
        return this.mCancelableRequestRegistry;
    }

    @Override
    public String getPackageName() {
        return this.packageName;
    }

    @Override
    public void setPackageName(String name) {
        this.packageName = name;
    }

    @Override
    public void setCubeName(String name) {
        this.cubeName = name;
    }

    @Override
    public String getCMCacheContext() {
        return this.mCMCacheContext;
    }

    @Override
    public void setCMCacheContext(String value) {
        this.mCMCacheContext = new String(value);
    }

    @Override
    public boolean isValidateRequest() {
        return this.isValidateRequest;
    }

    public void setValidateRequest(boolean value) {
        this.isValidateRequest = value;
    }

    @Override
    public boolean isValidateMissingMembers() {
        return this.isValidateMissingMembers;
    }

    public void setValidateMissingMembers(boolean value) {
        this.isValidateMissingMembers = value;
    }

    @Override
    public boolean isDMRRequest() {
        return this.isDMRRequest;
    }

    public void setDMRRequest(boolean value) {
        this.isDMRRequest = value;
    }

    @Override
    public boolean isMixedRequest() {
        return this.isMixedRequest;
    }

    public void setMixedRequest(boolean value) {
        this.isMixedRequest = value;
    }

    @Override
    public void setEnvFactory(IEnvironmentFactory envFactory) {
        this.environmentFactory = envFactory;
    }

    @Override
    public IEnvironmentFactory getEnvFactory() {
        return this.environmentFactory;
    }

    @Override
    public String getCubeName() {
        return this.cubeName;
    }

    @Override
    public void setQueryReuseManager(IQueryReuseManager theQueryReuseMap) {
        this.queryReuseManager = theQueryReuseMap;
    }

    @Override
    public IQueryReuseManager getQueryReuseManager() {
        return this.queryReuseManager;
    }

    @Override
    public TreeMap<String, String> getResolvedMacros() {
        return this.resolvedMacros;
    }

    public void setResolveConnection(boolean value) {
        this.resolveConnection = value;
    }

    @Override
    public boolean getResolveConnection() {
        return this.resolveConnection;
    }

    @Override
    public LoggingOverrides getLoggingOverrides() {
        return this.mLoggingOverrides;
    }

    @Override
    public void setLoggingOverrides(LoggingOverrides overrides) {
        this.mLoggingOverrides = overrides;
    }

    public boolean getResolveIsNullable() {
        return this.resolveIsNullable;
    }

    public void setResolveIsNullable(Element command) {
        Element queryFeedback = command.element("queryFeedback");
        if (queryFeedback != null) {
            Iterator it = queryFeedback.elementIterator("property");
            while (it.hasNext()) {
                Element propertyElement = (Element)it.next();
                String property = propertyElement.attributeValue("name");
                if (!"columnList".equals(property)) continue;
                this.resolveIsNullable = true;
                break;
            }
        }
    }

    public void setResolveIsNullable(boolean b) {
        this.resolveIsNullable = b;
    }

    @Override
    public String[] getRetrieveDatasets() {
        return null;
    }

    @Override
    public void setJDBCTraceFileName(String fName) {
        this.jdbcTraceFileName = fName;
    }

    @Override
    public String getJDBCTraceFileName() {
        return this.jdbcTraceFileName;
    }

    @Override
    public Set<String> getUserCapabilities() {
        return this.capabilities;
    }

    @Override
    public void setUserCapabilities(Set<String> theCapabilities) {
        this.capabilities = theCapabilities;
    }

    @Override
    public List<ICMSessionIdentity> getDefaultIdentityNames() {
        return this.defaultIdentityNames;
    }

    @Override
    public void setDefaultIdentityNames(List<ICMSessionIdentity> theDefaultIdentityNames) {
        this.defaultIdentityNames = theDefaultIdentityNames;
    }

    @Override
    public List<ICMSessionIdentity> getIdentities() {
        return this.identities;
    }

    @Override
    public void setIdentities(List<ICMSessionIdentity> theIdentities) {
        this.identities = theIdentities;
    }

    @Override
    public boolean isMetadataRequest() {
        return this.getOperationName() != null && this.getOperationName().equals("Metadata");
    }

    @Override
    public String getModelType() {
        return this.modelType;
    }

    @Override
    public void setModelType(String theModelType) {
        this.modelType = theModelType;
    }

    @Override
    public Map<String, String> getCookies() {
        return this.cookies;
    }

    @Override
    public void setCookies(Map<String, String> c) {
        this.cookies = c;
    }

    @Override
    public String getModuleSearchPath() {
        return this.moduleSearchPath;
    }

    @Override
    public void setModuleSearchPath(String path) {
        this.moduleSearchPath = path;
    }

    @Override
    public boolean getUseDesignLocaleForExpressions() {
        return this.useDesignLocaleForExpressions;
    }

    public void setUseDesignLocaleForExpressions(boolean value) {
        this.useDesignLocaleForExpressions = value;
    }

    public String getServiceID() {
        return this.serviceID;
    }

    public boolean isMetadataTreeRequest() {
        return this.isMetadataRequest() && "MA".equals(this.getServiceID());
    }
}

