/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.bibushandler;

import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.xqe.ast.sql.parser.SQLProcessor;
import com.cognos.xqe.ast.v5Exp.V5ExpressionProcessor;
import com.cognos.xqe.bibushandler.DQWarmupEnvironment;
import com.cognos.xqe.bibushandler.DQWarmupQuery;
import com.cognos.xqe.bibushandler.DQWarmupResultSet;
import com.cognos.xqe.bibushandler.DQWarmupSession;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.data.types.DecimalType;
import com.cognos.xqe.metadata.provider.Hierarchy;
import com.cognos.xqe.metadata.provider.Measure;
import com.cognos.xqe.metadata.provider.Member;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.QueryEnvironmentHelper;
import com.cognos.xqe.query.planner.QueryPlanner;
import com.cognos.xqe.trace.XQEDebugLog;
import com.cognos.xqe.util.pool.XQESAXReaderPool;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class DQWarmup {
    public static void doWarmup() {
        DQWarmup.doWarmupByRunQuery();
        DQWarmup.doWarmupByPreLoad();
    }

    public static void doWarmupByRunQuery() {
        Element modelPathNode;
        Document requestDocument = null;
        DQWarmupSession session = null;
        try {
            requestDocument = DQWarmup.getRequestDoc();
            session = new DQWarmupSession();
        }
        catch (FileNotFoundException e) {
            XQEDebugLog.err.printStackTrace(e);
        }
        catch (IOException e) {
            XQEDebugLog.err.printStackTrace(e);
        }
        catch (Exception e) {
            XQEDebugLog.err.printStackTrace(e);
        }
        File modelFile = new File(DQWarmup.getModelFile());
        if (requestDocument != null && session != null && modelFile.exists() && (modelPathNode = (Element)requestDocument.selectSingleNode("/command/execute/querySet/modelPath")) != null) {
            modelPathNode.setText(DQWarmup.getModelFile());
            DQWarmupEnvironment.setUpRequest(session.getRequestEnvironment(), requestDocument);
            DQWarmupQuery query = session.prepareV5Request(requestDocument, true);
            DQWarmupResultSet resultSet = query.getResultSet();
            while (resultSet.hasNext()) {
                resultSet.next();
            }
            resultSet.release();
            query.release();
            session.release();
        }
    }

    public static Document getRequestDoc() throws Exception {
        Document requestDocument = null;
        SAXReader xmlReader = XQESAXReaderPool.getInstance().borrowReader();
        try {
            FileInputStream is = new FileInputStream(DQWarmup.getRequestFile());
            requestDocument = xmlReader.read((InputStream)is);
            ((InputStream)is).close();
        }
        finally {
            if (xmlReader != null) {
                XQESAXReaderPool.getInstance().returnReader(xmlReader);
            }
        }
        return requestDocument;
    }

    private static String getRequestFile() {
        StringBuilder strBuf = DQWarmup.getDQWarmupDataDirectory();
        strBuf.append("request.xml");
        return strBuf.toString();
    }

    private static String getModelFile() {
        StringBuilder strBuf = DQWarmup.getDQWarmupDataDirectory();
        strBuf.append("model.xml");
        return strBuf.toString();
    }

    private static StringBuilder getDQWarmupDataDirectory() {
        XQEConfiguration configuration = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
        StringBuilder strBuf = new StringBuilder(configuration.getConfigDirectory());
        strBuf.append(File.separator);
        strBuf.append("warmup");
        strBuf.append(File.separator);
        strBuf.append("xqe");
        strBuf.append(File.separator);
        return strBuf;
    }

    public static void doWarmupByPreLoad() {
        Hierarchy dummyHierarchy = new Hierarchy();
        Member dummyMember = new Member();
        Measure dummyMeasure = new Measure();
        dummyHierarchy.getCaption();
        dummyMember.getCaption();
        dummyMeasure.getCaption();
        DecimalType.DEFAULT_DECIMALTYPE.createValue();
        QueryEnvironmentHelper qeh = DQWarmup.createQueryEnvironmentsNoBIBus();
        PlanningEnvironment planEnv = QueryPlanner.setupEnvironment(qeh.getRequestEnvironment());
        V5ExpressionProcessor.process("1 + 2", planEnv, Locale.ENGLISH);
        qeh.tearDownEnvironment();
        try {
            SQLProcessor.parseDataType("varchar(2)");
        }
        catch (Exception e) {
            XQEDebugLog.err.printStackTrace(e);
        }
    }

    public static QueryEnvironmentHelper createQueryEnvironmentsNoBIBus() {
        BIBusEnvelope env = new BIBusEnvelope();
        Element biBusElement = env.getBIBusHeader();
        biBusElement.detach();
        QueryEnvironmentHelper queryEnvironmentHelper = new QueryEnvironmentHelper();
        queryEnvironmentHelper.setRequestHeader(biBusElement);
        queryEnvironmentHelper.setUpEnvironment(true);
        return queryEnvironmentHelper;
    }
}

