/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.bibushandler;

import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.xqe.bibushandler.DQWarmupQuery;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.bibushandler.XQEService;
import com.cognos.xqe.config.XQECCLConfigurationFactory;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.query.engine.IExecutionEnvironment;
import com.cognos.xqe.query.engine.MultiRequestContext;
import com.cognos.xqe.query.engine.QueryEngine;
import com.cognos.xqe.runtree.PlannedV5QuerySet;
import com.cognos.xqe.util.IQueryReuseManager;
import com.cognos.xqe.util.QueryReuseManager;
import com.cognos.xqe.util.context.ExecutionEnvironmentContext;
import com.cognos.xqebifw.config.CCLConfigurationFactoryImpl;
import java.rmi.server.UID;
import java.util.Collection;
import java.util.Properties;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class DQWarmupSession {
    private QueryEngine queryEngine;
    private RequestEnvironment requestEnv;
    private IExecutionEnvironment executionEnv;
    private MultiRequestContext multiRequestContext;
    private ExecutionEnvironmentContext executionEnvironmentContext;

    public DQWarmupSession() throws Exception {
        this(null);
    }

    public DQWarmupSession(Properties props) throws Exception {
        XQECCLConfigurationFactory.initialize(new CCLConfigurationFactoryImpl());
        XQEService.initialize(props);
        this.queryEngine = QueryEngine.getInstance();
        BIBusEnvelope env = new BIBusEnvelope();
        Element biBusHeader = env.getBIBusHeader();
        biBusHeader.detach();
        this.requestEnv = new RequestEnvironment(biBusHeader);
        this.requestEnv.setRequestID(new UID().toString());
        this.requestEnv.setSessionContextID(this.requestEnv.getRequestID() + ".DQSession.SessionContextID");
        this.requestEnv.setProductLocale("en");
        this.requestEnv.setRunLocale("en-us");
        this.requestEnv.setMaxSeverityLevel(1);
        this.queryEngine.configureRequestEnvironment(this.requestEnv);
        this.executionEnv = this.requestEnv.getExecutionEnvironment();
        this.executionEnv.setConnectionElement(DocumentHelper.createElement((String)"connection"));
        this.multiRequestContext = this.queryEngine.configureMultiRequestContext(this.requestEnv, null);
        this.executionEnvironmentContext = ExecutionEnvironmentContext.enter(this.executionEnv);
        this.multiRequestContext.incrementRefCount();
    }

    public DQWarmupQuery createQuery() {
        return new DQWarmupQuery();
    }

    public DQWarmupQuery prepareV5Request(Document v5Document) {
        return this.prepareV5Request(v5Document, false);
    }

    public DQWarmupQuery prepareV5Request(Document v5Document, boolean registerRSAPIDataset) {
        PlannedV5QuerySet plan = this.queryEngine.prepareV5Request(this.requestEnv, v5Document, registerRSAPIDataset);
        DQWarmupQuery query = new DQWarmupQuery(this, plan);
        return query;
    }

    public RequestEnvironment getRequestEnvironment() {
        return this.requestEnv;
    }

    public IExecutionEnvironment getExecutionEnvironment() {
        return this.executionEnv;
    }

    public MultiRequestContext getMultiRequestContext() {
        return this.multiRequestContext;
    }

    public void setQueryReuseEnabled(boolean enabled) {
        QueryReuseManager.getInstance().setQueryReuseEnabled(enabled);
    }

    public void setQueryReuseManager(IQueryReuseManager theQueryReuseMap) {
        this.requestEnv.setQueryReuseManager(theQueryReuseMap);
    }

    public Collection<IDataSource> getDataSources() {
        return this.multiRequestContext.getDataSources();
    }

    public void release() {
        this.multiRequestContext.decrementRefCount();
        this.executionEnvironmentContext.exit();
        XQEService.terminate();
    }
}

