/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.bibushandler;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5.query.V5Source;
import com.cognos.xqe.ast.v5.result.V5QueryResultDefinition;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.NagParameterMapBasedQueryItemSubquery;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.TransformationEngine;
import com.cognos.xqe.query.engine.UnresolvedParameterException;
import com.cognos.xqe.query.executor.QueryExecutor;
import com.cognos.xqe.query.parameters.Parameter;
import com.cognos.xqe.query.parameters.Parameters;
import com.cognos.xqe.query.planner.QueryPlanner;
import com.cognos.xqe.rsapi.RSAPIDataset;
import com.cognos.xqe.rsapi.RSAPIEdge;
import com.cognos.xqe.rsapi.RSAPIEdgeIterator;
import com.cognos.xqe.rsapi.RSAPIEdgeRowset;
import com.cognos.xqe.rsapi.RSAPIPartialDataset;
import com.cognos.xqe.rsapi.RSAPIRow;
import com.cognos.xqe.rsapi.RSAPIRowset;
import com.cognos.xqe.runtree.relational.XSql;
import com.cognos.xqe.transformation.v5.util.V5SubQueryBuilder;
import java.util.ArrayList;
import java.util.List;

public class MacroRunQueryValue {
    private static final String NAME = "name";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String run(ExecutionEnvironment execEnv, String qiRef, String detailFilter) {
        boolean validationAtInfoLevel;
        RequestEnvironment reqEnv = (RequestEnvironment)execEnv.getRequestEnvironment();
        PlanningEnvironment planEnv = QueryPlanner.setupEnvironment(reqEnv);
        PlanningEnvironment subPlanEnv = V5SubQueryBuilder.createPlanningEnvironment(execEnv, planEnv);
        ExecutionEnvironment subExecEnv = (ExecutionEnvironment)subPlanEnv.getExecutionEnvironment();
        RequestEnvironment subReqEnv = (RequestEnvironment)subExecEnv.getRequestEnvironment();
        if (subPlanEnv.getMetadataConnection() == null) {
            subPlanEnv.setMetdataConnection(execEnv.getMetadataConnection());
        }
        V5QuerySet v5QuerySet = this.createQuery(qiRef, detailFilter, subPlanEnv);
        V5QueryResultDefinition v5QueryResultDefiniton = (V5QueryResultDefinition)v5QuerySet.getFirstChildByType(101055);
        boolean bl = validationAtInfoLevel = "validate".equals(reqEnv.getOperationName()) && reqEnv.getMaxSeverityLevel() == 3;
        if (validationAtInfoLevel) {
            v5QueryResultDefiniton.addQueryFeedback("CognosCommandText");
            v5QueryResultDefiniton.addQueryFeedback("nativeCommandText");
        }
        subReqEnv.setOperationName("execute");
        Parameters parameters = subReqEnv.getRequestParameters();
        Parameters unresolvedParams = parameters.getUnresolvedParameters();
        for (Parameter parameter : unresolvedParams.values()) {
            parameters.removeParameter(parameter.getName());
        }
        try {
            TransformationEngine.getInstance().applyTransformations(v5QuerySet, subPlanEnv);
        }
        catch (UnresolvedParameterException upe) {
            parameters.putAll(unresolvedParams);
            throw new UnresolvedParameterException(reqEnv, v5QuerySet, parameters);
        }
        parameters.putAll(unresolvedParams);
        IXQEQueryNode[] results = v5QuerySet.getChildrenOfType(401005);
        if (results == null || results.length != 1) {
            return null;
        }
        RSAPIDataset dataset = (RSAPIDataset)results[0];
        if (validationAtInfoLevel) {
            NagParameterMapBasedQueryItemSubquery nag = new NagParameterMapBasedQueryItemSubquery();
            nag.setActualQueryName(dataset.getName());
            nag.setCognosSQL(dataset.getCognosSQL());
            for (IXQEQueryNode xSql : this.findNativeSqlNodes(dataset)) {
                nag.addNativeSQL(((XSql)xSql).getSqlText());
            }
            execEnv.addNag(nag);
        }
        if (dataset.getNumEdges() != 1) {
            return null;
        }
        RSAPIEdge edge = dataset.getEdge(0);
        if (edge.getNumRowsets() != 1) {
            return null;
        }
        RSAPIEdgeRowset rowset = edge.getRowset(0);
        if (((RSAPIRowset)rowset).getNumColumns() != 1) {
            return null;
        }
        int[] startRowNumbers = new int[1];
        int[] numRows = new int[1];
        startRowNumbers[0] = 1;
        numRows[0] = 0;
        RSAPIPartialDataset partialDataset = null;
        boolean includeContext = false;
        boolean includeContextValues = false;
        String theResult = null;
        partialDataset = QueryExecutor.getInstance().getPartialDataset(dataset, startRowNumbers, numRows, includeContext, includeContextValues, subExecEnv);
        try {
            subPlanEnv.setPlanningActive(subReqEnv);
            try (RSAPIEdgeIterator it = partialDataset.edgeIterator(0);){
                while (it.hasNext()) {
                    RSAPIRow row = it.next();
                    IValue kval = row.getColumn(0);
                    String kv = null;
                    if (((Value)kval).isOK()) {
                        kv = ((Value)kval).toString();
                    }
                    if (kv == null) continue;
                    theResult = kv;
                    break;
                }
            }
        }
        finally {
            partialDataset.release();
            dataset.releaseResultset(subExecEnv);
        }
        return theResult;
    }

    public V5QuerySet createQuery(String qiRef, String detailFilter, PlanningEnvironment planEnv) {
        XQENodeFactory nf = planEnv.getNodeFactory();
        if (nf == null) {
            return null;
        }
        String q1 = "q1";
        String ki = "ki";
        String aggregate = "aggregate";
        String none = "none";
        String refDataItem = "refDataItem";
        V5QuerySet v5QuerySet = (V5QuerySet)nf.createNode(101002);
        v5QuerySet.addToIndex();
        IXQEQueryNode v5Query = nf.createNode(101006);
        v5Query.setPropertyValue(NAME, q1);
        v5QuerySet.addChild(v5Query);
        V5Source v5Source = (V5Source)nf.createNode(101007);
        String modelName = planEnv.getMetadataConnection().getModelName();
        String modelType = planEnv.getMetadataConnection().getModelType();
        v5Source.setModel(modelName);
        v5Source.setModelType(modelType);
        v5Query.addChild(v5Source);
        v5Query.setPropertyValue(V5Query.QueryHint.LOCAL_CACHE.getPropertyName(), false);
        v5Query.setPropertyValue("containsQueryHint", true);
        IXQEQueryNode v5Selection = nf.createNode(101009);
        v5Selection.setPropertyValue("autoSummary", false);
        v5Query.addChild(v5Selection);
        if (detailFilter != null) {
            IXQEQueryNode v5DetailFilters = nf.createNode(101008);
            v5Query.addChild(v5DetailFilters);
            IXQEQueryNode v5FilterExpression = nf.createNode(101013);
            v5DetailFilters.addChild(v5FilterExpression);
            v5FilterExpression.setPropertyValue("expression", detailFilter);
        }
        IXQEQueryNode v5DataItem = nf.createNode(101003);
        v5DataItem.setPropertyValue(NAME, ki);
        v5DataItem.setPropertyValue(aggregate, none);
        v5Selection.addChild(v5DataItem);
        IXQEQueryNode v5Expression = nf.createNode(101004);
        v5Expression.setPropertyValue("expression", qiRef);
        v5DataItem.addChild(v5Expression);
        V5QueryResultDefinition v5QueryResultDefinition = (V5QueryResultDefinition)nf.createNode(101055);
        v5QueryResultDefinition.setPropertyValue("refQuery", q1);
        v5QueryResultDefinition.setPropertyValue(NAME, "qrd1");
        v5QueryResultDefinition.setPropertyValue("topNRows", "1");
        v5QuerySet.addChild(v5QueryResultDefinition);
        IXQEQueryNode v5Edge = nf.createNode(101049);
        v5Edge.setPropertyValue(NAME, "e");
        v5QueryResultDefinition.addChild(v5Edge);
        IXQEQueryNode v5EdgeGroup = nf.createNode(101050);
        v5Edge.addChild(v5EdgeGroup);
        IXQEQueryNode v5ValueSet = nf.createNode(101057);
        v5ValueSet.setPropertyValue(NAME, "vs");
        v5EdgeGroup.addChild(v5ValueSet);
        IXQEQueryNode v5GroupBody = nf.createNode(101051);
        v5GroupBody.setPropertyValue(NAME, "gb");
        v5ValueSet.addChild(v5GroupBody);
        IXQEQueryNode v5DataItemRef = nf.createNode(101015);
        v5DataItemRef.setPropertyValue(refDataItem, ki);
        v5GroupBody.addChild(v5DataItemRef);
        return v5QuerySet;
    }

    private List<IXQEQueryNode> findNativeSqlNodes(IXQEQueryNode root) {
        ArrayList<IXQEQueryNode> nodeList = new ArrayList<IXQEQueryNode>();
        this.findNativeSqlNodes(root, nodeList);
        return nodeList;
    }

    private void findNativeSqlNodes(IXQEQueryNode aNode, List<IXQEQueryNode> nodeList) {
        if (aNode instanceof XSql) {
            nodeList.add(aNode);
        }
        for (int i = 0; i < aNode.getNumberChildren(); ++i) {
            this.findNativeSqlNodes(aNode.getChild(i), nodeList);
        }
    }
}

