/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.bibushandler;

public class SQLQueryMetrics {
    private static final String BASE_FORMAT_STRING = "SQL query of type '%s' took %,dms to execute, %,dms to fetch %,d rows, %,d rows discarded, %,d measures resulting in %,d values.";
    private QueryType queryType = QueryType.Unknown;
    private long numberOfRowsFetched = 0L;
    private long numberOfRowsDiscarded = 0L;
    private int numberOfProjectedMeasures = 0;
    private long sqlExecuteTime = 0L;
    private long sqlFetchTime = 0L;

    public SQLQueryMetrics() {
    }

    public SQLQueryMetrics(long theSqlFetchTime, QueryType theType) {
        this.sqlFetchTime = theSqlFetchTime;
        this.queryType = theType;
    }

    public QueryType getQueryType() {
        return this.queryType;
    }

    public long getNumberOfRowsFetched() {
        return this.numberOfRowsFetched;
    }

    public long getNumberOfRowsDiscarded() {
        return this.numberOfRowsDiscarded;
    }

    public int getNumberOfProjectedMeasures() {
        return this.numberOfProjectedMeasures;
    }

    public long getNumberOfValues() {
        return (this.numberOfRowsFetched - this.numberOfRowsDiscarded) * (long)this.numberOfProjectedMeasures;
    }

    public long getSqlExectuteTime() {
        return this.sqlExecuteTime;
    }

    public long getSqlFetchTime() {
        return this.sqlFetchTime;
    }

    public void setQueryType(QueryType type) {
        this.queryType = type;
    }

    public void setRowFetchData(long fetchTime, long rowsFetched, long rowsDiscarded, int measuresProjected) {
        this.sqlFetchTime = fetchTime;
        this.numberOfProjectedMeasures = measuresProjected;
        this.numberOfRowsFetched = rowsFetched;
        this.numberOfRowsDiscarded = rowsDiscarded;
    }

    public void setSqlExectuteTime(long exectuteTime) {
        this.sqlExecuteTime = exectuteTime;
    }

    public String toString() {
        return String.format(BASE_FORMAT_STRING, new Object[]{this.queryType, this.sqlExecuteTime, this.sqlFetchTime, this.numberOfRowsFetched, this.numberOfRowsDiscarded, this.numberOfProjectedMeasures, this.getNumberOfValues()});
    }

    public static enum QueryType {
        Fact,
        AggregateTable,
        ExternalAggregateStrategy,
        Unknown;

    }
}

