/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.bibushandler;

import com.cognos.cclcfgapi.CCLConfigurationException;
import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.cclcorej.util.CCLUsageData;
import com.cognos.i18n.NumericFormat;
import com.cognos.xqe.bibushandler.DQWarmup;
import com.cognos.xqe.bibushandler.ParquetEncryption;
import com.cognos.xqe.bibushandler.ServiceManager;
import com.cognos.xqe.bibushandler.content.ContentManager;
import com.cognos.xqe.bibushandler.content.IContentManager;
import com.cognos.xqe.cache.xindice.XindiceCacheManager;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQECCLConfigurationFactory;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.config.XQESubConfiguration;
import com.cognos.xqe.data.providers.ProviderManager;
import com.cognos.xqe.data.providers.olap.cache.OlapMetadataCacheService;
import com.cognos.xqe.data.providers.secbridge.SecBridge;
import com.cognos.xqe.data.values.ResultSetValue;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.management.XqeMBeanServer;
import com.cognos.xqe.metadata.provider.MetadataService;
import com.cognos.xqe.metrics.MetricsManager;
import com.cognos.xqe.query.engine.QueryEngine;
import com.cognos.xqe.runtree.olap.mdx.metadata.Cube;
import com.cognos.xqe.runtree.olap.mdx.metadata.CubeManager;
import com.cognos.xqe.runtree.olap.mdx.metadata.TupleStorageLogger;
import com.cognos.xqe.runtree.olap.mdx.metadata.metadatacache.CubeContextManager;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.OperationEnum;
import com.cognos.xqe.trace.XQEDebugLog;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.trace.remote.server.RemoteTraceServer;
import com.cognos.xqe.util.ExceptionUtil;
import com.cognos.xqe.util.LocaleConverter;
import com.cognos.xqe.util.datasets.DatasetManager;
import com.cognos.xqe.util.pool.XQEIntegerPool;
import com.cognos.xqe.util.pool.XQEIntegerPoolForNodeType;
import com.cognos.xqe.util.resource.ReleasableResourceTracker;
import com.cognos.xqe.zipi.IZipiBridge;
import com.cognos.xqe.zipi.ZipiBridge;
import com.ibm.bi.org.apache.hadoop.io.CryptoProvider;
import com.ibm.bi.org.apache.hadoop.io.ICryptoProvider;
import com.ibm.cognos.xqe.resultsdk.util.PostProcessingFilterLoader;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.DriverManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.IOUtils;

public class XQEService {
    private static final String BAD_TERMINATION = "XQE terminated incorrectly. It is likely that not every XQEService.initialize() call had a corresponding XQEService.terminate() call.";
    private static final int DEFAULT_NUM_WORKER_THREADS = 2;
    private static final String WORKER_POOL = "WorkerPool";
    private static final String DEFAULT_LOCALE = "en-us";
    private static final String CM_LIBRARIES = "CM Libraries";
    private static final String ZIPI = "Zipi";
    private static final String OFF = "OFF";
    private static ServiceManager services = null;
    private static ScheduledExecutorService sWorkerPool = null;
    private static int sWorkerPoolSize = 2;
    private static boolean showJavaStackTrace = false;
    protected static XQELogger sLogger = null;
    protected static XQELogger ipfLogger = null;
    private static volatile int sUseCounter = 0;
    private static Boolean isSSLProtocol = null;
    private static List<Logger> parquetLoggers = new ArrayList<Logger>();

    public static synchronized void initialize() {
        XQEService.initialize(new Properties());
    }

    public static synchronized void initialize(Properties props) {
        if (++sUseCounter == 1) {
            Class<?> clazz;
            String className;
            XQEConfiguration config = XQEConfigurationManager.getInstance().getOrCreateXQEConfiguration(props);
            try {
                XQEDebugLog.out.flush();
            }
            catch (Throwable ex) {
                System.err.println("Error initializing Debug Trace Logging: " + ExceptionUtil.getStackTrace(ex));
                throw new XQERuntimeException(XQEMessageKeys.INI_ErrorDuringInitialization, ex, "XQEDebugLog");
            }
            try {
                sWorkerPoolSize = config.getIntegerProperty("general.workerPool[@size]", 2);
                if (sWorkerPoolSize > -1) {
                    sWorkerPool = Executors.newScheduledThreadPool(sWorkerPoolSize, new ThreadFactory(){
                        private final AtomicInteger mThreadCounter = new AtomicInteger();

                        @Override
                        public Thread newThread(Runnable r) {
                            Thread t = new Thread(r, "XQEService-Worker" + this.mThreadCounter.incrementAndGet());
                            t.setDaemon(true);
                            return t;
                        }
                    });
                }
            }
            catch (Throwable ex) {
                System.err.println("Error initializing Debug Trace Logging: " + ExceptionUtil.getStackTrace(ex));
                throw new XQERuntimeException(XQEMessageKeys.INI_ErrorDuringInitialization, ex, WORKER_POOL);
            }
            try {
                sLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "InitTerm", LogLevel.ERROR);
                ipfLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "QueryService", LogLevel.CRITICAL);
            }
            catch (Throwable ex) {
                System.err.println("Error initializing XQE Diagnostics:" + ExceptionUtil.getStackTrace(ex));
                throw new XQERuntimeException(XQEMessageKeys.INI_ErrorDuringInitialization, ex, "XQELog");
            }
            XQEService.eraseSnappyTempFiles();
            services = new ServiceManager(config, sLogger, ipfLogger);
            services.load();
            if (config.inStandaloneMode()) {
                XQEService.initZosUsageTracking();
            }
            try {
                showJavaStackTrace = config.getBooleanProperty("general.showJavaStackTrace[@enabled]", false);
            }
            catch (Throwable ex) {
                sLogger.log(LogLevel.ERROR, "Error getting showJavaStackTrace from XQE(development) configuration file: ", ex);
                throw new XQERuntimeException(XQEMessageKeys.INI_ErrorDuringInitialization, ex, "showJavaStackTrace");
            }
            new NumericFormat(LocaleConverter.strToLocale(DEFAULT_LOCALE));
            XQEIntegerPool.getInteger(1);
            XQEIntegerPoolForNodeType.getInteger(101000);
            try {
                DriverManager.getDrivers();
            }
            catch (Exception e) {
                sLogger.log(LogLevel.ERROR, "Exception caught loading relational drivers at startup.This is an expected exception if any jdbc drivers is not installed.");
            }
            PostProcessingFilterLoader.preloadClassesToImproveFirstRunPerformance(config, sLogger);
            XQEService.cleanTupleStorage();
            sLogger.log("XQE initialized");
            XQEService.logManifestContent(sLogger);
            ipfLogger.log(ipfLogger.getDefaultLevel(), OperationEnum.STARTSERVICE_SUCCESS, XQEMessageKeys.ADT_XQEServiceStarted);
            if (config.isCryptoEnabled()) {
                ParquetEncryption.initialize();
                try {
                    Class<?> clazz2 = Class.forName(config.getStringProperty("DependencyInjection.CryptoProvider[@name]", null));
                    CryptoProvider.initialize((ICryptoProvider)((ICryptoProvider)clazz2.newInstance()));
                }
                catch (Exception e) {
                    throw new XQERuntimeException(e);
                }
            }
            try {
                className = config.getStringProperty("DependencyInjection.ContentManager[@name]", null);
                if (className != null) {
                    clazz = Class.forName(className);
                    ContentManager.initialize((IContentManager)clazz.newInstance());
                }
            }
            catch (Throwable e) {
                sLogger.log(LogLevel.ERROR, "Error pre-loading CM-releted libraries: ", e);
                ipfLogger.log(ipfLogger.getDefaultLevel(), OperationEnum.STARTSERVICE_FAILURE, XQEMessageKeys.INI_ErrorDuringInitialization, CM_LIBRARIES);
                throw new XQERuntimeException(XQEMessageKeys.INI_ErrorDuringInitialization, e, CM_LIBRARIES);
            }
            try {
                className = config.getStringProperty("DependencyInjection.ZipiBridge[@name]", null);
                if (className != null) {
                    clazz = Class.forName(className);
                    ZipiBridge.initialize((IZipiBridge)clazz.newInstance());
                }
            }
            catch (Throwable e) {
                throw new XQERuntimeException(XQEMessageKeys.INI_ErrorDuringInitialization, e, ZIPI);
            }
            if (config.inStandaloneMode()) {
                Runtime.getRuntime().addShutdownHook(new Thread(){

                    @Override
                    public void run() {
                        XQEService.checkTerminated();
                    }
                });
            }
            XQESubConfiguration subConfig = config.getChildren("dataset.parquet.logger");
            while (subConfig.hasNext()) {
                subConfig.next();
                String name = subConfig.getString("[@name]", null);
                String level = subConfig.getString("[@level]", OFF);
                Level logLevel = Level.OFF;
                if (level.equals(OFF)) {
                    logLevel = Level.OFF;
                } else if (level.equals("SEVERE")) {
                    logLevel = Level.SEVERE;
                } else if (level.equals("WARNING")) {
                    logLevel = Level.WARNING;
                } else if (level.equals("INFO")) {
                    logLevel = Level.INFO;
                }
                Logger logger = Logger.getLogger(name);
                logger.setLevel(logLevel);
                parquetLoggers.add(logger);
            }
            if (config.inStandaloneMode()) {
                DQWarmup.doWarmup();
            } else {
                DatasetManager.getInstance().initializeFlintServerManager();
            }
        }
    }

    private static void eraseSnappyTempFiles() {
        String snappyDir = System.getProperty("org.xerial.snappy.tempdir");
        if (null == snappyDir) {
            sLogger.log(LogLevel.INFO, "Snappy tempdir system property not found");
            return;
        }
        File snappyDirF = new File(snappyDir);
        if (!snappyDirF.exists()) {
            return;
        }
        for (File f : snappyDirF.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith("snappy-");
            }
        })) {
            try {
                f.delete();
            }
            catch (Throwable ex) {
                sLogger.log(LogLevel.INFO, "Could not clean snappy libraries from temp directory.", ex);
            }
        }
    }

    static void logManifestContent(XQELogger logger) {
        XQELogger obj = logger;
        Class<?> clazz = obj.getClass();
        String classSimpleName = clazz.getSimpleName();
        String classFileName = classSimpleName + ".class";
        String classFilePath = clazz.getResource(classFileName).toString();
        int bangSeparatorIndex = classFilePath.indexOf("!");
        String manifestFilePath = classFilePath.substring(0, bangSeparatorIndex + 1);
        manifestFilePath = manifestFilePath + "/META-INF/MANIFEST.MF";
        String manifestStr = "[Unable to read manifest]";
        try {
            URL manifestFileURL = new URL(manifestFilePath);
            manifestStr = IOUtils.toString((InputStream)manifestFileURL.openStream());
        }
        catch (IOException iOException) {
        }
        catch (Exception exception) {
        }
        catch (Error error) {
            // empty catch block
        }
        logger.log("Manifest: " + manifestFilePath + " \n" + manifestStr);
    }

    public static synchronized boolean isInitialized() {
        return sUseCounter > 0;
    }

    public static synchronized void checkTerminated() {
        if (sUseCounter > 0) {
            if (sLogger != null) {
                sLogger.log(BAD_TERMINATION);
            }
            System.err.println(BAD_TERMINATION);
        }
    }

    public static synchronized int getUseCounter() {
        return sUseCounter;
    }

    public static boolean isSSLProtocol() throws MalformedURLException, CCLConfigurationException {
        if (isSSLProtocol == null) {
            XQECCLConfigurationFactory.getInstance().init();
            ICCLConfiguration cclConfig = XQECCLConfigurationFactory.getInstance();
            String dispAddr = cclConfig.getValue("internalDispatcher", false);
            URL dispURL = new URL(dispAddr);
            isSSLProtocol = dispURL.getProtocol().equalsIgnoreCase("https") ? Boolean.TRUE : Boolean.FALSE;
        }
        return isSSLProtocol;
    }

    public static synchronized void terminate() {
        if (sUseCounter == 0) {
            IllegalStateException e = new IllegalStateException("XQEService.terminate() called without matching XQEService.initialize().");
            if (null != sLogger) {
                sLogger.log(e);
            }
            throw e;
        }
        if (sUseCounter == 1) {
            block46: {
                XQEConfiguration config;
                block45: {
                    block44: {
                        block43: {
                            block42: {
                                block41: {
                                    block40: {
                                        block39: {
                                            block38: {
                                                block37: {
                                                    block36: {
                                                        block35: {
                                                            config = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
                                                            MetricsManager.downOperationalStatus();
                                                            ResultSetValue.reportAndCleanup(false);
                                                            ReleasableResourceTracker.reportGlobalUnreleasedSummary();
                                                            try {
                                                                CubeContextManager.releaseInstance();
                                                            }
                                                            catch (Throwable ex) {
                                                                if (null == sLogger) break block35;
                                                                sLogger.log(LogLevel.ERROR, "Failed to release CubeContextManager: ", ex);
                                                            }
                                                        }
                                                        try {
                                                            CubeManager.releaseInstance();
                                                        }
                                                        catch (Throwable ex) {
                                                            if (null == sLogger) break block36;
                                                            sLogger.log(LogLevel.ERROR, "Failed to release CubeManager: ", ex);
                                                        }
                                                    }
                                                    try {
                                                        TupleStorageLogger.releaseInstance();
                                                    }
                                                    catch (Throwable ex) {
                                                        if (null == sLogger) break block37;
                                                        sLogger.log(LogLevel.ERROR, "Failed to release TupleStorageLogger: ", ex);
                                                    }
                                                }
                                                try {
                                                    OlapMetadataCacheService.releaseInstance();
                                                }
                                                catch (Throwable ex) {
                                                    if (null == sLogger) break block38;
                                                    sLogger.log(LogLevel.ERROR, "Failed to release OLAPMetadataCacheService: ", ex);
                                                }
                                            }
                                            if (config.inStandaloneMode()) {
                                                try {
                                                    MetadataService.releaseInstance();
                                                }
                                                catch (Throwable ex) {
                                                    if (null == sLogger) break block39;
                                                    sLogger.log(LogLevel.ERROR, "Failed to release MetadataService: ", ex);
                                                }
                                            }
                                        }
                                        services.unload();
                                        try {
                                            QueryEngine.releaseInstance();
                                        }
                                        catch (Throwable ex) {
                                            if (null == sLogger) break block40;
                                            sLogger.log(LogLevel.ERROR, "Failed to release QueryEngine: ", ex);
                                        }
                                    }
                                    try {
                                        ProviderManager.releaseInstance();
                                    }
                                    catch (Throwable ex) {
                                        if (null == sLogger) break block41;
                                        sLogger.log(LogLevel.ERROR, "Failed to release ProviderManager: ", ex);
                                    }
                                }
                                if (config.inStandaloneMode()) {
                                    try {
                                        SecBridge.releaseInstance();
                                    }
                                    catch (Throwable ex) {
                                        if (null == sLogger) break block42;
                                        sLogger.log(LogLevel.ERROR, "Failed to release SecBridge: ", ex);
                                    }
                                }
                            }
                            try {
                                XindiceCacheManager.releaseInstance();
                            }
                            catch (Throwable ex) {
                                if (null == sLogger) break block43;
                                sLogger.log(LogLevel.ERROR, "Failed to release XindiceCacheManager: ", ex);
                            }
                        }
                        XQEService.cleanTupleStorage();
                        if (sWorkerPool != null) {
                            try {
                                sWorkerPool.shutdownNow();
                            }
                            catch (Throwable ex) {
                                if (null == sLogger) break block44;
                                sLogger.log(LogLevel.ERROR, "Failed to shutdown WorkerPool: ", ex);
                            }
                        }
                    }
                    try {
                        RemoteTraceServer.releaseInstance();
                    }
                    catch (Throwable ex) {
                        if (null == sLogger) break block45;
                        sLogger.log(LogLevel.ERROR, "Failed to release RemoteTraceServer: ", ex);
                    }
                }
                if (config.inStandaloneMode()) {
                    try {
                        XqeMBeanServer.releaseInstance();
                    }
                    catch (Throwable ex) {
                        if (null == sLogger) break block46;
                        sLogger.log(LogLevel.ERROR, "Failed to release XqeMBeanServer: ", ex);
                    }
                }
            }
            if (null != sLogger) {
                sLogger.log(LogLevel.ERROR, "XQE terminated");
                sLogger = null;
            }
            if (null != ipfLogger) {
                ipfLogger.log(ipfLogger.getDefaultLevel(), OperationEnum.STOPSERVICE_SUCCESS, XQEMessageKeys.ADT_XQEServiceStopped);
                ipfLogger = null;
            }
            XQELog.logConsole("XQE terminated.");
            try {
                XQELog.release();
            }
            catch (Throwable ex) {
                ex.printStackTrace();
            }
        }
        --sUseCounter;
    }

    public static ScheduledExecutorService getWorkerPool() {
        return sWorkerPool;
    }

    public static boolean getShowJavaStackTrace() {
        return showJavaStackTrace;
    }

    private static void deleteFile(File file) {
        File[] files;
        if (!file.exists()) {
            return;
        }
        if (file.isDirectory() && (files = file.listFiles()) != null) {
            for (File f : files) {
                XQEService.deleteFile(f);
            }
        }
        file.delete();
    }

    private static void cleanTupleStorage() {
        File rootDirectory = new File(Cube.getStoragePath());
        XQEService.deleteFile(rootDirectory);
    }

    private static void initZosUsageTracking() {
        CCLUsageData usageData = new CCLUsageData();
        int usageResult = usageData.registerUsageTracking();
        sLogger.log(LogLevel.INFO, "CCLUsageData.registerUsageTracking, return code = " + usageResult);
    }
}

