/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.bibushandler.content;

import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.pogo.contentmanager.CMClass;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.xqe.bibushandler.IRequestEnvironment;
import com.cognos.xqe.bibushandler.content.CMException;
import com.cognos.xqe.bibushandler.content.ICMConnection;
import com.cognos.xqe.bibushandler.content.ICMDataSource;
import com.cognos.xqe.bibushandler.content.ICMModelViewSearchKey;
import com.cognos.xqe.bibushandler.content.ICMSessionIdentity;
import com.cognos.xqe.bibushandler.content.ICMUser;
import com.cognos.xqe.bibushandler.content.IContentManager;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqebifw.bibushandler.content.ContentManagerImpl;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.dom4j.Element;

public final class ContentManager {
    private static final AtomicBoolean INITIALIZED = new AtomicBoolean(false);
    private static IContentManager contentManagerImpl;
    private static XQELogger mCMLogger;

    public static void initialize(IContentManager aContentManager) throws XQERuntimeException {
        if (INITIALIZED.compareAndSet(false, true)) {
            contentManagerImpl = aContentManager;
            contentManagerImpl.initialize();
            mCMLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "CM", LogLevel.INFO);
        }
    }

    public static void setContentManagerImpl(IContentManager aContentManager) {
        contentManagerImpl = aContentManager;
        contentManagerImpl.initialize();
    }

    public static IContentManager getContentManagerImpl() {
        return contentManagerImpl;
    }

    public static BiBusHeader buildBiBusHeader(IRequestEnvironment reqEnv) {
        if (contentManagerImpl == null) {
            return null;
        }
        return contentManagerImpl.buildBiBusHeader(reqEnv);
    }

    public static ICMDataSource getDataSource(IRequestEnvironment reqEnv, String dsName) {
        if (contentManagerImpl == null) {
            return null;
        }
        return contentManagerImpl.getDataSource(reqEnv, dsName);
    }

    public static ICMConnection getConnection(IRequestEnvironment reqEnv, String dsName, String connectionName) {
        if (contentManagerImpl == null) {
            return null;
        }
        return contentManagerImpl.getDataSource(reqEnv, dsName).getConnection(connectionName);
    }

    public static Collection<ICMConnection> getConnections(IRequestEnvironment reqEnv, String dsName) {
        if (contentManagerImpl == null) {
            return Collections.emptySet();
        }
        return contentManagerImpl.getConnections(reqEnv, dsName);
    }

    public static ICMUser getUser(IRequestEnvironment reqEnv) {
        if (contentManagerImpl == null) {
            return null;
        }
        return contentManagerImpl.getUser(reqEnv);
    }

    public static String getUserClassIDs(IRequestEnvironment reqEnv, List<String> filter, boolean useSeries7Security) {
        if (contentManagerImpl == null) {
            return null;
        }
        return contentManagerImpl.getUserClassIDs(reqEnv, filter, useSeries7Security);
    }

    public static String getUserClassIDs(IRequestEnvironment reqEnv, String namespace, List<String> filter, boolean useSeries7Security) {
        if (contentManagerImpl == null) {
            return null;
        }
        return contentManagerImpl.getUserClassIDs(reqEnv, namespace, filter, useSeries7Security);
    }

    public static List<ICMSessionIdentity> getIdentitiesList(IRequestEnvironment reqEnv) {
        if (contentManagerImpl == null) {
            return Collections.emptyList();
        }
        List<ICMSessionIdentity> identities = contentManagerImpl.getIdentitiesList(reqEnv);
        if (mCMLogger.isOn()) {
            mCMLogger.log("IDENTITIES: " + identities.toString());
        }
        return contentManagerImpl.getIdentitiesList(reqEnv);
    }

    public static List<ICMSessionIdentity> getUserIdentitiesList(IRequestEnvironment reqEnv) {
        if (contentManagerImpl == null) {
            return Collections.emptyList();
        }
        return contentManagerImpl.getUserIdentitiesList(reqEnv);
    }

    public static String getUserName(IRequestEnvironment reqEnv) {
        if (contentManagerImpl == null) {
            return null;
        }
        return contentManagerImpl.getUserName(reqEnv);
    }

    public static Set<String> getModelViews(IRequestEnvironment reqEnv, String dsName, ICMModelViewSearchKey searchKey) {
        if (contentManagerImpl == null) {
            return Collections.emptySet();
        }
        return contentManagerImpl.getModelViews(reqEnv, dsName, searchKey);
    }

    public static boolean isDataSourceCached(IRequestEnvironment reqEnv, String name) {
        if (contentManagerImpl == null) {
            return false;
        }
        return contentManagerImpl.isDataSourceCached(reqEnv, name);
    }

    public static Map<String, ArrayList<String>> getParameterMap(IRequestEnvironment reqEnv) {
        if (contentManagerImpl == null) {
            return null;
        }
        return contentManagerImpl.getParameterMap(reqEnv);
    }

    public static String getSearchPathPropName(IRequestEnvironment reqEnv, String searchPath, String property) {
        if (contentManagerImpl == null) {
            return null;
        }
        return contentManagerImpl.getSearchPathPropName(reqEnv, searchPath, property);
    }

    public static ICMModelViewSearchKey createModelViewSearchKey(IRequestEnvironment reqEnv, String modelPath, String predicate) {
        if (contentManagerImpl == null) {
            return null;
        }
        return contentManagerImpl.createModelViewSearchKey(reqEnv, modelPath, predicate);
    }

    public static List<ICMSessionIdentity> getUserDefaultIdentityNames(IRequestEnvironment reqEnv) {
        if (contentManagerImpl == null) {
            return Collections.emptyList();
        }
        return contentManagerImpl.getUserDefaultIdentityNames(reqEnv);
    }

    public static String prettyPrintUserIdentities() {
        return null;
    }

    public static Set<String> getUserCapabilities(IRequestEnvironment reqEnv) {
        if (contentManagerImpl == null) {
            return Collections.emptySet();
        }
        return contentManagerImpl.getUserCapabilities(reqEnv);
    }

    public static Set<String> getPackageUserCapabilities(IRequestEnvironment reqEnv, String modelPath) {
        if (contentManagerImpl == null || !(contentManagerImpl instanceof ContentManagerImpl)) {
            return Collections.emptySet();
        }
        return ((ContentManagerImpl)contentManagerImpl).getPackageUserCapabilitiesfromCM(reqEnv, modelPath);
    }

    public static Element createBiBusHeader() {
        if (contentManagerImpl == null) {
            return null;
        }
        return contentManagerImpl.createBiBusHeader();
    }

    public static BiBusHeader buildBiBusHeaderFrom(BIBusEnvelope envelope) throws RemoteException {
        if (contentManagerImpl == null) {
            return null;
        }
        return contentManagerImpl.buildBiBusHeaderFrom(envelope);
    }

    public static BiBusHeader buildBiBusHeader(String nameSpace, String userName, String password) {
        if (contentManagerImpl == null) {
            return null;
        }
        return contentManagerImpl.buildBiBusHeader(nameSpace, userName, password);
    }

    public static List<CMClass> getProperties(String queryObject, String ... properties) throws CMException {
        if (contentManagerImpl == null) {
            return Collections.emptyList();
        }
        return contentManagerImpl.getProperties(queryObject, properties);
    }

    public static boolean isEnabled() {
        return contentManagerImpl != null;
    }

    public static boolean isRunning() {
        if (contentManagerImpl == null) {
            return false;
        }
        return contentManagerImpl.isRunning();
    }

    public static BIBusEnvelope logonToAccessAccount(String accessAccount) throws CMException {
        if (contentManagerImpl == null) {
            return null;
        }
        return contentManagerImpl.logonToAccessAccount(accessAccount);
    }

    public static void logOffAccessAccount(Element busHeader) throws CMException {
        if (contentManagerImpl == null) {
            return;
        }
        contentManagerImpl.logOffAccessAccount(busHeader);
    }

    public static void updateInMemoryAggregateXML(String dataSourceSearchPath, String inMemoryAggregateXML) throws CMException {
        if (contentManagerImpl == null) {
            return;
        }
        contentManagerImpl.updateInMemoryAggregateXML(dataSourceSearchPath, inMemoryAggregateXML);
    }

    public static List<String> getModelViewSearchPaths(IRequestEnvironment reqEnv, String modelView) {
        if (contentManagerImpl == null) {
            return Collections.emptyList();
        }
        return contentManagerImpl.getModelViewSearchPaths(reqEnv, modelView);
    }

    public static Set<String> getModelViews(IRequestEnvironment reqEnv, String modelPath) {
        if (contentManagerImpl == null) {
            return Collections.emptySet();
        }
        Set<String> modelViews = contentManagerImpl.getModelViews(reqEnv, modelPath);
        if (mCMLogger.isOn()) {
            mCMLogger.log("MODEL VIEWS: " + modelViews.toString());
        }
        return modelViews;
    }

    static {
        mCMLogger = null;
    }
}

