/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.bibushandler.datasource;

import com.cognos.xqe.ast.XQEPersistContext;
import com.cognos.xqe.ast.XQERestoreContext;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.bibushandler.content.ContentManager;
import com.cognos.xqe.bibushandler.content.ICMConnection;
import com.cognos.xqe.bibushandler.content.ICMDataSource;
import com.cognos.xqe.bibushandler.datasource.DataSourceConnection;
import com.cognos.xqe.bibushandler.datasource.DataSourceConnectionFromFile;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.data.model.AbstractDataSource;
import com.cognos.xqe.data.model.AmbiguousConnectionException;
import com.cognos.xqe.data.model.ConnectionNotFoundException;
import com.cognos.xqe.data.model.DataSourceNotFoundException;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.model.IDataSourceConnection;
import com.cognos.xqe.data.providers.SimpleDataSourceConnection;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPContext;
import com.cognos.xqe.util.MapCast;
import com.cognos.xqe.util.context.ExecutionEnvironmentContext;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.collections.map.Flat3Map;
import org.dom4j.Attribute;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class DataSource
extends AbstractDataSource {
    protected static final String DEFAULT_NAME_PROPERTY = "defaultName";
    protected static final String CREDENTIALS_PROPERTY = "credentials";
    protected static final String CONNECTION_STRING_PROPERTY = "connectionString";
    protected static final String SEARCH_PATH_PROPERTY = "searchPath";
    protected static final String IDENTITY_PROPERTY = "identity";
    protected static final String TYPE_PROPERTY = "type";
    private static final String NAME = "name";
    protected static final String VALUE_PROPERTY = "value";
    private static final String NSGENERAL_FILE_NAME = "nsgeneral.xml";
    private static final String ROLAP_CONN_STR = ";LOCAL;RO;";
    private static final String JDBC_STR = "URL=jdbc:";
    public static final String ROLAP_DISAMBIGUATION_NAME = "DynamicCubes";
    public static final String STRING_CM_DATASOURCE_NAME = "mCMDataSourceName";
    private String mCMDataSourceName;
    private Map<String, IDataSourceConnection> connections;
    private ReadWriteLock connectionListLock = new ReentrantReadWriteLock();

    public DataSource(String theName, String theCMDataSourceName, String theType, Map<String, Object> theMetadataProperties) {
        super(theName, theType, theMetadataProperties);
        this.mCMDataSourceName = theCMDataSourceName;
        if (LOGGER.isOn()) {
            LOGGER.log("Create new " + this.toString());
        }
        if (this.isROLAP() && !this.isDummy()) {
            this.prepareConnections((ExecutionEnvironment)ExecutionEnvironmentContext.getExecutionEnvironment());
        }
    }

    private boolean isDummy() {
        Object value = this.getMetadataProperties().get("isDummy");
        if (value != null) {
            return (Boolean)value;
        }
        return false;
    }

    public DataSource(String theName, String theCMDataSourceName, String theType) {
        super(theName, theType, null);
        this.mCMDataSourceName = theCMDataSourceName;
    }

    @Override
    public String getCMDataSourceName() {
        return this.mCMDataSourceName;
    }

    @Override
    public void setCMDataSourceName(String cmDSName) {
        this.mCMDataSourceName = cmDSName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IDataSourceConnection getDataSourceConnection() {
        ExecutionEnvironment env = (ExecutionEnvironment)ExecutionEnvironmentContext.getExecutionEnvironment();
        if (env == null) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_ExecutionEnvironmentMissing_INTERNAL);
        }
        this.prepareConnections(env);
        this.connectionListLock.readLock().lock();
        try {
            IDataSourceConnection conn;
            String connectionName = env.resolveDataSourceConnectionName(this.getCMDataSourceName());
            if (connectionName != null) {
                IDataSourceConnection connection = this.connections.get(connectionName);
                if (connection == null) {
                    if (this.connections.size() == 1) {
                        connection = this.connections.values().iterator().next();
                    } else {
                        throw new ConnectionNotFoundException((IDataSource)this, env.getConnectionSearchPath(), connectionName);
                    }
                }
                IDataSourceConnection iDataSourceConnection = connection;
                return iDataSourceConnection;
            }
            int numConnections = this.connections.size();
            if (numConnections > 1) {
                if (ROLAPContext.isRelQueryExecuting()) {
                    for (String name : this.connections.keySet()) {
                        if (!name.equalsIgnoreCase(ROLAP_DISAMBIGUATION_NAME)) continue;
                        IDataSourceConnection iDataSourceConnection = this.connections.get(name);
                        return iDataSourceConnection;
                    }
                }
                throw new AmbiguousConnectionException((IDataSource)this, new ArrayList<String>(this.connections.keySet()));
            }
            if (numConnections < 1) {
                throw new ConnectionNotFoundException((IDataSource)this, env.getConnectionSearchPath());
            }
            IDataSourceConnection iDataSourceConnection = conn = this.connections.values().iterator().next();
            return iDataSourceConnection;
        }
        finally {
            this.connectionListLock.readLock().unlock();
        }
    }

    public void setConnectionsMap(Map<String, IDataSourceConnection> newConnections) {
        this.connectionListLock.writeLock().lock();
        try {
            this.connections = newConnections;
        }
        finally {
            this.connectionListLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepareConnections(ExecutionEnvironment env) {
        this.connectionListLock.readLock().lock();
        try {
            if (this.connections != null) {
                return;
            }
        }
        finally {
            this.connectionListLock.readLock().unlock();
        }
        this.connectionListLock.writeLock().lock();
        try {
            String cs;
            this.connections = MapCast.uncheckedCast(new Flat3Map());
            String connectionString = (String)this.getMetadataProperties().get(CONNECTION_STRING_PROPERTY);
            if (connectionString != null) {
                DataSourceConnection connection = new DataSourceConnection(this.getName(), connectionString, this);
                this.connections.put(this.getName(), connection);
                return;
            }
            File nsGeneralFile = this.getNsGeneral();
            if (nsGeneralFile != null) {
                this.retrieveDataSourceConnectionsFromFile(env, nsGeneralFile);
                return;
            }
            ICMDataSource ds = null;
            ds = ContentManager.getDataSource(env.getRequestEnvironment(), this.getCMDataSourceName());
            if (!ds.exist()) {
                throw new DataSourceNotFoundException(this);
            }
            if (this.isROLAP()) {
                this.connections.put("ROLAPConnection", new SimpleDataSourceConnection(ROLAP_CONN_STR, null));
                return;
            }
            Collection<ICMConnection> conns = ds.getConnections();
            boolean jdbcConnectionsDefined = false;
            for (ICMConnection conn : conns) {
                cs = conn.getConnectionString();
                if (conn.isDisabled() || !cs.contains(JDBC_STR)) continue;
                jdbcConnectionsDefined = true;
            }
            for (ICMConnection conn : conns) {
                cs = conn.getConnectionString();
                if (conn.isDisabled()) continue;
                DataSourceConnection connection = new DataSourceConnection(conn.getDefaultName(), conn.getSearchPath(), cs, this, conn.getNamespace(), conn.getIsolationLevel(), conn.getApiToken());
                if (jdbcConnectionsDefined) {
                    if (!cs.contains(JDBC_STR)) continue;
                    this.connections.put(conn.getDefaultName(), connection);
                    continue;
                }
                this.connections.put(conn.getDefaultName(), connection);
            }
        }
        finally {
            this.connectionListLock.writeLock().unlock();
        }
    }

    private File getNsGeneral() {
        XQEConfiguration configuration = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
        String binDir = configuration.getBinDirectory();
        StringBuilder strFileNameBuf = new StringBuilder();
        strFileNameBuf.append(binDir).append(File.separator).append(NSGENERAL_FILE_NAME);
        File nsGeneralFile = new File(strFileNameBuf.toString());
        if (!nsGeneralFile.exists()) {
            return null;
        }
        return nsGeneralFile;
    }

    private void retrieveDataSourceConnectionsFromFile(ExecutionEnvironment env, File connectionsFile) {
        DataSourceConnectionFromFile connection = new DataSourceConnectionFromFile(this.getName(), connectionsFile);
        if (connection.getConnectionString(null) != null) {
            this.connections.put(this.getName(), connection);
        }
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("DataSource[name=");
        buffer.append(this.getName());
        buffer.append(", cmDataSourceName=");
        buffer.append(this.getCMDataSourceName());
        buffer.append("]");
        return buffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Element asXML() {
        ExecutionEnvironment env = (ExecutionEnvironment)ExecutionEnvironmentContext.getExecutionEnvironment();
        if (env == null) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_ExecutionEnvironmentMissing_INTERNAL);
        }
        Element dataSourceElement = DocumentHelper.createElement((String)"dataSource");
        Element nameElement = dataSourceElement.addElement(NAME);
        nameElement.addAttribute(VALUE_PROPERTY, this.getCMDataSourceName());
        Element typeElement = dataSourceElement.addElement(TYPE_PROPERTY);
        if (null != this.type) {
            typeElement.addAttribute(VALUE_PROPERTY, this.type);
        } else {
            String modelType = (String)this.getMetadataProperties().get("interface");
            if (null == modelType) {
                modelType = "?";
            }
            typeElement.addAttribute(VALUE_PROPERTY, modelType);
        }
        this.prepareConnections(env);
        this.connectionListLock.readLock().lock();
        try {
            TreeMap<String, IDataSourceConnection> sortedConnections = new TreeMap<String, IDataSourceConnection>(String.CASE_INSENSITIVE_ORDER);
            sortedConnections.putAll(this.connections);
            for (DataSourceConnection connection : sortedConnections.values()) {
                dataSourceElement.add(connection.asXML());
            }
        }
        finally {
            this.connectionListLock.readLock().unlock();
        }
        return dataSourceElement;
    }

    public static DataSource getOrAdd(ExecutionEnvironment env, Element node) {
        DataSource result = null;
        String modelPath = ((RequestEnvironment)env.getRequestEnvironment()).getModelPath();
        String name = node.attributeValue(STRING_CM_DATASOURCE_NAME);
        String type = node.attributeValue(TYPE_PROPERTY);
        if (modelPath != null && name != null && type != null) {
            result = (DataSource)env.getOrAddDataSource(modelPath, name, type, null);
        }
        return result;
    }

    @Override
    public void persistAttributeProperties(XQEPersistContext ctx) {
        super.persistAttributeProperties(ctx);
        if (this.mCMDataSourceName != null) {
            ctx.property(STRING_CM_DATASOURCE_NAME, this.getCMDataSourceName());
        }
    }

    @Override
    public void persistElementProperties(XQEPersistContext ctx) {
        super.persistElementProperties(ctx);
    }

    @Override
    protected void restoreElementProperty(XQERestoreContext ctx, Element node, Element inputNode) {
        super.restoreElementProperty(ctx, node, inputNode);
    }

    @Override
    protected void restoreAttributeProperty(XQERestoreContext ctx, Attribute att, Element inputNode) {
        String attname = att.getName();
        if (attname.equals(STRING_CM_DATASOURCE_NAME)) {
            Object value = ctx.attributeValue(att);
            this.mCMDataSourceName = (String)value;
        } else {
            super.restoreAttributeProperty(ctx, att, inputNode);
        }
    }
}

