/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.bibushandler.datasource;

import com.cognos.xqe.bibushandler.datasource.PropertiesDataTypeMask;
import com.cognos.xqe.bibushandler.datasource.ProviderCapabilites;
import com.cognos.xqe.data.model.CapabilitiesKey;
import com.cognos.xqe.data.model.CapabilitiesKeyParts;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.model.IDataSourceCapabilities;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Pattern;
import org.apache.commons.configuration2.AbstractConfiguration;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.MapConfiguration;
import org.apache.commons.configuration2.convert.DisabledListDelimiterHandler;

public class DataSourceCapabilities
implements IDataSourceCapabilities {
    private static final String NEW_LINE = "\n";
    protected AbstractConfiguration config = null;
    private IDataSource dataSource;
    private String delimiterIdentifierQuoteString;
    private String catalogDelimiterString;
    private String schemaDelimiterString;
    private String tableDelimiterString;
    private String columnDelimiterString;
    private String catalogSeparatorString;
    private String literalQuoteEscape;
    private String columnAliasKeywordString;
    protected ConcurrentMap<String, String> stringValueCache;
    protected ConcurrentMap<String, Boolean> booleanValueCache;
    private HashMap<String, ArrayList<FunctionSignature>> functionCache = new HashMap();
    private final CapabilitiesKey capabilitiesKey;
    private final CapabilitiesKey capabilitiesKeyFullParts;
    protected boolean copied = false;
    private boolean useCheckMemberRulesSecondaryQuery = false;
    private static final Pattern SPLITTER = Pattern.compile("[\\[\\]]");
    private static final String COMMA = ",";
    private static final String OPEN_SQUARE_BRACKET = "[";
    private static final String CLOSED_SQUARE_BRACKET = "]";
    private static final String ANY_TYPE = "any";

    public DataSourceCapabilities() {
        this.delimiterIdentifierQuoteString = null;
        this.catalogDelimiterString = null;
        this.catalogSeparatorString = ".";
        this.schemaDelimiterString = null;
        this.columnAliasKeywordString = null;
        this.columnDelimiterString = null;
        this.literalQuoteEscape = null;
        this.tableDelimiterString = null;
        this.capabilitiesKey = null;
        this.capabilitiesKeyFullParts = null;
    }

    public DataSourceCapabilities(CapabilitiesKey aCapabilitiesKey, AbstractConfiguration configuration) {
        this.delimiterIdentifierQuoteString = null;
        this.catalogDelimiterString = null;
        this.catalogSeparatorString = ".";
        this.schemaDelimiterString = null;
        this.columnAliasKeywordString = null;
        this.columnDelimiterString = null;
        this.literalQuoteEscape = null;
        this.tableDelimiterString = null;
        this.capabilitiesKey = aCapabilitiesKey;
        this.capabilitiesKeyFullParts = null;
        this.config = configuration;
        this.initValueCaches();
    }

    public DataSourceCapabilities(IDataSource aDataSource) {
        this(aDataSource, CapabilitiesKeyParts.NULL_KEY_PARTS, null);
    }

    public DataSourceCapabilities(IDataSource aDataSource, CapabilitiesKeyParts parts, Map<String, AbstractConfiguration> configs) {
        this.initValueCaches();
        this.dataSource = aDataSource;
        if (parts.getConnectionString() == null) {
            this.capabilitiesKeyFullParts = this.capabilitiesKey = new CapabilitiesKey(parts.getType(this.dataSource), parts, configs);
        } else {
            this.capabilitiesKey = new CapabilitiesKey(null, null, null, parts.getConnectionString());
            this.capabilitiesKeyFullParts = new CapabilitiesKey(parts.getType(this.dataSource), parts, configs);
        }
        this.init();
        this.initFunctionCache();
        this.setDelimiters();
        ProviderCapabilites.getInstance().addCapabilities(this.capabilitiesKey, this);
    }

    protected void initValueCaches() {
        this.stringValueCache = new ConcurrentHashMap<String, String>();
        this.booleanValueCache = new ConcurrentHashMap<String, Boolean>();
    }

    private void init() {
        try {
            AbstractConfiguration providerCapabilities = ProviderCapabilites.getInstance().resolveProviderCapabilities(this.capabilitiesKeyFullParts);
            this.copied = false;
            this.config = providerCapabilities;
        }
        catch (Exception e) {
            throw XQERuntimeException.wrap(XQEMessageKeys.GEN_UnexpectedException, e);
        }
    }

    public void setDelimiters() {
        this.delimiterIdentifierQuoteString = this.getStringValue("delimiters.identifierQuoteString", null);
        String temp = this.getStringValue("delimiters.catalogDelimiter", null);
        this.catalogDelimiterString = temp == null || temp.length() == 0 ? this.getIdentifierQuoteString() : temp;
        temp = this.getStringValue("delimiters.schemaDelimiter", null);
        this.schemaDelimiterString = temp == null || temp.length() == 0 ? this.getIdentifierQuoteString() : temp;
        temp = this.getStringValue("delimiters.tableDelimiter", null);
        this.tableDelimiterString = temp == null || temp.length() == 0 ? this.getIdentifierQuoteString() : temp;
        temp = this.getStringValue("delimiters.columnDelimiter", null);
        this.columnDelimiterString = temp == null || temp.length() == 0 ? this.getIdentifierQuoteString() : temp;
        temp = this.getStringValue("delimiters.catalogSeparator", null);
        this.catalogSeparatorString = temp == null || temp.length() == 0 ? "." : temp;
        this.literalQuoteEscape = this.getStringValue("delimiters.literalQuoteEscape", null);
        this.columnAliasKeywordString = this.getStringValue("keywords.columnAlias", null);
    }

    public void initFunctionCache() {
        Iterator keys = this.config.getKeys();
        try {
            while (keys.hasNext()) {
                String key = (String)keys.next();
                String[] parts = SPLITTER.split(key);
                if (parts.length != 2 || parts[0].equals("olap.Window.Specification")) continue;
                String functionName = parts[0];
                ArrayList<FunctionSignature> funcSigns = this.functionCache.get(functionName);
                if (funcSigns == null) {
                    funcSigns = new ArrayList();
                    this.functionCache.put(functionName, funcSigns);
                }
                String[] inits = parts[1].split(COMMA);
                long[] masks = new long[inits.length];
                for (int i = 0; i < inits.length; ++i) {
                    masks[i] = PropertiesDataTypeMask.getDataTypeMask(inits[i]);
                }
                funcSigns.add(new FunctionSignature(parts[1], masks));
            }
            for (String aKey : this.functionCache.keySet()) {
                ArrayList<FunctionSignature> funcSigns = this.functionCache.get(aKey);
                Collections.sort(funcSigns);
            }
        }
        catch (Exception e) {
            throw XQERuntimeException.wrap(XQEMessageKeys.GEN_UnexpectedException, e);
        }
    }

    private String getMatchingSignatures(String functionName, IDataType[] fArguments) {
        String key = null;
        ArrayList<FunctionSignature> funcSigns = this.functionCache.get(functionName);
        for (int i = 0; funcSigns != null && i < funcSigns.size() && (key = funcSigns.get(i).getMatchingSign(fArguments)) == null; ++i) {
        }
        return key;
    }

    @Override
    public boolean isSupported(String key) {
        return this.getBooleanValue(key, false);
    }

    @Override
    public String getStringValue(String key, String defaultValue) {
        if (key == null) {
            return defaultValue;
        }
        String value = (String)this.stringValueCache.get(key);
        if (null == value && (value = this.config.getString(key, defaultValue)) != null) {
            this.stringValueCache.put(key, value);
        }
        return value;
    }

    @Override
    public int getIntegerValue(String key, int defaultValue) {
        return this.config.getInt(key, defaultValue);
    }

    @Override
    public int getIntegerValue(String key) {
        try {
            return this.config.getInt(key);
        }
        catch (NoSuchElementException ex) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_UnexpectedException, (Throwable)ex);
        }
    }

    @Override
    public double getDoubleValue(String key, double defaultValue) {
        return this.config.getDouble(key, defaultValue);
    }

    @Override
    public double getDoubleValue(String key) {
        try {
            return this.config.getDouble(key);
        }
        catch (NoSuchElementException ex) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_UnexpectedException, (Throwable)ex);
        }
    }

    @Override
    public boolean getBooleanValue(String key, boolean defaultValue) {
        if (key == null) {
            return defaultValue;
        }
        Boolean value = (Boolean)this.booleanValueCache.get(key);
        if (null == value && (value = Boolean.valueOf(this.config.getBoolean(key, defaultValue))) != null) {
            this.booleanValueCache.put(key, value);
        }
        return value;
    }

    @Override
    public boolean getBooleanValue(String key) {
        Boolean value = (Boolean)this.booleanValueCache.get(key);
        if (null == value) {
            try {
                value = this.config.getBoolean(key);
                if (value != null) {
                    this.booleanValueCache.put(key, value);
                }
            }
            catch (NoSuchElementException ex) {
                throw new XQERuntimeException(XQEMessageKeys.GEN_UnexpectedException, (Throwable)ex);
            }
        }
        return value;
    }

    public IDataSource getDatasource() {
        return this.dataSource;
    }

    public String toString() {
        Iterator it = this.config.getKeys();
        StringBuilder buffer = new StringBuilder(NEW_LINE);
        while (it.hasNext()) {
            String key = (String)it.next();
            buffer.append(String.format("%s=%s\n", key, this.config.getString(key)));
        }
        return buffer.toString();
    }

    @Override
    @Deprecated
    public void setStringValue(String key, String newValue) {
        this.setValue(key, newValue);
    }

    @Override
    @Deprecated
    public void setValue(String key, Object newValue) {
        if (!this.copied) {
            MapConfiguration flattenedCapabilities = new MapConfiguration(new HashMap());
            flattenedCapabilities.copy((Configuration)this.config);
            flattenedCapabilities.setListDelimiterHandler(DisabledListDelimiterHandler.INSTANCE);
            flattenedCapabilities.setThrowExceptionOnMissing(true);
            this.config = flattenedCapabilities;
            this.copied = true;
        }
        this.config.clearProperty(key);
        if (newValue != null) {
            this.config.setProperty(key, newValue);
        }
        this.stringValueCache.remove(key);
        this.booleanValueCache.remove(key);
    }

    @Override
    public final String getCatalogDelimiter() {
        return this.catalogDelimiterString;
    }

    @Override
    public final String getSchemaDelimiter() {
        return this.schemaDelimiterString;
    }

    @Override
    public final String getTableDelimiter() {
        return this.tableDelimiterString;
    }

    @Override
    public final String getColumnDelimiter() {
        return this.columnDelimiterString;
    }

    @Override
    public final String getCatalogSeparator() {
        return this.catalogSeparatorString;
    }

    @Override
    public final String getLiteralQuoteEscape() {
        return this.literalQuoteEscape;
    }

    @Override
    public String getIdentifierQuoteString() {
        return this.delimiterIdentifierQuoteString;
    }

    @Override
    public String getColumnAliasKeyword() {
        return this.columnAliasKeywordString;
    }

    @Override
    public void setUseCheckMemberRulesSecondaryQuery(boolean checkMemRules) {
        this.useCheckMemberRulesSecondaryQuery = checkMemRules;
    }

    @Override
    public boolean getUseCheckMemberRulesSecondaryQuery() {
        return this.useCheckMemberRulesSecondaryQuery;
    }

    @Override
    public CapabilitiesKey getKey() {
        return this.capabilitiesKey;
    }

    @Override
    public AbstractConfiguration getConfiguration() {
        return this.config;
    }

    @Override
    public String generateKey(String functionName, IDataType[] fArguments) {
        return this.generateKeyParameters(functionName, fArguments, true);
    }

    @Override
    public String getFunctionPattern(String functionName, IDataType[] fArguments) {
        String matchedKey;
        String pattern = null;
        String key = this.generateKeyParameters(functionName, fArguments, false);
        if (key != null && (pattern = (String)this.stringValueCache.get(key)) == null && (matchedKey = this.generateKey(functionName, fArguments)) != null && (pattern = this.config.getString(matchedKey, null)) != null) {
            this.stringValueCache.put(key, pattern);
        }
        return pattern;
    }

    private String generateKeyParameters(String functionName, IDataType[] fArguments, boolean matchSign) {
        String key = null;
        if (functionName != null && fArguments != null) {
            try {
                if (functionName.startsWith("functions.XML") || functionName.startsWith("functions.JSON") || functionName.startsWith("aggregates.XML") || functionName.startsWith("aggregates.JSON")) {
                    String value = this.getStringValue(functionName, null);
                    if (value != null) {
                        key = functionName;
                    }
                } else if (fArguments.length > 0) {
                    String fSign;
                    if (matchSign) {
                        fSign = this.getMatchingSignatures(functionName, fArguments);
                    } else {
                        StringBuilder sb = new StringBuilder();
                        for (int i = 0; i < fArguments.length; ++i) {
                            if (i != 0) {
                                sb.append(COMMA);
                            }
                            if (fArguments[i] == null) {
                                sb.append(ANY_TYPE);
                                continue;
                            }
                            sb.append(fArguments[i].getTypeName());
                        }
                        fSign = sb.toString();
                    }
                    if (fSign != null) {
                        key = functionName + OPEN_SQUARE_BRACKET + fSign + CLOSED_SQUARE_BRACKET;
                    }
                } else {
                    key = functionName + OPEN_SQUARE_BRACKET + CLOSED_SQUARE_BRACKET;
                    String value = this.getStringValue(key, null);
                    if (value == null) {
                        key = null;
                    }
                }
            }
            catch (XQERuntimeException ex) {
                key = null;
            }
        }
        return key;
    }

    private class FunctionSignature
    implements Comparable<FunctionSignature> {
        private String signString;
        private long[] signMask;

        FunctionSignature(String signStr, long[] mask) {
            this.signString = signStr;
            this.signMask = mask;
        }

        public long[] getSignMask() {
            return this.signMask;
        }

        public String getMatchingSign(IDataType[] fArguments) {
            String dataTypeSigns = null;
            if (fArguments.length == this.signMask.length) {
                for (int i = 0; i < fArguments.length && !(fArguments[i] != null ? (PropertiesDataTypeMask.getDataTypeMask(fArguments[i].getTypeName()) & this.signMask[i]) == 0L : this.signMask[i] != Long.MAX_VALUE); ++i) {
                    if (i + 1 != fArguments.length) continue;
                    dataTypeSigns = this.signString;
                    break;
                }
            }
            return dataTypeSigns;
        }

        @Override
        public int compareTo(FunctionSignature funcInit) {
            int count0 = this.signMask.length;
            long[] maskInput = funcInit.getSignMask();
            int count1 = maskInput.length;
            int paramsCount = 0;
            paramsCount = count0 < count1 ? count0 : count1;
            for (int i = 0; i < paramsCount; ++i) {
                if (this.signMask[i] == maskInput[i]) continue;
                if (this.signMask[i] < maskInput[i]) {
                    return -1;
                }
                return 1;
            }
            return 0;
        }
    }
}

