/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.bibushandler.datasource;

import com.cognos.xqe.bibushandler.datasource.DataSourceCapabilities;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.data.model.CapabilitiesKey;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.model.IDataSourceCapabilities;
import com.cognos.xqe.data.providers.DataSourceTypeEnum;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.util.CollectionCast;
import com.cognos.xqe.util.ConnectionUtil;
import com.cognos.xqe.util.ResourceLocator;
import com.cognos.xqe.util.SingletonHelper;
import com.cognos.xqe.util.pool.XQESAXReaderPool;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.configuration2.AbstractConfiguration;
import org.apache.commons.configuration2.CombinedConfiguration;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.configuration2.builder.BuilderParameters;
import org.apache.commons.configuration2.builder.FileBasedConfigurationBuilder;
import org.apache.commons.configuration2.builder.fluent.FileBasedBuilderParameters;
import org.apache.commons.configuration2.builder.fluent.Parameters;
import org.apache.commons.configuration2.convert.DisabledListDelimiterHandler;
import org.apache.commons.configuration2.convert.ListDelimiterHandler;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.configuration2.tree.DefaultExpressionEngine;
import org.apache.commons.configuration2.tree.ExpressionEngine;
import org.apache.commons.configuration2.tree.NodeCombiner;
import org.apache.commons.configuration2.tree.OverrideCombiner;
import org.apache.commons.io.FileUtils;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.XPath;
import org.dom4j.io.SAXReader;

public final class ProviderCapabilites {
    private static final String XQE = "xqe";
    private static final String VERSION_PLACEHOLDER = "%";
    private static final String CAPABILITY_PATH = "/capabilities/provider[@name='%1$s']/configuration/properties";
    private static final String DEV_VERSION_EXT = ".dev";
    private static final String CAPABILITIES_CONFIG_FILE_NAME = "xqe.capability.xml";
    private boolean overrideConfigInUse = false;
    private static final SingletonHelper<ProviderCapabilites> SINGLETON_HELPER = new SingletonHelper<ProviderCapabilites>(){

        @Override
        protected ProviderCapabilites newInstance() {
            return new ProviderCapabilites(DefaultExpressionEngine.INSTANCE);
        }

        @Override
        protected void initializeImpl(ProviderCapabilites theInstance) {
            theInstance.initialize();
        }

        @Override
        protected void releaseImpl(ProviderCapabilites theInstance) {
        }
    };
    private ResourceLocator.IResourceMatcher[] resourceSearchPath;
    private Document capabiltiesIndexDoc = null;
    private DefaultExpressionEngine expressionEngine;
    private ConcurrentMap<CapabilitiesKey, IDataSourceCapabilities> capabilitiesCache = new ConcurrentHashMap<CapabilitiesKey, IDataSourceCapabilities>();

    private ProviderCapabilites(DefaultExpressionEngine expEngine) {
        this.expressionEngine = expEngine;
    }

    private void initialize() {
        XQEConfiguration xqeConfig = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
        File capabilitiesRoot = FileUtils.getFile((String[])new String[]{xqeConfig.getConfigDirectory(), XQE});
        this.resourceSearchPath = new ResourceLocator.IResourceMatcher[]{new ResourceLocator.DirectoryResourceMatcher(capabilitiesRoot), new ResourceLocator.ClassResourceMatcher(this.getClass(), "/META-INF/xqe/configuration/xqe/")};
        String configFileName = System.getProperty("CapabilityFileName");
        URL configURL = null;
        if (configFileName == null) {
            configFileName = CAPABILITIES_CONFIG_FILE_NAME;
            configURL = ResourceLocator.findURL(configFileName, this.resourceSearchPath);
        } else {
            configURL = this.fileNameToURL(configFileName);
            this.overrideConfigInUse = true;
        }
        if (configURL == null) {
            throw new XQERuntimeException(XQEMessageKeys.CFG_FileExistError, configFileName);
        }
        this.loadCapabiltiesIndex(configURL);
    }

    private void loadCapabiltiesIndex(URL configURL) {
        RuntimeException exception;
        block5: {
            SAXReader reader = null;
            exception = null;
            try {
                reader = XQESAXReaderPool.getInstance().borrowReader();
                this.capabiltiesIndexDoc = reader.read(configURL);
            }
            catch (Exception e) {
                exception = XQERuntimeException.wrap(XQEMessageKeys.GEN_UnexpectedException, e);
            }
            try {
                XQESAXReaderPool.getInstance().returnReader(reader);
            }
            catch (Exception e) {
                if (exception != null) break block5;
                exception = XQERuntimeException.wrap(e);
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    private URL locatePropertyResourceURL(String resourceName) {
        if (this.overrideConfigInUse && resourceName.contains("/")) {
            return this.fileNameToURL(resourceName);
        }
        return ResourceLocator.findURL(resourceName, this.resourceSearchPath);
    }

    private URL fileNameToURL(String fileName) {
        try {
            File file = new File(fileName.replace('/', File.separatorChar));
            if (file.exists()) {
                return file.toURI().toURL();
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return null;
    }

    public AbstractConfiguration resolveProviderCapabilities(CapabilitiesKey key) {
        CombinedConfiguration result = null;
        Map<String, AbstractConfiguration> builtInConfigs = key.getBuiltInConfigs();
        try {
            XPath xpathSelector = null;
            xpathSelector = DataSourceTypeEnum.isGenericJDBC(key.getProviderType()) ? DocumentHelper.createXPath((String)String.format(CAPABILITY_PATH, "JDBC")) : (null == key.getSubType() ? DocumentHelper.createXPath((String)String.format(CAPABILITY_PATH, key.getProviderType())) : DocumentHelper.createXPath((String)String.format("/capabilities/provider[@name='%1$s' and @subtype='%2$s']/configuration/properties", key.getProviderType(), key.getSubType())));
            List<Node> files = CollectionCast.uncheckedCast(xpathSelector.selectNodes((Object)this.capabiltiesIndexDoc));
            OverrideCombiner combiner = new OverrideCombiner();
            CombinedConfiguration combinedConfig = new CombinedConfiguration((NodeCombiner)combiner);
            combinedConfig.setThrowExceptionOnMissing(true);
            combinedConfig.setExpressionEngine((ExpressionEngine)this.expressionEngine);
            for (Node fe : files) {
                AbstractConfiguration config;
                String configName;
                String fileName = ((Element)fe).attributeValue("fileName");
                if (fileName != null) {
                    URL propFile = null;
                    URL propDevFile = null;
                    if (fileName.contains(VERSION_PLACEHOLDER)) {
                        String versionedFileName = fileName;
                        String version = key.getVersion();
                        if (null != version) {
                            versionedFileName = String.format(fileName, key.getProviderTypeOverride(), key.getSubType(), version);
                        }
                        propFile = this.locatePropertyResourceURL(versionedFileName);
                        propDevFile = this.locatePropertyResourceURL(versionedFileName + DEV_VERSION_EXT);
                        while (propFile == null) {
                            if (null == (version = ProviderCapabilites.trimVersion(version))) {
                                propFile = this.locatePropertyResourceURL(fileName);
                                break;
                            }
                            versionedFileName = String.format(fileName, key.getProviderTypeOverride(), key.getSubType(), version);
                            propFile = this.locatePropertyResourceURL(versionedFileName);
                            propDevFile = this.locatePropertyResourceURL(versionedFileName + DEV_VERSION_EXT);
                        }
                    } else {
                        propFile = this.locatePropertyResourceURL(fileName);
                        propDevFile = this.locatePropertyResourceURL(fileName + DEV_VERSION_EXT);
                    }
                    if (propDevFile != null) {
                        XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "Configuration", LogLevel.TRACE).log(LogLevel.TRACE, "Loading " + propDevFile.toExternalForm() + " configuration file");
                        this.loadConfigFile(propDevFile, combinedConfig);
                    }
                    if (propFile == null) continue;
                    XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "Configuration", LogLevel.TRACE).log(LogLevel.TRACE, "Attempting to load " + propFile.toExternalForm());
                    this.loadConfigFile(propFile, combinedConfig);
                    continue;
                }
                if (builtInConfigs == null || (configName = ((Element)fe).attributeValue("configName")) == null || null == (config = builtInConfigs.get(configName))) continue;
                combinedConfig.addConfiguration((Configuration)config);
            }
            result = combinedConfig;
        }
        catch (ConfigurationException e) {
            throw new XQERuntimeException(e);
        }
        return result;
    }

    private void loadConfigFile(URL propFile, CombinedConfiguration combinedConfig) throws ConfigurationException {
        FileBasedConfigurationBuilder builder = new FileBasedConfigurationBuilder(PropertiesConfiguration.class).configure(new BuilderParameters[]{(BuilderParameters)((FileBasedBuilderParameters)((FileBasedBuilderParameters)new Parameters().fileBased().setListDelimiterHandler((ListDelimiterHandler)new DisabledListDelimiterHandler())).setThrowExceptionOnMissing(true)).setURL(propFile)});
        PropertiesConfiguration conf = (PropertiesConfiguration)builder.getConfiguration();
        combinedConfig.addConfiguration((Configuration)conf);
    }

    public void addCapabilities(CapabilitiesKey key, IDataSourceCapabilities datasourceCapabilities) {
        this.capabilitiesCache.put(key, datasourceCapabilities);
    }

    public IDataSourceCapabilities getCapabilities(CapabilitiesKey key) {
        return (IDataSourceCapabilities)this.capabilitiesCache.get(key);
    }

    public void setProperty(CapabilitiesKey key, String propertyKey, Object property) {
        IDataSourceCapabilities cachedCapabilities = this.getCapabilities(key);
        AbstractConfiguration config = null;
        if (cachedCapabilities == null) {
            config = this.resolveProviderCapabilities(key);
            this.addCapabilities(key, new DataSourceCapabilities(key, config));
        } else {
            config = cachedCapabilities.getConfiguration();
        }
        config.setProperty(propertyKey, property);
    }

    private static String trimVersion(String version) {
        if (null == version || version.length() == 0) {
            return null;
        }
        int lastSeperatorIndex = version.lastIndexOf(46);
        if (lastSeperatorIndex < 0) {
            return null;
        }
        return version.substring(0, lastSeperatorIndex);
    }

    public static ProviderCapabilites getInstance() {
        return SINGLETON_HELPER.getInstance();
    }

    public static void releaseInstance() {
        SINGLETON_HELPER.releaseInstance();
    }

    public IDataSourceCapabilities getOrAddDatasourceCapabilities(IDataSource dataSource) {
        return this.getOrAddDatasourceCapabilities(dataSource, null);
    }

    public IDataSourceCapabilities getOrAddDatasourceCapabilities(IDataSource dataSource, String version) {
        IDataSourceCapabilities capabilities = null;
        CapabilitiesKey key = ProviderCapabilites.createCapabilitiesKey(dataSource, version);
        capabilities = this.getCapabilities(key);
        if (capabilities != null) {
            dataSource.setCapabilities(capabilities);
        }
        return capabilities;
    }

    public static CapabilitiesKey createCapabilitiesKey(IDataSource dataSource) {
        return ProviderCapabilites.createCapabilitiesKey(dataSource, null);
    }

    public static CapabilitiesKey createCapabilitiesKey(IDataSource dataSource, String version) {
        CapabilitiesKey key = null;
        key = DataSourceTypeEnum.isJDBC(dataSource.getType()) || DataSourceTypeEnum.isTM1(dataSource.getType()) ? new CapabilitiesKey(null, version, null, ConnectionUtil.getConnectionString(dataSource)) : (DataSourceTypeEnum.isTMR(dataSource.getType()) ? new CapabilitiesKey(dataSource.getType(), version) : new CapabilitiesKey(dataSource.getType()));
        return key;
    }

    public IDataSourceCapabilities getOrAddProviderCapabilities(String providerType) {
        CapabilitiesKey key = new CapabilitiesKey(providerType);
        IDataSourceCapabilities capabilities = this.getCapabilities(key);
        if (capabilities == null) {
            capabilities = new DataSourceCapabilities(key, this.resolveProviderCapabilities(key));
            this.addCapabilities(key, capabilities);
        }
        return capabilities;
    }

    public void refreshCapabilitiesCache() {
        this.capabilitiesCache.clear();
    }

    public void reset() {
        this.capabilitiesCache.clear();
        this.initialize();
    }
}

