/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.bibushandler.recorder;

import com.cognos.xqe.bibushandler.recorder.Event;
import com.cognos.xqe.util.xml.stax.ChildElementIterator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

public final class EventLog
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String XML_ELEM_EVENT_LOG = "eventLog";
    private static final String XML_ATTR_SIZE = "size";
    private final List<Event> mEvents;
    private int mIndex = -1;

    public EventLog() {
        this.mEvents = new ArrayList<Event>();
    }

    public EventLog(int initialCapacity) {
        this.mEvents = new ArrayList<Event>(initialCapacity);
    }

    public synchronized int getIndex() {
        return this.mIndex;
    }

    public synchronized void setIndex(int index) {
        this.mIndex = index;
    }

    public synchronized boolean hasNext() {
        return this.mIndex + 1 < this.mEvents.size();
    }

    public synchronized Event current() {
        return this.mEvents.get(this.mIndex);
    }

    public synchronized Event next() {
        if (this.mIndex + 1 < this.mEvents.size()) {
            ++this.mIndex;
        } else {
            return null;
        }
        return this.mEvents.get(this.mIndex);
    }

    public synchronized void rewind() {
        this.mIndex = -1;
    }

    public synchronized boolean isEmpty() {
        return this.mEvents.isEmpty();
    }

    public synchronized int size() {
        return this.mEvents.size();
    }

    public synchronized void add(Event event) {
        this.mEvents.add(event);
    }

    public synchronized void clear() {
        this.mEvents.clear();
        this.mIndex = -1;
    }

    public void serialize(XMLStreamWriter writer) throws XMLStreamException {
        writer.writeStartElement(XML_ELEM_EVENT_LOG);
        writer.writeAttribute(XML_ATTR_SIZE, Integer.toString(this.mEvents.size()));
        for (int i = 0; i < this.mEvents.size(); ++i) {
            this.mEvents.get(i).serialize(writer);
        }
        writer.writeEndElement();
    }

    public static EventLog deserialize(XMLStreamReader reader) throws XMLStreamException {
        reader.require(1, null, XML_ELEM_EVENT_LOG);
        int size = Integer.parseInt(reader.getAttributeValue(null, XML_ATTR_SIZE));
        EventLog eventLog = new EventLog(size);
        ChildElementIterator childIter = new ChildElementIterator(reader);
        while (childIter.next()) {
            eventLog.add(Event.deserialize(reader));
        }
        return eventLog;
    }
}

