/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.cache;

import com.cognos.xqe.cache.ICacheListener;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class CacheMetricsTracker
implements ICacheListener {
    ReadWriteLock rwLock = null;
    long hits = 0L;
    long misses = 0L;
    double avgMissTime = 0.0;
    long missData = 0L;

    public CacheMetricsTracker(boolean threadSafe) {
        if (!threadSafe) {
            this.rwLock = new ReentrantReadWriteLock();
        }
    }

    private void lockRead() {
        if (this.rwLock != null) {
            this.rwLock.readLock().lock();
        }
    }

    private void unlockRead() {
        if (this.rwLock != null) {
            this.rwLock.readLock().unlock();
        }
    }

    private void lockWrite() {
        if (this.rwLock != null) {
            this.rwLock.writeLock().lock();
        }
    }

    private void unlockWrite() {
        if (this.rwLock != null) {
            this.rwLock.writeLock().unlock();
        }
    }

    @Override
    public void incrementHits() {
        this.lockWrite();
        try {
            ++this.hits;
        }
        finally {
            this.unlockWrite();
        }
    }

    @Override
    public void incrementHits(long hitCount) {
        this.lockWrite();
        try {
            this.hits += hitCount;
        }
        finally {
            this.unlockWrite();
        }
    }

    @Override
    public void incrementMisses() {
        this.lockWrite();
        try {
            ++this.misses;
        }
        finally {
            this.unlockWrite();
        }
    }

    @Override
    public void incrementMisses(long missCount) {
        this.lockWrite();
        try {
            this.misses += missCount;
        }
        finally {
            this.unlockWrite();
        }
    }

    public void incrementAvgMissTime(long time) {
        this.lockWrite();
        try {
            this.avgMissTime = (this.avgMissTime + (double)time) / 2.0;
        }
        finally {
            this.unlockWrite();
        }
    }

    public void incrementAvgMissTime(double time) {
        this.lockWrite();
        try {
            this.avgMissTime = (this.avgMissTime + time) / 2.0;
        }
        finally {
            this.unlockWrite();
        }
    }

    public void incrementMissData(long increment) {
        this.lockWrite();
        try {
            this.missData += increment;
        }
        finally {
            this.unlockWrite();
        }
    }

    public void incrementAll(CacheMetricsTracker tracker) {
        this.lockWrite();
        try {
            this.hits += tracker.hits;
            this.misses += tracker.misses;
            this.avgMissTime = (this.avgMissTime + tracker.avgMissTime) / 2.0;
        }
        finally {
            this.unlockWrite();
        }
    }

    public long getHits() {
        this.lockRead();
        try {
            long l = this.hits;
            return l;
        }
        finally {
            this.unlockRead();
        }
    }

    public long getMisses() {
        this.lockRead();
        try {
            long l = this.misses;
            return l;
        }
        finally {
            this.unlockRead();
        }
    }

    public long getRequests() {
        this.lockRead();
        try {
            long l = this.hits + this.misses;
            return l;
        }
        finally {
            this.unlockRead();
        }
    }

    public double getMissTime() {
        this.lockRead();
        try {
            double d = this.avgMissTime;
            return d;
        }
        finally {
            this.unlockRead();
        }
    }

    public long getMissData() {
        this.lockRead();
        try {
            long l = this.missData;
            return l;
        }
        finally {
            this.unlockRead();
        }
    }

    public void clear() {
        this.lockWrite();
        try {
            this.hits = 0L;
            this.misses = 0L;
            this.avgMissTime = 0.0;
            this.missData = 0L;
        }
        finally {
            this.unlockWrite();
        }
    }
}

