/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.cache.storage;

import com.cognos.xqe.cache.CacheException;
import com.cognos.xqe.cache.ICacheKey;
import com.cognos.xqe.cache.ICacheStorage;
import com.cognos.xqe.cache.ICacheableObject;
import com.cognos.xqe.cache.storage.InvalidCacheObjectException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.StringReader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.xindice.core.DBException;
import org.apache.xindice.core.data.Key;
import org.apache.xindice.core.data.Record;
import org.apache.xindice.core.data.Value;
import org.apache.xindice.core.filer.BTreeFiler;
import org.apache.xindice.core.filer.BTreeNotFoundException;
import org.apache.xindice.core.filer.Filer;
import org.apache.xindice.util.Configuration;
import org.apache.xindice.util.ReadOnlyException;
import org.apache.xindice.util.XindiceException;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class BTreeCacheStorage
implements ICacheStorage {
    private static final String UNKNOWN_NAME = "unknown";
    private static final int DEFAULT_PAGE_SIZE = 256;
    private static int pageSize;
    private static final int DEFAULT_MAX_DESCRIPTORS = 64;
    private static int maxDescriptors;
    private static final int DEFAULT_PAGE_COUNT = 256;
    private static int initialPageCount;
    private static final int DEFAULT_FLUSH_FREQUENCY = 100000;
    private static int flushFrequency;
    private static final String TBL = ".tbl";
    private File mCacheDir;
    private String mCacheName;
    private boolean mReplace;
    private ReadWriteLock rwLock = new ReentrantReadWriteLock();
    Map<Object, Filer> storageMap = new HashMap<Object, Filer>();
    ReadWriteLock mapLock = new ReentrantReadWriteLock();
    Map<Object, AtomicInteger> flushMap = new HashMap<Object, AtomicInteger>();
    private static final int LONG_BYTE_SIZE = 8;
    private static final int BYTE_BITMASK = 255;
    private static int[] byteLocation;
    private int cacheElements;
    private int cacheSizebytes;

    private Filer createCacheStorage(String cacheName, String cachePartition, boolean replace) throws CacheException {
        try {
            String fileName = cacheName + "_part_" + cachePartition;
            File cacheFile = new File(this.mCacheDir + File.separator + fileName + TBL);
            if (replace && cacheFile.exists() && !cacheFile.delete()) {
                throw new CacheException.FileRemovalFailure(cacheFile.getAbsolutePath());
            }
            BTreeFiler storage = new BTreeFiler();
            storage.setLocation(this.mCacheDir, fileName);
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder parser = factory.newDocumentBuilder();
            InputSource src = new InputSource(new StringReader("<xindice>    <root-collection dbroot='./db/' name='db'>        <queryengine>            <resolver autoindex='false' class='org.apache.xindice.core.query.XPathQueryResolver'/>            <resolver class='org.apache.xindice.core.xupdate.XUpdateQueryResolver'/>        </queryengine>    </root-collection>    <xml-rpc>        <driver name='xerces'/>    </xml-rpc></xindice>"));
            Document document = parser.parse(src);
            Configuration btreeConfig = new Configuration(document, false);
            btreeConfig.setAttribute("maxkeysize", 8);
            btreeConfig.setAttribute("pagesize", pageSize);
            btreeConfig.setAttribute("max-descriptors", maxDescriptors);
            btreeConfig.setAttribute("pagecount", initialPageCount);
            storage.setConfig(btreeConfig);
            if (!storage.exists()) {
                storage.create();
            }
            storage.open();
            return storage;
        }
        catch (ReadOnlyException e) {
            throw new CacheException.UnexpectedError(e);
        }
        catch (SAXException e) {
            throw new CacheException.UnexpectedError(e);
        }
        catch (IOException e) {
            throw new CacheException.UnexpectedError(e);
        }
        catch (DBException e) {
            throw new CacheException.CreationFailed(e);
        }
        catch (XindiceException e) {
            throw new CacheException.UnexpectedError(e);
        }
        catch (Throwable e) {
            throw new CacheException.UnexpectedError(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Filer getPartitionedStorage(ICacheKey key) throws CacheException {
        Filer store;
        this.mapLock.readLock().lock();
        try {
            store = this.storageMap.get(key.getPartition());
        }
        finally {
            this.mapLock.readLock().unlock();
        }
        if (store == null) {
            this.mapLock.writeLock().lock();
            try {
                store = this.storageMap.get(key.getPartition());
                if (store == null) {
                    store = this.createCacheStorage(this.mCacheName, key.getPartition().toString(), this.mReplace);
                    this.storageMap.put(key.getPartition(), store);
                    this.flushMap.put(key.getPartition(), new AtomicInteger(0));
                }
            }
            finally {
                this.mapLock.writeLock().unlock();
            }
        }
        return store;
    }

    private void flushStorageForKey(ICacheKey key) throws CacheException {
        int count = 0;
        this.mapLock.readLock().lock();
        try {
            count = this.flushMap.get(key.getPartition()).incrementAndGet();
        }
        finally {
            this.mapLock.readLock().unlock();
        }
        if (count % flushFrequency == 0) {
            Filer store = this.getPartitionedStorage(key);
            try {
                store.flush();
            }
            catch (DBException e) {
                throw new CacheException.FileIOError(store.getName(), e);
            }
        }
    }

    private Filer findStorage(ICacheKey key) throws CacheException {
        return this.getPartitionedStorage(key);
    }

    public BTreeCacheStorage(String cacheDirName, String cacheName, boolean replace) throws CacheException {
        byteLocation = new int[8];
        for (int i = 0; i < 8; ++i) {
            BTreeCacheStorage.byteLocation[i] = (7 - i) * 8;
        }
        this.cacheElements = 0;
        this.cacheSizebytes = 0;
        this.mCacheName = cacheName;
        this.mReplace = replace;
        this.mCacheDir = new File(cacheDirName);
        if (!this.mCacheDir.exists() && !this.mCacheDir.mkdir()) {
            throw new CacheException.DirectoryCreationFailure(this.mCacheDir.getAbsolutePath());
        }
    }

    private Key convertKey(ICacheKey cacheKey) {
        return new Key(BTreeCacheStorage.convertLong(cacheKey.getLong()));
    }

    public static byte[] convertLong(long value) {
        byte[] result = new byte[8];
        for (int i = 0; i < 8; ++i) {
            result[i] = (byte)(value >> byteLocation[i] & 0xFFL);
        }
        return result;
    }

    @Override
    public boolean contains(ICacheKey key) throws CacheException {
        Filer filer = null;
        this.rwLock.readLock().lock();
        try {
            filer = this.findStorage(key);
            Record record = filer.readRecord(this.convertKey(key));
            if (record != null) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (BTreeNotFoundException e) {
            boolean bl = false;
            return bl;
        }
        catch (DBException e) {
            String name = filer.getName();
            throw new CacheException.FileIOError(name, e);
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    @Override
    public ICacheableObject get(ICacheKey key) throws CacheException {
        try {
            if (key.getCacheableObjectClass() != null) {
                return this.get(key, (ICacheableObject)key.getCacheableObjectClass().newInstance());
            }
        }
        catch (IllegalAccessException e) {
            throw new CacheException.UnexpectedError(e);
        }
        catch (InstantiationException e) {
            throw new InvalidCacheObjectException(e);
        }
        return null;
    }

    @Override
    public ICacheableObject get(ICacheKey key, ICacheableObject shell) throws CacheException {
        Filer filer = null;
        this.rwLock.readLock().lock();
        try {
            filer = this.findStorage(key);
            Record record = filer.readRecord(this.convertKey(key));
            if (record != null) {
                ByteArrayInputStream byteStream = new ByteArrayInputStream(record.getValue().getData());
                ObjectInputStream in = new ObjectInputStream(byteStream);
                shell.readFromStream(in);
                ICacheableObject iCacheableObject = shell;
                return iCacheableObject;
            }
            ICacheableObject byteStream = null;
            return byteStream;
        }
        catch (IOException e) {
            throw new CacheException.ObjectCreationException(e);
        }
        catch (ClassNotFoundException e) {
            throw new CacheException.ObjectCreationException(e);
        }
        catch (BTreeNotFoundException e) {
            ICacheableObject byteStream = null;
            return byteStream;
        }
        catch (DBException e) {
            String name = filer.getName();
            throw new CacheException.FileIOError(name, e);
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    @Override
    public void put(ICacheKey key, ICacheableObject obj) throws CacheException {
        Filer filer = null;
        this.rwLock.writeLock().lock();
        try {
            Value value = this.createValue(obj);
            Key bKey = this.convertKey(key);
            filer = this.findStorage(key);
            filer.writeRecord(bKey, value);
        }
        catch (DBException e) {
            throw new CacheException.FileIOError(filer.getName(), e);
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
        this.flushStorageForKey(key);
    }

    @Override
    public boolean localReferences() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void close() throws CacheException {
        this.rwLock.writeLock().lock();
        try {
            for (Filer filer : this.storageMap.values()) {
                try {
                    filer.drop();
                }
                catch (DBException e) {
                    throw new CacheException.FileIOError(filer.getName(), e);
                    return;
                }
            }
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void flush() throws CacheException {
        this.rwLock.writeLock().lock();
        try {
            for (Filer filer : this.storageMap.values()) {
                try {
                    filer.flush();
                }
                catch (DBException e) {
                    throw new CacheException.FileIOError(filer.getName(), e);
                    return;
                }
            }
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() throws CacheException {
        this.mapLock.writeLock().lock();
        try {
            for (Map.Entry<Object, Filer> entry : this.storageMap.entrySet()) {
                Filer store = entry.getValue();
                this.rwLock.writeLock().lock();
                try {
                    if (!store.isOpened()) continue;
                    store.close();
                    store.drop();
                }
                catch (DBException dbEx) {
                    throw new CacheException.FileIOError(store.getName(), dbEx);
                }
                finally {
                    this.rwLock.writeLock().unlock();
                }
            }
            this.storageMap.clear();
        }
        finally {
            this.mapLock.writeLock().unlock();
        }
    }

    @Override
    public int getFreeSize() {
        return 0;
    }

    private Value createValue(ICacheableObject obj) throws CacheException {
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        try {
            ObjectOutputStream out = new ObjectOutputStream(byteStream);
            obj.writeToStream(out);
            out.flush();
        }
        catch (IOException e) {
            throw new CacheException.ObjectSerializationException(e);
        }
        return new Value(byteStream.toByteArray());
    }

    @Override
    public void bulkPut(List<ICacheKey> keys, List<ICacheableObject> objs) throws CacheException {
        Key[] bKeys = new Key[keys.size()];
        Value[] values = new Value[keys.size()];
        for (int i = 0; i < keys.size(); ++i) {
            bKeys[i] = this.convertKey(keys.get(i));
            values[i] = this.createValue(objs.get(i));
        }
        this.rwLock.writeLock().lock();
        try {
            BTreeFiler filer = (BTreeFiler)this.findStorage(keys.get(0));
            if (filer != this.findStorage(keys.get(keys.size() - 1))) {
                throw new CacheException.InternalError();
            }
            filer.bulkLoad(bKeys, values);
            this.flushStorageForKey(keys.get(0));
        }
        catch (DBException e) {
            throw new CacheException.UnexpectedError(e);
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
    }

    public int getCacheSize() {
        return this.cacheElements;
    }

    public int getCacheSizeBytes() {
        return this.cacheSizebytes;
    }

    @Override
    public void remove(ICacheKey key) throws CacheException {
        Filer filer = null;
        this.rwLock.writeLock().lock();
        try {
            Key bKey = this.convertKey(key);
            filer = this.findStorage(key);
            filer.deleteRecord(bKey);
        }
        catch (DBException e) {
            throw new CacheException.FileIOError(filer.getName(), e);
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
        this.flushStorageForKey(key);
    }

    static {
        String flushProperty;
        String initialPageCountProperty;
        String maxDescriptorsProperty;
        pageSize = 256;
        maxDescriptors = 64;
        initialPageCount = 256;
        flushFrequency = 100000;
        String pageSizeProperty = System.getProperty("CACHE_PAGE_SIZE");
        if (pageSizeProperty != null) {
            pageSize = Integer.parseInt(pageSizeProperty);
        }
        if ((maxDescriptorsProperty = System.getProperty("CACHE_MAX_DESCRIPTORS")) != null) {
            maxDescriptors = Integer.parseInt(maxDescriptorsProperty);
        }
        if ((initialPageCountProperty = System.getProperty("CACHE_INITIAL_PAGE_COUNT")) != null) {
            initialPageCount = Integer.parseInt(initialPageCountProperty);
        }
        if ((flushProperty = System.getProperty("CACHE_FLUSH_FREQUENCY")) != null) {
            flushFrequency = Integer.parseInt(flushProperty);
        }
    }
}

