/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.cache.storage;

import com.cognos.xqe.cache.CacheException;
import com.cognos.xqe.cache.ICacheKey;
import com.cognos.xqe.cache.ICacheableObject;
import com.cognos.xqe.cache.storage.HashmapCacheStorage;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;

public class BufferHashmapCacheStorage
extends HashmapCacheStorage {
    private Map<ICacheKey, ByteBuffer> bufferStorage = new HashMap<ICacheKey, ByteBuffer>();

    @Override
    public boolean localReferences() {
        return false;
    }

    @Override
    public ICacheableObject get(ICacheKey key, ICacheableObject shell) throws CacheException {
        ByteBuffer buf = this.bufferStorage.get(key);
        if (buf != null) {
            shell.inflateObject(buf);
            buf.rewind();
            return shell;
        }
        return null;
    }

    @Override
    public void put(ICacheKey key, ICacheableObject obj) throws CacheException {
        ByteBuffer buf = ByteBuffer.allocate(obj.getSize());
        obj.deflateObject(buf);
        buf.rewind();
        this.bufferStorage.put(key, buf);
    }

    @Override
    public boolean contains(ICacheKey key) {
        return this.bufferStorage.containsKey(key);
    }

    @Override
    public void remove(ICacheKey key) throws CacheException {
        this.bufferStorage.remove(key);
    }
}

