/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.cache.transformer;

import com.cognos.xqe.cache.transformer.Transformer;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.record.ActionRecord;
import com.cognos.xqe.metadata.record.AliasRecord;
import com.cognos.xqe.metadata.record.CatalogRecord;
import com.cognos.xqe.metadata.record.CubeRecord;
import com.cognos.xqe.metadata.record.DimensionRecord;
import com.cognos.xqe.metadata.record.HierarchyRecord;
import com.cognos.xqe.metadata.record.LevelRecord;
import com.cognos.xqe.metadata.record.MacroRecord;
import com.cognos.xqe.metadata.record.MeasureRecord;
import com.cognos.xqe.metadata.record.MemberRecord;
import com.cognos.xqe.metadata.record.MetadataRecord;
import com.cognos.xqe.metadata.record.NamedSetRecord;
import com.cognos.xqe.metadata.record.PropertyRecord;
import com.cognos.xqe.metadata.record.RecordType;
import com.cognos.xqe.metadata.record.VariableRecord;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class StringToMetadataRecordListTransformer
implements Transformer<String, List<? extends MetadataRecord>> {
    @Override
    public String inflateKey(ObjectInputStream stream) {
        String answer = null;
        try {
            answer = (String)stream.readObject();
        }
        catch (IOException e) {
            throw new XQERuntimeException(e);
        }
        catch (ClassNotFoundException e) {
            throw new XQERuntimeException(e);
        }
        return answer;
    }

    @Override
    public List<? extends MetadataRecord> inflateValue(ObjectInputStream stream) {
        List answer = Collections.emptyList();
        try {
            int size = stream.readInt();
            answer = new ArrayList(size);
            for (int i = 0; i < size; ++i) {
                answer.add(this.inflateMetadataRecordValue(stream));
            }
        }
        catch (IOException e) {
            throw new XQERuntimeException(e);
        }
        return answer;
    }

    protected MetadataRecord inflateMetadataRecordValue(ObjectInputStream stream) {
        MetadataRecord record = null;
        try {
            RecordType type = RecordType.values()[stream.readInt()];
            switch (type) {
                case CATALOG: {
                    record = new CatalogRecord();
                    break;
                }
                case CUBE: {
                    record = new CubeRecord();
                    break;
                }
                case DIMENSION: {
                    record = new DimensionRecord();
                    break;
                }
                case HIERARCHY: {
                    record = new HierarchyRecord();
                    break;
                }
                case LEVEL: {
                    record = new LevelRecord();
                    break;
                }
                case MEMBER: {
                    record = new MemberRecord();
                    break;
                }
                case MEASURE: {
                    record = new MeasureRecord();
                    break;
                }
                case PROPERTY: {
                    record = new PropertyRecord();
                    break;
                }
                case MACRO: {
                    record = new MacroRecord();
                    break;
                }
                case NAMEDSET: {
                    record = new NamedSetRecord();
                    break;
                }
                case ALIAS: {
                    record = new AliasRecord();
                    break;
                }
                case ACTION: {
                    record = new ActionRecord();
                    break;
                }
                case VARIABLE: {
                    record = new VariableRecord();
                    break;
                }
                default: {
                    throw new RuntimeException("Don't know how to inflate a " + (Object)((Object)type));
                }
            }
            record.deexternalize(stream);
        }
        catch (IOException e) {
            throw new XQERuntimeException(e);
        }
        return record;
    }

    @Override
    public void serializeKey(String key, ObjectOutputStream stream) {
        try {
            stream.writeObject(key);
        }
        catch (IOException e) {
            throw new XQERuntimeException(e);
        }
    }

    @Override
    public void serializeValue(List<? extends MetadataRecord> value, ObjectOutputStream stream) {
        try {
            stream.writeInt(value.size());
            for (MetadataRecord metadataRecord : value) {
                this.serializeMetadataRecordValue(metadataRecord, stream);
            }
        }
        catch (IOException e) {
            throw new XQERuntimeException(e);
        }
    }

    protected void serializeMetadataRecordValue(MetadataRecord value, ObjectOutputStream stream) {
        try {
            stream.writeInt(value.getRecordType().ordinal());
            value.externalize(stream);
        }
        catch (IOException e) {
            throw new XQERuntimeException(e);
        }
    }
}

