/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.cache.xindice;

import com.cognos.xqe.bibushandler.XQEService;
import com.cognos.xqe.cache.transformer.Transformer;
import com.cognos.xqe.cache.xindice.XindiceBackedMap;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.util.SingletonHelper;
import com.cognos.xqe.util.SoftRefCache;
import com.cognos.xqe.util.io.FileCleanerService;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.Serializable;
import java.util.BitSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

public final class XindiceCacheManager {
    private static final long INTEGRITY_SCAN_PERIOD = 10000L;
    private static final String CACHE_FILE_PREFIX = "xindice_";
    private static final String CACHE_FILE_SUFFIX = ".cache.tbl";
    private File dataDirectory = null;
    private Map<String, MapRecord> masterTable = new HashMap<String, MapRecord>();
    private final SoftRefCache<String, XindiceBackedMap<?, ?>> activeMaps = new SoftRefCache();
    private XQELogger logger;
    private long lastIntegrityScanTime = 0L;
    private static SingletonHelper<XindiceCacheManager> singletonHelper = new SingletonHelper<XindiceCacheManager>(){

        @Override
        protected XindiceCacheManager newInstance() {
            return new XindiceCacheManager();
        }

        @Override
        protected void releaseImpl(XindiceCacheManager theInstance) {
            theInstance.release();
        }

        @Override
        protected void initializeImpl(XindiceCacheManager theInstance) {
            theInstance.initialize();
        }
    };

    private XindiceCacheManager() {
    }

    public File getDataDirectory() {
        return this.dataDirectory;
    }

    public synchronized <K, V> XindiceBackedMap<K, V> getMap(String name, Transformer<K, V> transformer, boolean reuse, long diskLifeSpan, boolean autoFlush, boolean compressed, boolean encrypted) {
        StringBuilder buffer;
        if (this.logger.isOn(LogLevel.INFO)) {
            StringBuilder buffer2 = new StringBuilder();
            buffer2.append("Getting Map named ").append(name).append(" with reuse=").append(reuse).append(", diskLifeSpan=").append(diskLifeSpan).append(", autoFlush=").append(autoFlush).append(", compressed=").append(compressed).append(", encrypted=").append(encrypted);
            this.logger.log(LogLevel.INFO, buffer2.toString());
        }
        this.integrityScan();
        XindiceBackedMap<Object, Object> answer = null;
        boolean dropCachedData = false;
        MapRecord record = this.masterTable.get(name);
        if (record == null) {
            record = new MapRecord();
            record.setCacheFile(this.createCacheFile());
            if (this.logger.isOn(LogLevel.TRACE)) {
                buffer = new StringBuilder();
                buffer.append("Creating new cache file ").append(record.getCacheFile().getPath());
                this.logger.log(LogLevel.TRACE, buffer.toString());
            }
        } else {
            if (this.logger.isOn(LogLevel.TRACE)) {
                buffer = new StringBuilder();
                buffer.append("Using existing cache file ").append(record.getCacheFile().getPath());
                this.logger.log(LogLevel.TRACE, buffer.toString());
            }
            if (record.isCompressed() != compressed) {
                this.logger.log(LogLevel.WARN, "Compression setting is inconsistent with existing cached data - dropping contents.");
                dropCachedData = true;
            } else if (record.isEncrypted() != encrypted) {
                this.logger.log(LogLevel.WARN, "Encryption setting is inconsistent with existing cached data - dropping contents.");
                dropCachedData = true;
            } else if (diskLifeSpan > 0L && System.currentTimeMillis() - record.getCacheFile().lastModified() > diskLifeSpan) {
                this.logger.log(LogLevel.WARN, "Disk life span exceeded by existing file - dropping contents.");
                dropCachedData = true;
            }
        }
        answer = this.activeMaps.get(name);
        if (dropCachedData) {
            if (null != answer) {
                this.logger.log(LogLevel.WARN, "An incompatible cache instance is already in use - it will be clobbered!");
            }
            if (record.getCacheFile().exists()) {
                FileCleanerService.getInstance().deleteLater(record.getCacheFile());
            }
            record.setCacheFile(this.createCacheFile());
        }
        if (null == answer || dropCachedData) {
            try {
                answer = new XindiceBackedMap<K, V>(record.getCacheFile(), transformer, reuse, autoFlush, compressed, encrypted);
            }
            catch (XQERuntimeException ex) {
                if (ex.getMessageKey() == XQEMessageKeys.CSH_XindiceFilerDropFailed) {
                    if (record.getCacheFile().exists()) {
                        FileCleanerService.getInstance().deleteLater(record.getCacheFile());
                    }
                    record.setCacheFile(this.createCacheFile());
                    answer = new XindiceBackedMap<K, V>(record.getCacheFile(), transformer, reuse, autoFlush, compressed, encrypted);
                }
                throw ex;
            }
            this.activeMaps.put(name, answer);
        }
        if (diskLifeSpan > 0L) {
            record.setDiskLifeSpan(diskLifeSpan);
        }
        record.setCompressed(compressed);
        record.setEncrypted(encrypted);
        this.masterTable.put(name, record);
        return answer;
    }

    private File createCacheFile() {
        try {
            File dataDir = this.getDataDirectory();
            if (!dataDir.exists()) {
                dataDir.mkdirs();
            }
            return File.createTempFile(CACHE_FILE_PREFIX, CACHE_FILE_SUFFIX, this.getDataDirectory());
        }
        catch (IOException e) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_UnexpectedException, (Throwable)e);
        }
    }

    public synchronized void removeMap(String mapName) {
        if (this.logger.isOn(LogLevel.INFO)) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("Removing the cache named ").append(mapName);
            this.logger.log(LogLevel.INFO, buffer.toString());
        }
        this.integrityScan();
        this.activeMaps.remove(mapName);
        MapRecord record = this.masterTable.remove(mapName);
        if (null != record && record.getCacheFile().exists()) {
            FileCleanerService.getInstance().deleteLater(record.getCacheFile());
        }
    }

    public synchronized Serializable getUserData(String mapName) {
        if (this.logger.isOn(LogLevel.INFO)) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("Getting user data for cache named ").append(mapName);
            this.logger.log(LogLevel.INFO, buffer.toString());
        }
        this.integrityScan();
        MapRecord record = this.masterTable.get(mapName);
        if (null != record) {
            return record.getUserData();
        }
        return null;
    }

    public synchronized boolean setUserData(String mapName, Serializable userData) {
        if (this.logger.isOn(LogLevel.INFO)) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("Setting user data for cache named ").append(mapName);
            this.logger.log(LogLevel.INFO, buffer.toString());
        }
        this.integrityScan();
        MapRecord record = this.masterTable.get(mapName);
        if (null != record) {
            record.setUserData(userData);
            this.masterTable.put(mapName, record);
            return true;
        }
        return false;
    }

    private void integrityScan() {
        if (System.currentTimeMillis() - this.lastIntegrityScanTime > 10000L) {
            this.lastIntegrityScanTime = System.currentTimeMillis();
            this.scanForDanglingTables();
            this.scanForMissingAndExpiredTables();
        }
    }

    private void initialize() {
        if (!XQEService.isInitialized()) {
            throw new XQERuntimeException(XQEMessageKeys.INI_XQEServiceWasNotInitialized);
        }
        this.logger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "XindiceCacheManager", LogLevel.INFO);
        this.logger.log(LogLevel.INFO, "Initializing XindiceCacheManager");
        try {
            XQEConfiguration config = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
            StringBuilder builder = new StringBuilder(config.getXqeDataDirectory());
            builder.append(File.separatorChar);
            builder.append("xindice_cache_tables");
            builder.append(System.currentTimeMillis());
            this.dataDirectory = new File(builder.toString());
            this.dataDirectory = this.dataDirectory.getAbsoluteFile();
            this.dataDirectory.mkdirs();
        }
        catch (RuntimeException ex) {
            if (this.logger.isOn(LogLevel.ERROR)) {
                this.logger.log(LogLevel.ERROR, "An error occurred during initialization:\n", (Throwable)ex);
            }
            throw ex;
        }
    }

    private void release() {
        this.logger.log(LogLevel.INFO, "Releasing XindiceCacheManager");
        for (String key : this.masterTable.keySet()) {
            XindiceBackedMap<?, ?> map = this.activeMaps.get(key);
            if (null == map) continue;
            map.close();
        }
        this.masterTable.clear();
        this.destroyDataDirectory();
    }

    private void destroyDataDirectory() {
        for (File f : this.dataDirectory.listFiles()) {
            if (f.delete()) continue;
            FileCleanerService.getInstance().deleteLater(f);
        }
        if (!this.dataDirectory.delete()) {
            FileCleanerService.getInstance().deleteLater(this.dataDirectory);
        }
    }

    private void scanForDanglingTables() {
        if (!this.dataDirectory.exists()) {
            return;
        }
        File[] allDataFiles = this.dataDirectory.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.getName().startsWith(XindiceCacheManager.CACHE_FILE_PREFIX) && pathname.getName().endsWith(XindiceCacheManager.CACHE_FILE_SUFFIX);
            }
        });
        if (null == allDataFiles || 0 == allDataFiles.length) {
            return;
        }
        BitSet danglingMap = new BitSet(allDataFiles.length);
        for (MapRecord record : this.masterTable.values()) {
            for (int i = 0; i < allDataFiles.length; ++i) {
                if (!record.getCacheFile().getName().equals(allDataFiles[i].getName())) continue;
                danglingMap.set(i);
            }
        }
        danglingMap.flip(0, allDataFiles.length);
        for (int i = 0; i < allDataFiles.length; ++i) {
            if (!danglingMap.get(i)) continue;
            if (this.logger.isOn(LogLevel.WARN)) {
                StringBuilder buffer = new StringBuilder();
                buffer.append("Removing unreferenced cache file ").append(allDataFiles[i].getPath());
                this.logger.log(LogLevel.WARN, buffer.toString());
            }
            if (!allDataFiles[i].exists() || allDataFiles[i].delete()) continue;
            FileCleanerService.getInstance().deleteLater(allDataFiles[i]);
        }
    }

    private void scanForMissingAndExpiredTables() {
        LinkedList<String> missingCaches = new LinkedList<String>();
        LinkedList<String> expiredCaches = new LinkedList<String>();
        for (Map.Entry<String, MapRecord> entry : this.masterTable.entrySet()) {
            StringBuilder buffer;
            String mapName = entry.getKey();
            MapRecord record = entry.getValue();
            if (!record.getCacheFile().exists()) {
                if (this.logger.isOn(LogLevel.WARN)) {
                    buffer = new StringBuilder();
                    buffer.append("The cache file is missing for the cache named ").append(mapName);
                    this.logger.log(LogLevel.WARN, buffer.toString());
                }
                missingCaches.add(mapName);
                continue;
            }
            if (record.getDiskLifeSpan() <= 0L || System.currentTimeMillis() - record.getCacheFile().lastModified() <= record.getDiskLifeSpan()) continue;
            if (this.logger.isOn(LogLevel.WARN)) {
                buffer = new StringBuilder();
                buffer.append("Expiration date exceeded for the cache named ").append(mapName);
                this.logger.log(LogLevel.WARN, buffer.toString());
            }
            expiredCaches.add(mapName);
        }
        for (String mapName : missingCaches) {
            this.masterTable.remove(mapName);
        }
        for (String mapName : expiredCaches) {
            MapRecord record = this.masterTable.remove(mapName);
            if (null == record || !record.getCacheFile().exists() || record.getCacheFile().delete()) continue;
            FileCleanerService.getInstance().deleteLater(record.getCacheFile());
        }
    }

    public static XindiceCacheManager getInstance() {
        return singletonHelper.getInstance();
    }

    public static void releaseInstance() {
        singletonHelper.releaseInstance();
    }

    private static final class MapRecord
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private File cacheFile = null;
        private long diskLifeSpan = -1L;
        private boolean compressed = false;
        private boolean encrypted = false;
        private Serializable userData = null;

        MapRecord() {
        }

        public File getCacheFile() {
            return this.cacheFile;
        }

        public void setCacheFile(File theCacheFile) {
            this.cacheFile = theCacheFile;
        }

        public long getDiskLifeSpan() {
            return this.diskLifeSpan;
        }

        public void setDiskLifeSpan(long theDiskLifeSpan) {
            this.diskLifeSpan = theDiskLifeSpan;
        }

        public boolean isCompressed() {
            return this.compressed;
        }

        public void setCompressed(boolean isCompressed) {
            this.compressed = isCompressed;
        }

        public boolean isEncrypted() {
            return this.encrypted;
        }

        public void setEncrypted(boolean isEncrypted) {
            this.encrypted = isEncrypted;
        }

        public Serializable getUserData() {
            return this.userData;
        }

        public void setUserData(Serializable theUserData) {
            this.userData = theUserData;
        }
    }
}

