/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.config;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.configuration.event.ConfigurationEvent;
import org.apache.commons.configuration.event.ConfigurationListener;

public class TracingConfigurationListener
implements ConfigurationListener {
    public static final Logger LOG = Logger.getLogger(TracingConfigurationListener.class.getName());

    public void configurationChanged(ConfigurationEvent event) {
        if (!LOG.isLoggable(Level.CONFIG)) {
            return;
        }
        if (event.isBeforeUpdate()) {
            return;
        }
        String type = "";
        switch (event.getType()) {
            case 1: {
                type = "add_property";
                break;
            }
            case 4: {
                type = "clean";
                break;
            }
            case 2: {
                type = "clear_property";
                break;
            }
            case 5: {
                type = "read_property";
                break;
            }
            case 3: {
                type = "set_property";
                break;
            }
            default: {
                type = "<unknown>";
            }
        }
        String timing = "after";
        if (event.isBeforeUpdate()) {
            timing = "before";
        }
        LOG.config(String.format("%s = %s (%s %s on %s)", event.getPropertyName(), event.getPropertyValue(), timing, type, event.getSource()));
    }
}

