/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.json;

import com.cognos.xqe.data.json.AbstractJSONReader;
import com.cognos.xqe.data.providers.relational.AbstractConnection;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.util.json.JsonPathUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLConnection;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;

public class BasicJSONReader
extends AbstractJSONReader {
    private JSONArray jsonObj;
    private int nRows = 0;

    BasicJSONReader(AbstractConnection connection, IValue content, String pathExpr) throws IOException {
        super(connection, content, pathExpr);
    }

    BasicJSONReader(URLConnection connection, String pathExpr) throws IOException {
        super(connection, pathExpr);
    }

    @Override
    protected void initialize(InputStream iStream, String pathExpr) {
        try {
            this.readFromInputStream(iStream, pathExpr);
        }
        catch (IOException e) {
            throw new XQERuntimeException(e);
        }
    }

    @Override
    public boolean hasNext() {
        return this.nRows < this.jsonObj.size();
    }

    @Override
    public JSONObject next() {
        return (JSONObject)this.jsonObj.get(this.nRows++);
    }

    private void readFromInputStream(InputStream iStream, String pathExpr) throws IOException {
        Object jObj = JsonPathUtils.readFromInputStream(iStream, pathExpr);
        if (jObj instanceof JSONArray) {
            this.jsonObj = (JSONArray)jObj;
        } else {
            this.jsonObj = new JSONArray();
            this.jsonObj.add((Object)((JSONObject)jObj));
        }
    }
}

