/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.json;

import com.cognos.xqe.data.json.JSONReader;
import com.cognos.xqe.data.json.JSONUtil;
import com.cognos.xqe.data.json.PagingReader;
import com.cognos.xqe.data.json.StreamingJSONReader;
import com.cognos.xqe.data.providers.relational.AbstractConnection;
import com.cognos.xqe.exception.XQERuntimeException;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.net.URL;
import java.util.Map;
import net.minidev.json.JSONObject;

public class FacebookReader
implements JSONReader {
    private static final String[] CURSOR_BASED_APIS = new String[]{"/posts", "/statuses", "/feed", "/photos", "/videos", "/links"};
    private JSONReader reader;

    FacebookReader(AbstractConnection connection, Map<String, Object> properties, String thePathExpr) throws IOException {
        String connectionURL = (String)properties.get("URL");
        String path = new URL(connectionURL).getPath();
        this.reader = FacebookReader.contains(CURSOR_BASED_APIS, path) ? new CollectionReader(connection, properties, thePathExpr) : new StreamingJSONReader(connection, properties, thePathExpr);
    }

    @Override
    public boolean hasNext() {
        return this.reader.hasNext();
    }

    @Override
    public JSONObject next() {
        return (JSONObject)this.reader.next();
    }

    @Override
    public void release() {
        this.reader.release();
    }

    protected static boolean contains(String[] array, String value) {
        for (int i = 0; i < array.length; ++i) {
            if (!value.contains(array[i])) continue;
            return true;
        }
        return false;
    }

    @Override
    public void remove() {
    }

    private class CollectionReader
    extends PagingReader {
        private static final String DATA = "data";
        private static final String NEXT = "next";
        private static final String CURSORS = "cursors";

        CollectionReader(AbstractConnection connection, Map<String, Object> properties, String path) {
            super(connection, properties, path);
        }

        @Override
        protected String getNextPageURL() {
            String nextPageURL = null;
            try {
                JsonToken token;
                while ((token = this.parser.nextToken()) != null) {
                    if (token != JsonToken.FIELD_NAME) continue;
                    String name = this.parser.getCurrentName();
                    if (name.equals(CURSORS)) {
                        this.parser.nextToken();
                        this.parser.skipChildren();
                        continue;
                    }
                    if (!name.equals(NEXT)) continue;
                    this.parser.nextToken();
                    nextPageURL = (String)JSONUtil.parseValue(this.parser);
                    break;
                }
            }
            catch (IOException e) {
                throw new XQERuntimeException(e);
            }
            return nextPageURL;
        }

        @Override
        protected void getContentImpl() throws IOException {
            this.parser.nextToken();
            JsonToken token = this.parser.nextToken();
            if (token == JsonToken.FIELD_NAME && this.parser.getCurrentName().equals(DATA)) {
                this.parser.nextToken();
                this.parser.nextToken();
            }
        }
    }
}

