/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.json;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultIndenter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.ibm.json.xml.XMLToJSONTransformer;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.URLConnection;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;
import org.apache.commons.io.IOUtils;
import org.xml.sax.SAXException;

public final class JSONUtil {
    public static final String ROOT = "$";

    public static JSONObject parseObject(JsonParser parser) throws IOException {
        JSONObject jsonObject = new JSONObject();
        while (parser.nextToken() != JsonToken.END_OBJECT) {
            Object value;
            if (parser.getCurrentToken() == null) {
                return null;
            }
            String key = parser.getCurrentName();
            switch (parser.nextToken()) {
                case START_OBJECT: {
                    value = JSONUtil.parseObject(parser);
                    break;
                }
                case START_ARRAY: {
                    value = JSONUtil.parseArray(parser);
                    break;
                }
                default: {
                    value = JSONUtil.parseValue(parser);
                }
            }
            jsonObject.put((Object)key, value);
        }
        return jsonObject;
    }

    public static JSONArray parseArray(JsonParser parser) throws IOException {
        JSONArray jsonArray = new JSONArray();
        while (parser.nextToken() != JsonToken.END_ARRAY) {
            Object value;
            switch (parser.getCurrentToken()) {
                case START_OBJECT: {
                    value = JSONUtil.parseObject(parser);
                    break;
                }
                case START_ARRAY: {
                    value = JSONUtil.parseArray(parser);
                    break;
                }
                default: {
                    value = JSONUtil.parseValue(parser);
                }
            }
            jsonArray.add(value);
        }
        return jsonArray;
    }

    public static Object parseValue(JsonParser parser) throws IOException {
        Object value;
        JsonToken token = parser.getCurrentToken();
        if (token == JsonToken.VALUE_EMBEDDED_OBJECT || token == JsonToken.VALUE_NULL) {
            value = null;
        } else if (token == JsonToken.VALUE_STRING) {
            value = parser.getText();
        } else if (token == JsonToken.VALUE_NUMBER_INT || token == JsonToken.VALUE_NUMBER_FLOAT) {
            JsonParser.NumberType numberType = parser.getNumberType();
            switch (numberType) {
                case BIG_DECIMAL: {
                    value = parser.getDecimalValue();
                    break;
                }
                case BIG_INTEGER: {
                    value = parser.getBigIntegerValue();
                    break;
                }
                case DOUBLE: {
                    value = parser.getDoubleValue();
                    break;
                }
                case FLOAT: {
                    value = Float.valueOf(parser.getFloatValue());
                    break;
                }
                case LONG: {
                    value = parser.getLongValue();
                    break;
                }
                case INT: {
                    value = parser.getIntValue();
                    break;
                }
                default: {
                    value = null;
                    break;
                }
            }
        } else if (token == JsonToken.VALUE_TRUE || token == JsonToken.VALUE_FALSE) {
            value = parser.getBooleanValue();
        } else {
            throw new IOException("Unrecognized value object.");
        }
        return value;
    }

    public static Object parse(JsonParser parser) throws IOException {
        JsonToken token = parser.getCurrentToken();
        if (token == null) {
            return null;
        }
        if (token == JsonToken.START_OBJECT) {
            return JSONUtil.parseObject(parser);
        }
        if (token == JsonToken.START_ARRAY) {
            return JSONUtil.parseArray(parser);
        }
        return JSONUtil.parseValue(parser);
    }

    public static InputStream getInputStream(URLConnection connection) throws IOException {
        try {
            return connection.getInputStream();
        }
        catch (ConnectException e) {
            throw e;
        }
        catch (IOException e) {
            if (connection instanceof HttpURLConnection) {
                InputStream eStream = ((HttpURLConnection)connection).getErrorStream();
                String error = JSONUtil.readResponse(eStream);
                e.initCause(new IOException(error));
                throw e;
            }
            throw e;
        }
    }

    public static String readResponse(InputStream eStream) throws IOException {
        StringBuilder sBuilder = new StringBuilder();
        BufferedReader reader = new BufferedReader(new InputStreamReader(eStream));
        String line = reader.readLine();
        while (line != null) {
            sBuilder.append(line + System.getProperty("line.separator"));
            line = reader.readLine();
        }
        eStream.close();
        return sBuilder.toString();
    }

    public static String prettyPrint(String json) {
        String result = json;
        try {
            ObjectMapper mapper = new ObjectMapper();
            Object jObject = mapper.readValue(json, Object.class);
            DefaultPrettyPrinter pp = new DefaultPrettyPrinter();
            pp.indentArraysWith((DefaultPrettyPrinter.Indenter)DefaultIndenter.SYSTEM_LINEFEED_INSTANCE);
            result = mapper.writer((PrettyPrinter)pp).writeValueAsString(jObject);
        }
        catch (JsonParseException jsonParseException) {
        }
        catch (JsonMappingException jsonMappingException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String convertXMLToJSON(String xml, String encoding) throws SAXException, IOException {
        try (InputStream is = null;){
            is = IOUtils.toInputStream((String)xml, (String)encoding);
            String string = XMLToJSONTransformer.transform((InputStream)is);
            return string;
        }
    }
}

