/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.json;

import com.cognos.xqe.authentication.AuthenticationHelper;
import com.cognos.xqe.data.json.JSONReader;
import com.cognos.xqe.data.json.JSONUtil;
import com.cognos.xqe.data.model.LogonFailureException;
import com.cognos.xqe.data.providers.relational.AbstractConnection;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.util.json.JsonPathUtils;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidObjectException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import net.minidev.json.JSONObject;

public class PagingReader
implements JSONReader {
    protected JSONObject jsonObj;
    private JsonPath jsonPath;
    protected String originalURL;
    private boolean hasQueryPart;
    protected AbstractConnection connection;
    protected Map<String, Object> properties;
    protected String dataKey;
    protected Object pageToken;
    protected String nextPageToken;
    protected String nextPageKey;
    protected JsonParser parser;

    PagingReader(AbstractConnection theConnection, Map<String, Object> theProperties, String pathExpr) {
        this.properties = new HashMap<String, Object>(theProperties);
        this.originalURL = (String)theProperties.get("URL");
        this.connection = theConnection;
        if (pathExpr != null) {
            this.jsonPath = JsonPath.compile((String)pathExpr, (Predicate[])new Predicate[0]);
        }
        this.getContent(this.originalURL);
    }

    PagingReader(AbstractConnection theConnection, Map<String, Object> theProperties, String path, String dataField, String nextPageProp, String nextPageField) throws IOException {
        this.properties = new HashMap<String, Object>(theProperties);
        this.originalURL = (String)theProperties.get("URL");
        this.connection = theConnection;
        if (path != null) {
            this.jsonPath = JsonPath.compile((String)path, (Predicate[])new Predicate[0]);
        }
        this.dataKey = dataField;
        this.nextPageToken = nextPageProp;
        this.nextPageKey = nextPageField;
        boolean bl = this.hasQueryPart = new URL(this.originalURL).getQuery() != null;
        if ("$".equals(path)) {
            path = null;
        } else {
            StringBuilder builder = new StringBuilder();
            builder.append("$.");
            builder.append(this.dataKey);
            if (builder.toString().equals(path)) {
                path = null;
            } else {
                builder.append(".");
                String prefix = builder.toString();
                if (path != null && path.startsWith(prefix)) {
                    path = path.substring(prefix.length());
                }
            }
        }
        this.getContent(this.originalURL);
    }

    @Override
    public boolean hasNext() {
        this.jsonObj = null;
        try {
            if (this.parser.getCurrentToken() == JsonToken.END_ARRAY && !this.getNextPage()) {
                return false;
            }
            this.jsonObj = JSONUtil.parseObject(this.parser);
            if (this.jsonObj == null) {
                return false;
            }
            this.parser.nextToken();
            return true;
        }
        catch (IOException e) {
            throw new XQERuntimeException(e);
        }
    }

    protected boolean getNextPage() throws IOException {
        String nextPageURL = this.getNextPageURL();
        if (this.eod(nextPageURL)) {
            return false;
        }
        this.getContent(nextPageURL);
        return true;
    }

    protected String getNextPageURL() {
        String nextPageURL = null;
        if (this.pageToken != null) {
            String formatStr = this.hasQueryPart ? "%s&%s=%s" : "%s?%s=%s";
            nextPageURL = String.format(formatStr, this.originalURL, this.nextPageToken, this.pageToken.toString());
        }
        return nextPageURL;
    }

    protected boolean eod(String nextPageURL) {
        return nextPageURL == null;
    }

    @Override
    public JSONObject next() {
        JSONObject jObj = this.jsonObj;
        if (this.jsonPath != null) {
            jObj = (JSONObject)JsonPathUtils.read(jObj, this.jsonPath);
        }
        return jObj;
    }

    @Override
    public void release() {
        try {
            this.parser.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected void getContent(String url) {
        HttpURLConnection urlConnection = null;
        try {
            this.properties.put("URL", url);
            urlConnection = (HttpURLConnection)AuthenticationHelper.createURLConnection(this.connection, this.properties);
            InputStream iStream = urlConnection.getInputStream();
            JsonFactory factory = new JsonFactory();
            if (this.parser != null) {
                this.parser.close();
            }
            this.parser = factory.createParser(iStream);
            this.parser.enable(JsonParser.Feature.AUTO_CLOSE_SOURCE);
            this.getContentImpl();
        }
        catch (IOException e) {
            try {
                if (urlConnection != null) {
                    if (urlConnection.getResponseCode() == 401) {
                        throw new LogonFailureException(LogonFailureException.SubCodeEnum.UNAUTHORIZED, (String)null);
                    }
                    InputStream eStream = urlConnection.getErrorStream();
                    String error = JSONUtil.readResponse(eStream);
                    e.initCause(new IOException(error));
                }
                throw e;
            }
            catch (IOException e1) {
                throw new XQERuntimeException(e1);
            }
        }
    }

    protected void getContentImpl() throws IOException {
        JsonToken token = this.parser.nextToken();
        this.pageToken = null;
        while (token != null) {
            token = this.parser.nextToken();
            if (token != JsonToken.FIELD_NAME) continue;
            String name = this.parser.getCurrentName();
            if (name.equals(this.nextPageKey)) {
                this.parser.nextToken();
                this.pageToken = (String)JSONUtil.parseValue(this.parser);
                continue;
            }
            if (!name.equals(this.dataKey)) continue;
            this.parser.nextToken();
            break;
        }
        if (token != null) {
            this.parser.nextToken();
            if (this.parser.getCurrentToken() != JsonToken.START_OBJECT) {
                throw new InvalidObjectException(this.parser.getCurrentToken().asString());
            }
        }
    }

    @Override
    public void remove() {
    }
}

