/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.json;

import com.cognos.xqe.authentication.AuthenticationHelper;
import com.cognos.xqe.data.json.AbstractJSONReader;
import com.cognos.xqe.data.json.InvalidJSONPathExpression;
import com.cognos.xqe.data.json.JSONUtil;
import com.cognos.xqe.data.providers.relational.AbstractConnection;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.util.json.JsonPathUtils;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.jayway.jsonpath.InvalidPathException;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLConnection;
import java.util.Map;

public class StreamingJSONReader
extends AbstractJSONReader {
    private JsonParser parser;
    private JsonPath jsonPath;
    private Object jsonObj;
    private boolean isArray;

    StreamingJSONReader(AbstractConnection connection, IValue content, String pathExpr) throws IOException {
        super(connection, content, pathExpr);
    }

    StreamingJSONReader(URLConnection connection, String pathExpr, String subPathExpr) throws IOException {
        super(connection, pathExpr);
        if (subPathExpr != null && !subPathExpr.equals("$")) {
            this.jsonPath = JsonPath.compile((String)subPathExpr, (Predicate[])new Predicate[0]);
        }
    }

    StreamingJSONReader(URLConnection connection, String pathExpr) throws IOException {
        super(connection, pathExpr);
    }

    StreamingJSONReader(AbstractConnection connection, Map<String, Object> properties, String pathExpr) throws IOException {
        super(AuthenticationHelper.createURLConnection(connection, properties), pathExpr);
    }

    @Override
    protected void initialize(InputStream iStream, String pathExpr) {
        try {
            String[] keys = pathExpr.split("\\.");
            JsonFactory factory = new JsonFactory();
            this.parser = factory.createParser(iStream);
            this.parser.enable(JsonParser.Feature.AUTO_CLOSE_SOURCE);
            this.parser.nextToken();
            if (this.parser.getCurrentToken() == JsonToken.START_ARRAY && keys.length > 1) {
                throw new InvalidPathException();
            }
            if (keys.length > 1) {
                this.parser.nextToken();
                block2: for (int i = 1; i < keys.length; ++i) {
                    String key = keys[i];
                    do {
                        if (this.parser.getCurrentToken() != JsonToken.FIELD_NAME) continue;
                        String name = this.parser.getCurrentName();
                        this.parser.nextToken();
                        if (name.equals(key)) continue block2;
                        this.parser.skipChildren();
                    } while (this.parser.nextToken() != null);
                    throw new InvalidJSONPathExpression(null);
                }
            }
            if (this.parser.getCurrentToken() == JsonToken.START_ARRAY) {
                this.isArray = true;
                this.parser.nextToken();
            }
        }
        catch (IOException e) {
            throw new XQERuntimeException(e);
        }
    }

    @Override
    public boolean hasNext() {
        try {
            if (this.isArray ? this.parser.getCurrentToken() == JsonToken.END_ARRAY : this.jsonObj != null) {
                return false;
            }
            this.jsonObj = JSONUtil.parse(this.parser);
            this.parser.nextToken();
        }
        catch (IOException e) {
            throw new XQERuntimeException(e);
        }
        return this.jsonObj != null;
    }

    @Override
    public Object next() {
        Object jObj = this.jsonObj;
        if (this.jsonPath != null) {
            jObj = JsonPathUtils.read(jObj, this.jsonPath);
        }
        return jObj;
    }

    @Override
    public void release() {
        try {
            this.parser.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

