/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.model;

import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.xqe.data.model.DataSourceException;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQEMessages;
import java.util.List;
import org.dom4j.Element;

public class AmbiguousConnectionException
extends DataSourceException {
    static final long serialVersionUID = 23478237445865L;
    private final transient List<String> mConnectionNames;

    public AmbiguousConnectionException() {
        super(XQEMessageKeys.DS_AmbiguousConnection);
        this.mConnectionNames = null;
    }

    public AmbiguousConnectionException(IDataSource ds, List<String> connectionNames) {
        super(ds, XQEMessageKeys.DS_AmbiguousConnection);
        this.mConnectionNames = connectionNames;
    }

    @Override
    public String getFaultCode() {
        return "CQE-801";
    }

    @Override
    public String getFaultString() {
        return XQEMessages.getMessage(XQEMessageKeys.DS_AmbiguousConnection, XQEMessages.getCurrProductLocale());
    }

    @Override
    public BIBusEnvelope getFaultEnvelope() {
        Element dsElement;
        BIBusEnvelope faultEnvelope = new BIBusEnvelope();
        Element faultElement = faultEnvelope.createFaultElement(this.getFaultCode(), this.getFaultString());
        Element faultDataSource = this.getFaultDataSource();
        if (faultDataSource != null) {
            faultElement.add(faultDataSource);
        }
        if ((dsElement = this.getDataSource().asXML()) != null) {
            faultElement.add(dsElement);
        }
        return faultEnvelope;
    }

    public List<String> getConnectionNames() {
        return this.mConnectionNames;
    }
}

