/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.model;

import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.xqe.data.model.DataSourceException;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQEMessages;
import java.io.IOException;
import java.util.List;
import org.dom4j.Element;

public class AmbiguousSignonException
extends DataSourceException {
    static final long serialVersionUID = 752742587431L;
    private final transient List<String> mSignonNames;

    public AmbiguousSignonException() {
        super(XQEMessageKeys.DS_AmbiguousSignon);
        this.mSignonNames = null;
    }

    public AmbiguousSignonException(IDataSource theDataSource, List<String> signonNames) {
        super(theDataSource, XQEMessageKeys.DS_AmbiguousSignon);
        this.mSignonNames = signonNames;
    }

    @Override
    public String getFaultCode() {
        return "CQE-802";
    }

    @Override
    public String getFaultString() {
        return XQEMessages.getMessage(XQEMessageKeys.DS_AmbiguousSignon, XQEMessages.getCurrProductLocale());
    }

    @Override
    public BIBusEnvelope getFaultEnvelope() {
        Element dsElement;
        BIBusEnvelope faultEnvelope = new BIBusEnvelope();
        Element faultElement = faultEnvelope.createFaultElement(this.getFaultCode(), this.getFaultString());
        Element faultConnection = this.getFaultConnection();
        if (faultConnection != null) {
            faultElement.add(faultConnection);
        }
        if ((dsElement = this.getDataSource().asXML()) != null) {
            faultElement.add(dsElement);
        }
        return faultEnvelope;
    }

    public String getResult() {
        BIBusEnvelope envelope = this.getFaultEnvelope();
        String sResult = new String();
        try {
            sResult = envelope.getAsString();
        }
        catch (IOException e) {
            sResult = "";
        }
        return sResult;
    }

    public List<String> getSignonNames() {
        return this.mSignonNames;
    }
}

