/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.model;

import com.cognos.xqe.data.model.CapabilitiesKeyParts;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.configuration2.AbstractConfiguration;
import org.apache.commons.lang.builder.HashCodeBuilder;

public final class CapabilitiesKey {
    private final String providerType;
    private final String providerTypeOverride;
    private final String version;
    private final String subType;
    private final Map<String, AbstractConfiguration> builtInConfigs;
    private volatile int cachedHashCode = -1;
    private final String driverName;
    private final String driverVersion;
    private final boolean isGenericJDBC;
    private final String connectionString;

    public CapabilitiesKey(String aProviderType) {
        if (null == aProviderType) {
            CapabilitiesKey.throwProviderTypeWasNull();
        }
        this.providerType = aProviderType;
        this.providerTypeOverride = null;
        this.version = null;
        this.subType = null;
        this.builtInConfigs = null;
        this.driverName = null;
        this.driverVersion = null;
        this.isGenericJDBC = false;
        this.connectionString = null;
    }

    public CapabilitiesKey(String aProviderType, String aVersion) {
        if (null == aProviderType) {
            CapabilitiesKey.throwProviderTypeWasNull();
        }
        this.providerType = aProviderType;
        this.providerTypeOverride = null;
        this.version = aVersion;
        this.subType = null;
        this.driverName = null;
        this.driverVersion = null;
        this.builtInConfigs = null;
        this.isGenericJDBC = false;
        this.connectionString = null;
    }

    public CapabilitiesKey(String aProviderType, String aVersion, String aSubType) {
        if (null == aProviderType) {
            CapabilitiesKey.throwProviderTypeWasNull();
        }
        this.providerType = aProviderType;
        this.providerTypeOverride = null;
        this.version = aVersion;
        this.subType = aSubType;
        this.builtInConfigs = null;
        this.driverName = null;
        this.driverVersion = null;
        this.isGenericJDBC = false;
        this.connectionString = null;
    }

    public CapabilitiesKey(String aProviderType, String aVersion, String aSubType, Map<String, AbstractConfiguration> theBuiltInConfigs) {
        if (null == aProviderType) {
            CapabilitiesKey.throwProviderTypeWasNull();
        }
        this.providerType = aProviderType;
        this.providerTypeOverride = null;
        this.version = aVersion;
        this.subType = aSubType;
        this.builtInConfigs = theBuiltInConfigs;
        this.driverName = null;
        this.driverVersion = null;
        this.isGenericJDBC = false;
        this.connectionString = null;
    }

    public CapabilitiesKey(String aProviderType, String aVersion, String aSubType, String aConnectionString) {
        this.providerType = aProviderType;
        this.providerTypeOverride = null;
        this.version = aVersion;
        this.subType = aSubType;
        this.builtInConfigs = null;
        this.driverName = null;
        this.driverVersion = null;
        this.isGenericJDBC = false;
        this.connectionString = aConnectionString;
    }

    public CapabilitiesKey(String aProviderType, CapabilitiesKeyParts parts, Map<String, AbstractConfiguration> theBuiltInConfigs) {
        if (null == aProviderType) {
            CapabilitiesKey.throwProviderTypeWasNull();
        }
        this.providerType = aProviderType;
        this.providerTypeOverride = parts.getTypeOverride();
        this.version = parts.getVersion();
        this.subType = parts.getSubtype();
        this.builtInConfigs = theBuiltInConfigs;
        this.driverName = parts.getDriverName();
        this.driverVersion = parts.getDriverVersion();
        this.isGenericJDBC = parts.isGenericJDBC();
        this.connectionString = parts.getConnectionString();
    }

    public String getProviderType() {
        return this.providerType;
    }

    public String getSubType() {
        return this.subType;
    }

    public String getVersion() {
        return this.version;
    }

    public String getProviderTypeOverride() {
        return this.providerTypeOverride;
    }

    public boolean isGenericJDBC() {
        return this.isGenericJDBC;
    }

    public Map<String, AbstractConfiguration> getBuiltInConfigs() {
        if (null == this.builtInConfigs) {
            return null;
        }
        return Collections.unmodifiableMap(this.builtInConfigs);
    }

    public boolean equals(Object other) {
        if (!(other instanceof CapabilitiesKey)) {
            return false;
        }
        CapabilitiesKey otherKey = (CapabilitiesKey)other;
        if (this.providerType == null ? otherKey.providerType != null : !this.providerType.equals(otherKey.providerType)) {
            return false;
        }
        if (this.version == null ? otherKey.version != null : !this.version.equals(otherKey.version)) {
            return false;
        }
        if (this.subType == null ? otherKey.subType != null : !this.subType.equals(otherKey.subType)) {
            return false;
        }
        if (this.connectionString == null ? otherKey.connectionString != null : !this.connectionString.equals(otherKey.connectionString)) {
            return false;
        }
        return CapabilitiesKey.builtInConfigsEquals(this.builtInConfigs, otherKey.builtInConfigs);
    }

    public int hashCode() {
        if (-1 == this.cachedHashCode) {
            HashCodeBuilder hcb = new HashCodeBuilder();
            hcb.append((Object)this.providerType);
            hcb.append((Object)this.version);
            hcb.append((Object)this.subType);
            if (this.providerTypeOverride != null) {
                hcb.append((Object)this.providerTypeOverride);
            }
            if (this.driverName != null) {
                hcb.append((Object)this.driverName);
            }
            if (this.driverVersion != null) {
                hcb.append((Object)this.driverVersion);
            }
            if (this.connectionString != null) {
                hcb.append((Object)this.connectionString);
            }
            CapabilitiesKey.appendBuiltInConfigsHashCode(this.builtInConfigs, hcb);
            this.cachedHashCode = hcb.toHashCode();
            if (-1 == this.cachedHashCode) {
                this.cachedHashCode = 0;
            }
        }
        return this.cachedHashCode;
    }

    private static void throwProviderTypeWasNull() {
        throw new IllegalArgumentException("aProviderType was null.");
    }

    private static void appendBuiltInConfigsHashCode(Map<String, AbstractConfiguration> theBuiltInConfig, HashCodeBuilder hcb) {
        if (null == theBuiltInConfig) {
            return;
        }
        for (Map.Entry<String, AbstractConfiguration> entry : theBuiltInConfig.entrySet()) {
            hcb.append((Object)entry.getKey());
            CapabilitiesKey.appendConfigurationHashCode(entry.getValue(), hcb);
        }
    }

    private static boolean builtInConfigsEquals(Map<String, AbstractConfiguration> theBuiltInConfig1, Map<String, AbstractConfiguration> theBuiltInConfig2) {
        if (null == theBuiltInConfig1) {
            return null == theBuiltInConfig2;
        }
        if (null == theBuiltInConfig2) {
            return false;
        }
        if (theBuiltInConfig1 == theBuiltInConfig2) {
            return true;
        }
        if (theBuiltInConfig1.size() != theBuiltInConfig2.size()) {
            return false;
        }
        for (Map.Entry<String, AbstractConfiguration> entry : theBuiltInConfig1.entrySet()) {
            AbstractConfiguration cfg2;
            AbstractConfiguration cfg1 = entry.getValue();
            if (CapabilitiesKey.configurationEquals(cfg1, cfg2 = theBuiltInConfig2.get(entry.getKey()))) continue;
            return false;
        }
        return true;
    }

    private static void appendConfigurationHashCode(AbstractConfiguration cfg, HashCodeBuilder hcb) {
        if (null == cfg) {
            return;
        }
        Iterator keyIter = cfg.getKeys();
        while (keyIter.hasNext()) {
            String key = (String)keyIter.next();
            Object value = cfg.getProperty(key);
            hcb.append((Object)key);
            hcb.append(value);
        }
    }

    private static boolean configurationEquals(AbstractConfiguration cfg1, AbstractConfiguration cfg2) {
        String key;
        if (null == cfg1) {
            return null == cfg2;
        }
        if (null == cfg2) {
            return false;
        }
        if (cfg1 == cfg2) {
            return true;
        }
        HashSet<String> keySet = new HashSet<String>();
        int count1 = 0;
        int count2 = 0;
        Iterator keyIter = cfg1.getKeys();
        while (keyIter.hasNext()) {
            key = (String)keyIter.next();
            keySet.add(key);
            ++count1;
        }
        keyIter = cfg2.getKeys();
        while (keyIter.hasNext()) {
            key = (String)keyIter.next();
            if (!keySet.contains(key)) {
                return false;
            }
            Object value1 = cfg1.getProperty(key);
            Object value2 = cfg2.getProperty(key);
            if (null == value1) {
                if (null != value2) {
                    return false;
                }
            } else {
                if (null == value2) {
                    return false;
                }
                if (value1 != value2 && !value1.equals(value2)) {
                    return false;
                }
            }
            ++count2;
        }
        return count1 == count2;
    }
}

