/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.model;

import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.xqe.data.model.DataSourceException;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.model.IDataSourceConnectionSignon;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQEMessages;
import java.io.IOException;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.QName;
import org.dom4j.dom.DOMElement;

public class LogonFailureException
extends DataSourceException {
    static final long serialVersionUID = 754378423723487L;
    private SubCodeEnum subCode = SubCodeEnum.UNKNOWN;
    private String faultInfoStr;
    private IDataSourceConnectionSignon signon = null;
    private boolean signonSet = false;

    @Deprecated
    public LogonFailureException() {
        super(XQEMessageKeys.DS_DataSourceLogonFailure);
    }

    public LogonFailureException(SubCodeEnum code) {
        super(XQEMessageKeys.DS_DataSourceLogonFailure);
        this.subCode = code;
    }

    public LogonFailureException(SubCodeEnum code, Throwable cause) {
        super(XQEMessageKeys.DS_DataSourceLogonFailure, cause);
        this.subCode = code;
    }

    public LogonFailureException(IDataSource theDataSource, SubCodeEnum code, Throwable cause) {
        super(theDataSource, XQEMessageKeys.DS_DataSourceLogonFailure, cause);
        this.subCode = code;
    }

    public LogonFailureException(IDataSource theDataSource, SubCodeEnum code) {
        super(theDataSource, XQEMessageKeys.DS_DataSourceLogonFailure);
        this.subCode = code;
    }

    public LogonFailureException(SubCodeEnum code, String additionalFaultInfo) {
        super(XQEMessageKeys.DS_DataSourceLogonFailure);
        this.subCode = code;
        this.faultInfoStr = additionalFaultInfo;
    }

    @Deprecated
    public LogonFailureException(IDataSource theDataSource) {
        super(theDataSource, XQEMessageKeys.DS_DataSourceLogonFailure);
    }

    public LogonFailureException(IDataSource theDataSource, Exception ex) {
        super(theDataSource, XQEMessageKeys.DS_DataSourceLogonFailure, ex);
    }

    public void setSubCode(SubCodeEnum code) {
        this.subCode = code;
    }

    public SubCodeEnum getSubCode() {
        return this.subCode;
    }

    @Override
    public String getFaultCode() {
        return "CQE-803";
    }

    @Override
    public String getFaultString() {
        return XQEMessages.getMessage(XQEMessageKeys.DS_DataSourceLogonFailure, XQEMessages.getCurrProductLocale());
    }

    private String getFaultSubstring() {
        if (this.getCause() != null && this.getCause().getLocalizedMessage() != null) {
            return this.getCause().getLocalizedMessage();
        }
        switch (this.subCode) {
            case INVALID_CREDENTIALS: {
                return XQEMessages.getMessage(XQEMessageKeys.DS_InvalidCredentials, XQEMessages.getCurrProductLocale());
            }
            case INVALID_CONN_STRING: {
                return XQEMessages.getMessage(XQEMessageKeys.DS_InvalidConnectionString, XQEMessages.getCurrProductLocale());
            }
            case INVALID_SERVER: {
                return XQEMessages.getMessage(XQEMessageKeys.DS_InvalidServerInfo, XQEMessages.getCurrProductLocale());
            }
            case NO_CONNECTION: {
                return XQEMessages.getMessage(XQEMessageKeys.DS_ConnectionRequestRefused, XQEMessages.getCurrProductLocale());
            }
            case MAX_CONNECTIONS: {
                return XQEMessages.getMessage(XQEMessageKeys.DS_MaxSConnectionsPerUserExceeded, XQEMessages.getCurrProductLocale());
            }
            case INVALID_CUBE_PWD: {
                return XQEMessages.getMessage(XQEMessageKeys.DS_InvalidCubePassword, XQEMessages.getCurrProductLocale());
            }
            case XML_TAG_FAULT: {
                return XQEMessages.getMessage(XQEMessageKeys.DS_XMLDataNeedsToBeUploaded, XQEMessages.getCurrProductLocale());
            }
            case UNAUTHORIZED: {
                return XQEMessages.getMessage(XQEMessageKeys.DS_ConnectionUnauthorized, XQEMessages.getCurrProductLocale());
            }
        }
        return XQEMessages.getMessage(XQEMessageKeys.DS_ConnectionFailedWithUnknownReason, XQEMessages.getCurrProductLocale());
    }

    @Override
    protected void addSubfaultElements(Element faultElement) {
        DOMElement faultSubcode = new DOMElement(new QName("faultSubcode"));
        faultSubcode.addText(this.subCode.getFaultSubCode());
        faultElement.add((Element)faultSubcode);
        DOMElement faultSubstring = new DOMElement(new QName("faultSubstring"));
        faultSubstring.addText(this.getFaultSubstring());
        faultElement.add((Element)faultSubstring);
        if (this.faultInfoStr != null) {
            Element fault;
            try {
                fault = DocumentHelper.parseText((String)this.faultInfoStr).getRootElement();
            }
            catch (DocumentException e) {
                fault = null;
            }
            Element faultInfo = DocumentHelper.createElement((String)"additionalFaultInfo");
            faultInfo.add(fault);
            faultElement.add(faultInfo);
        }
    }

    @Override
    protected Element getFaultSignon() {
        if (!this.signonSet) {
            return super.getFaultSignon();
        }
        return LogonFailureException.getFaultSignonElem(this.signon);
    }

    public String getResult() {
        BIBusEnvelope envelope = this.getFaultEnvelope();
        String sResult = new String();
        try {
            sResult = envelope.getAsString();
        }
        catch (IOException e) {
            sResult = "";
        }
        return sResult;
    }

    public void setSignon(IDataSourceConnectionSignon signonObject) {
        this.signon = signonObject;
        this.signonSet = true;
    }

    public static enum SubCodeEnum {
        INVALID_CREDENTIALS("1"),
        INVALID_CONN_STRING("2"),
        INVALID_SERVER("3"),
        NO_CONNECTION("4"),
        MAX_CONNECTIONS("5"),
        INVALID_CUBE_PWD("6"),
        XML_TAG_FAULT("7"),
        UNAUTHORIZED("8"),
        UNKNOWN("99");

        private final String faultSubCode;

        private SubCodeEnum(String theFaultSubCode) {
            this.faultSubCode = theFaultSubCode;
        }

        public String getFaultSubCode() {
            return this.faultSubCode;
        }
    }
}

