/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.model;

import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.Fault;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import org.dom4j.Element;
import org.dom4j.QName;
import org.dom4j.dom.DOMElement;

public class ModelNotFoundException
extends XQERuntimeException {
    private static final long serialVersionUID = 1L;

    public ModelNotFoundException(String modelPath) {
        this((Throwable)null, modelPath);
    }

    public ModelNotFoundException(Throwable cause, String modelPath) {
        super(XQEMessageKeys.GEN_ModelDoesNotExist, cause, modelPath);
    }

    private void addMessage(Element exception, String msg) {
        DOMElement message = new DOMElement(new QName("message"));
        exception.add((Element)message);
        DOMElement messageString = new DOMElement(new QName("messageString"));
        messageString.addText(msg);
        message.add((Element)messageString);
    }

    protected Element getFaultDetail() {
        DOMElement exception = new DOMElement(new QName("exception"));
        this.addMessage((Element)exception, this.getFaultString());
        for (Throwable cause = this.getCause(); cause != null; cause = cause.getCause()) {
            String msg = cause.getLocalizedMessage();
            if (msg != null) {
                this.addMessage((Element)exception, msg);
            }
            if (cause == cause.getCause()) break;
        }
        return exception;
    }

    @Override
    public BIBusEnvelope getFaultEnvelope() {
        BIBusEnvelope faultEnvelope = new BIBusEnvelope();
        Element faultElement = faultEnvelope.createFaultElement(this.getFaultCode(), this.getFaultString());
        Element detailElement = faultElement.element("detail");
        Element detailMessage = this.getFaultDetail();
        if (detailMessage != null) {
            detailElement.add(detailMessage);
        }
        return faultEnvelope;
    }

    @Override
    public Fault getFault() {
        return this.getFaultFromEnvelope();
    }

    @Override
    public String getFaultCode() {
        return "CQE-1214";
    }
}

