/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers;

import com.cognos.xqe.data.providers.ProviderManager;

public final class DataSourceTypeEnum {
    private static final String SUBTYPE = "SUBTYPE";
    private static final String EQUALS = "=";
    public static final String DO = "DO";
    public static final String EB = "EB";
    public static final String MAZ = "MAZ";
    public static final String M19 = "M19";
    public static final String M17 = "M17";
    public static final String M16 = "M16";
    public static final String M14 = "M14";
    public static final String M12 = "M12";
    public static final String M8 = "M8";
    public static final String YK = "YK";
    public static final String PC = "PC";
    public static final String BW = "BW";
    public static final String OL = "OL";
    public static final String OR = "OR";
    public static final String JDOR = "JD-OR";
    public static final String D2 = "D2";
    public static final String JDD2 = "JD-D2";
    public static final String SS = "SS";
    public static final String JDSS = "JD-SS";
    public static final String TD = "TD";
    public static final String JDTD = "JD-TD";
    public static final String NZ = "NZ";
    public static final String JDNZ = "JD-NZ";
    public static final String HV = "HV";
    public static final String SF = "SF";
    public static final String JDSF = "JD-SF";
    public static final String OD = "OD";
    public static final String JD = "JD";
    public static final String JDBC = "JDBC";
    public static final String JAQLSQL = "JAQL-SQL";
    public static final String XI = "XI";
    public static final String RO = "RO";
    public static final String XO = "XO";
    public static final String X5 = "X5";
    public static final String X8 = "X8";
    public static final String TM = "TM";
    public static final String TMR = "TMR";
    public static final String ODATA = "ODATA";
    public static final String JSON = "JSON";
    public static final String COUCHDB = "COUCHDB";
    public static final String CLOUDANT = "CLOUDANT";
    public static final String DB2OLAPODP = "DB2OlapODP";
    public static final String MSAZUREASODP = "MSAzureASODP";
    public static final String MSANALYSIS2019ODP = "MSAnalysis2019ODP";
    public static final String MSANALYSIS2017ODP = "MSAnalysis2017ODP";
    public static final String MSANALYSIS2016ODP = "MSAnalysis2016ODP";
    public static final String MSANALYSIS2014ODP = "MSAnalysis2014ODP";
    public static final String MSANALYSIS2012ODP = "MSAnalysis2012ODP";
    public static final String MSANALYSIS2008ODP = "MSAnalysis2008ODP";
    public static final String MSANALYSIS2005ODP = "MSAnalysis2005ODP";
    public static final String POWERCUBEODPXQE = "PowerCubeODPXQE";
    public static final String SAPBWODP = "SAPBWODP";
    public static final String SAPBWODP2 = "SAPBWODP2";
    public static final String TM1OLAPODPXQE = "TM1OlapODPXQE";
    public static final String NGTM1ODP = "NGTM1ODP";
    public static final String TM1REST = "TM1REST";
    public static final String DB2CSXMLA = "DB2CSXMLA";
    public static final String ROLAPODPXQE = "ROLAPODPXQE";
    public static final String YKXMLA = "YKXMLA";
    public static final String M8XMLA = "M8XMLA";
    public static final String MS_SQL = "MS SQL";
    public static final String ORACLE = "Oracle";
    public static final String DB2 = "DB2";
    public static final String NETEZZA = "NETEZZA";
    public static final String HIVE = "HIVE";
    public static final String WSDL = "WSDL";
    public static final String SFDC = "ERP-SFDC";
    public static final String SAPR3 = "ERP-SAP";
    public static final String SIEBEL = "ERP-SIEBEL";
    public static final String ALLEGROGRAPH = "Allegrograph";
    public static final String GENERIC_JDBC = "JDBC";
    public static final String PARQUET = "PARQUET";
    public static final String FLINT = "FLINT";

    public static String getProviderName(String providerCode) {
        if (DO.equals(providerCode)) {
            return DB2OLAPODP;
        }
        if (EB.equals(providerCode)) {
            return DB2OLAPODP;
        }
        if (MAZ.equals(providerCode)) {
            return MSAZUREASODP;
        }
        if (M19.equals(providerCode)) {
            return MSANALYSIS2019ODP;
        }
        if (M17.equals(providerCode)) {
            return MSANALYSIS2017ODP;
        }
        if (M16.equals(providerCode)) {
            return MSANALYSIS2016ODP;
        }
        if (M14.equals(providerCode)) {
            return MSANALYSIS2014ODP;
        }
        if (M12.equals(providerCode)) {
            return MSANALYSIS2012ODP;
        }
        if (M8.equals(providerCode)) {
            return MSANALYSIS2008ODP;
        }
        if (YK.equals(providerCode)) {
            return MSANALYSIS2005ODP;
        }
        if (PC.equals(providerCode)) {
            return POWERCUBEODPXQE;
        }
        if (BW.equals(providerCode)) {
            return SAPBWODP;
        }
        if (XI.equals(providerCode)) {
            return DB2CSXMLA;
        }
        if (RO.equals(providerCode)) {
            return ROLAPODPXQE;
        }
        if (OL.equals(providerCode)) {
            return MS_SQL;
        }
        if (OR.equals(providerCode)) {
            return ORACLE;
        }
        if (D2.equals(providerCode)) {
            return DB2;
        }
        if (HV.equals(providerCode)) {
            return HV;
        }
        if (TM.equals(providerCode)) {
            return ProviderManager.getInstance().getProviderInfo(providerCode).getProviderName();
        }
        if (TMR.equals(providerCode)) {
            return TM1REST;
        }
        if (X8.equals(providerCode)) {
            return M8XMLA;
        }
        if (X5.equals(providerCode)) {
            return YKXMLA;
        }
        if (XO.equals(providerCode)) {
            return XO;
        }
        if (ODATA.equals(providerCode)) {
            return ODATA;
        }
        if (JAQLSQL.equals(providerCode)) {
            return JAQLSQL;
        }
        return providerCode;
    }

    public static String getProviderCode(String providerName) {
        if (providerName.equals(DB2)) {
            return D2;
        }
        if (providerName.equals(DB2CSXMLA)) {
            return XI;
        }
        if (providerName.equals(DB2OLAPODP)) {
            return EB;
        }
        if (providerName.equals(XO)) {
            return XO;
        }
        if (providerName.equals(YKXMLA)) {
            return X5;
        }
        if (providerName.equals(M8XMLA)) {
            return X8;
        }
        if (providerName.equals(MSANALYSIS2005ODP)) {
            return YK;
        }
        if (providerName.equals(MSANALYSIS2008ODP)) {
            return M8;
        }
        if (providerName.equals(MSANALYSIS2012ODP)) {
            return M12;
        }
        if (providerName.equals(MSANALYSIS2014ODP)) {
            return M14;
        }
        if (providerName.equals(MSANALYSIS2016ODP)) {
            return M16;
        }
        if (providerName.equals(MSAZUREASODP)) {
            return MAZ;
        }
        if (providerName.equals(MSANALYSIS2017ODP)) {
            return M17;
        }
        if (providerName.equals(MSANALYSIS2019ODP)) {
            return M19;
        }
        if (providerName.equals(MS_SQL)) {
            return OL;
        }
        if (providerName.equals(ORACLE)) {
            return OR;
        }
        if (providerName.equals(HIVE)) {
            return HV;
        }
        if (providerName.equals(POWERCUBEODPXQE)) {
            return PC;
        }
        if (providerName.equals(SAPBWODP)) {
            return BW;
        }
        if (providerName.equals(SAPBWODP2)) {
            return BW;
        }
        if (providerName.equals(TM1OLAPODPXQE)) {
            return TM;
        }
        if (providerName.equals(NGTM1ODP)) {
            return TM;
        }
        if (providerName.equals(TM1REST)) {
            return TMR;
        }
        if (providerName.equals(SFDC)) {
            return SFDC;
        }
        if (providerName.equals(SAPR3)) {
            return SAPR3;
        }
        if (providerName.equals(SIEBEL)) {
            return SIEBEL;
        }
        if (providerName.equals(ODATA)) {
            return ODATA;
        }
        if (providerName.equals(JAQLSQL)) {
            return JAQLSQL;
        }
        return null;
    }

    public static boolean isEssbase(String providerCode) {
        return EB.equals(providerCode) || DO.equals(providerCode);
    }

    public static boolean isROLAP(String providerCode) {
        return RO.equals(providerCode);
    }

    public static boolean isCubingServices(String providerCode) {
        return XI.equals(providerCode);
    }

    public static boolean isMicrosoft(String providerCode) {
        return DataSourceTypeEnum.isYukon(providerCode) || XO.equals(providerCode);
    }

    public static boolean isYukon(String providerCode) {
        return YK.equals(providerCode) || M8.equals(providerCode) || M12.equals(providerCode) || M14.equals(providerCode) || M16.equals(providerCode) || M17.equals(providerCode) || M19.equals(providerCode) || MAZ.equals(providerCode) || X5.equals(providerCode) || X8.equals(providerCode);
    }

    public static boolean isODBOMSAS(String providerCode) {
        return YK.equals(providerCode) || M8.equals(providerCode) || M12.equals(providerCode) || M14.equals(providerCode) || M16.equals(providerCode) || M17.equals(providerCode) || M19.equals(providerCode) || MAZ.equals(providerCode);
    }

    public static boolean isPostMSAS2005(String providerCode) {
        return M8.equals(providerCode) || M12.equals(providerCode) || M14.equals(providerCode) || M16.equals(providerCode) || M17.equals(providerCode) || M19.equals(providerCode) || MAZ.equals(providerCode) || X8.equals(providerCode);
    }

    public static boolean isRelational(String providerCode) {
        return DataSourceTypeEnum.isSQLServer(providerCode) || DataSourceTypeEnum.isDB2(providerCode) || DataSourceTypeEnum.isOracle(providerCode) || DataSourceTypeEnum.isTeradata(providerCode) || DataSourceTypeEnum.isNetezza(providerCode) || DataSourceTypeEnum.isGenericJDBC(providerCode) || DataSourceTypeEnum.isERP(providerCode) || DataSourceTypeEnum.isOData(providerCode) || DataSourceTypeEnum.isJAQLSQL(providerCode) || DataSourceTypeEnum.isJSON(providerCode) || DataSourceTypeEnum.isColumnar(providerCode) || DataSourceTypeEnum.isFlint(providerCode);
    }

    public static boolean isSQLServer(String providerCode) {
        return SS.equals(providerCode) || JDSS.equals(providerCode) || OL.equals(providerCode);
    }

    public static boolean isDB2(String providerCode) {
        return D2.equals(providerCode) || JDD2.equals(providerCode);
    }

    public static boolean isOracle(String providerCode) {
        return OR.equals(providerCode) || JDOR.equals(providerCode);
    }

    public static boolean isPowerCube(String providerCode) {
        return PC.equals(providerCode);
    }

    public static boolean isTM(String providerCode) {
        return TM.equals(providerCode) || TMR.equals(providerCode);
    }

    public static boolean isTM1(String providerCode) {
        return TM.equals(providerCode);
    }

    public static boolean isTMR(String providerCode) {
        return TMR.equals(providerCode);
    }

    public static boolean isSAPBW(String providerCode) {
        return BW.equals(providerCode);
    }

    public static boolean isTeradata(String providerCode) {
        return TD.equals(providerCode) || JDTD.equals(providerCode);
    }

    public static boolean isNetezza(String providerCode) {
        return NZ.equals(providerCode) || JDNZ.equals(providerCode);
    }

    public static boolean isGenericJDBC(String providerCode) {
        return "JDBC".equals(providerCode) || OD.equals(providerCode) || JD.equals(providerCode);
    }

    public static boolean isSalesforce(String providerCode) {
        return SF.equals(providerCode) || JDSF.equals(providerCode);
    }

    public static boolean isJDBC(String providerCode) {
        return DataSourceTypeEnum.isSQLServer(providerCode) || DataSourceTypeEnum.isDB2(providerCode) || DataSourceTypeEnum.isOracle(providerCode) || DataSourceTypeEnum.isTeradata(providerCode) || DataSourceTypeEnum.isNetezza(providerCode) || DataSourceTypeEnum.isSalesforce(providerCode) || DataSourceTypeEnum.isGenericJDBC(providerCode) || DataSourceTypeEnum.isProviderJDBC(providerCode);
    }

    public static boolean isProviderJDBC(String providerCode) {
        return providerCode != null && providerCode.startsWith("JD-");
    }

    public static boolean isMondrian(String providerCode) {
        return XO.equals(providerCode);
    }

    public static boolean isOData(String providerCode) {
        return ODATA.equals(providerCode);
    }

    public static boolean isJSON(String providerCode) {
        return JSON.equals(providerCode) || DataSourceTypeEnum.isCloudant(providerCode) || DataSourceTypeEnum.isCouchDB(providerCode);
    }

    public static boolean isCouchDB(String providerCode) {
        return COUCHDB.equals(providerCode);
    }

    public static boolean isCloudant(String providerCode) {
        return CLOUDANT.equals(providerCode);
    }

    public static boolean isJAQLSQL(String providerCode) {
        return JAQLSQL.equals(providerCode);
    }

    public static boolean isERP(String providerCode) {
        return SFDC.equals(providerCode) || SAPR3.equals(providerCode) || SIEBEL.equals(providerCode);
    }

    public static boolean isFlint(String providerCode) {
        return FLINT.equals(providerCode);
    }

    public static boolean isColumnar(String providerCode) {
        return PARQUET.equals(providerCode);
    }

    public static boolean isSQLProvider(String providerCode) {
        return DataSourceTypeEnum.isJDBC(providerCode) || DataSourceTypeEnum.isERP(providerCode) || DataSourceTypeEnum.isJAQLSQL(providerCode);
    }

    public static String getInterfaceTypeFromConnectionString(String connectionString) {
        if (connectionString != null) {
            String[] tokens = connectionString.split(";");
            if (tokens.length <= 2) {
                return null;
            }
            String type = tokens[2];
            if (type.equals(JSON)) {
                for (String token : tokens) {
                    if (!token.contains(EQUALS)) continue;
                    String key = token.substring(0, token.indexOf(EQUALS));
                    String value = token.substring(key.length() + 1);
                    if (!key.equals(SUBTYPE)) continue;
                    if (value.equalsIgnoreCase(COUCHDB)) {
                        type = COUCHDB;
                        break;
                    }
                    if (!value.equalsIgnoreCase(CLOUDANT)) break;
                    type = CLOUDANT;
                    break;
                }
            }
            return type;
        }
        return null;
    }

    public static boolean supportsJavaKerberos(String providerCode, String connectionString) {
        return DataSourceTypeEnum.isGenericJDBC(providerCode) || DataSourceTypeEnum.isSQLServer(providerCode) || DataSourceTypeEnum.isDB2(providerCode) || DataSourceTypeEnum.isOracle(providerCode) || DataSourceTypeEnum.isTeradata(providerCode) || DataSourceTypeEnum.isNetezza(providerCode);
    }

    public static boolean isOIDCSupported(String providerCode) {
        return DataSourceTypeEnum.isGenericJDBC(providerCode) || DataSourceTypeEnum.isDB2(providerCode) || DataSourceTypeEnum.isTeradata(providerCode);
    }
}

