/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.analytics;

import com.cognos.xqe.data.providers.analytics.IForecastProvider;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;

public class LocalForecast
implements IForecastProvider {
    Collection<Double> historicalValues;
    Collection<Double> historicalTimes;
    Collection<Double> forecastTimes;
    double timesMean = 0.0;
    double timesSquareMean = 0.0;
    double valuesMean = 0.0;
    double valuesSquareMean = 0.0;
    double standardYError = 0.0;
    double standardXError = 0.0;
    static double[][] tDistributionValues = new double[][]{{1.0, 12.71}, {2.0, 4.303}, {3.0, 3.182}, {4.0, 2.776}, {5.0, 2.571}, {6.0, 2.447}, {7.0, 2.365}, {8.0, 2.306}, {9.0, 2.262}, {10.0, 2.228}, {11.0, 2.201}, {12.0, 2.179}, {13.0, 2.16}, {14.0, 2.145}, {15.0, 2.131}, {16.0, 2.12}, {17.0, 2.11}, {18.0, 2.101}, {19.0, 2.093}, {20.0, 2.086}, {21.0, 2.08}, {22.0, 2.074}, {23.0, 2.069}, {24.0, 2.064}, {25.0, 2.06}, {26.0, 2.056}, {27.0, 2.052}, {28.0, 2.048}, {29.0, 2.045}, {30.0, 2.042}, {40.0, 2.021}, {50.0, 2.009}, {60.0, 2.0}, {80.0, 1.99}, {100.0, 1.984}, {120.0, 1.98}};

    @Override
    public void cancel() {
    }

    @Override
    public boolean prepare(String modelParameters) {
        if (modelParameters.compareToIgnoreCase(".LocalForecast") != 0 && modelParameters.compareToIgnoreCase("com.cognos.xqe.data.providers.analytics.LocalForecast") != 0) {
            throw new XQERuntimeException(XQEMessageKeys.PRE_UnsupportedAlgorithm);
        }
        return true;
    }

    @Override
    public Collection execute(Collection<Double> fHistoricalTimePeriods, Collection<Double> fHistoricalValues, Collection<Double> fForecastTimePeriods) {
        this.historicalValues = fHistoricalValues;
        this.historicalTimes = fHistoricalTimePeriods;
        this.forecastTimes = fForecastTimePeriods;
        return this.predictForForecastTimes();
    }

    public Collection<Double[]> predictForForecastTimes() throws XQERuntimeException {
        Vector<Double[]> forecastResultRows = new Vector<Double[]>(this.forecastTimes.size());
        this.timesMean = this.computeMean(this.historicalTimes, 1);
        this.timesSquareMean = this.computeMean(this.historicalTimes, 2);
        this.valuesMean = this.computeMean(this.historicalValues, 1);
        this.valuesSquareMean = this.computeMean(this.historicalValues, 2);
        int n = this.forecastTimes.size();
        Double tDistributionValue = LocalForecast.getTDistributionValue97p5(n - 2);
        this.standardYError = (double)n * this.valuesSquareMean - (double)n * this.valuesMean * this.valuesMean;
        this.standardXError = (double)n * this.timesSquareMean - (double)n * this.timesMean * this.timesMean;
        Double errorVariance = null;
        if (n > 2) {
            errorVariance = Math.sqrt(this.standardYError / (double)(n - 2));
        }
        double slope = this.computeSlope();
        double intersept = this.computeIntercept();
        for (Double timeOrdinal : this.forecastTimes) {
            Double forecastValue = null;
            Double forecastError = null;
            if (timeOrdinal != null && this.historicalValues.size() >= 2) {
                forecastValue = slope * timeOrdinal + intersept;
            }
            if (tDistributionValue != null && errorVariance != null && timeOrdinal != null) {
                double confidenceAt95 = tDistributionValue * errorVariance * Math.sqrt((double)(1 + 1 / n) + (timeOrdinal - this.timesMean) * (timeOrdinal - this.timesMean) / this.standardXError);
                forecastError = confidenceAt95 / 2.0;
            }
            forecastResultRows.add(new Double[]{forecastValue, forecastError});
        }
        return forecastResultRows;
    }

    private double computeIntercept() {
        double slope = this.computeSlope();
        return this.valuesMean - this.timesMean * slope;
    }

    private double computeSlope() {
        double covariance = 0.0;
        double timeVariance = 0.0;
        Iterator<Double> historicalTimesIt = this.historicalTimes.iterator();
        Iterator<Double> historicalValuesIt = this.historicalValues.iterator();
        while (historicalTimesIt.hasNext() && historicalValuesIt.hasNext()) {
            Double oTime = historicalTimesIt.next();
            Double oValue = historicalValuesIt.next();
            if (oTime == null || oValue == null) continue;
            double timeOrdinal = oTime;
            double value = oValue;
            covariance += (timeOrdinal - this.timesMean) * (value - this.valuesMean);
            timeVariance += (timeOrdinal - this.timesMean) * (timeOrdinal - this.timesMean);
        }
        if (timeVariance == 0.0) {
            return 0.0;
        }
        return covariance / timeVariance;
    }

    private double computeMean(Collection<Double> values, int power) {
        double sum = 0.0;
        double count = 0.0;
        for (Double oValue : values) {
            if (oValue == null) continue;
            double value = oValue;
            if (power == 2) {
                value *= value;
            } else if (power != 1) {
                value = Math.pow(value, power);
            }
            sum += value;
            count += 1.0;
        }
        if (count == 0.0) {
            return 0.0;
        }
        return sum / count;
    }

    private static Double getTDistributionValue97p5(int nDegrees) {
        if (nDegrees < 1) {
            return null;
        }
        for (int i = 0; i < tDistributionValues.length; ++i) {
            if (!((double)nDegrees <= tDistributionValues[i][0])) continue;
            return tDistributionValues[i][1];
        }
        return tDistributionValues[tDistributionValues.length - 1][1];
    }
}

