/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.connection;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.pool.connection.ConnectionParameters;
import com.cognos.xqe.pool.connection.IConnectionFactory;
import com.cognos.xqe.pool.connection.IPooledConnection;
import com.cognos.xqe.pool.connection.decoration.ConnectionFactoryDecorator;
import com.cognos.xqe.query.engine.IExecutionEnvironment;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;

public class ConnectionFactoryLogDecorator
extends ConnectionFactoryDecorator {
    private final XQELogger ipfConnectionLogger;
    private final IExecutionEnvironment mExecutionEnvironment;
    private final XQELogger mLogger;

    public ConnectionFactoryLogDecorator(IConnectionFactory connectionFactory, XQELogger logger, IExecutionEnvironment executionEnvironment) {
        super(connectionFactory);
        this.mExecutionEnvironment = executionEnvironment;
        this.mLogger = logger;
        this.ipfConnectionLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "QueryService.Connection", LogLevel.TRACE);
    }

    @Override
    protected void afterCreateConnection(ConnectionParameters connectionParameters, Object connection) {
        if (this.mLogger.isOn() || this.ipfConnectionLogger.isOn()) {
            StringBuilder buffer = new StringBuilder("created (");
            buffer.append(connectionParameters.toString()).append(")=");
            buffer.append(connection.toString());
            String msg = buffer.toString();
            this.mLogger.log(msg);
            this.ipfConnectionLogger.log(msg);
        }
    }

    @Override
    protected void afterDestroyConnection(IPooledConnection pooledConnection) {
        if (this.mLogger.isOn() || this.ipfConnectionLogger.isOn()) {
            StringBuilder buffer = new StringBuilder("destroyed ");
            buffer.append(pooledConnection.getConnection().toString());
            String msg = buffer.toString();
            this.mLogger.log(msg);
            this.ipfConnectionLogger.log(msg);
        }
    }

    public IExecutionEnvironment getExecutionEnvironment() {
        return this.mExecutionEnvironment;
    }
}

