/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.connection;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metrics.MetricsManager;
import com.cognos.xqe.pool.connection.ConnectionParameters;
import com.cognos.xqe.pool.connection.IConnectionFactory;
import com.cognos.xqe.pool.connection.IPooledConnection;
import com.cognos.xqe.pool.connection.decoration.ConnectionFactoryDecorator;

public class ConnectionFactoryStatisticsDecorator
extends ConnectionFactoryDecorator {
    private final String mCreationCounterName;
    private final String mDestructionCounterName;
    private static final String CONNECTION_PREFIX = "XqeCnx";

    public ConnectionFactoryStatisticsDecorator(IConnectionFactory connectionFactory, String name) throws XQERuntimeException {
        super(connectionFactory);
        XQEConfiguration xqeConfig = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
        if (xqeConfig.inStandaloneMode()) {
            this.mCreationCounterName = CONNECTION_PREFIX + name + "Creation";
            this.mDestructionCounterName = CONNECTION_PREFIX + name + "Destruction";
            MetricsManager.createMetric(this.mCreationCounterName);
            MetricsManager.createMetric(this.mDestructionCounterName);
        } else {
            this.mCreationCounterName = null;
            this.mDestructionCounterName = null;
        }
    }

    @Override
    protected void afterCreateConnection(ConnectionParameters connectionParameters, Object connection) {
        if (this.mCreationCounterName != null) {
            MetricsManager.incrementCounter(this.mCreationCounterName);
        }
    }

    @Override
    protected void afterDestroyConnection(IPooledConnection pooledConnection) {
        if (this.mDestructionCounterName != null) {
            MetricsManager.incrementCounter(this.mDestructionCounterName);
        }
    }
}

