/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.connection;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public final class ConnectionStringParser {
    public static final String PROVIDER_TYPE = "PROVIDER_TYPE";
    public static final String LOCAL = "LOCAL";
    public static final String PLACEHOLDER = "%s";
    private static final String DELIMITER = ";";
    private static final String ERRMSG_CONNECTIONSTRING_WAS_NULL = "The connection string was null";
    private static final String ERRMSG_HANDLER_WAS_NULL = "The callback handler was null";

    private ConnectionStringParser() {
    }

    public static void parse(String connectionString, TokenHandler handler) {
        if (null == connectionString) {
            throw new NullPointerException(ERRMSG_CONNECTIONSTRING_WAS_NULL);
        }
        if (null == handler) {
            throw new NullPointerException(ERRMSG_HANDLER_WAS_NULL);
        }
        if (connectionString.length() > 0) {
            ConnectionStringParser.parseSequenceToHandler(connectionString, handler);
        }
    }

    public static Map<String, String> parse(String connectionString) {
        if (null == connectionString) {
            throw new NullPointerException(ERRMSG_CONNECTIONSTRING_WAS_NULL);
        }
        final HashMap<String, String> connectionParameters = new HashMap<String, String>();
        TokenHandler mapHandler = new TokenHandler(){

            @Override
            public void onKeyValueToken(String key, String value) {
                connectionParameters.put(key, value);
            }

            @Override
            public void onSimpleToken(String value) {
                connectionParameters.put(value, value);
            }
        };
        ExtractPositionalArgumentsTokenHandler positionalHandler = new ExtractPositionalArgumentsTokenHandler();
        positionalHandler.setNextHandler(mapHandler);
        ConnectionStringParser.parseSequenceToHandler(connectionString, positionalHandler);
        connectionParameters.put(PROVIDER_TYPE, positionalHandler.getProviderType());
        return connectionParameters;
    }

    public static Map<String, String> parse(String connectionString, Set<String> allowedTokens) {
        if (null == connectionString) {
            throw new NullPointerException(ERRMSG_CONNECTIONSTRING_WAS_NULL);
        }
        final HashMap<String, String> connectionParameters = new HashMap<String, String>();
        TokenHandler mapHandler = new TokenHandler(){

            @Override
            public void onKeyValueToken(String key, String value) {
                connectionParameters.put(key, value);
            }

            @Override
            public void onSimpleToken(String value) {
                connectionParameters.put(value, value);
            }
        };
        ExtractPositionalArgumentsTokenHandler positionalHandler = new ExtractPositionalArgumentsTokenHandler();
        FilteringTokenHandler filteringHandler = new FilteringTokenHandler(allowedTokens);
        positionalHandler.setNextHandler(filteringHandler);
        filteringHandler.setNextHandler(mapHandler);
        ConnectionStringParser.parseSequenceToHandler(connectionString, positionalHandler);
        connectionParameters.put(PROVIDER_TYPE, positionalHandler.getProviderType());
        return connectionParameters;
    }

    private static void parseSequenceToHandler(String sequence, TokenHandler handler) {
        String[] parts = sequence.split(DELIMITER);
        for (int i = 0; i < parts.length; ++i) {
            ConnectionStringParser.parseTokenToHandler(parts[i], handler);
        }
    }

    private static void parseTokenToHandler(String token, TokenHandler handler) {
        int equalIndex = token.indexOf(61);
        if (equalIndex != -1) {
            String key = token.substring(0, equalIndex);
            String value = token.substring(equalIndex + 1);
            handler.onKeyValueToken(key, value);
        } else {
            handler.onSimpleToken(token);
        }
    }

    public static class FilteringTokenHandler
    extends ChainedTokenHandler {
        private Set<String> allowedTokens = null;

        public FilteringTokenHandler(Set<String> theAllowedTokens) {
            this.allowedTokens = theAllowedTokens;
        }

        @Override
        public boolean handleKeyValueToken(String key, String value) {
            return !this.allowedTokens.contains(key);
        }

        @Override
        public boolean handleSimpleToken(String value) {
            return !this.allowedTokens.contains(value);
        }
    }

    public static class ExtractPositionalArgumentsTokenHandler
    extends ChainedTokenHandler {
        private static final int FIRST_PART = 1;
        private static final int SECOND_PART = 2;
        private static final int THIRD_PART = 3;
        private boolean local = false;
        private String providerType = null;
        private int part = 0;

        public boolean isLocal() {
            return this.local;
        }

        public String getProviderType() {
            return this.providerType;
        }

        @Override
        public boolean handleKeyValueToken(String key, String value) {
            ++this.part;
            return false;
        }

        @Override
        public boolean handleSimpleToken(String value) {
            ++this.part;
            if (1 == this.part) {
                return true;
            }
            if (2 == this.part) {
                this.local = ConnectionStringParser.LOCAL.equals(value);
                return true;
            }
            if (3 == this.part) {
                this.providerType = value;
                return true;
            }
            return false;
        }
    }

    public static abstract class ChainedTokenHandler
    implements TokenHandler {
        private TokenHandler nextHandler = null;

        public void setNextHandler(TokenHandler theNextHandler) {
            this.nextHandler = theNextHandler;
        }

        @Override
        public final void onKeyValueToken(String key, String value) {
            if (!this.handleKeyValueToken(key, value) && null != this.nextHandler) {
                this.nextHandler.onKeyValueToken(key, value);
            }
        }

        @Override
        public final void onSimpleToken(String value) {
            if (!this.handleSimpleToken(value) && null != this.nextHandler) {
                this.nextHandler.onSimpleToken(value);
            }
        }

        public abstract boolean handleKeyValueToken(String var1, String var2);

        public abstract boolean handleSimpleToken(String var1);
    }

    public static interface TokenHandler {
        public void onSimpleToken(String var1);

        public void onKeyValueToken(String var1, String var2);
    }
}

